/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

final class RailsAdapters {
    static final String DEVELOPMENT_DB_SUFFIX = "_development";
    private static final String PRODUCTION_DB_SUFFIX = "_production";
    private static final String TEST_DB_SUFFIX = "_test";

    private RailsAdapters() {
    }

    static void commentOutSocket(FileObject fileObject, String string) {
        Parameters.notNull((CharSequence)"dir", (Object)fileObject);
        Parameters.notNull((CharSequence)"host", (Object)string);
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    RailsAdapters.commentOutSocket(styledDocument, string, 0);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static void commentOutSocket(Document document, String string, int n) throws BadLocationException {
        int n2;
        boolean bl;
        String string2 = document.getText(0, document.getLength());
        int n3 = string2.indexOf("socket:", n);
        if (n3 == -1) {
            return;
        }
        int n4 = 0;
        for (int i = n3 - 1; i >= 0 && string2.charAt(i) != '\n'; --i) {
            ++n4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# JRuby doesn't support socket:\n");
        boolean bl2 = bl = string2.indexOf("host:", n) == -1;
        if (bl) {
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("host: " + string + "\n");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("#");
        document.insertString(n3, stringBuilder.toString(), null);
        RailsAdapters.commentOutSocket(document, string, n3 + stringBuilder.length() + "socket:".length());
    }

    static void addProperty(Document document, String string, String string2, String string3) throws BadLocationException {
        int n;
        String string4 = document.getText(0, document.getLength());
        int n2 = string4.indexOf(string3);
        if (n2 == -1) {
            return;
        }
        int n3 = RailsAdapters.determineIndent(string4, n2);
        for (n = n2 + string3.length(); string4.charAt(n) != '\n' && n <= string4.length(); ++n) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string + " " + string2 + '\n');
        document.insertString(n + 1, stringBuilder.toString(), null);
    }

    static void removeProperty(Document document, String string) throws BadLocationException {
        String string2 = document.getText(0, document.getLength());
        int n = string2.indexOf(string);
        if (n == -1) {
            return;
        }
        int n2 = RailsAdapters.determineIndent(string2, n);
        int n3 = string.length();
        for (int i = n + string.length(); i <= string2.length(); ++i) {
            ++n3;
            if (string2.charAt(i) == '\n') break;
        }
        document.remove(n - n2, n3 + n2);
    }

    static String getPropertyValue(Document document, String string) throws BadLocationException {
        String string2 = document.getText(0, document.getLength());
        int n = string2.indexOf(string);
        if (n == -1) {
            return null;
        }
        int n2 = n + string.length();
        int n3 = 0;
        for (int i = n2; i < string2.length() && string2.charAt(i) != '\n'; ++i) {
            ++n3;
        }
        return document.getText(n2, n3).trim();
    }

    private static int determineIndent(String string, int n) {
        int n2 = 0;
        for (int i = n - 1; i >= 0 && string.charAt(i) != '\n'; --i) {
            ++n2;
        }
        return n2;
    }

    static String getTestDatabaseName(String string) {
        return RailsAdapters.buildDatabaseName(string, TEST_DB_SUFFIX);
    }

    static String getProductionDatabaseName(String string) {
        return RailsAdapters.buildDatabaseName(string, PRODUCTION_DB_SUFFIX);
    }

    private static String buildDatabaseName(String string, String string2) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(DEVELOPMENT_DB_SUFFIX);
        if (n == -1) {
            return string + string2;
        }
        if (n == 0) {
            return string2;
        }
        return string.substring(0, n) + string2;
    }
}

