/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.data.provider.SortCriteria;
import com.sun.rave.web.ui.component.Button;
import com.sun.rave.web.ui.component.DropDown;
import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.component.Table;
import com.sun.rave.web.ui.component.TableColumn;
import com.sun.rave.web.ui.component.TablePanelsBase;
import com.sun.rave.web.ui.component.TableRowGroup;
import com.sun.rave.web.ui.event.TableSortActionListener;
import com.sun.rave.web.ui.model.Option;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TablePanels
extends TablePanelsBase
implements NamingContainer {
    public static final String FILTER_PANEL_ID = "_filterPanel";
    public static final String PREFERENCES_PANEL_ID = "_preferencesPanel";
    public static final String PRIMARY_SORT_COLUMN_MENU_ID = "_primarySortColumnMenu";
    public static final String PRIMARY_SORT_COLUMN_MENU_FACET = "primarySortColumnMenu";
    public static final String PRIMARY_SORT_COLUMN_MENU_LABEL_ID = "_primarySortColumnMenuLabel";
    public static final String PRIMARY_SORT_COLUMN_MENU_LABEL_FACET = "primarySortColumnMenuLabel";
    public static final String PRIMARY_SORT_ORDER_MENU_ID = "_primarySortOrderMenu";
    public static final String PRIMARY_SORT_ORDER_MENU_FACET = "primarySortOrderMenu";
    public static final String SECONDARY_SORT_COLUMN_MENU_ID = "_secondarySortColumnMenu";
    public static final String SECONDARY_SORT_COLUMN_MENU_FACET = "secondarySortColumnMenu";
    public static final String SECONDARY_SORT_COLUMN_MENU_LABEL_ID = "_secondarySortColumnMenuLabel";
    public static final String SECONDARY_SORT_COLUMN_MENU_LABEL_FACET = "secondarySortColumnMenuLabel";
    public static final String SECONDARY_SORT_ORDER_MENU_ID = "_secondarySortOrderMenu";
    public static final String SECONDARY_SORT_ORDER_MENU_FACET = "secondarySortOrderMenu";
    public static final String SORT_PANEL_ID = "_sortPanel";
    public static final String SORT_PANEL_CANCEL_BUTTON_ID = "_sortPanelCancelButton";
    public static final String SORT_PANEL_CANCEL_BUTTON_FACET = "sortPanelCancelButton";
    public static final String SORT_PANEL_SUBMIT_BUTTON_ID = "_sortPanelSubmitButton";
    public static final String SORT_PANEL_SUBMIT_BUTTON_FACET = "sortPanelSubmitButton";
    public static final String TERTIARY_SORT_COLUMN_MENU_ID = "_tertiarySortColumnMenu";
    public static final String TERTIARY_SORT_COLUMN_MENU_FACET = "tertiarySortColumnMenu";
    public static final String TERTIARY_SORT_COLUMN_MENU_LABEL_ID = "_tertiarySortColumnMenuLabel";
    public static final String TERTIARY_SORT_COLUMN_MENU_LABEL_FACET = "tertiarySortColumnMenuLabel";
    public static final String TERTIARY_SORT_ORDER_MENU_ID = "_tertiarySortOrderMenu";
    public static final String TERTIARY_SORT_ORDER_MENU_FACET = "tertiarySortOrderMenu";
    private Table table = null;

    public Table getTableAncestor() {
        if (this.table == null) {
            TablePanels component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public UIComponent getPrimarySortColumnMenu() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_COLUMN_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(PRIMARY_SORT_COLUMN_MENU_ID);
        child.setItems(this.getSortColumnMenuOptions());
        child.setSelected(this.getSelectedSortColumnMenuOption(1));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initPrimarySortOrderMenu()");
        } else {
            this.log("getPrimarySortColumnMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPrimarySortColumnMenuLabel() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_COLUMN_MENU_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(PRIMARY_SORT_COLUMN_MENU_LABEL_ID);
        child.setText(this.getTheme().getMessage("table.panel.primarySortColumn"));
        child.setLabelLevel(2);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPrimarySortOrderMenu() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_ORDER_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(PRIMARY_SORT_ORDER_MENU_ID);
        child.setItems(this.getSortOrderMenuOptions());
        child.setSelected(this.getSelectedSortOrderMenuOption(1));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initPrimarySortOrderMenuToolTip()");
        } else {
            this.log("getPrimarySortOrderMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSecondarySortColumnMenu() {
        UIComponent facet = this.getFacet(SECONDARY_SORT_COLUMN_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(SECONDARY_SORT_COLUMN_MENU_ID);
        child.setItems(this.getSortColumnMenuOptions());
        child.setSelected(this.getSelectedSortColumnMenuOption(2));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initSecondarySortOrderMenu()");
        } else {
            this.log("getSecondarySortColumnMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSecondarySortColumnMenuLabel() {
        UIComponent facet = this.getFacet(SECONDARY_SORT_COLUMN_MENU_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(SECONDARY_SORT_COLUMN_MENU_LABEL_ID);
        child.setText(this.getTheme().getMessage("table.panel.secondarySortColumn"));
        child.setLabelLevel(2);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSecondarySortOrderMenu() {
        UIComponent facet = this.getFacet(SECONDARY_SORT_ORDER_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(SECONDARY_SORT_ORDER_MENU_ID);
        child.setItems(this.getSortOrderMenuOptions());
        child.setSelected(this.getSelectedSortOrderMenuOption(2));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initSecondarySortOrderMenuToolTip()");
        } else {
            this.log("getSecondarySortOrderMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSortPanelCancelButton() {
        UIComponent facet = this.getFacet(SORT_PANEL_CANCEL_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Button child = new Button();
        child.setId(SORT_PANEL_CANCEL_BUTTON_ID);
        child.setMini(true);
        child.setText(this.getTheme().getMessage("table.panel.cancel"));
        child.setToolTip(this.getTheme().getMessage("table.panel.cancelChanges"));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnClick("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').toggleSortPanel(); return false");
        } else {
            this.log("getSortPanelCancelButton", "Tab index & onClick not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSortPanelSubmitButton() {
        UIComponent facet = this.getFacet(SORT_PANEL_SUBMIT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Button child = new Button();
        child.setId(SORT_PANEL_SUBMIT_BUTTON_ID);
        child.setMini(true);
        child.setPrimary(true);
        child.setText(this.getTheme().getMessage("table.panel.submit"));
        child.setToolTip(this.getTheme().getMessage("table.panel.applyChanges"));
        child.addActionListener(new TableSortActionListener());
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnClick("return document.getElementById('" + table.getClientId(this.getFacesContext()) + "').validateSortPanel()");
        } else {
            this.log("getSortPanelSubmitButton", "Tab index & onClick not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getTertiarySortColumnMenu() {
        UIComponent facet = this.getFacet(TERTIARY_SORT_COLUMN_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(TERTIARY_SORT_COLUMN_MENU_ID);
        child.setItems(this.getSortColumnMenuOptions());
        child.setSelected(this.getSelectedSortColumnMenuOption(3));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initTertiarySortOrderMenu()");
        } else {
            this.log("getTertiarySortColumnMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getTertiarySortColumnMenuLabel() {
        UIComponent facet = this.getFacet(TERTIARY_SORT_COLUMN_MENU_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(TERTIARY_SORT_COLUMN_MENU_LABEL_ID);
        child.setText(this.getTheme().getMessage("table.panel.tertiarySortColumn"));
        child.setLabelLevel(2);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getTertiarySortOrderMenu() {
        UIComponent facet = this.getFacet(TERTIARY_SORT_ORDER_MENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown child = new DropDown();
        child.setId(TERTIARY_SORT_ORDER_MENU_ID);
        child.setItems(this.getSortOrderMenuOptions());
        child.setSelected(this.getSelectedSortOrderMenuOption(3));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
            child.setOnChange("document.getElementById('" + table.getClientId(this.getFacesContext()) + "').initTertiarySortOrderMenuToolTip()");
        } else {
            this.log("getTertiarySortOrderMenu", "Tab index & onChange not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.table = null;
        super.encodeBegin(context);
    }

    private String getSelectedSortColumnMenuOption(int level) {
        TableRowGroup group;
        String result = null;
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        if (group != null) {
            TableColumn col;
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext() && (!(col = (TableColumn)((Object)kids.next())).isRendered() || (result = this.getSelectedSortColumnMenuOption(col, level)) == null)) {
            }
        } else {
            this.log("getSelectedSortColumnMenuOption", "Cannot obtain select sort column menu option, TableRowGroup is null");
        }
        return result;
    }

    private String getSelectedSortColumnMenuOption(TableColumn component, int level) {
        Table table;
        TableRowGroup group;
        String result = null;
        if (component == null) {
            this.log("getSelectedSortColumnMenuOption", "Cannot obtain select sort column menu option, TableColumn is null");
            return result;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn kid = (TableColumn)((Object)kids.next());
                result = this.getSelectedSortColumnMenuOption(kid, level);
                if (result == null) continue;
                return result;
            }
        }
        TableRowGroup tableRowGroup = group = (table = this.getTableAncestor()) != null ? table.getTableRowGroupChild() : null;
        if (group != null) {
            int sortLevel;
            SortCriteria criteria = component.getSortCriteria();
            if (criteria != null && (sortLevel = group.getSortLevel(criteria)) == level) {
                result = criteria.getCriteriaKey();
            }
        } else {
            this.log("getSelectedSortColumnMenuOption", "Cannot obtain select sort column menu option, TableRowGroup is null");
        }
        return result;
    }

    private String getSelectedSortOrderMenuOption(int level) {
        TableRowGroup group;
        String result = null;
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        if (group != null) {
            TableColumn col;
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext() && (!(col = (TableColumn)((Object)kids.next())).isRendered() || (result = this.getSelectedSortOrderMenuOption(col, level)) == null)) {
            }
        } else {
            this.log("getSelectedSortOrderMenuOption", "Cannot obtain select sort order menu option, TableRowGroup is null");
        }
        return result;
    }

    private String getSelectedSortOrderMenuOption(TableColumn component, int level) {
        Table table;
        TableRowGroup group;
        String result = null;
        if (component == null) {
            this.log("getSelectedSortOrderMenuOption", "Cannot obtain select sort column order option, TableColumn is null");
            return result;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn kid = (TableColumn)((Object)kids.next());
                result = this.getSelectedSortColumnMenuOption(kid, level);
                if (result == null) continue;
                return result;
            }
        }
        TableRowGroup tableRowGroup = group = (table = this.getTableAncestor()) != null ? table.getTableRowGroupChild() : null;
        if (group != null) {
            int sortLevel;
            SortCriteria criteria = component.getSortCriteria();
            if (criteria != null && (sortLevel = group.getSortLevel(criteria)) == level) {
                result = Boolean.toString(group.isDescendingSort(criteria));
            }
        } else {
            this.log("getSelectedSortOrderMenuOption", "Cannot obtain select sort order menu option, TableRowGroup is null");
        }
        return result;
    }

    private Option[] getSortColumnMenuOptions() {
        ArrayList<Option> list = new ArrayList<Option>();
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        list.add(new Option("", this.getTheme().getMessage("table.panel.none")));
        if (group != null) {
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered()) continue;
                this.initSortColumnMenuOptions(col, list);
            }
        } else {
            this.log("getSortColumnMenuOptions", "Cannot obtain sort column menu options, TableRowGroup is null");
        }
        Option[] options = new Option[list.size()];
        return list.toArray(options);
    }

    private Option[] getSortOrderMenuOptions() {
        ArrayList<Option> results = new ArrayList<Option>();
        results.add(new Option("false", this.getTheme().getMessage("table.sort.augment.undeterminedAscending")));
        results.add(new Option("true", this.getTheme().getMessage("table.sort.augment.undeterminedDescending")));
        Option[] options = new Option[results.size()];
        return results.toArray(options);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private void initSortColumnMenuOptions(TableColumn component, List list) {
        SortCriteria criteria;
        if (component == null) {
            return;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn kid = (TableColumn)((Object)kids.next());
                this.initSortColumnMenuOptions(kid, list);
            }
        }
        if ((criteria = component.getSortCriteria()) == null) {
            this.log("initSortColumnMenuOptions", "Cannot initialize sort column menu options, SortCriteria is null");
            return;
        }
        String label = component.getSelectId() != null ? this.getTheme().getMessage("table.select.selectedItems") : component.getHeaderText();
        list.add(new Option(criteria.getCriteriaKey(), label != null ? label : ""));
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

