/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.AlertBase;
import com.sun.rave.web.ui.component.Icon;
import com.sun.rave.web.ui.component.IconHyperlink;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

public class Alert
extends AlertBase {
    public static final String ALERT_IMAGE_FACET = "alertImage";
    public static final String ALERT_LINK_FACET = "alertLink";

    public UIComponent getAlertIcon() {
        Object imageFacet = this.getFacet(ALERT_IMAGE_FACET);
        if (imageFacet == null) {
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            imageFacet = theme.getIcon(this.getIconIdentifier());
            imageFacet.setId(this.getId() + "_" + ALERT_IMAGE_FACET);
        }
        if (imageFacet instanceof Icon) {
            Icon icon = (Icon)((Object)imageFacet);
            icon.setAlt(this.getAlt());
            icon.setIcon(this.getIconIdentifier());
            if (!Beans.isDesignTime()) {
                this.getFacets().put(ALERT_IMAGE_FACET, imageFacet);
            }
        }
        return imageFacet;
    }

    public UIComponent getAlertLink() {
        Object linkFacet = this.getFacet(ALERT_LINK_FACET);
        String newId = this.getId() + "_" + ALERT_LINK_FACET;
        if ((linkFacet == null || linkFacet.getId().equals(newId)) && this.getLinkText() != null) {
            IconHyperlink h = new IconHyperlink();
            h.setId(newId);
            h.setTarget(this.getLinkTarget());
            h.setText(this.getLinkText());
            h.setToolTip(this.getLinkToolTip());
            h.setUrl(this.getLinkURL());
            h.setIcon("HREF_LINK");
            MethodBinding action = this.getLinkAction();
            if (action != null) {
                h.setAction(action);
            }
            linkFacet = h;
            if (!Beans.isDesignTime()) {
                this.getFacets().put(ALERT_LINK_FACET, linkFacet);
            }
        }
        return linkFacet;
    }

    private String getIconIdentifier() {
        String type = this.getType();
        if (type != null) {
            String lower = type.toLowerCase();
            if (lower.startsWith("warn")) {
                return "ALERT_WARNING_LARGE";
            }
            if (lower.startsWith("ques")) {
                return "ALERT_HELP_LARGE";
            }
            if (lower.startsWith("info")) {
                return "ALERT_INFO_LARGE";
            }
            if (lower.startsWith("succ")) {
                return "ALERT_SUCCESS_LARGE";
            }
        }
        return "ALERT_ERROR_LARGE";
    }

    public void setLinkURL(String linkURL) {
        super.setLinkURL(linkURL);
        UIComponent link = this.getFacet(ALERT_LINK_FACET);
        if (link != null && link instanceof IconHyperlink) {
            ((IconHyperlink)link).setUrl(linkURL);
        }
    }

    public void setLinkToolTip(String linkToolTip) {
        super.setLinkToolTip(linkToolTip);
        UIComponent link = this.getFacet(ALERT_LINK_FACET);
        if (link != null && link instanceof IconHyperlink) {
            ((IconHyperlink)link).setToolTip(linkToolTip);
        }
    }

    public void setLinkText(String linkText) {
        super.setLinkText(linkText);
        UIComponent link = this.getFacet(ALERT_LINK_FACET);
        if (link != null && link instanceof IconHyperlink) {
            ((IconHyperlink)link).setText(linkText);
        }
    }

    public void setLinkTarget(String linkTarget) {
        super.setLinkTarget(linkTarget);
        UIComponent link = this.getFacet(ALERT_LINK_FACET);
        if (link != null && link instanceof IconHyperlink) {
            ((IconHyperlink)link).setTarget(linkTarget);
        }
    }

    public void setLinkAction(MethodBinding linkAction) {
        super.setLinkAction(linkAction);
        UIComponent link = this.getFacet(ALERT_LINK_FACET);
        if (link != null && link instanceof IconHyperlink) {
            ((IconHyperlink)link).setAction(linkAction);
        }
    }
}

