/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.editor.semantic.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExitDetector
extends CancellableTreePathScanner<Boolean, Stack<Tree>> {
    private CompilationInfo info;
    private Document doc;
    private List<int[]> highlights;
    private boolean doExitPoints;
    private Collection<TypeMirror> exceptions;
    private Stack<Map<TypeMirror, List<Tree>>> exceptions2HighlightsStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<int[]> process(CompilationInfo compilationInfo, Document document, MethodTree methodTree, Collection<Tree> collection) {
        this.info = compilationInfo;
        this.doc = document;
        this.highlights = new ArrayList<int[]>();
        this.exceptions2HighlightsStack = new Stack();
        this.exceptions2HighlightsStack.push(null);
        try {
            Object object;
            int n;
            CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
            this.doExitPoints = collection == null;
            Boolean bl = (Boolean)this.scan(TreePath.getPath(compilationUnitTree, (Tree)methodTree), null);
            if (this.isCanceled()) {
                List<int[]> list = null;
                return list;
            }
            if (this.doExitPoints && bl != Boolean.TRUE && (n = Utilities.findLastBracket(methodTree, compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document)) != -1) {
                this.highlights.add(new int[]{n, n + 1});
            }
            ArrayList<Object> arrayList = null;
            if (collection != null) {
                arrayList = new ArrayList<Object>();
                for (Tree map2 : collection) {
                    if (this.isCanceled()) {
                        object = null;
                        return object;
                    }
                    object = compilationInfo.getTrees().getTypeMirror(TreePath.getPath(compilationUnitTree, map2));
                    if (object == null) continue;
                    arrayList.add(object);
                }
            }
            Types types = compilationInfo.getTypes();
            assert (this.exceptions2HighlightsStack.size() == 1) : this.exceptions2HighlightsStack.size();
            Map<TypeMirror, List<Tree>> map = this.exceptions2HighlightsStack.peek();
            if (map != null) {
                for (TypeMirror typeMirror : map.keySet()) {
                    if (this.isCanceled()) {
                        List<int[]> list = null;
                        return list;
                    }
                    boolean list = true;
                    if (arrayList != null) {
                        list = false;
                        for (Object object2 : arrayList) {
                            list |= types.isAssignable(typeMirror, (TypeMirror)object2);
                        }
                    }
                    if (!list) continue;
                    for (Object object2 : map.get(typeMirror)) {
                        this.addHighlightFor((Tree)object2);
                    }
                }
            }
            object = this.highlights;
            return object;
        }
        finally {
            this.info = null;
            this.doc = null;
            this.highlights = null;
            this.exceptions2HighlightsStack = null;
        }
    }

    private void addHighlightFor(Tree tree) {
        int n = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
        int n2 = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), tree);
        this.highlights.add(new int[]{n, n2});
    }

    private void addToExceptionsMap(TypeMirror typeMirror, Tree tree) {
        List<Tree> list;
        if (typeMirror == null || tree == null) {
            return;
        }
        Map<TypeMirror, List<Tree>> map = this.exceptions2HighlightsStack.peek();
        if (map == null) {
            map = new HashMap<TypeMirror, List<Tree>>();
            this.exceptions2HighlightsStack.pop();
            this.exceptions2HighlightsStack.push(map);
        }
        if ((list = map.get(typeMirror)) == null) {
            list = new ArrayList<Tree>();
            map.put(typeMirror, list);
        }
        list.add(tree);
    }

    private void doPopup() {
        Map<TypeMirror, List<Tree>> map = this.exceptions2HighlightsStack.pop();
        if (map == null) {
            return;
        }
        Map<TypeMirror, List<Tree>> map2 = this.exceptions2HighlightsStack.pop();
        if (map2 == null) {
            this.exceptions2HighlightsStack.push(map);
            return;
        }
        for (TypeMirror typeMirror : map.keySet()) {
            List<Tree> list = map.get(typeMirror);
            List<Tree> list2 = map2.get(typeMirror);
            if (list == null) continue;
            if (list2 == null) {
                map2.put(typeMirror, list);
                continue;
            }
            list2.addAll(list);
        }
        this.exceptions2HighlightsStack.push(map2);
    }

    public Boolean visitTry(TryTree tryTree, Stack<Tree> stack) {
        this.exceptions2HighlightsStack.push(null);
        Boolean bl = (Boolean)this.scan(tryTree.getBlock(), stack);
        boolean bl2 = true;
        for (CatchTree catchTree : tryTree.getCatches()) {
            Boolean bl3 = (Boolean)this.scan(catchTree, stack);
            bl2 &= bl3 == Boolean.TRUE;
        }
        Boolean bl4 = (Boolean)this.scan(tryTree.getFinallyBlock(), stack);
        this.doPopup();
        if (bl == Boolean.TRUE && bl2) {
            return Boolean.TRUE;
        }
        return bl4;
    }

    public Boolean visitReturn(ReturnTree returnTree, Stack<Tree> stack) {
        if (this.exceptions == null && this.doExitPoints) {
            this.addHighlightFor(returnTree);
        }
        super.visitReturn(returnTree, stack);
        return Boolean.TRUE;
    }

    public Boolean visitCatch(CatchTree catchTree, Stack<Tree> stack) {
        TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(new TreePath(this.getCurrentPath(), catchTree.getParameter()), catchTree.getParameter().getType()));
        Types types = this.info.getTypes();
        if (typeMirror != null) {
            HashSet<TypeMirror> hashSet = new HashSet<TypeMirror>();
            Map<TypeMirror, List<Tree>> map = this.exceptions2HighlightsStack.peek();
            if (map != null) {
                for (TypeMirror typeMirror2 : map.keySet()) {
                    if (!types.isAssignable(typeMirror2, typeMirror)) continue;
                    hashSet.add(typeMirror2);
                }
                for (TypeMirror typeMirror2 : hashSet) {
                    map.remove(typeMirror2);
                }
            }
        }
        this.scan(catchTree.getParameter(), stack);
        return (Boolean)this.scan(catchTree.getBlock(), stack);
    }

    public Boolean visitMethodInvocation(MethodInvocationTree methodInvocationTree, Stack<Tree> stack) {
        Element element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), methodInvocationTree.getMethodSelect()));
        if (element == null) {
            System.err.println("Warning: decl == null");
            System.err.println("tree=" + methodInvocationTree);
        }
        if (element != null && element.getKind() == ElementKind.METHOD) {
            for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                this.addToExceptionsMap(typeMirror, methodInvocationTree);
            }
        }
        super.visitMethodInvocation(methodInvocationTree, stack);
        return null;
    }

    public Boolean visitThrow(ThrowTree throwTree, Stack<Tree> stack) {
        this.addToExceptionsMap(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), throwTree.getExpression())), throwTree);
        super.visitThrow(throwTree, stack);
        return Boolean.TRUE;
    }

    public Boolean visitNewClass(NewClassTree newClassTree, Stack<Tree> stack) {
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
            for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                this.addToExceptionsMap(typeMirror, newClassTree);
            }
        }
        super.visitNewClass(newClassTree, stack);
        return null;
    }

    public Boolean visitMethod(MethodTree methodTree, Stack<Tree> stack) {
        this.scan(methodTree.getModifiers(), stack);
        this.scan(methodTree.getReturnType(), stack);
        this.scan(methodTree.getTypeParameters(), stack);
        this.scan(methodTree.getParameters(), stack);
        this.scan(methodTree.getThrows(), stack);
        return (Boolean)this.scan(methodTree.getBody(), stack);
    }

    public Boolean visitIf(IfTree ifTree, Stack<Tree> stack) {
        this.scan(ifTree.getCondition(), stack);
        Boolean bl = (Boolean)this.scan(ifTree.getThenStatement(), stack);
        Boolean bl2 = (Boolean)this.scan(ifTree.getElseStatement(), stack);
        if (bl == Boolean.TRUE && bl2 == Boolean.TRUE) {
            return Boolean.TRUE;
        }
        return null;
    }
}

