/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String ERROR = "<error>";
    private static final String UNKNOWN = "<unknown>";
    private static boolean caseSensitive = true;
    private static boolean showDeprecatedMembers = true;
    private static boolean inited;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;
    private static String cachedPrefix;
    private static Pattern cachedPattern;

    public static boolean startsWith(String string, String string2) {
        if (string == null || string.length() == 0 || ERROR.equals(string)) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        return Utilities.isCaseSensitive() ? string.startsWith(string2) : string.toLowerCase(Locale.ENGLISH).startsWith(string2.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithCamelCase(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return false;
        }
        if (!string2.equals(cachedPrefix) || cachedPattern == null) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            do {
                String string3 = string2.substring(n2, (n = Utilities.findNextUpper(string2, n2 + 1)) == -1 ? string2.length() : n);
                stringBuilder.append(string3);
                stringBuilder.append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                n2 = n;
            } while (n != -1);
            cachedPrefix = string2;
            cachedPattern = Pattern.compile(stringBuilder.toString());
        }
        return cachedPattern.matcher(string).matches();
    }

    private static int findNextUpper(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCaseSensitive() {
        Utilities.lazyInit();
        return caseSensitive;
    }

    public static void setCaseSensitive(boolean bl) {
        Utilities.lazyInit();
        caseSensitive = bl;
    }

    public static boolean isShowDeprecatedMembers() {
        Utilities.lazyInit();
        return showDeprecatedMembers;
    }

    public static void setShowDeprecatedMembers(boolean bl) {
        Utilities.lazyInit();
        showDeprecatedMembers = bl;
    }

    public static boolean guessMethodArguments() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
        return preferences.getBoolean("guessMethodArguments", false);
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            preferences = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    public static int getImportanceLevel(String string) {
        int n = 50;
        if (string.startsWith("java.lang") || string.startsWith("java.util")) {
            n -= 10;
        } else if (string.startsWith("org.omg") || string.startsWith("org.apache")) {
            n += 10;
        } else if (string.startsWith("com.sun") || string.startsWith("com.ibm") || string.startsWith("com.apple")) {
            n += 20;
        } else if (string.startsWith("sun") || string.startsWith("sunw") || string.startsWith("netscape")) {
            n += 30;
        }
        return n;
    }

    public static boolean hasAccessibleInnerClassConstructor(Element element, Scope scope, Trees trees) {
        DeclaredType declaredType = (DeclaredType)element.asType();
        for (TypeElement typeElement : ElementFilter.typesIn(element.getEnclosedElements())) {
            if (!trees.isAccessible(scope, typeElement, declaredType)) continue;
            DeclaredType declaredType2 = (DeclaredType)typeElement.asType();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
                if (!trees.isAccessible(scope, executableElement, declaredType2)) continue;
                return true;
            }
        }
        return false;
    }

    public static TreePath getPathElementOfKind(Tree.Kind kind, TreePath treePath) {
        return Utilities.getPathElementOfKind(EnumSet.of(kind), treePath);
    }

    public static TreePath getPathElementOfKind(EnumSet<Tree.Kind> enumSet, TreePath treePath) {
        while (treePath != null) {
            if (enumSet.contains((Object)treePath.getLeaf().getKind())) {
                return treePath;
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaContext(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)document), (int)n);
            if (tokenSequence == null) {
                boolean bl = false;
                return bl;
            }
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                boolean bl = true;
                return bl;
            }
            if (n == tokenSequence.offset()) {
                boolean bl = true;
                return bl;
            }
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case DOUBLE_LITERAL: {
                    if (tokenSequence.token().text().charAt(0) == '.') break;
                }
                case CHAR_LITERAL: 
                case FLOAT_LITERAL: 
                case FLOAT_LITERAL_INVALID: 
                case INT_LITERAL: 
                case INVALID_COMMENT_END: 
                case JAVADOC_COMMENT: 
                case LONG_LITERAL: 
                case STRING_LITERAL: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl) {
        return Utilities.getTypeName(typeMirror, bl, false);
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl, boolean bl2) {
        if (typeMirror == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(bl2).visit(typeMirror, bl);
    }

    public static CharSequence getElementName(Element element, boolean bl) {
        if (element == null || element.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(element, bl);
    }

    public static Collection<? extends Element> getForwardReferences(TreePath treePath, int n, SourcePositions sourcePositions, Trees trees) {
        HashSet<Element> hashSet = new HashSet<Element>();
        while (treePath != null) {
            switch (treePath.getLeaf().getKind()) {
                case BLOCK: 
                case CLASS: {
                    return hashSet;
                }
                case VARIABLE: {
                    hashSet.add(trees.getElement(treePath));
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2.getLeaf().getKind() == Tree.Kind.CLASS) {
                        boolean bl = ((VariableTree)treePath.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                        for (Tree tree : ((ClassTree)treePath2.getLeaf()).getMembers()) {
                            if (tree.getKind() != Tree.Kind.VARIABLE || sourcePositions.getStartPosition(treePath.getCompilationUnit(), tree) < (long)n || !bl && ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
                            hashSet.add(trees.getElement(new TreePath(treePath2, tree)));
                        }
                    }
                    return hashSet;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)treePath.getLeaf();
                    if (sourcePositions.getEndPosition(treePath.getCompilationUnit(), enhancedForLoopTree.getExpression()) < (long)n) break;
                    hashSet.add(trees.getElement(new TreePath(treePath, enhancedForLoopTree.getVariable())));
                }
            }
            treePath = treePath.getParentPath();
        }
        return hashSet;
    }

    public static List<String> varNamesSuggestions(TypeMirror typeMirror, String string, Types types, Elements elements, Iterable<? extends Element> iterable, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (typeMirror == null) {
            return arrayList;
        }
        Object object4 = Utilities.varNamesForType(typeMirror, types, elements);
        if (bl) {
            object3 = new ArrayList(object4.size());
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                object3.add(Utilities.getConstName((String)object));
            }
            object4 = object3;
        }
        object3 = string;
        while (object3 != null && ((String)object3).length() > 0) {
            object2 = new ArrayList();
            object = object4.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!Utilities.startsWith(string2, (String)object3)) continue;
                object2.add(string2);
            }
            if (object2.isEmpty()) {
                object3 = Utilities.nextName((CharSequence)object3);
                continue;
            }
            object4 = object2;
            string = string.substring(0, string.length() - ((String)object3).length());
            object3 = null;
        }
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            boolean bl2 = typeMirror.getKind().isPrimitive();
            if (string != null && string.length() > 0) {
                object = bl ? string.toUpperCase(Locale.ENGLISH) + '_' + (String)object : string + ((String)object).toUpperCase(Locale.ENGLISH).charAt(0) + ((String)object).substring(1);
            }
            int n = 1;
            while (Utilities.isClashing((String)object, iterable)) {
                if (bl2) {
                    char c = ((String)object).charAt(0);
                    c = (char)(c + '\u0001');
                    object = Character.toString(c);
                    if (c != 'z') continue;
                    bl2 = false;
                    continue;
                }
                object = (String)object + n++;
            }
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public static boolean inAnonymousOrLocalClass(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS && treePath2.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && treePath2.getLeaf().getKind() != Tree.Kind.CLASS) {
            return true;
        }
        return Utilities.inAnonymousOrLocalClass(treePath2);
    }

    private static List<String> varNamesForType(TypeMirror typeMirror, Types types, Elements elements) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                TypeElement typeElement = elements.getTypeElement("java.lang.Iterable");
                DeclaredType declaredType = typeElement != null ? types.getDeclaredType(typeElement, new TypeMirror[0]) : null;
                TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
                if (typeMirror2.getKind() == TypeKind.ARRAY && declaredType != null && types.isSubtype(typeMirror2, declaredType)) {
                    return Utilities.varNamesForType(typeMirror2, types, elements);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : Utilities.varNamesForType(typeMirror2, types, elements)) {
                    arrayList.add(string.endsWith("s") ? string + "es" : string + "s");
                }
                return arrayList;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return Collections.singletonList(((Object)typeMirror).toString().substring(0, 1));
            }
            case TYPEVAR: {
                return Collections.singletonList(((Object)typeMirror).toString().toLowerCase(Locale.ENGLISH));
            }
            case ERROR: {
                String string = ((ErrorType)typeMirror).asElement().getSimpleName().toString();
                if (string.toUpperCase(Locale.ENGLISH).contentEquals(string)) {
                    return Collections.singletonList(string.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<String> arrayList = new ArrayList<String>();
                if ("Iterator".equals(string)) {
                    arrayList.add("it");
                }
                while ((string = Utilities.nextName(string)).length() > 0) {
                    arrayList.add(string);
                    stringBuilder.append(string.charAt(0));
                }
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                }
                return arrayList;
            }
            case DECLARED: {
                List<? extends TypeMirror> list;
                TypeElement typeElement = elements.getTypeElement("java.lang.Iterable");
                DeclaredType declaredType = typeElement != null ? types.getDeclaredType(typeElement, new TypeMirror[0]) : null;
                String string = ((DeclaredType)typeMirror).asElement().getSimpleName().toString();
                if (string.toUpperCase(Locale.ENGLISH).contentEquals(string)) {
                    return Collections.singletonList(string.toLowerCase(Locale.ENGLISH));
                }
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList<String> arrayList = new ArrayList<String>();
                if ("Iterator".equals(string)) {
                    arrayList.add("it");
                }
                while ((string = Utilities.nextName(string)).length() > 0) {
                    arrayList.add(string);
                    stringBuilder.append(string.charAt(0));
                }
                if (declaredType != null && types.isSubtype(typeMirror, declaredType) && (list = ((DeclaredType)typeMirror).getTypeArguments()).size() > 0) {
                    TypeMirror typeMirror3 = list.get(0);
                    if (typeMirror3.getKind() == TypeKind.ARRAY || typeMirror3.getKind() != TypeKind.WILDCARD && types.isSubtype(typeMirror3, declaredType)) {
                        arrayList.addAll(Utilities.varNamesForType(typeMirror3, types, elements));
                    } else {
                        for (String string2 : Utilities.varNamesForType(typeMirror3, types, elements)) {
                            arrayList.add(string2.endsWith("s") ? string2 + "es" : string2 + "s");
                        }
                    }
                }
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                }
                return arrayList;
            }
            case WILDCARD: {
                TypeMirror typeMirror4 = ((WildcardType)typeMirror).getExtendsBound();
                if (typeMirror4 == null) {
                    typeMirror4 = ((WildcardType)typeMirror).getSuperBound();
                }
                if (typeMirror4 == null) break;
                return Utilities.varNamesForType(typeMirror4, types, elements);
            }
        }
        return Collections.emptyList();
    }

    private static String getConstName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!bl) {
                    stringBuilder.append('_');
                }
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            stringBuilder.append(Character.toUpperCase(c));
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static String nextName(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char c2 = Character.toLowerCase(c);
            stringBuilder.append(c2);
            stringBuilder.append(charSequence.subSequence(i + 1, charSequence.length()));
            break;
        }
        return stringBuilder.toString();
    }

    private static boolean isClashing(String string, Iterable<? extends Element> iterable) {
        if (JavaTokenContext.getKeyword((String)string) != null) {
            return true;
        }
        for (Element element : iterable) {
            if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER && element.getKind() != ElementKind.EXCEPTION_PARAMETER || !string.contentEquals(element.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutableElement fuzzyResolveMethodInvocation(CompilationInfo compilationInfo, TreePath treePath, TypeMirror[] typeMirrorArray, int[] nArray) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION || treePath.getLeaf().getKind() == Tree.Kind.NEW_CLASS);
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
            void var7_13;
            Object object;
            Object object2;
            LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
            for (ExpressionTree object32 : methodInvocationTree.getArguments()) {
                object2 = new TreePath(treePath, object32);
                linkedList.add(compilationInfo.getTrees().getTypeMirror((TreePath)object2));
            }
            switch (methodInvocationTree.getMethodSelect().getKind()) {
                case IDENTIFIER: {
                    object2 = compilationInfo.getTrees().getScope(treePath);
                    TypeElement typeElement = object2.getEnclosingClass();
                    TypeMirror expressionTree = typeElement != null ? typeElement.asType() : null;
                    object = ((IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString();
                    break;
                }
                case MEMBER_SELECT: {
                    TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression()));
                    object = ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getIdentifier().toString();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (var7_13 == null || var7_13.getKind() != TypeKind.DECLARED) {
                return null;
            }
            return Utilities.resolveMethod(compilationInfo, linkedList, (DeclaredType)var7_13, false, false, (String)object, typeMirrorArray, nArray);
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
            NewClassTree newClassTree = (NewClassTree)treePath.getLeaf();
            for (ExpressionTree expressionTree : newClassTree.getArguments()) {
                TreePath treePath2 = new TreePath(treePath, expressionTree);
                linkedList.add(compilationInfo.getTrees().getTypeMirror(treePath2));
            }
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, newClassTree.getIdentifier()));
            if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) {
                return null;
            }
            return Utilities.resolveMethod(compilationInfo, linkedList, (DeclaredType)typeMirror, false, true, null, typeMirrorArray, nArray);
        }
        return null;
    }

    private static Iterable<ExecutableElement> execsIn(CompilationInfo compilationInfo, TypeElement typeElement, boolean bl, String string) {
        if (bl) {
            return ElementFilter.constructorsIn(compilationInfo.getElements().getAllMembers(typeElement));
        }
        LinkedList<ExecutableElement> linkedList = new LinkedList<ExecutableElement>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers(typeElement))) {
            if (!string.equals(executableElement.getSimpleName().toString())) continue;
            linkedList.add(executableElement);
        }
        return linkedList;
    }

    private static ExecutableElement resolveMethod(CompilationInfo compilationInfo, List<TypeMirror> list, DeclaredType declaredType, boolean bl, boolean bl2, String string, TypeMirror[] typeMirrorArray, int[] nArray) {
        ExecutableElement executableElement = null;
        block0: for (ExecutableElement executableElement2 : Utilities.execsIn(compilationInfo, (TypeElement)declaredType.asElement(), bl2, string)) {
            if (!compilationInfo.getTypes().isSubtype(declaredType, ((TypeElement)executableElement2.getEnclosingElement()).asType()) || executableElement2.getParameters().size() != list.size()) continue;
            TypeMirror typeMirror = null;
            int n = -1;
            ExecutableType executableType = (ExecutableType)compilationInfo.getTypes().asMemberOf(declaredType, executableElement2);
            Iterator<? extends TypeMirror> iterator = executableType.getParameterTypes().iterator();
            Iterator<TypeMirror> iterator2 = list.iterator();
            boolean bl3 = false;
            int n2 = 0;
            while (iterator.hasNext() && iterator2.hasNext()) {
                TypeMirror typeMirror2 = iterator.next();
                TypeMirror typeMirror3 = iterator2.next();
                if (!compilationInfo.getTypes().isAssignable(typeMirror3, typeMirror2)) {
                    if (bl3) continue block0;
                    bl3 = true;
                    typeMirror = typeMirror2;
                    n = n2;
                }
                ++n2;
            }
            if (!bl3) continue;
            if (typeMirrorArray[0] == null) {
                typeMirrorArray[0] = typeMirror;
                nArray[0] = n;
                executableElement = executableElement2;
                continue;
            }
            if (nArray[0] == n && compilationInfo.getTypes().isSameType(typeMirrorArray[0], typeMirror)) continue;
            return null;
        }
        return executableElement;
    }

    static {
        preferencesTracker = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                String string;
                String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
                if (string == null || "completion-case-sensitive".equals(string)) {
                    Utilities.setCaseSensitive(preferences.getBoolean("completion-case-sensitive", false));
                }
                if (string == null || "show-deprecated-members".equals(string)) {
                    Utilities.setShowDeprecatedMembers(preferences.getBoolean("show-deprecated-members", true));
                }
            }
        };
        cachedPrefix = null;
        cachedPattern = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement packageElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? packageElement.getQualifiedName() : packageElement.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement typeElement, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean bl) {
            super(new StringBuilder());
            this.varArg = bl;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Boolean bl) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
                Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                if (iterator.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (iterator.hasNext()) {
                        this.visit(iterator.next(), bl);
                        if (!iterator.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(Utilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType arrayType, Boolean bl) {
            boolean bl2 = this.varArg;
            this.varArg = false;
            this.visit(arrayType.getComponentType(), bl);
            return ((StringBuilder)this.DEFAULT_VALUE).append(bl2 ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
            Object object;
            Element element = typeVariable.asElement();
            if (element != null && !Utilities.CAPTURED_WILDCARD.equals(object = element.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append((String)object);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                object = typeVariable.getLowerBound();
                if (object != null && object.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit((TypeMirror)object, bl);
                } else {
                    object = typeVariable.getUpperBound();
                    if (object != null && object.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (object.getKind() == TypeKind.TYPEVAR) {
                            object = ((TypeVariable)object).getLowerBound();
                        }
                        this.visit((TypeMirror)object, bl);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType wildcardType, Boolean bl) {
            int n = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror typeMirror = wildcardType.getSuperBound();
            if (typeMirror == null) {
                typeMirror = wildcardType.getExtendsBound();
                if (typeMirror != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (typeMirror.getKind() == TypeKind.WILDCARD) {
                        typeMirror = ((WildcardType)typeMirror).getSuperBound();
                    }
                    this.visit(typeMirror, bl);
                } else if (!(n != 0 || (typeMirror = SourceUtils.getBound((WildcardType)wildcardType)) == null || typeMirror.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(typeMirror, bl);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(typeMirror, bl);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Boolean bl) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

