/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.FileScanningWorker;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskCache;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskManager;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerImpl
extends TaskManager {
    public static final String PROP_SCOPE = "taskScanningScope";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_WORKING_STATUS = "workingStatus";
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private FileScanningWorker worker;
    private TaskCache taskCache = new TaskCache();
    private TaskList taskList = new TaskList();
    private TaskScanningScope scope = Accessor.getEmptyScope();
    private TaskFilter filter = TaskFilter.EMPTY;
    private static TaskManagerImpl theInstance;
    private final Set<PushTaskScanner> workingScanners = new HashSet<PushTaskScanner>(10);
    private boolean fileScannerWorking = false;
    private boolean workingStatus = false;
    private FileChangeListener fileListener = null;

    public static TaskManagerImpl getInstance() {
        if (null == theInstance) {
            theInstance = new TaskManagerImpl();
        }
        return theInstance;
    }

    public void observe(final TaskScanningScope taskScanningScope, final TaskFilter taskFilter) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doObserve(taskScanningScope, taskFilter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doObserve(TaskScanningScope taskScanningScope, TaskFilter taskFilter) {
        TaskScanningScope taskScanningScope2 = this.scope;
        TaskFilter taskFilter2 = this.filter;
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (null == taskScanningScope || Accessor.getEmptyScope().equals(taskScanningScope)) {
                this.scope.attach(null);
                this.stopWorker();
                this.listenToFileSystemChanges(this.scope, false);
                this.workingScanners.clear();
                this.fileScannerWorking = false;
                for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                    pushTaskScanner.setScope(null, null);
                }
                for (FileTaskScanner fileTaskScanner : ScannerList.getFileScannerList().getScanners()) {
                    fileTaskScanner.attach(null);
                }
                this.scope = Accessor.getEmptyScope();
                this.filter = TaskFilter.EMPTY;
                this.taskList.clear();
                this.taskCache.clear();
                this.setWorkingStatus(false);
            } else {
                if (null == taskFilter) {
                    taskFilter = TaskFilter.EMPTY;
                }
                if (!this.scope.equals(taskScanningScope) || !this.filter.equals(taskFilter)) {
                    this.taskList.clear();
                    if (!taskScanningScope.equals(this.scope)) {
                        this.scope.attach(null);
                        taskScanningScope.attach(Accessor.createCallback((TaskManager)this, taskScanningScope));
                    }
                    this.workingScanners.clear();
                    this.fileScannerWorking = false;
                    this.setWorkingStatus(false);
                    this.scope = taskScanningScope;
                    this.filter = taskFilter;
                    this.attachFileScanners(taskFilter, this.filter);
                    this.attachPushScanners(taskScanningScope, taskFilter, this.filter);
                    this.listenToFileSystemChanges(this.scope, true);
                    this.startWorker();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            TaskManagerImpl.this.worker.scan(TaskManagerImpl.this.scope.iterator(), TaskManagerImpl.this.filter);
                        }
                    });
                }
            }
        }
        this.propertySupport.firePropertyChange(PROP_SCOPE, taskScanningScope2, taskScanningScope);
        this.propertySupport.firePropertyChange(PROP_FILTER, taskFilter2, taskFilter);
    }

    private void attachFileScanners(TaskFilter taskFilter, TaskFilter taskFilter2) {
        for (FileTaskScanner fileTaskScanner : this.getFileScanners()) {
            if (!taskFilter.isEnabled(fileTaskScanner)) {
                fileTaskScanner.attach(null);
                continue;
            }
            if (!taskFilter.isEnabled(fileTaskScanner)) continue;
            fileTaskScanner.attach(Accessor.createCallback((TaskManager)this, fileTaskScanner));
        }
    }

    private void attachPushScanners(TaskScanningScope taskScanningScope, TaskFilter taskFilter, TaskFilter taskFilter2) {
        for (PushTaskScanner pushTaskScanner : this.getPushScanners()) {
            if (!taskFilter.isEnabled(pushTaskScanner)) {
                pushTaskScanner.setScope(null, null);
                continue;
            }
            if (!taskFilter.isEnabled(pushTaskScanner)) continue;
            pushTaskScanner.setScope(taskScanningScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
        }
    }

    Iterable<? extends FileTaskScanner> getFileScanners() {
        return ScannerList.getFileScannerList().getScanners();
    }

    Iterable<? extends PushTaskScanner> getPushScanners() {
        return ScannerList.getPushScannerList().getScanners();
    }

    public void abort() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doAbort();
            }
        });
    }

    private void doAbort() {
        if (null != this.worker) {
            this.worker.abort();
        }
        for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
            pushTaskScanner.setScope(null, null);
        }
        this.workingScanners.clear();
        this.fileScannerWorking = false;
        this.setWorkingStatus(false);
    }

    boolean isObserved() {
        return !Accessor.getEmptyScope().equals(this.getScope());
    }

    public TaskScanningScope getScope() {
        return this.scope;
    }

    public TaskList getTasks() {
        return this.taskList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void startWorker() {
        if (null == this.worker) {
            this.worker = new FileScanningWorker(this.taskCache, this.taskList, this.filter, new FileScannerProgress());
            RequestProcessor.getDefault().post((Runnable)this.worker);
        }
    }

    private void stopWorker() {
        if (null != this.worker) {
            this.worker.kill();
            this.worker = null;
        }
    }

    private void maybeScanResource(final FileObject fileObject, final boolean bl) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TaskManagerImpl.this.isObserved() && TaskManagerImpl.this.scope.isInScope(fileObject)) {
                    TaskManagerImpl taskManagerImpl = TaskManagerImpl.this;
                    synchronized (taskManagerImpl) {
                        if (bl) {
                            TaskManagerImpl.this.taskCache.clear(fileObject);
                            TaskManagerImpl.this.taskList.clear(fileObject);
                        }
                        TaskManagerImpl.this.startWorker();
                        TaskManagerImpl.this.worker.priorityScan(fileObject);
                    }
                }
            }
        });
    }

    private FileChangeListener getFileChangeListener() {
        if (null == this.fileListener) {
            this.fileListener = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                    TaskManagerImpl.this.maybeScanResource(fileEvent.getFile(), false);
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    TaskManagerImpl.this.maybeScanResource(fileEvent.getFile(), false);
                }

                public void fileChanged(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    TaskManagerImpl.this.maybeScanResource(fileObject, true);
                }

                public void fileDeleted(final FileEvent fileEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            TaskManagerImpl taskManagerImpl = TaskManagerImpl.this;
                            synchronized (taskManagerImpl) {
                                FileObject fileObject = fileEvent.getFile();
                                TaskManagerImpl.this.taskCache.clear(fileObject);
                                TaskManagerImpl.this.taskList.clear(fileObject);
                            }
                        }
                    });
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    TaskManagerImpl.this.maybeScanResource(fileRenameEvent.getFile(), false);
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                }
            };
        }
        return this.fileListener;
    }

    private void listenToFileSystemChanges(TaskScanningScope taskScanningScope, boolean bl) {
        FileSystem fileSystem = this.getFileSystem(taskScanningScope);
        if (null != fileSystem) {
            if (bl) {
                fileSystem.addFileChangeListener(this.getFileChangeListener());
            } else if (null != this.fileListener) {
                fileSystem.removeFileChangeListener(this.getFileChangeListener());
                this.fileListener = null;
            }
        }
    }

    private FileSystem getFileSystem(TaskScanningScope taskScanningScope) {
        Iterator iterator;
        if (null != taskScanningScope && (iterator = taskScanningScope.iterator()).hasNext()) {
            try {
                FileObject fileObject = (FileObject)iterator.next();
                if (null != fileObject) {
                    return fileObject.getFileSystem();
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.getLogger().log(Level.WARNING, fileStateInvalidException.getMessage(), fileStateInvalidException);
            }
        }
        return null;
    }

    public TaskFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(final FileTaskScanner fileTaskScanner, FileObject ... fileObjectArray) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskCache.clear(fileTaskScanner, fileObjectArray);
            this.taskList.clear(fileTaskScanner, fileObjectArray);
            if (this.isObserved() && this.isEnabled(fileTaskScanner)) {
                final ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
                for (int i = 0; i < fileObjectArray.length && null != this.scope; ++i) {
                    if (!this.scope.isInScope(fileObjectArray[i])) continue;
                    arrayList.add(fileObjectArray[i]);
                }
                if (!arrayList.isEmpty()) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            TaskManagerImpl.this.startWorker();
                            TaskManagerImpl.this.worker.priorityScan(fileTaskScanner, arrayList.toArray(new FileObject[arrayList.size()]));
                        }
                    };
                    RequestProcessor.getDefault().post(runnable);
                }
            }
        }
    }

    private boolean isEnabled(FileTaskScanner fileTaskScanner) {
        return this.getFilter().isEnabled(fileTaskScanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner fileTaskScanner) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskCache.clear(fileTaskScanner);
            this.taskList.clear(fileTaskScanner);
            if (this.isObserved() && this.isEnabled(fileTaskScanner)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TaskManagerImpl.this.startWorker();
                        TaskManagerImpl.this.worker.scan(TaskManagerImpl.this.scope.iterator(), TaskManagerImpl.this.filter);
                    }
                };
                RequestProcessor.getDefault().post(runnable);
            }
        }
    }

    public void refresh(final TaskScanningScope taskScanningScope) {
        if (this.scope.equals(taskScanningScope)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    TaskManagerImpl.this.doRefresh(taskScanningScope);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(TaskScanningScope taskScanningScope) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.scope.equals(taskScanningScope)) {
                this.listenToFileSystemChanges(this.scope, false);
                this.listenToFileSystemChanges(this.scope, true);
                this.taskList.clear();
                if (this.isObserved()) {
                    for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                        pushTaskScanner.setScope(null, null);
                        if (!this.getFilter().isEnabled(pushTaskScanner)) continue;
                        pushTaskScanner.setScope(taskScanningScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            TaskManagerImpl.this.startWorker();
                            TaskManagerImpl.this.worker.scan(TaskManagerImpl.this.scope.iterator(), TaskManagerImpl.this.filter);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(PushTaskScanner pushTaskScanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.add(pushTaskScanner);
            this.setWorkingStatus(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(PushTaskScanner pushTaskScanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.remove(pushTaskScanner);
            this.setWorkingStatus(this.isWorking());
        }
    }

    public void setTasks(PushTaskScanner pushTaskScanner, FileObject fileObject, List<? extends Task> list) {
        if (this.isObserved() && this.scope.isInScope(fileObject)) {
            this.taskList.setTasks(pushTaskScanner, fileObject, list, this.filter);
        }
    }

    public void clearAllTasks(PushTaskScanner pushTaskScanner) {
        this.taskList.clear(pushTaskScanner);
    }

    private Logger getLogger() {
        return Logger.getLogger(TaskManagerImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkingStatus(boolean bl) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (bl != this.workingStatus) {
                boolean bl2 = this.workingStatus;
                this.workingStatus = bl;
                this.propertySupport.firePropertyChange(PROP_WORKING_STATUS, bl2, bl);
                if (!this.workingStatus) {
                    this.workingScanners.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorking() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            return !this.workingScanners.isEmpty() || this.fileScannerWorking;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (!this.isWorking()) {
                return;
            }
            this._waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            try {
                this.workingScanners.wait();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }

    class FileScannerProgress {
        FileScannerProgress() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void started() {
            Set set = TaskManagerImpl.this.workingScanners;
            synchronized (set) {
                TaskManagerImpl.this.fileScannerWorking = true;
                TaskManagerImpl.this.setWorkingStatus(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Set set = TaskManagerImpl.this.workingScanners;
            synchronized (set) {
                TaskManagerImpl.this.fileScannerWorking = false;
                TaskManagerImpl.this.setWorkingStatus(TaskManagerImpl.this.isWorking());
            }
        }
    }
}

