/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterRepository {
    private static FilterRepository theInstance;
    private LinkedList<TaskFilter> filters = new LinkedList();
    private int active = -1;

    FilterRepository() {
    }

    public static FilterRepository getDefault() {
        if (null == theInstance) {
            theInstance = new FilterRepository();
        }
        return theInstance;
    }

    public void assign(FilterRepository filterRepository) {
        if (filterRepository != this) {
            this.filters.clear();
            Iterator iterator = filterRepository.filters.iterator();
            while (iterator.hasNext()) {
                this.filters.add((TaskFilter)((TaskFilter)iterator.next()).clone());
            }
            this.active = filterRepository.active;
        }
    }

    public Object clone() {
        FilterRepository filterRepository = new FilterRepository();
        filterRepository.assign(this);
        return filterRepository;
    }

    public List<TaskFilter> getAllFilters() {
        return new ArrayList<TaskFilter>(this.filters);
    }

    void add(TaskFilter taskFilter) {
        this.filters.add(taskFilter);
    }

    void remove(TaskFilter taskFilter) {
        if (taskFilter == this.getActive()) {
            this.setActive(null);
        }
        this.filters.remove(taskFilter);
    }

    Iterator<TaskFilter> iterator() {
        return this.filters.iterator();
    }

    int size() {
        return this.filters.size();
    }

    TaskFilter getFilterByName(String string) {
        for (TaskFilter taskFilter : this.filters) {
            if (!taskFilter.getName().equals(string)) continue;
            return taskFilter;
        }
        return null;
    }

    public TaskFilter getActive() {
        return this.active == -1 || this.filters.isEmpty() ? null : this.filters.get(this.active);
    }

    public void setActive(TaskFilter taskFilter) {
        if (taskFilter == null) {
            this.active = -1;
        } else {
            int n = this.filters.indexOf(taskFilter);
            if (n != -1) {
                this.active = n;
            }
        }
    }

    public void load() throws IOException {
        Object object;
        this.filters.clear();
        this.active = -1;
        Preferences preferences = NbPreferences.forModule(FilterRepository.class);
        preferences = preferences.node("Filters");
        this.active = preferences.getInt("active", -1);
        int n = preferences.getInt("count", 0);
        for (int i = 0; i < n; ++i) {
            object = new TaskFilter();
            try {
                ((TaskFilter)object).load(preferences, "Filter_" + i);
            }
            catch (BackingStoreException backingStoreException) {
                IOException iOException = new IOException("Cannot load filter repository");
                iOException.initCause(backingStoreException);
                throw iOException;
            }
            this.filters.add((TaskFilter)object);
        }
        if (preferences.getBoolean("firstTimeStart", true)) {
            preferences.putBoolean("firstTimeStart", false);
            TaskFilter taskFilter = this.createNewFilter();
            taskFilter.setName(NbBundle.getMessage(FilterRepository.class, (String)"LBL_DefaultFilter"));
            object = new TypesFilter();
            ((TypesFilter)object).setTaskCountLimit(100);
            taskFilter.setTypesFilter((TypesFilter)object);
            taskFilter.setKeywordsFilter(new KeywordsFilter());
            this.filters.add(taskFilter);
            this.setActive(taskFilter);
            this.save();
        }
    }

    public void save() throws IOException {
        try {
            Preferences preferences = NbPreferences.forModule(FilterRepository.class);
            preferences = preferences.node("Filters");
            preferences.clear();
            preferences.putBoolean("firstTimeStart", false);
            preferences.putInt("count", this.filters.size());
            preferences.putInt("active", this.active);
            for (int i = 0; i < this.filters.size(); ++i) {
                TaskFilter taskFilter = this.filters.get(i);
                taskFilter.save(preferences, "Filter_" + i);
            }
        }
        catch (BackingStoreException backingStoreException) {
            IOException iOException = new IOException("Cannot save filter repository");
            iOException.initCause(backingStoreException);
            throw iOException;
        }
    }

    TaskFilter createNewFilter() {
        return new TaskFilter(NbBundle.getMessage(FilterRepository.class, (String)"LBL_NewFilter"));
    }

    void clear() {
        this.filters.clear();
        this.setActive(null);
    }

    List<TaskFilter> getFilters() {
        return new ArrayList<TaskFilter>(this.filters);
    }
}

