/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MissingPlatformError;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileObject;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.tasklist.ErrorAnnotator;
import org.netbeans.modules.java.source.tasklist.JavaTaskProvider;
import org.netbeans.modules.java.source.tasklist.RebuildOraculum;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassNamesForFileOraculumImpl;
import org.netbeans.modules.java.source.usages.ClassPathRootsListener;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.netbeans.modules.java.source.usages.VirtualSourceProviderQuery;
import org.netbeans.modules.java.source.util.LowMemoryEvent;
import org.netbeans.modules.java.source.util.LowMemoryListener;
import org.netbeans.modules.java.source.util.LowMemoryNotifier;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUpdater
implements PropertyChangeListener,
FileChangeListener,
ClassPathRootsListener.ClassPathRootsChangedListener {
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private static final Logger ACTIVITY_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".activity");
    private static final Set<String> warnedIgnoredRoots = Collections.synchronizedSet(new HashSet());
    private static final Set<String> ignoredDirectories = RepositoryUpdater.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS .svn");
    private static final boolean noscan = Boolean.getBoolean("netbeans.javacore.noscan");
    private static final boolean PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
    static final String GOING_TO_RECOMPILE = "Going to recompile: {0}";
    static final String CONTAINS_TASKLIST_DATA = "containsTasklistData";
    static final String CONTAINS_TASKLIST_DEPENDENCY_DATA = "containsTasklistDependencyData";
    static final String DIRTY_ROOT = "dirty";
    static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    static final String EXTRA_COMPILER_OPTIONS = "extraCompilerOptions";
    static final String CLASSPATH_ATTRIBUTE = "classPath";
    static final String DIGEST = "digest";
    static int DELAY = Utilities.isWindows() ? 2000 : 1000;
    private static RepositoryUpdater instance;
    private final GlobalSourcePath cpImpl;
    private final ClassPath cp;
    private final ClassPath ucp;
    private final ClassPath binCp;
    private Set<URL> scannedRoots;
    private Set<URL> scannedBinaries;
    private Map<URL, List<URL>> deps;
    private static final RequestProcessor WORKER;
    private Work currentWork;
    private boolean dirty;
    private volatile int noSubmited;
    private volatile boolean notInitialized = true;
    private final AtomicBoolean closed;
    private Map<ClassPath, Set<URL>> classPath2Roots;
    private final Map<URL, JavaFileFilterImplementation> filters = Collections.synchronizedMap(new HashMap());
    private final FilterListener filterListener = new FilterListener();
    private final Map<URL, Collection<File>> url2Recompile = new HashMap<URL, Collection<File>>();
    private boolean recompileScheduled;
    private boolean recompileToBeScheduled;
    private final Set<URL> recompileFilesWithErrors = new HashSet<URL>();
    private boolean recompileFilesWithErrorsScheduled;
    private boolean recompileFilesWithErrorsToBeScheduled;
    private final Map<URL, Collection<File>> url2CompileWithDeps = new HashMap<URL, Collection<File>>();
    private final Map<URL, Reference<RequestProcessor.Task>> url2CompileWithDepsTask = new HashMap<URL, Reference<RequestProcessor.Task>>();
    private final Set<URL> rootsWithVirtualSource = new HashSet<URL>();
    private boolean compileWithDepsToBeScheduled;
    private int compileScheduled;
    private int lockRU;
    private final Map<URL, String> root2DebugData = new HashMap<URL, String>();
    static Callback CALLBACK;
    private static final int MAX_DUMPS = 255;

    private RepositoryUpdater() {
        this.closed = new AtomicBoolean(false);
        this.scannedRoots = Collections.synchronizedSet(new HashSet());
        this.scannedBinaries = Collections.synchronizedSet(new HashSet());
        this.deps = Collections.synchronizedMap(new HashMap());
        this.cpImpl = GlobalSourcePath.getDefault();
        this.cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getSourcePath());
        this.ucp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getUnknownSourcePath());
        this.binCp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getBinaryPath());
        this.classPath2Roots = Collections.synchronizedMap(new WeakHashMap());
        this.open();
    }

    public ClassPath getScannedSources() {
        return this.cp;
    }

    public ClassPath getScannedBinaries() {
        return this.binCp;
    }

    public Map<URL, List<URL>> getDependencies() {
        return new HashMap<URL, List<URL>>(this.deps);
    }

    private synchronized void open() throws IllegalStateException {
        if (this.notInitialized) {
            try {
                this.cpImpl.setExcludesListener(this);
                this.cp.addPropertyChangeListener((PropertyChangeListener)this);
                this.registerFileSystemListener();
                this.submitBatch();
                this.notInitialized = false;
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new IllegalStateException();
            }
        }
    }

    public void close() {
        try {
            this.closed.set(true);
            this.cpImpl.setExcludesListener(null);
            this.cp.removePropertyChangeListener((PropertyChangeListener)this);
            this.unregisterFileSystemListener();
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "propertyChange from ClassPath: evt={0}, property name={1}", new Object[]{propertyChangeEvent.toString(), propertyChangeEvent.getPropertyName()});
        }
        if ("roots".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() == this.cp) {
            this.submitBatch();
        }
        if ("includes".equals(propertyChangeEvent.getPropertyName()) && (propertyChangeEvent.getSource() == this.cpImpl || propertyChangeEvent.getSource() == this.cp)) {
            ClassPath classPath = (ClassPath)propertyChangeEvent.getNewValue();
            assert (classPath != null);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ClassPath change, cp={0}", classPath.toString());
            }
            for (ClassPath.Entry entry : classPath.entries()) {
                URL uRL = entry.getURL();
                this.scheduleCompilation(uRL, uRL, true, false);
            }
            return;
        }
    }

    @Override
    public void rootsChanged(Collection<ClassPath> collection, File file) {
        LinkedList<URL> linkedList;
        FileObject fileObject;
        assert (collection != null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "modified roots changedCp={0}", collection.toString());
        }
        FileObject fileObject2 = fileObject = file != null ? FileUtil.toFileObject((File)file) : null;
        if (fileObject != null && RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (linkedList = this.getOwningBinaryRoot(fileObject)) != null) {
            try {
                this.submit(Work.binary(fileObject, linkedList));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        linkedList = new LinkedList();
        for (ClassPath classPath : collection) {
            Set<URL> set = this.classPath2Roots.get(classPath);
            if (set == null) continue;
            for (URL uRL : set) {
                FileObject fileObject3;
                List<URL> list = this.deps.get(uRL);
                if (list != null && (fileObject3 = URLMapper.findFileObject((URL)uRL)) != null) {
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject3, (String)"classpath/boot");
                    ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject3, (String)"classpath/compile");
                    ClassPath[] classPathArray = new ClassPath[]{classPath2, classPath3};
                    LinkedList<URL> linkedList2 = new LinkedList<URL>();
                    for (int i = 0; i < classPathArray.length; ++i) {
                        ClassPath classPath4 = classPathArray[i];
                        if (classPath4 == null) continue;
                        for (ClassPath.Entry entry : classPath4.entries()) {
                            URL uRL2 = entry.getURL();
                            URL[] uRLArray = this.cpImpl.getSourceRootForBinaryRoot(uRL2, classPath4, false);
                            if (uRLArray == null) continue;
                            for (URL uRL3 : uRLArray) {
                                if (uRL3.equals(uRL)) continue;
                                linkedList2.add(uRL3);
                            }
                        }
                    }
                    this.deps.put(uRL, linkedList2);
                }
                linkedList.add(uRL);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "roots for filter change={0}", ((Object)linkedList).toString());
        }
        this.submit(Work.filterChange(linkedList, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBatch() {
        Work work;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.currentWork != null) {
                this.dirty = true;
                return;
            }
            this.currentWork = work = Work.batch();
        }
        this.submit(work);
    }

    public synchronized boolean isScanInProgress() {
        return this.notInitialized || this.noSubmited > 0 || !GlobalSourcePath.getDefault().isFinished();
    }

    public synchronized void waitScanFinished() throws InterruptedException {
        while (this.isScanInProgress()) {
            this.wait(1000L);
        }
    }

    private synchronized boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        this.currentWork = null;
        return false;
    }

    private synchronized void resetDirty(Work work) {
        assert (work != null);
        if (work == this.currentWork) {
            this.dirty = false;
            this.currentWork = null;
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        try {
            URL uRL;
            boolean bl = false;
            if ((RepositoryUpdater.isJava(fileObject) || fileObject.isFolder() || (bl = VirtualSourceProviderQuery.hasVirtualSource(fileObject))) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                File file;
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (uRL2 != null && (file = FileUtil.toFile((FileObject)fileObject.getParent())) != null) {
                    Object object;
                    String string = fileRenameEvent.getExt();
                    boolean bl2 = false;
                    if (RepositoryUpdater.isJava(string) || (bl2 = VirtualSourceProviderQuery.hasVirtualSource(string))) {
                        object = fileRenameEvent.getName();
                        object = (String)object + '.' + string;
                        URL uRL3 = new File(file, (String)object).toURI().toURL();
                        this.submit(Work.delete(uRL3, uRL2, fileObject.isFolder(), bl2));
                        if (TasklistSettings.isTasklistEnabled()) {
                            ErrorAnnotator errorAnnotator;
                            Set<URL> set = TaskCache.getDefault().dumpErrors(uRL2, uRL3, FileUtil.toFile((FileObject)fileObject), Collections.emptyList());
                            if (TasklistSettings.isBadgesEnabled() && (errorAnnotator = ErrorAnnotator.getAnnotator()) != null) {
                                errorAnnotator.updateInError(set);
                            }
                        }
                    }
                    object = Work.compile(fileObject, uRL2, bl);
                    WORKER.post(new Runnable((Work)object){
                        final /* synthetic */ Work val$work;
                        {
                            this.val$work = work;
                        }

                        public void run() {
                            RepositoryUpdater.this.submit(this.val$work);
                        }
                    }, DELAY);
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                File file;
                String string = fileRenameEvent.getName();
                String string2 = fileRenameEvent.getExt();
                if (string2.length() > 0) {
                    string = string + '.' + string2;
                }
                if ((file = FileUtil.toFile((FileObject)fileObject.getParent())) != null) {
                    URL uRL4 = new File(file, string).toURI().toURL();
                    this.submit(Work.binary(uRL4, uRL, fileObject.isFolder()));
                    this.submit(Work.binary(fileObject, uRL));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL = this.getOwningSourceRoot(fileObject);
            if (uRL != null && VisibilityQuery.getDefault().isVisible(fileObject)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Folder created: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
                }
                this.scheduleCompilation(fileObject.getURL(), uRL, true, false);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        boolean bl = fileObject.isFolder();
        try {
            URL uRL;
            boolean bl2 = false;
            if ((RepositoryUpdater.isJava(fileObject) || bl || (bl2 = VirtualSourceProviderQuery.hasVirtualSource(fileObject))) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Java file deleted: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL2);
                }
                if (uRL2 != null) {
                    RepositoryUpdater.markRootTasklistDirty(uRL2);
                    this.submit(Work.delete(fileObject, uRL2, bl, bl2));
                    if (TasklistSettings.isTasklistEnabled()) {
                        ErrorAnnotator errorAnnotator;
                        Set<URL> set = TaskCache.getDefault().dumpErrors(uRL2, fileObject.getURL(), FileUtil.toFile((FileObject)fileObject), Collections.emptyList());
                        if (TasklistSettings.isBadgesEnabled() && (errorAnnotator = ErrorAnnotator.getAnnotator()) != null) {
                            errorAnnotator.updateInError(set);
                        }
                        JavaTaskProvider.refresh(fileObject);
                    }
                }
            } else if ((RepositoryUpdater.isBinary(fileObject) || bl) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL;
            if ((RepositoryUpdater.isJava(fileObject) || VirtualSourceProviderQuery.hasVirtualSource(fileObject)) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Java file created: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL2);
                }
                if (uRL2 != null) {
                    RepositoryUpdater.markRootTasklistDirty(uRL2);
                    File file = FileUtil.toFile((FileObject)fileObject);
                    assert (file != null);
                    this.assureCompiledWithDeps(uRL2, file);
                    if (TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled()) {
                        this.assureFilesWithErrorsRecompiled(uRL2);
                    }
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        try {
            URL uRL;
            if ((RepositoryUpdater.isJava(fileObject) || VirtualSourceProviderQuery.hasVirtualSource(fileObject)) && VisibilityQuery.getDefault().isVisible(fileObject)) {
                URL uRL2 = this.getOwningSourceRoot(fileObject);
                File file = FileUtil.toFile((FileObject)fileObject);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Java file changed: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL2);
                }
                if (uRL2 != null && file != null) {
                    RepositoryUpdater.markRootTasklistDirty(uRL2);
                    this.assureCompiledWithDeps(uRL2, file);
                }
            } else if (RepositoryUpdater.isBinary(fileObject) && VisibilityQuery.getDefault().isVisible(fileObject) && (uRL = this.getOwningBinaryRoot(fileObject)) != null) {
                this.submit(Work.binary(fileObject, uRL));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public final void scheduleCompilation(FileObject fileObject, FileObject fileObject2) throws IOException {
        URL uRL = fileObject.getURL();
        URL uRL2 = fileObject2.getURL();
        if (!this.cpImpl.isLibrary(fileObject2)) {
            assert ("file".equals(uRL.getProtocol()) && "file".equals(uRL2.getProtocol()));
            this.scheduleCompilation(uRL, uRL2, fileObject.isFolder(), !RepositoryUpdater.isJava(fileObject));
        }
    }

    private final void scheduleCompilation(URL uRL, URL uRL2, boolean bl, boolean bl2) {
        this.submit(Work.compile(uRL, uRL2, bl, bl2));
    }

    public final CountDownLatch scheduleCompilationAndWait(FileObject fileObject, FileObject fileObject2) throws IOException {
        CountDownLatch[] countDownLatchArray = new CountDownLatch[1];
        this.submit(Work.compile(fileObject, fileObject2.getURL(), countDownLatchArray, fileObject.equals(fileObject2)));
        this.open();
        return countDownLatchArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Work work) {
        if (!noscan) {
            JavaSource.Priority priority;
            Object object = this;
            synchronized (object) {
                ++this.noSubmited;
            }
            object = new CompileWorker(work);
            switch (work.getType()) {
                case RECOMPILE: 
                case RECOMPILE_FILES_WITH_ERRORS: {
                    priority = JavaSource.Priority.LOW;
                    break;
                }
                default: {
                    priority = JavaSource.Priority.MAX;
                }
            }
            JavaSourceAccessor.getINSTANCE().runSpecialTask((CancellableTask<CompilationInfo>)object, priority);
        }
    }

    private void registerFileSystemListener() {
        FileUtil.addFileChangeListener((FileChangeListener)this);
    }

    private void unregisterFileSystemListener() {
        FileUtil.removeFileChangeListener((FileChangeListener)this);
    }

    private URL getOwningSourceRoot(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedRoots);
        for (URL uRL : arrayList) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return uRL;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getOwningBinaryRoot(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        try {
            Set<URL> set = this.scannedBinaries;
            synchronized (set) {
                URL uRL = fileObject.getURL();
                for (URL uRL2 : this.scannedBinaries) {
                    String string;
                    String string2;
                    URL uRL3 = FileUtil.getArchiveFile((URL)uRL2);
                    boolean bl = true;
                    if (uRL3 == null) {
                        uRL3 = uRL2;
                        bl = false;
                    }
                    if ((string2 = uRL3.getPath()).equals(string = uRL.getPath())) {
                        return uRL2;
                    }
                    if (bl || !string.startsWith(string2)) continue;
                    return uRL2;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public void rebuildRoot(URL uRL, boolean bl) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Rebuild Root: " + uRL, new Exception());
        }
        this.submit(Work.filterChange(Collections.singletonList(uRL), bl));
    }

    public void rebuildAll(boolean bl) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Rebuild All.", new Exception());
        }
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (FileObject fileObject : this.getScannedSources().getRoots()) {
            try {
                linkedList.add(fileObject.getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        this.submit(Work.filterChange(linkedList, bl));
    }

    public static int getDelay() {
        return DELAY;
    }

    private void registerClassPath(URL uRL, ClassPath classPath, ClasspathInfo.PathKind pathKind) {
        Set<URL> set = this.classPath2Roots.get(classPath);
        if (set == null) {
            set = new HashSet<URL>();
            this.classPath2Roots.put(classPath, set);
            ClassPathRootsListener.getDefault().addClassPathRootsListener(classPath, pathKind != ClasspathInfo.PathKind.SOURCE, this);
        }
        set.add(uRL);
    }

    private synchronized void assureRecompiled(URL uRL, Collection<File> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Collection<File> collection2 = this.url2Recompile.get(uRL);
        if (collection2 == null) {
            collection2 = new LinkedHashSet<File>();
            this.url2Recompile.put(uRL, collection2);
        }
        collection2.addAll(collection);
        if (!this.recompileScheduled) {
            if (this.lockRU > 0) {
                this.recompileToBeScheduled = true;
            } else {
                this.submit(Work.recompile());
                this.recompileScheduled = true;
            }
        }
    }

    private synchronized void assureFilesWithErrorsRecompiled(URL uRL) {
        this.recompileFilesWithErrors.add(uRL);
        if (!this.recompileFilesWithErrorsScheduled) {
            if (this.lockRU > 0) {
                this.recompileFilesWithErrorsToBeScheduled = true;
            } else {
                this.submit(Work.recompileFilesWithErrors());
                this.recompileFilesWithErrorsScheduled = true;
            }
        }
    }

    private synchronized void assureCompiledWithDeps(final URL uRL, File file) {
        Collection<Object> collection;
        RequestProcessor.Task task;
        Reference<RequestProcessor.Task> reference = this.url2CompileWithDepsTask.get(uRL);
        RequestProcessor.Task task2 = task = reference != null ? reference.get() : null;
        if (task == null || !task.cancel()) {
            if (this.lockRU == 0 || task != null) {
                collection = new LinkedHashSet();
                this.url2CompileWithDeps.put(uRL, collection);
            } else {
                collection = this.url2CompileWithDeps.get(uRL);
                if (collection == null) {
                    collection = new LinkedHashSet();
                    this.url2CompileWithDeps.put(uRL, collection);
                }
            }
            if (this.lockRU == 0) {
                LOGGER.log(Level.FINER, "creating a new task for root: {0}", uRL.toExternalForm());
                final Collection<Object> collection2 = collection;
                task = WORKER.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                        synchronized (repositoryUpdater) {
                            RepositoryUpdater.this.compileScheduled--;
                        }
                        RepositoryUpdater.this.submit(Work.compileWithDeps(uRL, collection2));
                        RepositoryUpdater.this.noSubmited--;
                    }
                });
                this.url2CompileWithDepsTask.put(uRL, new WeakReference<RequestProcessor.Task>(task));
                ++this.compileScheduled;
                ++this.noSubmited;
            } else {
                this.url2CompileWithDepsTask.remove(uRL);
            }
        } else {
            collection = this.url2CompileWithDeps.get(uRL);
        }
        assert (collection != null);
        collection.add(file);
        if (this.lockRU > 0) {
            this.compileWithDepsToBeScheduled = true;
        } else {
            task.schedule(DELAY);
        }
    }

    private void findDependencies(URL uRL, Stack<URL> stack, Map<URL, List<URL>> map) {
        if (map.containsKey(uRL)) {
            return;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return;
        }
        stack.push(uRL);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath[] classPathArray = new ClassPath[]{classPath, classPath2};
        LinkedList<URL> linkedList = new LinkedList<URL>();
        for (int i = 0; i < classPathArray.length; ++i) {
            ClassPath classPath3 = classPathArray[i];
            if (classPath3 == null) continue;
            for (ClassPath.Entry entry : classPath3.entries()) {
                URL uRL2 = entry.getURL();
                URL[] uRLArray = this.cpImpl.getSourceRootForBinaryRoot(uRL2, classPath3, false);
                if (uRLArray == null) continue;
                for (URL uRL3 : uRLArray) {
                    if (uRL3.equals(uRL) || stack.contains(uRL3)) continue;
                    linkedList.add(uRL3);
                    this.findDependencies(uRL3, stack, map);
                }
            }
        }
        map.put(uRL, linkedList);
        stack.pop();
    }

    public synchronized boolean isRULocked() {
        return this.lockRU > 0;
    }

    public synchronized void lockRU() {
        ++this.lockRU;
    }

    public void unlockRU() {
        this.unlockRU(null);
    }

    public synchronized void unlockRU(final Runnable runnable) {
        if (--this.lockRU > 0) {
            return;
        }
        assert (this.lockRU == 0);
        if (this.recompileToBeScheduled) {
            this.submit(Work.recompile());
            this.recompileScheduled = true;
            this.recompileToBeScheduled = false;
        }
        if (this.recompileFilesWithErrorsToBeScheduled) {
            this.submit(Work.recompileFilesWithErrors());
            this.recompileFilesWithErrorsScheduled = true;
            this.recompileFilesWithErrorsToBeScheduled = false;
        }
        if (this.compileWithDepsToBeScheduled) {
            ArrayList<URL> arrayList;
            HashMap<URL, List<URL>> hashMap = new HashMap<URL, List<URL>>();
            for (URL uRL : this.url2CompileWithDeps.keySet()) {
                this.findDependencies(uRL, new Stack<URL>(), hashMap);
            }
            try {
                arrayList = Utilities.topologicalSort(hashMap.keySet(), hashMap);
                Collections.reverse(arrayList);
            }
            catch (TopologicalSortException topologicalSortException) {
                Exceptions.printStackTrace((Throwable)topologicalSortException);
                arrayList = new ArrayList<URL>(this.url2CompileWithDeps.keySet());
            }
            int n = 0;
            for (final URL uRL : arrayList) {
                RequestProcessor.Task task;
                if (!this.url2CompileWithDeps.containsKey(uRL)) continue;
                Reference<RequestProcessor.Task> reference = this.url2CompileWithDepsTask.get(uRL);
                RequestProcessor.Task task2 = task = reference != null ? reference.get() : null;
                if (task == null || !task.cancel()) {
                    final Collection<File> collection = this.url2CompileWithDeps.get(uRL);
                    task = WORKER.create(new Runnable(){

                        public void run() {
                            RepositoryUpdater.this.submit(Work.compileWithDeps(uRL, collection));
                            RepositoryUpdater.this.noSubmited--;
                        }
                    });
                    ++this.noSubmited;
                    this.url2CompileWithDepsTask.put(uRL, new WeakReference<RequestProcessor.Task>(task));
                }
                task.schedule(DELAY + n++);
            }
            this.compileWithDepsToBeScheduled = false;
            if (runnable != null) {
                WORKER.create(new Runnable(){

                    public void run() {
                        RepositoryUpdater.this.submit(Work.notifyFinished(runnable));
                    }
                }).schedule(DELAY + n++);
            }
        }
    }

    private static void markRootTasklistDirty(URL uRL) throws IOException {
        if (TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled()) {
            RepositoryUpdater.ensureAttributeValue(uRL, DIRTY_ROOT, "true", false);
        } else {
            RepositoryUpdater.ensureAttributeValue(uRL, CONTAINS_TASKLIST_DEPENDENCY_DATA, null, false);
            if (!TasklistSettings.isTasklistEnabled()) {
                RepositoryUpdater.ensureAttributeValue(uRL, CONTAINS_TASKLIST_DATA, null, false);
            }
        }
    }

    static boolean ensureAttributeValue(URL uRL, String string, String string2, boolean bl) throws IOException {
        Properties properties = RepositoryUpdater.loadProperties(uRL);
        String string3 = properties.getProperty(string);
        if (string2 != null && string2.equals(string3) || string2 == null && string3 == null) {
            return false;
        }
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        if (bl) {
            properties.setProperty(DIRTY_ROOT, "true");
        }
        RepositoryUpdater.storeProperties(uRL, properties);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ensureAttributeValue attr: " + string + " current: " + string3 + " new: " + string2 + " markDirty: " + bl);
        }
        return true;
    }

    static void setAttribute(URL uRL, String string, String string2) throws IOException {
        Properties properties = RepositoryUpdater.loadProperties(uRL);
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        RepositoryUpdater.storeProperties(uRL, properties);
    }

    static String getAttribute(URL uRL, String string, String string2) throws IOException {
        Properties properties = RepositoryUpdater.loadProperties(uRL);
        return properties.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL) throws IOException {
        File file = RepositoryUpdater.getAttributeFile(uRL);
        Properties properties = new Properties();
        if (!file.exists()) {
            return properties;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                properties.load(bufferedInputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warning("Broken attribute file: " + file.getAbsolutePath());
                Properties properties2 = new Properties();
                Object var7_5 = null;
                ((InputStream)bufferedInputStream).close();
                return properties2;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(URL uRL, Properties properties) throws IOException {
        File file = RepositoryUpdater.getAttributeFile(uRL);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            properties.store(bufferedOutputStream, "");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)bufferedOutputStream).close();
            throw throwable;
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    private static File getAttributeFile(URL uRL) throws IOException {
        File file = Index.getClassFolder(uRL);
        return new File(file.getParentFile(), "attributes.properties");
    }

    private static boolean isJava(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        if ("java".equals(fileObject.getExt().toLowerCase())) {
            return true;
        }
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    private static boolean isJava(String string) {
        return string != null && "java".equals(string.toLowerCase());
    }

    private static boolean isBinary(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getExt().toLowerCase();
        return "class".equals(string) || "jar".equals(string) || "zip".equals(string);
    }

    private static String classPathToString(ClasspathInfo classpathInfo) throws FileStateInvalidException {
        ClassPath classPath = ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(classpathInfo, ClasspathInfo.PathKind.BOOT);
        ClassPath classPath2 = ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(classpathInfo, ClasspathInfo.PathKind.COMPILE);
        ClassPath classPath3 = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        StringBuilder stringBuilder = new StringBuilder();
        RepositoryUpdater.classPathToStringImpl(classPath, stringBuilder);
        RepositoryUpdater.classPathToStringImpl(classPath2, stringBuilder);
        RepositoryUpdater.classPathToStringImpl(classPath3, stringBuilder);
        return stringBuilder.toString();
    }

    private static void classPathToStringImpl(ClassPath classPath, StringBuilder stringBuilder) {
        for (ClassPath.Entry entry : classPath.entries()) {
            URL uRL = entry.getURL();
            stringBuilder.append(uRL.toExternalForm());
            File file = ClassPathRootsListener.fileForURL(uRL);
            if (file != null) {
                stringBuilder.append("(");
                if (file.isFile()) {
                    stringBuilder.append(file.lastModified());
                } else {
                    stringBuilder.append("-1");
                }
                stringBuilder.append(")");
            }
            stringBuilder.append(":");
        }
    }

    public void verifySourceLevel(URL uRL, String string) throws IOException {
        String string2 = RepositoryUpdater.getAttribute(uRL, SOURCE_LEVEL_ROOT, null);
        if (string != null && string2 != null && !string.equals(string2)) {
            LOGGER.log(Level.FINE, "source level change detected (provided={1}, existing={2}), refreshing whole source root ({0})", new Object[]{uRL.toExternalForm(), string, string2});
            this.submit(Work.filterChange(Collections.singletonList(uRL), true));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitWorkStarted() throws InterruptedException {
        boolean bl = false;
        while (true) {
            boolean bl2;
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                bl2 = this.compileScheduled > 0 || !this.url2Recompile.isEmpty() || !this.recompileFilesWithErrors.isEmpty();
            }
            if (!bl2) break;
            Thread.sleep(100L);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<URL> batchCompile(LinkedList<CompileTuple> var0, FileObject var1_1, ClasspathInfo var2_2, SourceAnalyser var3_3, Set<URI> var4_4, Set<File> var5_5, AtomicBoolean var6_6, Set<? super ElementHandle<TypeElement>> var7_7, AtomicBoolean var8_8, Set<File> var9_9, Map<URI, List<String>> var10_10, Set<File> var11_11) throws IOException {
        if (!RepositoryUpdater.$assertionsDisabled && var0 == null) {
            throw new AssertionError();
        }
        if (!RepositoryUpdater.$assertionsDisabled && var1_1 == null) {
            throw new AssertionError();
        }
        if (!RepositoryUpdater.$assertionsDisabled && var2_2 == null) {
            throw new AssertionError();
        }
        var12_12 = FileUtil.toFile((FileObject)var1_1);
        if (!RepositoryUpdater.$assertionsDisabled && var12_12 == null) {
            throw new AssertionError();
        }
        var13_13 = null;
        var14_14 = ClasspathInfoAccessor.getINSTANCE().getFileManager(var2_2);
        var15_15 = new CompilerListener();
        var16_16 = new HashMap<URI, List<String>>(var10_10);
        var10_10.clear();
        var17_17 = new HashSet<URL>();
        LowMemoryNotifier.getDefault().addLowMemoryListener(var15_15);
        try {
            block54: {
                block52: {
                    block50: {
                        block51: {
                            var18_18 = null;
                            try {
                                var19_19 = new LinkedList<CompileTuple>();
                                var20_20 = false;
                                var21_21 = false;
                                var22_22 = SourceLevelQuery.getSourceLevel((FileObject)var1_1);
lbl24:
                                // 9 sources

                                while (!var0.isEmpty() || !var19_19.isEmpty() || var13_13 != null) {
                                    if (var6_6 != null && var6_6.getAndSet(false)) {
                                        var23_23 = var17_17;
                                        var33_38 = null;
                                        if (var18_18 == null) break block50;
                                        break block51;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl239
                            }
                            catch (Throwable var32_46) {
                                var33_41 = null;
                                if (var18_18 == null) throw var32_46;
                                var18_18.finish();
                                throw var32_46;
                            }
                        }
                        var18_18.finish();
                    }
                    var35_42 = null;
                    LowMemoryNotifier.getDefault().removeLowMemoryListener(var15_15);
                    return var23_23;
lbl-1000:
                    // 1 sources

                    {
                        if (var8_8 == null || !var8_8.get()) ** GOTO lbl-1000
                        var23_23 = var17_17;
                        var33_39 = null;
                        if (var18_18 == null) break block52;
                    }
                    var18_18.finish();
                }
                var35_43 = null;
                LowMemoryNotifier.getDefault().removeLowMemoryListener(var15_15);
                return var23_23;
lbl-1000:
                // 1 sources

                {
                    block53: {
                        try {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            if (!var15_15.lowMemory.getAndSet(false)) break block55;
                                            if (var18_18 != null) {
                                                var18_18.finish();
                                            }
                                            var18_18 = null;
                                            var15_15.cleanDiagnostics();
                                            if (var20_20) break block53;
                                            var20_20 = true;
                                            System.gc();
                                            ** GOTO lbl24
                                        }
                                        if (var13_13 == null) {
                                            if (!var0.isEmpty()) {
                                                var13_13 = var0.remove(0);
                                                var21_21 = false;
                                            } else {
                                                var13_13 = (CompileTuple)var19_19.remove(0);
                                                var21_21 = true;
                                            }
                                            if (RepositoryUpdater.CALLBACK != null) {
                                                RepositoryUpdater.CALLBACK.willCompile(var13_13.jfo);
                                            }
                                        }
                                        if (var18_18 == null) {
                                            var18_18 = JavaSourceAccessor.getINSTANCE().createJavacTask(var2_2, var15_15, var22_22, new ClassNamesForFileOraculumImpl(var16_16));
                                            var18_18.setTaskListener(var15_15);
                                            if (RepositoryUpdater.LOGGER.isLoggable(Level.FINER)) {
                                                RepositoryUpdater.LOGGER.finer("Created new JavacTask for: " + FileUtil.getFileDisplayName((FileObject)var1_1) + " " + var2_2.toString());
                                            }
                                        }
                                        if (RepositoryUpdater.LOGGER.isLoggable(Level.FINEST)) {
                                            RepositoryUpdater.LOGGER.finest("Parsing file: " + var13_13.jfo.toUri());
                                        }
                                        var23_23 = var18_18.parse(new JavaFileObject[]{var13_13.jfo});
                                        if (!var15_15.lowMemory.getAndSet(false)) break block56;
                                        var18_18.finish();
                                        var18_18 = null;
                                        var15_15.cleanDiagnostics();
                                        var23_23 = null;
                                        if (var20_20) {
                                            if (var21_21) break block53;
                                            var19_19.add(var13_13);
                                            var13_13 = null;
                                            var20_20 = false;
                                        } else {
                                            var20_20 = true;
                                        }
                                        System.gc();
                                        ** GOTO lbl24
                                    }
                                    var24_26 = var18_18.enterTrees((Iterable)var23_23);
                                    if (!var13_13.virtual && var13_13.file != null) {
                                        var25_27 = var13_13.file.getName();
                                        var25_27 = var25_27.substring(0, var25_27.length() - ".java".length());
                                        var26_28 = var24_26.iterator();
                                        while (var26_28.hasNext()) {
                                            var27_29 = (TypeElement)var26_28.next();
                                            if (var27_29 == null || var25_27.equals(var27_29.getSimpleName().toString())) continue;
                                            var28_31 = new LinkedList<String>();
                                            var29_35 = JavacElements.instance(var18_18.getContext());
                                            var30_36 = var24_26.iterator();
                                            while (var30_36.hasNext()) {
                                                var31_37 = (TypeElement)var30_36.next();
                                                var28_31.add(var29_35.getBinaryName(var31_37).toString());
                                            }
                                            var10_10.put(var13_13.file.toURI(), var28_31);
                                            break;
                                        }
                                    }
                                    if (!var15_15.lowMemory.getAndSet(false)) break block57;
                                    var18_18.finish();
                                    var18_18 = null;
                                    var15_15.cleanDiagnostics();
                                    var23_23 = null;
                                    var24_26 = null;
                                    if (var20_20) {
                                        if (var21_21) break block53;
                                        var19_19.add(var13_13);
                                        var13_13 = null;
                                        var20_20 = false;
                                    } else {
                                        var20_20 = true;
                                    }
                                    System.gc();
                                    ** GOTO lbl24
                                }
                                var18_18.analyze();
                                if (!var15_15.lowMemory.getAndSet(false)) break block58;
                                var18_18.finish();
                                var18_18 = null;
                                var15_15.cleanDiagnostics();
                                var23_23 = null;
                                var24_26 = null;
                                if (var20_20) {
                                    if (var21_21) break block53;
                                    var19_19.add(var13_13);
                                    var13_13 = null;
                                    var20_20 = false;
                                } else {
                                    var20_20 = true;
                                }
                                System.gc();
                                ** GOTO lbl24
                            }
                            if (var3_3 != null) {
                                var25_27 = new boolean[1];
                                var3_3.analyse((Iterable<? extends CompilationUnitTree>)var23_23, var18_18, var14_14, var13_13.virtual, var13_13.indexable, var13_13.virtual != false ? FileObjects.fileFileObject(var13_13.file, var12_12, null) : var13_13.jfo, var7_7, (boolean[])var25_27);
                                if (var13_13.file != null) {
                                    ExecutableFilesIndex.DEFAULT.setMainClass(var1_1.getURL(), var13_13.file.toURI().toURL(), (boolean)var25_27[0]);
                                }
                            }
                            var25_27 = new ArrayList<E>();
                            var26_28 = var13_13.jfo.toUri();
                            var27_29 = var15_15.errors.iterator();
                            while (var27_29.hasNext()) {
                                var28_32 = (Diagnostic)var27_29.next();
                                if (RepositoryUpdater.LOGGER.isLoggable(Level.FINER)) {
                                    RepositoryUpdater.LOGGER.finer(var28_32.toString());
                                }
                                if (!var13_13.jfo.equals(var28_32.getSource())) continue;
                                var25_27.add(var28_32);
                                var27_29.remove();
                            }
                            var27_29 = var15_15.warnings.iterator();
                            while (var27_29.hasNext()) {
                                var28_33 = (Diagnostic)var27_29.next();
                                if (RepositoryUpdater.LOGGER.isLoggable(Level.FINER)) {
                                    RepositoryUpdater.LOGGER.finer(var28_33.toString());
                                }
                                if (!var13_13.jfo.equals(var28_33.getSource())) continue;
                                var25_27.add(var28_33);
                                var27_29.remove();
                            }
                            if (TasklistSettings.isTasklistEnabled() && var13_13.file != null && !var13_13.virtual) {
                                var17_17.addAll(TaskCache.getDefault().dumpErrors(var1_1.getURL(), var26_28.toURL(), var13_13.file, (List<? extends Diagnostic>)var25_27));
                            }
                            Log.instance((Context)var18_18.getContext()).nerrors = 0;
                            if (var5_5 != null && !var13_13.virtual) {
                                var5_5.add(var13_13.file);
                            }
                            if (var9_9 != null && !var13_13.virtual) {
                                var27_29 = RebuildOraculum.sortOut(var18_18.getElements(), (Iterable<? extends TypeElement>)var24_26);
                                var9_9.addAll(RebuildOraculum.get().findFilesToRebuild(var12_12, var13_13.file.toURI().toURL(), var2_2, (Map<ElementHandle, Collection<String>>)var27_29));
                            }
                            for (JavaFileObject var28_34 : var18_18.generate((Iterable<? extends Element>)var24_26)) {
                                if (!(var28_34 instanceof OutputFileObject) || var11_11 == null) continue;
                                var11_11.add(((OutputFileObject)var28_34).getFile());
                            }
                            var13_13 = null;
                            var20_20 = false;
                        }
                        catch (CouplingAbort var23_24) {
                            RepositoryUpdater.couplingAbort(var23_24, var13_13.jfo);
                            if (var18_18 != null) {
                                var18_18.finish();
                            }
                            var18_18 = null;
                            var15_15.cleanDiagnostics();
                            var20_20 = false;
                        }
                        catch (Throwable var23_25) {
                            if (RepositoryUpdater.LOGGER.isLoggable(Level.FINEST)) {
                                var24_26 = var2_2.getClassPath(ClasspathInfo.PathKind.BOOT);
                                var25_27 = var2_2.getClassPath(ClasspathInfo.PathKind.COMPILE);
                                var26_28 = var2_2.getClassPath(ClasspathInfo.PathKind.SOURCE);
                                var27_29 = String.format("batchCompile caused an exception Root: %s File: %s Bootpath: %s Classpath: %s Sourcepath: %s", new Object[]{FileUtil.getFileDisplayName((FileObject)var1_1), var13_13.jfo.toUri().toString(), var24_26 == null ? null : var24_26.toString(), var25_27 == null ? null : var25_27.toString(), var26_28 == null ? null : var26_28.toString()});
                                RepositoryUpdater.LOGGER.log(Level.FINEST, (String)var27_29, var23_25);
                            }
                            if (var23_25 instanceof ThreadDeath) {
                                throw (ThreadDeath)var23_25;
                            }
                            if (var23_25 instanceof OutputFileManager.InvalidSourcePath) {
                                throw (OutputFileManager.InvalidSourcePath)var23_25;
                            }
                            if (var23_25 instanceof MissingPlatformError) {
                                throw (MissingPlatformError)var23_25;
                            }
                            if (var18_18 != null) {
                                var18_18.finish();
                            }
                            if (var5_5 != null) {
                                var5_5.add(var13_13.file);
                            }
                            var24_26 = var13_13.jfo.toUri();
                            var18_18 = null;
                            var13_13 = null;
                            var15_15.cleanDiagnostics();
                            if (var23_25 instanceof Abort || var23_25 instanceof Symbol.CompletionFailure) ** GOTO lbl24
                            var25_27 = var2_2.getClassPath(ClasspathInfo.PathKind.BOOT);
                            var26_28 = var2_2.getClassPath(ClasspathInfo.PathKind.COMPILE);
                            var27_29 = var2_2.getClassPath(ClasspathInfo.PathKind.SOURCE);
                            var23_23 = Exceptions.attachMessage((Throwable)var23_25, (String)String.format("Root: %s File: %s Bootpath: %s Classpath: %s Sourcepath: %s", new Object[]{FileUtil.getFileDisplayName((FileObject)var1_1), var24_26.toString(), var25_27 == null ? null : var25_27.toString(), var26_28 == null ? null : var26_28.toString(), var27_29 == null ? null : var27_29.toString()}));
                            Exceptions.printStackTrace((Throwable)var23_23);
                        }
                        ** GOTO lbl24
                    }
                    if (var20_20) {
                        RepositoryUpdater.LOGGER.warning("Not enough memory to compile folder: " + FileUtil.getFileDisplayName((FileObject)var1_1));
                    }
                    var33_40 = null;
                    if (var18_18 == null) break block54;
                    var18_18.finish();
                }
            }
            var35_44 = null;
            LowMemoryNotifier.getDefault().removeLowMemoryListener(var15_15);
            return var17_17;
        }
        catch (Throwable var34_47) {
            var35_45 = null;
            LowMemoryNotifier.getDefault().removeLowMemoryListener(var15_15);
            throw var34_47;
        }
    }

    private static Set<String> parseSet(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty(string, string2), " \t\n\r\f,-:+!");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public static Map<String, List<File>> getAllClassFiles(File file, String string, boolean bl) {
        int n;
        assert (file != null);
        HashMap<String, List<File>> hashMap = new HashMap<String, List<File>>();
        String string2 = file.getAbsolutePath();
        if (string2.charAt((n = string2.length()) - 1) != File.separatorChar) {
            ++n;
        }
        File file2 = file;
        if (!(string.length() <= 0 || (file2 = new File(file2, string)).exists() && file2.isDirectory())) {
            return hashMap;
        }
        RepositoryUpdater.getAllClassFilesImpl(file2, file, n, hashMap, bl);
        return hashMap;
    }

    public static Set<File> getAffectedCacheFiles(FileObject fileObject, FileObject fileObject2) {
        Object object;
        assert (fileObject != null);
        assert (fileObject2 != null);
        File[] fileArray = null;
        File file = null;
        try {
            file = Index.getClassFolder(fileObject2.getURL());
            if (file != null && (object = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject)) != null) {
                fileArray = RepositoryUpdater.getAffectedCacheFiles(((String)object).replace('/', File.separatorChar), file, false, false);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        object = new HashSet();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    if (file2.getName().endsWith("rs")) {
                        LinkedList linkedList = new LinkedList();
                        RepositoryUpdater.readRSFile(file2, file, linkedList);
                        for (File file3 : linkedList) {
                            object.add(file3);
                        }
                        continue;
                    }
                    object.add(file2);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return object;
    }

    private static File[] getAffectedCacheFiles(String string, File file, boolean bl, boolean bl2) {
        File[] fileArray = null;
        if (bl) {
            File file2 = new File(file, string);
            fileArray = file2.listFiles();
        } else {
            File[] fileArray2;
            String[] stringArray;
            File file3;
            int n = string.lastIndexOf(File.separatorChar);
            int n2 = string.lastIndexOf(46);
            File file4 = file3 = n == -1 ? file : new File(file, string.substring(0, n));
            if (bl2) {
                stringArray = new String[]{string.substring(n + 1) + '.' + "rx"};
            } else {
                fileArray2 = string.substring(n + 1, n2);
                stringArray = new String[]{(String)fileArray2 + '.', (String)fileArray2 + '$'};
            }
            fileArray2 = file3.listFiles();
            if (fileArray2 != null) {
                ArrayList<File> arrayList = new ArrayList<File>(fileArray2.length);
                block0: for (File file5 : fileArray2) {
                    String string2 = file5.getName();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string2.startsWith(stringArray[i])) continue;
                        arrayList.add(file5);
                        continue block0;
                    }
                }
                fileArray = arrayList.toArray(new File[arrayList.size()]);
            }
        }
        return fileArray;
    }

    private static void gatherResources(File file, File file2, int n, Map<String, List<File>> map) {
        String string = file2.getAbsolutePath();
        int n2 = string.lastIndexOf(46);
        if (n2 + 1 + "rs".length() == string.length() && string.endsWith("rs")) {
            List<File> list = map.get(string = string.substring(n, n2));
            if (list == null) {
                list = new LinkedList<File>();
                map.put(string, list);
            }
            list.add(0, file2);
            try {
                RepositoryUpdater.readRSFile(file2, file, list);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else if (n2 + 1 + "rx".length() == string.length() && string.endsWith("rx")) {
            if ((n2 = string.lastIndexOf(46, n2 - 1)) > 0) {
                List<File> list = map.get(string = string.substring(n, n2));
                if (list == null) {
                    list = new LinkedList<File>();
                    map.put(string, list);
                }
                list.add(0, file2);
                try {
                    RepositoryUpdater.readRSFile(file2, file, list);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else if (n2 + 1 + "class".length() == string.length() && string.endsWith("class")) {
            int n3 = string.indexOf(36, n);
            List<File> list = map.get(string = n3 == -1 ? string.substring(n, n2) : string.substring(n, n3));
            if (list == null) {
                list = new LinkedList<File>();
                map.put(string, list);
            }
            list.add(file2);
        }
    }

    private static void getAllClassFilesImpl(File file, File file2, int n, Map<String, List<File>> map, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            LOGGER.info("IO error while listing folder: " + file.getAbsolutePath() + " isDirectory: " + file.isDirectory() + " canRead: " + file.canRead());
            return;
        }
        for (File file3 : fileArray) {
            if (file3.isDirectory() && bl) {
                RepositoryUpdater.getAllClassFilesImpl(file3, file2, n, map, bl);
                continue;
            }
            RepositoryUpdater.gatherResources(file2, file3, n, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readRSFile(File file, File file2, List<? super File> list) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                File file3 = new File(file2, FileObjects.convertPackage2Folder(string) + '.' + "class");
                list.add(file3);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<? extends ElementHandle<TypeElement>> readRefFile(File file) throws IOException {
        LinkedList<ElementHandle> linkedList = new LinkedList<ElementHandle>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return linkedList;
    }

    public static Collection<? extends ElementHandle<TypeElement>> getRelatedFiles(File file, File file2) throws IOException {
        int n;
        assert (file != null);
        assert (file2 != null);
        LinkedList<ElementHandle> linkedList = new LinkedList<ElementHandle>();
        String string = FileObjects.getRelativePath(file2, file);
        File file3 = Index.getClassFolder(file2.toURI().toURL());
        File file4 = new File(file3, string + '.' + "rx");
        boolean bl = false;
        if (file4.exists()) {
            bl = true;
            linkedList.addAll(RepositoryUpdater.readRefFile(file4));
        }
        if ((n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        if ((file4 = new File(file3, string + '.' + "rs")).exists()) {
            bl = true;
            linkedList.addAll(RepositoryUpdater.readRefFile(file4));
        }
        if (!bl) {
            n = string.lastIndexOf(File.separatorChar);
            String string2 = n == -1 ? "" : string.substring(0, n);
            String string3 = FileObjects.convertFolder2Package(string2, File.separatorChar);
            File file5 = new File(file3, string2);
            String string4 = string.substring(n + 1);
            String[] stringArray = new String[]{string4 + '.', string4 + '$'};
            File[] fileArray = file5.listFiles();
            if (fileArray != null) {
                block0: for (File file6 : fileArray) {
                    String string5 = file6.getName();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string5.startsWith(stringArray[i])) continue;
                        n = string5.lastIndexOf(46);
                        if (n > 0) {
                            string5 = string5.substring(0, n);
                        }
                        String string6 = string3.length() == 0 ? string5 : string3 + '.' + string5;
                        linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string6));
                        continue block0;
                    }
                }
            }
        }
        return linkedList;
    }

    private static ClassPath.Entry getClassPathEntry(ClassPath classPath, URL uRL) {
        assert (classPath != null);
        assert (uRL != null);
        for (ClassPath.Entry entry : classPath.entries()) {
            if (!uRL.equals(entry.getURL())) continue;
            return entry;
        }
        return null;
    }

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void couplingAbort(CouplingAbort couplingAbort, JavaFileObject javaFileObject) {
        String string = System.getProperty("netbeans.user") + "/var/log/";
        JavaFileObject javaFileObject2 = couplingAbort.getClassFile();
        String string2 = javaFileObject2 != null ? javaFileObject2.toUri().toASCIIString() : "<unknown>";
        String string3 = javaFileObject2 != null ? javaFileObject2.getName() : "unknown";
        File file = new File(string + string3 + ".dump");
        boolean bl = false;
        for (int i = 1; i < 255 && file.exists(); ++i) {
            file = new File(string + string3 + '_' + i + ".dump");
        }
        if (!file.exists()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                try {
                    printWriter.println(String.format("Coupling error: class file %s, source file %s", string2, javaFileObject.toUri().toASCIIString()));
                    printWriter.println("----- Sig file content: -------------------------------------------");
                    if (javaFileObject2 == null) {
                        printWriter.println("no content");
                    } else if (javaFileObject2.getName().toLowerCase().endsWith(".sig")) {
                        printWriter.println(javaFileObject2.getCharContent(true));
                    } else {
                        printWriter.println("not a sig file");
                    }
                    printWriter.println("----- Source file content: ----------------------------------------");
                    printWriter.println(javaFileObject.getCharContent(true));
                    printWriter.println("----- Tree: -------------------------------------------------------");
                    printWriter.println(couplingAbort.getTree().toString());
                    printWriter.println("----- Coupling Error: ---------------------------------------------");
                    couplingAbort.printStackTrace(printWriter);
                    Object var12_12 = null;
                    printWriter.close();
                    bl = true;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    printWriter.close();
                    bl = true;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "Error when writing coupling dump file!", iOException);
            }
        }
        if (bl) {
            LOGGER.log(Level.SEVERE, "Coupling error: class file {0}, source file {1}", new Object[]{string2, javaFileObject.toUri().toASCIIString()});
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + string + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static /* synthetic */ ClassPath access$1900(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.cp;
    }

    static /* synthetic */ ClassPath access$2000(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.ucp;
    }

    static /* synthetic */ ClassPath access$2100(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.binCp;
    }

    static /* synthetic */ Map access$2300(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.deps;
    }

    static /* synthetic */ void access$2500(RepositoryUpdater repositoryUpdater, Work work) {
        repositoryUpdater.resetDirty(work);
    }

    static /* synthetic */ boolean access$2800(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.isDirty();
    }

    static /* synthetic */ Set access$3700(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.recompileFilesWithErrors;
    }

    static /* synthetic */ boolean access$3802(RepositoryUpdater repositoryUpdater, boolean bl) {
        repositoryUpdater.recompileFilesWithErrorsScheduled = bl;
        return repositoryUpdater.recompileFilesWithErrorsScheduled;
    }

    static /* synthetic */ RequestProcessor access$4100() {
        return WORKER;
    }

    static /* synthetic */ int access$400(RepositoryUpdater repositoryUpdater) {
        return repositoryUpdater.noSubmited;
    }

    static {
        WORKER = new RequestProcessor(RepositoryUpdater.class.getName(), 1);
        CALLBACK = null;
    }

    private static class CompileTuple {
        public final JavaFileObject jfo;
        public final File file;
        public final boolean virtual;
        public final boolean indexable;

        public CompileTuple(JavaFileObject javaFileObject, File file) {
            this.jfo = javaFileObject;
            this.file = file;
            this.virtual = false;
            this.indexable = true;
        }

        public CompileTuple(JavaFileObject javaFileObject, File file, boolean bl) {
            this.jfo = javaFileObject;
            this.file = file;
            this.virtual = true;
            this.indexable = bl;
        }
    }

    private class FilterListener
    implements ChangeListener {
        private FilterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof JavaFileFilterImplementation) {
                LinkedList<URL> linkedList = new LinkedList<URL>();
                Map map = RepositoryUpdater.this.filters;
                synchronized (map) {
                    for (Map.Entry entry : RepositoryUpdater.this.filters.entrySet()) {
                        if (entry.getValue() != object) continue;
                        linkedList.add((URL)entry.getKey());
                    }
                }
                RepositoryUpdater.this.submit(Work.filterChange(linkedList, true));
            }
        }
    }

    static interface Callback {
        public void willCompile(JavaFileObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerListener
    implements DiagnosticListener<JavaFileObject>,
    LowMemoryListener,
    TaskListener {
        final List<Diagnostic> errors = new LinkedList<Diagnostic>();
        final List<Diagnostic> warnings = new LinkedList<Diagnostic>();
        final List<Symbol.ClassSymbol> justEntered = new LinkedList<Symbol.ClassSymbol>();
        final AtomicBoolean lowMemory = new AtomicBoolean();

        private CompilerListener() {
        }

        void cleanDiagnostics() {
            if (!this.errors.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    for (Diagnostic diagnostic : this.errors) {
                        LOGGER.finer(diagnostic.toString());
                    }
                }
                this.errors.clear();
            }
            if (!this.warnings.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    for (Diagnostic diagnostic : this.warnings) {
                        LOGGER.finer(diagnostic.toString());
                    }
                }
                this.warnings.clear();
            }
            this.justEntered.clear();
        }

        List<? extends Symbol.ClassSymbol> getEnteredTypes() {
            ArrayList<Symbol.ClassSymbol> arrayList = new ArrayList<Symbol.ClassSymbol>(this.justEntered);
            this.justEntered.clear();
            return arrayList;
        }

        @Override
        public void report(Diagnostic diagnostic) {
            Diagnostic.Kind kind = diagnostic.getKind();
            if (kind == Diagnostic.Kind.ERROR) {
                this.errors.add(diagnostic);
            } else if (kind == Diagnostic.Kind.WARNING || kind == Diagnostic.Kind.MANDATORY_WARNING) {
                this.warnings.add(diagnostic);
            }
        }

        @Override
        public void started(TaskEvent taskEvent) {
        }

        @Override
        public void finished(TaskEvent taskEvent) {
            if (taskEvent.getKind() == TaskEvent.Kind.ENTER) {
                CompilationUnitTree compilationUnitTree = taskEvent.getCompilationUnit();
                for (Tree tree : compilationUnitTree.getTypeDecls()) {
                    Symbol.ClassSymbol classSymbol;
                    if (!(tree instanceof JCTree.JCClassDecl) || (classSymbol = ((JCTree.JCClassDecl)tree).sym) == null) continue;
                    if (classSymbol.sourcefile == null) {
                        classSymbol.sourcefile = taskEvent.getSourceFile();
                    }
                    if (classSymbol.sourcefile instanceof FileObjects.ZipFileBase) continue;
                    this.justEntered.add(classSymbol);
                }
            }
        }

        @Override
        public void lowMemory(LowMemoryEvent lowMemoryEvent) {
            this.lowMemory.set(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileList {
        private final File root;
        private final List<File> javaFiles = new LinkedList<File>();
        private final List<File> virtualJavaFiles = new LinkedList<File>();
        private boolean initialized;
        private String digest;

        public FileList(File file) {
            assert (file != null);
            this.root = file;
        }

        public List<? extends File> getJavaFiles() {
            this.init();
            return Collections.unmodifiableList(this.javaFiles);
        }

        public List<? extends File> getVirtualJavaFiles() {
            this.init();
            return Collections.unmodifiableList(this.virtualJavaFiles);
        }

        private synchronized void init() {
            if (!this.initialized) {
                FileList.collectFiles(this.root, this.javaFiles, this.virtualJavaFiles);
                this.computeDigest(this.root, this.javaFiles);
                this.initialized = true;
            }
        }

        private boolean resolveDigest(URL uRL) {
            try {
                return RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.DIGEST, this.digest, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return true;
            }
        }

        private void computeDigest(File file, List<File> list) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (File object : list) {
                stringBuilder.append(object.getPath()).append(object.lastModified());
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = stringBuilder.toString().getBytes();
                byte[] byArray2 = messageDigest.digest(byArray);
                this.digest = this.printDigest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Exceptions.printStackTrace((Throwable)noSuchAlgorithmException);
            }
        }

        private String printDigest(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                String string = Integer.toHexString(0xFF & byArray[i]);
                if (string.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        private static void collectFiles(File file, List<? super File> list, List<? super File> list2) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    String string = file2.getName();
                    if (file2.isDirectory() && !ignoredDirectories.contains(string)) {
                        FileList.collectFiles(file2, list, list2);
                        continue;
                    }
                    if (string.endsWith(".java")) {
                        list.add(file2);
                        continue;
                    }
                    if (!VirtualSourceProviderQuery.hasVirtualSource(file2)) continue;
                    list2.add(file2);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompileWorker
    implements CancellableTask<CompilationInfo> {
        private final Work ticket;
        private Work work;
        private List<URL> state;
        private Set<URL> oldRoots;
        private Set<URL> oldBinaries;
        private Set<URL> newBinaries;
        private ProgressHandle handle;
        private final Set<URI> dirtyCrossFiles;
        private final Set<URL> ignoreExcludes;
        private final AtomicBoolean canceled;
        private BinaryAnalyser activeBinaryAnalyzer;
        private long cbst;
        private long csst;

        public CompileWorker(Work work) {
            assert (work != null);
            this.work = work;
            this.ticket = work;
            this.canceled = new AtomicBoolean(false);
            this.dirtyCrossFiles = new HashSet<URI>();
            this.ignoreExcludes = new HashSet<URL>();
        }

        @Override
        public void cancel() {
            this.canceled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(CompilationInfo compilationInfo) throws IOException {
            ACTIVITY_LOGGER.finest("START");
            try {
                try {
                    ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                        /*
                         * Exception decompiling
                         */
                        @Override
                        public Void run() throws IOException {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                    Object var4_3 = null;
                    ACTIVITY_LOGGER.finest("FINISHED");
                }
                Object var4_2 = null;
                ACTIVITY_LOGGER.finest("FINISHED");
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ACTIVITY_LOGGER.finest("FINISHED");
                throw throwable;
            }
        }

        private void findDependencies(URL uRL, Stack<URL> stack, Map<URL, List<URL>> map, Set<URL> set, boolean bl) {
            if (bl && RepositoryUpdater.this.scannedRoots.contains(uRL)) {
                this.oldRoots.remove(uRL);
                return;
            }
            if (map.containsKey(uRL)) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return;
            }
            stack.push(uRL);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            ClassPath[] classPathArray = new ClassPath[]{classPath, classPath2};
            LinkedList<URL> linkedList = new LinkedList<URL>();
            for (int i = 0; i < classPathArray.length; ++i) {
                ClassPath classPath3 = classPathArray[i];
                if (classPath3 == null) continue;
                for (ClassPath.Entry entry : classPath3.entries()) {
                    URL uRL2 = entry.getURL();
                    URL[] uRLArray = RepositoryUpdater.this.cpImpl.getSourceRootForBinaryRoot(uRL2, classPath3, false);
                    if (uRLArray != null) {
                        for (URL uRL3 : uRLArray) {
                            if (uRL3.equals(uRL)) {
                                this.ignoreExcludes.add(uRL);
                                continue;
                            }
                            if (stack.contains(uRL3)) continue;
                            linkedList.add(uRL3);
                            this.findDependencies(uRL3, stack, map, set, bl);
                        }
                        continue;
                    }
                    if (!bl) continue;
                    if (!RepositoryUpdater.this.scannedBinaries.contains(uRL2)) {
                        set.add(uRL2);
                    }
                    this.oldBinaries.remove(uRL2);
                }
            }
            map.put(uRL, linkedList);
            stack.pop();
        }

        private void gatherResourceForParseFilesFromRoot(Collection<? extends File> collection, File file, File file2, Map<String, List<File>> map) {
            int n;
            String string;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "going to compute resources");
                LOGGER.log(Level.FINEST, "files={0}", collection);
            }
            if ((string = file2.getAbsolutePath()).charAt((n = string.length()) - 1) != File.separatorChar) {
                ++n;
            }
            for (File file3 : collection) {
                String string2 = FileObjects.stripExtension(FileObjects.getRelativePath(file, file3));
                LOGGER.log(Level.FINEST, "relative={0}", string2);
                File file4 = new File(file2, string2 + '.' + "rs");
                LOGGER.log(Level.FINEST, "f={0}, exists={1}", new Object[]{file4.getAbsolutePath(), file4.exists()});
                if (file4.exists()) {
                    RepositoryUpdater.gatherResources(file2, file4, n, map);
                    continue;
                }
                file4 = new File(file2, string2 + '.' + "class");
                LOGGER.log(Level.FINEST, "f={0}, exists={1}", new Object[]{file4.getAbsolutePath(), file4.exists()});
                if (!file4.exists()) continue;
                RepositoryUpdater.gatherResources(file2, file4, n, map);
                File file5 = file4.getParentFile();
                File[] fileArray = file5.listFiles();
                if (fileArray == null) {
                    LOGGER.info("IO error while listing folder: " + file5.getAbsolutePath() + " isDirectory: " + file5.isDirectory() + " canRead: " + file5.canRead());
                    continue;
                }
                String string3 = FileObjects.stripExtension(file4.getName()) + "$";
                for (File file6 : fileArray) {
                    if (!file6.getName().startsWith(string3)) continue;
                    RepositoryUpdater.gatherResources(file2, file6, n, map);
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "resources={0}", map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean scanRoots() {
            Object object;
            URL uRL;
            Iterator<URL> iterator;
            long l = System.currentTimeMillis();
            try {
                iterator = this.newBinaries.iterator();
                while (iterator.hasNext()) {
                    block25: {
                        boolean bl4;
                        if (this.canceled.getAndSet(false)) {
                            boolean bl2 = false;
                            Object var14_20 = null;
                            this.cbst += System.currentTimeMillis() - l;
                            return bl2;
                        }
                        if (RepositoryUpdater.this.closed.get()) {
                            boolean bl3 = true;
                            Object var14_21 = null;
                            this.cbst += System.currentTimeMillis() - l;
                            return bl3;
                        }
                        uRL = iterator.next();
                        this.updateProgress(uRL);
                        try {
                            Object v0;
                            iterator.remove();
                            ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().createUsagesQuery(uRL, false);
                            RepositoryUpdater.this.scannedBinaries.add(uRL);
                            long l2 = 0L;
                            BinaryAnalyser binaryAnalyser = classIndexImpl.getBinaryAnalyser();
                            object = null;
                            try {
                                object = binaryAnalyser.start(uRL, this.canceled, RepositoryUpdater.this.closed);
                                v0 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_19;
                                v0 = var11_19 = null;
                            }
                            if (object == null || object == BinaryAnalyser.Result.FINISHED) {
                                l2 = binaryAnalyser.finish();
                                break block25;
                            }
                            if (object == BinaryAnalyser.Result.CLOSED) {
                                binaryAnalyser.clear();
                                break block25;
                            }
                            this.activeBinaryAnalyzer = binaryAnalyser;
                            bl4 = false;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof ThreadDeath) {
                                throw (ThreadDeath)throwable;
                            }
                            Exceptions.attachMessage((Throwable)throwable, (String)("While scanning: " + uRL));
                            Exceptions.printStackTrace((Throwable)throwable);
                            continue;
                        }
                        Object var14_22 = null;
                        this.cbst += System.currentTimeMillis() - l;
                        return bl4;
                    }
                    // JSR Ret
                }
                Object var14_23 = null;
                this.cbst += System.currentTimeMillis() - l;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                this.cbst += System.currentTimeMillis() - l;
                throw throwable;
            }
            l = System.currentTimeMillis();
            try {
                iterator = this.state.listIterator(this.state.size());
                while (iterator.hasPrevious()) {
                    if (this.canceled.getAndSet(false)) {
                        boolean bl = false;
                        Object var16_28 = null;
                        this.csst += System.currentTimeMillis() - l;
                        return bl;
                    }
                    if (RepositoryUpdater.this.closed.get()) {
                        boolean bl5 = true;
                        Object var16_29 = null;
                        this.csst += System.currentTimeMillis() - l;
                        return bl5;
                    }
                    try {
                        uRL = (URL)iterator.previous();
                        iterator.remove();
                        if (this.oldRoots.remove(uRL) || RepositoryUpdater.this.scannedRoots.contains(uRL)) continue;
                        long l3 = System.currentTimeMillis();
                        this.updateProgress(uRL);
                        this.updateFolder(uRL, uRL, true, false);
                        long l4 = System.currentTimeMillis() - l3;
                        if (PERF_TEST) {
                            try {
                                object = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                                Method method = ((Class)object).getMethod("reportScanOfFile", String.class, Long.class);
                                method.invoke(((Class)object).newInstance(), uRL.toExternalForm(), new Long(l4));
                            }
                            catch (Exception exception) {
                                Exceptions.printStackTrace((Throwable)exception);
                            }
                        }
                        LOGGER.finer(String.format("Scannig of %s took %d ms.", uRL.toExternalForm(), l4));
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                }
                Object var16_30 = null;
                this.csst += System.currentTimeMillis() - l;
                return true;
            }
            catch (Throwable throwable) {
                Object var16_31 = null;
                this.csst += System.currentTimeMillis() - l;
                throw throwable;
            }
        }

        private void updateProgress(URL uRL) {
            assert (uRL != null);
            if (this.handle == null) {
                return;
            }
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            try {
                if ("file".equals(uRL2.getProtocol())) {
                    File file = new File(new URI(uRL2.toString()));
                    this.handle.progress(file.getAbsolutePath());
                } else {
                    this.handle.progress(uRL2.toString());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.handle.progress(uRL2.toString());
            }
        }

        private void parseFiles(URL uRL, File file, boolean bl, Iterable<? extends File> iterable, Iterable<? extends File> iterable2, boolean bl2, JavaFileFilterImplementation javaFileFilterImplementation, Map<String, List<File>> map, Set<File> set, Set<File> set2, Map<URI, List<String>> map2, boolean bl3, boolean bl4) throws IOException {
            this.parseFiles(uRL, file, bl, iterable, iterable2, bl2, javaFileFilterImplementation, map, set, set2, map2, bl3, bl4, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void parseFiles(URL uRL, File file, boolean bl, Iterable<? extends File> iterable, Iterable<? extends File> iterable2, boolean bl2, JavaFileFilterImplementation javaFileFilterImplementation, Map<String, List<File>> map, Set<File> set, Set<File> set2, Map<URI, List<String>> map2, boolean bl3, boolean bl4, FileList fileList, File file2) throws IOException {
            boolean bl5;
            List<File> list;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            assert (!bl3 || set != null);
            LOGGER.finer("parseFiles: " + uRL);
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return;
            }
            if (!fileObject.isFolder()) {
                LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            File file3 = FileUtil.toFile((FileObject)fileObject);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            if (classPath == null) {
                LOGGER.warning("No source path for folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            if (classPath2 == null) {
                LOGGER.warning("No boot path for folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            if (classPath3 == null) {
                LOGGER.warning("No compile path for folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            if (!Arrays.asList(classPath.getRoots()).contains(fileObject)) {
                LOGGER.warning("Source root: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " not on its sourcepath.");
                return;
            }
            ClassPath.Entry entry = null;
            if (!this.ignoreExcludes.contains(uRL)) {
                entry = RepositoryUpdater.getClassPathEntry(classPath, uRL);
            }
            LOGGER.fine("Initial value of clean: " + bl2);
            if (bl) {
                if (RepositoryUpdater.getAttribute(uRL, RepositoryUpdater.DIRTY_ROOT, null) != null) {
                    LOGGER.fine("forcing clean due to dirty root");
                    bl2 = true;
                }
                if (RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.SOURCE_LEVEL_ROOT, (String)(object4 = SourceLevelQuery.getSourceLevel((FileObject)fileObject)), true)) {
                    LOGGER.fine("forcing clean due to source level change");
                    bl2 = true;
                }
                if (((String)(object3 = CompilerSettings.getCommandLine())).length() == 0) {
                    object3 = null;
                }
                if (RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.EXTRA_COMPILER_OPTIONS, (String)object3, true)) {
                    LOGGER.fine("forcing clean due to extra compiler options change");
                    bl2 = true;
                }
                if (RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.CLASSPATH_ATTRIBUTE, RepositoryUpdater.classPathToString(ClasspathInfoAccessor.getINSTANCE().create(classPath2, classPath3, classPath, null, true, false, false)), true)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("forcing clean due to difderent classpaths, original: " + RepositoryUpdater.getAttribute(uRL, RepositoryUpdater.CLASSPATH_ATTRIBUTE, "") + "new:" + RepositoryUpdater.classPathToString(ClasspathInfoAccessor.getINSTANCE().create(classPath2, classPath3, classPath, null, true, false, false)));
                    }
                    bl2 = true;
                }
                if (TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled()) {
                    if (RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.CONTAINS_TASKLIST_DATA, "true", true)) {
                        LOGGER.fine("forcing clean because there are not tasklist data");
                        bl2 = true;
                    }
                    if (RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.CONTAINS_TASKLIST_DEPENDENCY_DATA, "true", true)) {
                        LOGGER.fine("forcing clean because there are not tasklist dependency data");
                        bl2 = true;
                    }
                }
            }
            object4 = new LinkedList();
            object3 = ClassIndexManager.getDefault().createUsagesQuery(uRL, true);
            if (object3 == null) {
                return;
            }
            if (fileList != null && !fileList.resolveDigest(uRL) && !bl2) {
                return;
            }
            if (map == null && file2 != null) {
                map = RepositoryUpdater.getAllClassFiles(file, FileObjects.getRelativePath(file3, file2), true);
            }
            SourceAnalyser sourceAnalyser = ((ClassIndexImpl)object3).getSourceAnalyser();
            assert (sourceAnalyser != null);
            boolean bl52 = bl && !sourceAnalyser.isValid();
            LOGGER.fine("forcing clean because of invalid index");
            HashSet<File> hashSet = new HashSet<File>();
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            HashSet<File> hashSet2 = new HashSet<File>();
            if (bl) {
                if (TasklistSettings.isTasklistEnabled()) {
                    for (URL serializable2 : TaskCache.getDefault().getAllFilesWithRecord(uRL)) {
                        try {
                            hashSet2.add(FileUtil.normalizeFile((File)new File(serializable2.toURI())));
                        }
                        catch (URISyntaxException hashSet4) {
                            LOGGER.log(Level.FINEST, null, hashSet4);
                        }
                    }
                } else {
                    RepositoryUpdater.ensureAttributeValue(uRL, RepositoryUpdater.CONTAINS_TASKLIST_DATA, "false", false);
                }
            }
            HashSet hashSet3 = bl ? null : new HashSet();
            HashSet hashSet4 = bl ? null : new HashSet();
            HashSet<File> hashSet5 = bl ? null : new HashSet<File>();
            HashSet<File> hashSet6 = bl ? null : new HashSet<File>();
            HashSet<URL> hashSet7 = new HashSet<URL>();
            for (File bl7 : iterable) {
                if (!bl7.canRead()) {
                    if (set == null) continue;
                    set.add(bl7);
                    continue;
                }
                if (!hashSet2.isEmpty()) {
                    hashSet2.remove(bl7);
                }
                object2 = FileObjects.getRelativePath(file3, bl7);
                if (entry == null || entry.includes(((String)object2).replace(File.separatorChar, '/'))) {
                    if (bl52 || bl2 || this.dirtyCrossFiles.remove(bl7.toURI())) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            void var37_45;
                            String file5 = "Compiling " + bl7.getPath() + " due to ";
                            if (bl52) {
                                String list3 = file5 + "invalidIndex";
                            } else if (bl2) {
                                String iterable3 = file5 + "clean";
                            } else {
                                String hashSet72 = file5 + "dirtyCrossFiles";
                            }
                            LOGGER.finest((String)var37_45);
                        }
                        ((LinkedList)object4).add(new CompileTuple(FileObjects.fileFileObject(bl7, file3, javaFileFilterImplementation, charset), bl7));
                        continue;
                    }
                    int n = ((String)object2).lastIndexOf(46);
                    object = n > -1 ? ((String)object2).substring(0, n) : object2;
                    List<File> list2 = map.remove(object);
                    if (list2 == null) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Compiling " + bl7.getPath() + " no cache for it");
                        }
                        ((LinkedList)object4).add(new CompileTuple(FileObjects.fileFileObject(bl7, file3, javaFileFilterImplementation, charset), bl7));
                        continue;
                    }
                    boolean bl6 = list2.get(0).getName().endsWith("rs");
                    list = null;
                    if (list2.get(0).lastModified() < bl7.lastModified()) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("Compiling " + bl7.getPath() + " timestamp (cache: " + list2.get(0).lastModified() + " source: " + bl7.lastModified() + ")");
                        }
                        ((LinkedList)object4).add(new CompileTuple(FileObjects.fileFileObject(bl7, file3, javaFileFilterImplementation, charset), bl7));
                        Object object5 = null;
                        for (File file4 : list2) {
                            file4.delete();
                            if (bl6) {
                                list = object2;
                                object5 = FileObjects.getBinaryName(file4, file);
                                bl6 = false;
                                continue;
                            }
                            String string = FileObjects.getBinaryName(file4, file);
                            if (list != null && !((String)object5).equals(string)) {
                                sourceAnalyser.delete(string, (String)((Object)list));
                            } else {
                                sourceAnalyser.delete(string, null);
                            }
                            if (hashSet3 == null) continue;
                            hashSet3.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string));
                            hashSet5.add(file4);
                        }
                        continue;
                    }
                    if (!bl6) continue;
                    list2.remove(0);
                    hashSet.addAll(list2);
                    continue;
                }
                if (!TasklistSettings.isTasklistEnabled()) continue;
                hashSet7.addAll(TaskCache.getDefault().dumpErrors(uRL, bl7.toURI().toURL(), bl7, Collections.emptyList()));
            }
            LinkedList linkedList = new LinkedList();
            boolean bl7 = false;
            for (File file5 : iterable2) {
                bl5 = true;
                if (!file5.canRead()) continue;
                object = FileObjects.getRelativePath(file3, file5);
                if (entry != null && !entry.includes(((String)object).replace(File.separatorChar, '/'))) continue;
                if (bl52 || bl2 || this.dirtyCrossFiles.remove(file5.toURI())) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        String string = "Compiling " + file5.getPath() + " due to ";
                        string = bl52 ? string + "invalidIndex" : (bl2 ? string + "clean" : string + "dirtyCrossFiles");
                        LOGGER.finest(string);
                    }
                    linkedList.add(file5);
                    continue;
                }
                int n = ((String)object).lastIndexOf(46);
                Object object6 = n > -1 ? ((String)object).substring(0, n) : object;
                list = map.remove(object6);
                if (list == null) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Compiling " + file5.getPath() + " no cache for it");
                    }
                    linkedList.add(file5);
                    continue;
                }
                if (list.isEmpty() || !list.get(0).getName().endsWith("rx")) continue;
                if (list.get(0).lastModified() < file5.lastModified()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Compiling " + file5.getPath() + " timestamp (cache: " + list.get(0).lastModified() + " source: " + file5.lastModified() + ")");
                    }
                    linkedList.add(file5);
                    for (File file6 : list) {
                        file6.delete();
                        String string = FileObjects.getBinaryName(file6, file);
                        sourceAnalyser.delete(string, (String)object);
                        if (hashSet3 == null) continue;
                        hashSet3.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string));
                    }
                    continue;
                }
                list.remove(0);
                hashSet.addAll(list);
            }
            if (bl5) {
                RepositoryUpdater.this.rootsWithVirtualSource.add(uRL);
            }
            for (List<File> list3 : map.values()) {
                for (File file7 : list3) {
                    if (hashSet.contains(file7)) continue;
                    file7.delete();
                    if (!file7.getName().endsWith("class")) continue;
                    String string = FileObjects.getBinaryName(file7, file);
                    sourceAnalyser.delete(string, null);
                    if (hashSet3 == null) continue;
                    hashSet3.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string));
                    hashSet5.add(file7);
                }
            }
            object2 = ClasspathInfoAccessor.getINSTANCE().create(classPath2, classPath3, classPath, javaFileFilterImplementation, true, this.ignoreExcludes.contains(uRL), !linkedList.isEmpty());
            if (!linkedList.isEmpty()) {
                Iterable<VirtualSourceProviderQuery.Binding> iterable3 = VirtualSourceProviderQuery.translate(linkedList, file3);
                for (VirtualSourceProviderQuery.Binding binding : iterable3) {
                    ClasspathInfoAccessor.getINSTANCE().registerVirtualSource((ClasspathInfo)object2, binding.virtual);
                    if (!bl4) continue;
                    ((LinkedList)object4).add(new CompileTuple(binding.virtual, binding.original, binding.index));
                }
            }
            if (!((AbstractCollection)object4).isEmpty()) {
                hashSet7.addAll(RepositoryUpdater.batchCompile((LinkedList)object4, fileObject, (ClasspathInfo)object2, sourceAnalyser, this.dirtyCrossFiles, set, bl3 ? this.canceled : null, hashSet4, bl ? RepositoryUpdater.this.closed : null, set2, map2, hashSet6));
            }
            Object var37_50 = null;
            object = null;
            if (hashSet4 != null && !RepositoryUpdater.this.closed.get()) {
                assert (hashSet3 != null);
                assert (hashSet6 != null);
                assert (hashSet5 != null);
                HashSet hashSet8 = new HashSet(hashSet4);
                object = new HashSet(hashSet3);
                hashSet8.removeAll(hashSet3);
                object.removeAll(hashSet4);
                hashSet4.retainAll(hashSet3);
                hashSet5.removeAll(hashSet6);
                if (set2 != null) {
                    set2.addAll(RebuildOraculum.findAllDependent(file3, null, ((ClasspathInfo)object2).getClassIndex(), (Collection<ElementHandle<TypeElement>>)object));
                }
            }
            sourceAnalyser.store();
            Object object7 = RepositoryUpdater.this;
            synchronized (object7) {
                if (RepositoryUpdater.this.url2Recompile.get(uRL) == null) {
                    RepositoryUpdater.setAttribute(uRL, RepositoryUpdater.DIRTY_ROOT, null);
                }
            }
            if (TasklistSettings.isTasklistEnabled()) {
                object7 = hashSet2.iterator();
                while (object7.hasNext()) {
                    File file8 = (File)object7.next();
                    hashSet7.addAll(TaskCache.getDefault().dumpErrors(uRL, file8.toURI().toURL(), file8, Collections.emptyList()));
                }
                if (TasklistSettings.isBadgesEnabled() && !hashSet7.isEmpty() && (object7 = ErrorAnnotator.getAnnotator()) != null) {
                    ((ErrorAnnotator)((Object)object7)).updateInError(hashSet7);
                }
                JavaTaskProvider.refresh(fileObject);
            }
            if (hashSet4 != null && !RepositoryUpdater.this.closed.get()) {
                void var37_52;
                assert (hashSet3 != null);
                assert (var37_52 != null);
                assert (object != null);
                ((ClassIndexImpl)object3).typesEvent(var37_52.isEmpty() ? null : new ClassIndexImplEvent((ClassIndexImpl)object3, (Iterable<? extends ElementHandle<TypeElement>>)var37_52), object.isEmpty() ? null : new ClassIndexImplEvent((ClassIndexImpl)object3, (Iterable<? extends ElementHandle<TypeElement>>)object), hashSet4.isEmpty() ? null : new ClassIndexImplEvent((ClassIndexImpl)object3, hashSet4));
                BuildArtifactMapperImpl.classCacheUpdated(uRL, file, hashSet5, hashSet6);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateFolder(URL uRL, URL uRL2, boolean bl, boolean bl2) throws IOException {
            block16: {
                FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
                if (fileObject == null) {
                    return;
                }
                if (!fileObject.isFolder()) {
                    LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    return;
                }
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                if (classPath == null || classPath2 == null || classPath3 == null) {
                    String string = FileUtil.getFileDisplayName((FileObject)fileObject);
                    if (!warnedIgnoredRoots.add(string)) return;
                    LOGGER.warning("Ignoring root with no ClassPath: " + string);
                    return;
                }
                RepositoryUpdater.this.registerClassPath(uRL2, classPath2, ClasspathInfo.PathKind.BOOT);
                RepositoryUpdater.this.registerClassPath(uRL2, classPath3, ClasspathInfo.PathKind.COMPILE);
                RepositoryUpdater.this.registerClassPath(uRL2, classPath, ClasspathInfo.PathKind.SOURCE);
                try {
                    block15: {
                        try {
                            File file = FileUtil.toFile((FileObject)fileObject);
                            if (file == null) {
                                Object var18_13 = null;
                                if (bl2) return;
                                if (!bl) return;
                                break block15;
                            }
                            File file2 = bl ? file : FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
                            JavaFileFilterImplementation javaFileFilterImplementation = (JavaFileFilterImplementation)RepositoryUpdater.this.filters.get(uRL2);
                            if (javaFileFilterImplementation == null && (javaFileFilterImplementation = JavaFileFilterQuery.getFilter(fileObject)) != null) {
                                if (!RepositoryUpdater.this.filters.values().contains(javaFileFilterImplementation)) {
                                    javaFileFilterImplementation.addChangeListener((ChangeListener)RepositoryUpdater.this.filterListener);
                                }
                                RepositoryUpdater.this.filters.put(uRL2, javaFileFilterImplementation);
                            }
                            File file3 = Index.getClassFolder(file);
                            HashMap<URI, List<String>> hashMap = new HashMap<URI, List<String>>();
                            Map<String, List<File>> map = Collections.emptyMap();
                            FileList fileList = new FileList(file2);
                            HashSet<File> hashSet = new HashSet<File>();
                            if (bl) {
                                RepositoryUpdater.this.root2DebugData.put(uRL2, fileList.getJavaFiles().size() + ":" + fileList.getVirtualJavaFiles().size());
                            }
                            this.parseFiles(uRL2, file3, bl, fileList.getJavaFiles(), fileList.getVirtualJavaFiles(), bl2, javaFileFilterImplementation, null, hashSet, null, hashMap, false, true, fileList, file2);
                            if (!hashMap.isEmpty()) {
                                LOGGER.log(Level.FINE, "misplaces classes detected");
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "misplacedSource2FQNs={0}", hashMap);
                                }
                                map = new HashMap();
                                this.gatherResourceForParseFilesFromRoot(hashSet, file, file3, map);
                                this.parseFiles(uRL2, file3, bl, hashSet, fileList.getVirtualJavaFiles(), true, javaFileFilterImplementation, map, null, null, hashMap, false, false);
                            }
                            break block16;
                        }
                        catch (OutputFileManager.InvalidSourcePath invalidSourcePath) {
                            Object var18_15 = null;
                            if (bl2) return;
                            if (!bl) return;
                            RepositoryUpdater.this.scannedRoots.add(uRL2);
                            return;
                        }
                        catch (MissingPlatformError missingPlatformError) {
                            Object var18_16 = null;
                            if (bl2) return;
                            if (!bl) return;
                            RepositoryUpdater.this.scannedRoots.add(uRL2);
                            return;
                        }
                    }
                    RepositoryUpdater.this.scannedRoots.add(uRL2);
                    return;
                }
                catch (Throwable throwable) {
                    Object var18_17 = null;
                    if (bl2) throw throwable;
                    if (!bl) throw throwable;
                    RepositoryUpdater.this.scannedRoots.add(uRL2);
                    throw throwable;
                }
            }
            Object var18_14 = null;
            if (bl2) return;
            if (!bl) return;
            RepositoryUpdater.this.scannedRoots.add(uRL2);
        }

        private void updateFile(URL uRL, URL uRL2, boolean bl, Collection<File> collection) throws IOException {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
            if (fileObject == null || fileObject2 == null) {
                return;
            }
            assert ("file".equals(uRL2.getProtocol())) : "Unexpected protocol of URL: " + uRL2;
            ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().createUsagesQuery(uRL2, true);
            if (classIndexImpl != null) {
                try {
                    HashSet hashSet;
                    Object object;
                    String string;
                    Object object2;
                    Object object3;
                    classIndexImpl.setDirty(null);
                    JavaFileFilterImplementation javaFileFilterImplementation = JavaFileFilterQuery.getFilter(fileObject);
                    File file = FileUtil.toFile((FileObject)fileObject2);
                    File file2 = FileUtil.toFile((FileObject)fileObject);
                    File file3 = Index.getClassFolder(file);
                    Map<String, List<File>> map = RepositoryUpdater.getAllClassFiles(file3, FileObjects.getRelativePath(file, file2.getParentFile()), false);
                    String string2 = FileObjects.getRelativePath(file, file2);
                    int n = string2.lastIndexOf(46);
                    String string3 = n > -1 ? string2.substring(0, n) : string2;
                    List<File> list = map.remove(string3);
                    SourceAnalyser sourceAnalyser = classIndexImpl.getSourceAnalyser();
                    assert (sourceAnalyser != null);
                    HashSet<Pair<String, Object>> hashSet3 = new HashSet<Pair<String, Object>>();
                    HashSet hashSet4 = new HashSet();
                    HashSet<ElementHandle> hashSet5 = new HashSet<ElementHandle>();
                    HashSet<File> hashSet6 = new HashSet<File>();
                    HashSet<File> hashSet7 = new HashSet<File>();
                    if (list != null) {
                        object3 = null;
                        object2 = null;
                        for (File hashSet22 : list) {
                            hashSet22.delete();
                            string = FileObjects.getExtension(hashSet22.getName());
                            if ("class".equals(string)) {
                                object = FileObjects.getBinaryName(hashSet22, file3);
                                if (object3 != null && !object2.equals(object)) {
                                    hashSet3.add(Pair.of(object, object3));
                                } else {
                                    hashSet3.add(Pair.of(object, null));
                                }
                                hashSet5.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, new String[]{object}));
                                hashSet7.add(hashSet22);
                                continue;
                            }
                            if (!"rs".equals(string) && !"rx".equals(string)) continue;
                            object3 = string2;
                            object2 = FileObjects.getBinaryName(hashSet22, file3);
                        }
                    } else {
                        hashSet3.add(Pair.of(FileObjects.convertFolder2Package(string3, '/'), null));
                    }
                    object3 = ClasspathInfoAccessor.getINSTANCE().create(fileObject, javaFileFilterImplementation, true, false, bl);
                    object2 = RepositoryUpdater.getClassPathEntry(((ClasspathInfo)object3).getClassPath(ClasspathInfo.PathKind.SOURCE), uRL2);
                    if (object2 == null || object2.includes(fileObject)) {
                        Object object4;
                        Object object5;
                        hashSet = new CompilerListener();
                        JavaFileManager javaFileManager = ClasspathInfoAccessor.getINSTANCE().getFileManager((ClasspathInfo)object3);
                        string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
                        object = new LinkedList();
                        if (bl) {
                            object5 = VirtualSourceProviderQuery.translate(Collections.singleton(file2), file);
                            Iterator<VirtualSourceProviderQuery.Binding> iterator = object5.iterator();
                            while (iterator.hasNext()) {
                                object4 = iterator.next();
                                ClasspathInfoAccessor.getINSTANCE().registerVirtualSource((ClasspathInfo)object3, ((VirtualSourceProviderQuery.Binding)object4).virtual);
                                object.add(new CompileTuple(((VirtualSourceProviderQuery.Binding)object4).virtual, ((VirtualSourceProviderQuery.Binding)object4).original, ((VirtualSourceProviderQuery.Binding)object4).index));
                            }
                        } else {
                            object.add(new CompileTuple(FileObjects.nbFileObject(fileObject, fileObject2, javaFileFilterImplementation, false), file2));
                        }
                        if (!object.isEmpty()) {
                            int n2;
                            Object object6;
                            object5 = JavaSourceAccessor.getINSTANCE().createJavacTask((ClasspathInfo)object3, (DiagnosticListener<? super JavaFileObject>)((Object)hashSet), string);
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("Created new javac for: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " " + ((ClasspathInfo)object3).toString());
                            }
                            ((BasicJavacTask)object5).setTaskListener((TaskListener)((Object)hashSet));
                            boolean bl2 = false;
                            object4 = object.iterator();
                            while (object4.hasNext()) {
                                Object object7;
                                CompileTuple compileTuple = (CompileTuple)object4.next();
                                object6 = object5.parse(new JavaFileObject[]{compileTuple.jfo});
                                Iterable iterable = object5.enterTrees((Iterable)object6);
                                if (collection != null) {
                                    object7 = RebuildOraculum.sortOut(((BasicJavacTask)object5).getElements(), iterable);
                                    collection.addAll(RebuildOraculum.get().findFilesToRebuild(file, uRL, (ClasspathInfo)object3, (Map<ElementHandle, Collection<String>>)object7));
                                }
                                ((JavacTaskImpl)object5).analyze();
                                object7 = new boolean[1];
                                sourceAnalyser.analyse((Iterable<? extends CompilationUnitTree>)object6, (JavacTaskImpl)object5, javaFileManager, compileTuple.virtual, compileTuple.indexable, compileTuple.virtual ? FileObjects.fileFileObject(compileTuple.file, file, null) : compileTuple.jfo, hashSet4, (boolean[])object7);
                                Log.instance((Context)((BasicJavacTask)object5).getContext()).nerrors = 0;
                                n2 |= object7[0];
                            }
                            ExecutableFilesIndex.DEFAULT.setMainClass(uRL2, fileObject.getURL(), n2 != 0);
                            for (Pair pair : hashSet3) {
                                sourceAnalyser.delete(pair);
                            }
                            if (!bl) {
                                assert (object.size() == 1);
                                object4 = ((CompileTuple)object.iterator().next()).jfo;
                                ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>();
                                for (Diagnostic diagnostic : ((CompilerListener)((Object)hashSet)).errors) {
                                    if (object4 != diagnostic.getSource()) continue;
                                    arrayList.add(diagnostic);
                                }
                                for (Diagnostic diagnostic : ((CompilerListener)((Object)hashSet)).warnings) {
                                    if (object4 != diagnostic.getSource()) continue;
                                    arrayList.add(diagnostic);
                                }
                                if (TasklistSettings.isTasklistEnabled()) {
                                    ErrorAnnotator errorAnnotator;
                                    object6 = TaskCache.getDefault().dumpErrors(uRL2, uRL, file2, arrayList);
                                    if (TasklistSettings.isBadgesEnabled() && (errorAnnotator = ErrorAnnotator.getAnnotator()) != null) {
                                        errorAnnotator.updateInError((Set<URL>)object6);
                                    }
                                    JavaTaskProvider.refresh(fileObject);
                                }
                            }
                            for (JavaFileObject javaFileObject : ((JavacTaskImpl)object5).generate()) {
                                if (!(javaFileObject instanceof OutputFileObject)) continue;
                                hashSet6.add(((OutputFileObject)javaFileObject).getFile());
                            }
                            ((CompilerListener)((Object)hashSet)).cleanDiagnostics();
                            object5.finish();
                        } else {
                            for (Pair pair : hashSet3) {
                                sourceAnalyser.delete(pair);
                            }
                        }
                    }
                    hashSet = new HashSet(hashSet4);
                    HashSet<ElementHandle<TypeElement>> hashSet2 = new HashSet<ElementHandle<TypeElement>>(hashSet5);
                    hashSet.removeAll(hashSet5);
                    hashSet2.removeAll(hashSet4);
                    hashSet4.retainAll(hashSet5);
                    hashSet7.removeAll(hashSet6);
                    if (collection != null) {
                        collection.addAll(RebuildOraculum.findAllDependent(file, null, ((ClasspathInfo)object3).getClassIndex(), hashSet2));
                    }
                    sourceAnalyser.store();
                    if (!RepositoryUpdater.this.closed.get()) {
                        classIndexImpl.typesEvent(hashSet.isEmpty() ? null : new ClassIndexImplEvent(classIndexImpl, hashSet), hashSet2.isEmpty() ? null : new ClassIndexImplEvent(classIndexImpl, hashSet2), hashSet4.isEmpty() ? null : new ClassIndexImplEvent(classIndexImpl, hashSet4));
                        BuildArtifactMapperImpl.classCacheUpdated(uRL2, file3, hashSet7, hashSet6);
                    }
                }
                catch (OutputFileManager.InvalidSourcePath invalidSourcePath) {
                    return;
                }
                catch (MissingPlatformError missingPlatformError) {
                    return;
                }
            }
        }

        private List<File> delete(URL uRL, URL uRL2, boolean bl, boolean bl2) throws IOException {
            List<File> list = null;
            assert ("file".equals(uRL2.getProtocol())) : "Unexpected protocol of URL: " + uRL2;
            File file = FileUtil.normalizeFile((File)new File(URI.create(uRL2.toExternalForm())));
            assert ("file".equals(uRL.getProtocol())) : "Unexpected protocol of URL: " + uRL;
            File file2 = FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm())));
            String string = FileObjects.getRelativePath(file, file2);
            assert (string != null && string.length() > 0) : String.format("File %s not under root %s ", file2.getAbsolutePath(), file.getAbsolutePath());
            File file3 = Index.getClassFolder(file);
            File[] fileArray = RepositoryUpdater.getAffectedCacheFiles(string, file3, bl, bl2);
            if (fileArray != null && fileArray.length > 0) {
                HashSet<ElementHandle<TypeElement>> hashSet = new HashSet<ElementHandle<TypeElement>>();
                ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().createUsagesQuery(uRL2, true);
                assert (classIndexImpl != null);
                SourceAnalyser sourceAnalyser = classIndexImpl.getSourceAnalyser();
                assert (sourceAnalyser != null);
                ArrayList arrayList = new ArrayList();
                this.getFiles(fileArray, file3, arrayList, hashSet);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject != null) {
                    JavaFileFilterImplementation javaFileFilterImplementation = JavaFileFilterQuery.getFilter(fileObject);
                    Object object = ClasspathInfoAccessor.getINSTANCE().create(fileObject, javaFileFilterImplementation, true, false, false);
                    list = RebuildOraculum.findAllDependent(file, null, ((ClasspathInfo)object).getClassIndex(), hashSet);
                }
                for (Object object : arrayList) {
                    sourceAnalyser.delete((Pair<String, String>)object);
                }
                sourceAnalyser.store();
                if (!RepositoryUpdater.this.closed.get()) {
                    classIndexImpl.typesEvent(null, new ClassIndexImplEvent(classIndexImpl, hashSet), null);
                }
            }
            return list;
        }

        private void getFiles(File[] fileArray, File file, List<? super Pair<String, String>> list, Set<ElementHandle<TypeElement>> set) throws IOException {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.getFiles(file2.listFiles(), file, list, set);
                } else {
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    String string2 = FileObjects.getExtension(file2.getName());
                    if ("rs".equals(string2)) {
                        object3 = new LinkedList();
                        RepositoryUpdater.readRSFile(file2, file, object3);
                        object2 = FileObjects.getRelativePath(file, file2);
                        object = FileObjects.getBinaryName(file2, file);
                        string = ((String)object2).substring(0, ((String)object2).length() - "rs".length()) + "java";
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            File file3 = (File)iterator.next();
                            String string3 = FileObjects.getBinaryName(file3, file);
                            if (!((String)object).equals(string3)) {
                                list.add(Pair.of(string3, string));
                            } else {
                                list.add(Pair.of(string3, null));
                            }
                            set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string3));
                            file3.delete();
                        }
                    } else if ("rx".equals(string2)) {
                        object3 = new LinkedList();
                        RepositoryUpdater.readRSFile(file2, file, (List)object3);
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (File)object2.next();
                            string = FileObjects.getBinaryName((File)object, file);
                            list.add(Pair.of(string, null));
                            set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string));
                            ((File)object).delete();
                        }
                    } else {
                        object3 = FileObjects.getBinaryName(file2, file);
                        list.add(Pair.of(object3, null));
                        set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, new String[]{object3}));
                    }
                }
                file2.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBinary(URL uRL, URL uRL2) throws IOException {
            CachingArchiveProvider.getDefault().clearArchive(uRL2);
            File file = Index.getClassFolder(uRL2);
            FileObjects.deleteRecursively(file);
            ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().createUsagesQuery(uRL2, false);
            if (classIndexImpl == null) {
                return;
            }
            BinaryAnalyser binaryAnalyser = classIndexImpl.getBinaryAnalyser();
            if (binaryAnalyser != null) {
                try {
                    BinaryAnalyser.Result result = binaryAnalyser.start(uRL2, new AtomicBoolean(false), new AtomicBoolean(false));
                    while (result == BinaryAnalyser.Result.CANCELED) {
                        result = binaryAnalyser.resume();
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    binaryAnalyser.finish();
                    throw throwable;
                }
                binaryAnalyser.finish();
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recompile() throws IOException {
            Map<URL, Collection<File>> map = new HashMap<URL, Collection<File>>();
            RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
            synchronized (repositoryUpdater) {
                map.putAll(RepositoryUpdater.this.url2Recompile);
                RepositoryUpdater.this.url2Recompile.clear();
                RepositoryUpdater.this.recompileScheduled = false;
            }
            LOGGER.log(Level.FINEST, RepositoryUpdater.GOING_TO_RECOMPILE, map);
            map = this.compileFileFromRoots(map, true, false, null);
            if (!map.isEmpty()) {
                repositoryUpdater = RepositoryUpdater.this;
                synchronized (repositoryUpdater) {
                    for (URL uRL : map.keySet()) {
                        LinkedHashSet<File> linkedHashSet = (LinkedHashSet<File>)RepositoryUpdater.this.url2Recompile.get(uRL);
                        if (linkedHashSet == null) {
                            linkedHashSet = new LinkedHashSet<File>();
                            RepositoryUpdater.this.url2Recompile.put(uRL, linkedHashSet);
                        }
                        linkedHashSet.addAll(map.get(uRL));
                    }
                    if (!RepositoryUpdater.this.recompileScheduled) {
                        RepositoryUpdater.this.submit(Work.recompile());
                        RepositoryUpdater.this.recompileScheduled = true;
                    }
                }
            }
        }

        private void compileWithDeps(URL uRL, Collection<File> collection) throws IOException {
            LinkedHashSet linkedHashSet;
            HashMap<URL, Collection<File>> hashMap = TasklistSettings.isTasklistEnabled() && TasklistSettings.isDependencyTrackingEnabled() ? new HashMap<URL, Collection<File>>() : null;
            HashMap<URL, Collection<File>> hashMap2 = new HashMap<URL, Collection<File>>();
            hashMap2.put(uRL, collection);
            if (collection.size() == 1) {
                linkedHashSet = collection.iterator().next();
                URL uRL2 = ((File)((Object)linkedHashSet)).toURI().toURL();
                LinkedList<File> linkedList = hashMap != null ? new LinkedList<File>() : null;
                this.updateFile(uRL2, uRL, !RepositoryUpdater.isJava(FileObjects.getExtension(((File)((Object)linkedHashSet)).getName())), linkedList);
                if (hashMap != null) {
                    hashMap.put(uRL, linkedList);
                }
            } else {
                linkedHashSet = this.compileFileFromRoots(hashMap2, false, true, hashMap);
                assert (linkedHashSet.isEmpty());
            }
            if (hashMap != null && !hashMap.isEmpty()) {
                assert (hashMap.containsKey(uRL));
                linkedHashSet = new LinkedHashSet((Collection)hashMap.get(uRL));
                linkedHashSet.removeAll(collection);
                if (!linkedHashSet.isEmpty()) {
                    RepositoryUpdater.this.assureRecompiled(uRL, linkedHashSet);
                } else {
                    RepositoryUpdater.setAttribute(uRL, RepositoryUpdater.DIRTY_ROOT, null);
                }
            } else {
                RepositoryUpdater.setAttribute(uRL, RepositoryUpdater.DIRTY_ROOT, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<URL, Collection<File>> compileFileFromRoots(Map<URL, Collection<File>> map, boolean bl, boolean bl2, Map<URL, Collection<File>> map2) throws IOException {
            Object object;
            LinkedList<URL> linkedList = new LinkedList<URL>();
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingWorkspace"));
            progressHandle.start();
            try {
                object = map.keySet().iterator();
                while (object.hasNext()) {
                    URL uRL = object.next();
                    linkedList.add(uRL);
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject == null) {
                        LOGGER.info("Root folder: " + uRL + " doesn't exist.");
                        object.remove();
                        continue;
                    }
                    long l = System.currentTimeMillis();
                    JavaFileFilterImplementation javaFileFilterImplementation = JavaFileFilterQuery.getFilter(fileObject);
                    File file = Index.getClassFolder(uRL);
                    Collection<File> collection = map.get(uRL);
                    long l2 = System.currentTimeMillis();
                    HashSet<File> hashSet = bl ? new HashSet<File>() : null;
                    HashMap<String, List<File>> hashMap = new HashMap<String, List<File>>();
                    File file2 = FileUtil.toFile((FileObject)fileObject);
                    try {
                        List<Object> list;
                        LinkedHashSet<File> linkedHashSet = map2 != null ? new LinkedHashSet<File>() : null;
                        this.gatherResourceForParseFilesFromRoot(collection, file2, file, hashMap);
                        HashMap<URI, List<String>> hashMap2 = new HashMap<URI, List<String>>();
                        if (bl2 && RepositoryUpdater.this.rootsWithVirtualSource.contains(uRL)) {
                            FileList fileList = new FileList(file2);
                            list = fileList.getVirtualJavaFiles();
                        } else {
                            list = Collections.emptyList();
                        }
                        this.parseFiles(uRL, file, false, collection, list, true, javaFileFilterImplementation, hashMap, hashSet, linkedHashSet, hashMap2, bl, true);
                        if (!hashMap2.isEmpty()) {
                            LOGGER.log(Level.FINE, "misplaces classes detected");
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.log(Level.FINEST, "misplacedSource2FQNs={0}", hashMap2);
                            }
                            hashMap.clear();
                            this.gatherResourceForParseFilesFromRoot(collection, file2, file, hashMap);
                            this.parseFiles(uRL, file, false, collection, list, true, javaFileFilterImplementation, hashMap, hashSet, linkedHashSet, hashMap2, bl, false);
                        }
                        if (linkedHashSet != null && !linkedHashSet.isEmpty()) {
                            map2.put(uRL, linkedHashSet);
                        }
                        if (hashSet != null) {
                            collection.removeAll(hashSet);
                            if (!collection.isEmpty()) {
                                map.put(uRL, collection);
                                break;
                            }
                            object.remove();
                        } else {
                            object.remove();
                        }
                    }
                    catch (OutputFileManager.InvalidSourcePath invalidSourcePath) {
                        object.remove();
                    }
                    catch (MissingPlatformError missingPlatformError) {
                        object.remove();
                    }
                    Logger.getLogger("TIMER").log(Level.FINE, "Deps - Reparse", new Object[]{fileObject, System.currentTimeMillis() - l2});
                    Logger.getLogger("TIMER").log(Level.FINE, "Deps - Total", new Object[]{fileObject, System.currentTimeMillis() - l});
                }
                progressHandle.finish();
                object = map;
                Object var25_24 = null;
            }
            catch (Throwable throwable) {
                Object var25_25 = null;
                progressHandle.finish();
                throw throwable;
            }
            progressHandle.finish();
            return object;
        }

        static /* synthetic */ void access$800(CompileWorker compileWorker, URL uRL, Stack stack, Map map, Set set, boolean bl) {
            compileWorker.findDependencies(uRL, stack, map, set, bl);
        }

        static /* synthetic */ List access$902(CompileWorker compileWorker, List list) {
            compileWorker.state = list;
            return compileWorker.state;
        }

        static /* synthetic */ List access$900(CompileWorker compileWorker) {
            return compileWorker.state;
        }

        static /* synthetic */ void access$1100(CompileWorker compileWorker, URL uRL, URL uRL2, boolean bl, boolean bl2) throws IOException {
            compileWorker.updateFolder(uRL, uRL2, bl, bl2);
        }

        static /* synthetic */ long access$1202(CompileWorker compileWorker, long l) {
            compileWorker.cbst = l;
            return compileWorker.cbst;
        }

        static /* synthetic */ long access$1302(CompileWorker compileWorker, long l) {
            compileWorker.csst = l;
            return compileWorker.csst;
        }

        static /* synthetic */ ProgressHandle access$1400(CompileWorker compileWorker) {
            return compileWorker.handle;
        }

        static /* synthetic */ ProgressHandle access$1402(CompileWorker compileWorker, ProgressHandle progressHandle) {
            compileWorker.handle = progressHandle;
            return compileWorker.handle;
        }

        static /* synthetic */ Set access$1502(CompileWorker compileWorker, Set set) {
            compileWorker.oldRoots = set;
            return compileWorker.oldRoots;
        }

        static /* synthetic */ Set access$1702(CompileWorker compileWorker, Set set) {
            compileWorker.oldBinaries = set;
            return compileWorker.oldBinaries;
        }

        static /* synthetic */ Set access$2202(CompileWorker compileWorker, Set set) {
            compileWorker.newBinaries = set;
            return compileWorker.newBinaries;
        }

        static /* synthetic */ Set access$1700(CompileWorker compileWorker) {
            return compileWorker.oldBinaries;
        }

        static /* synthetic */ Set access$2200(CompileWorker compileWorker) {
            return compileWorker.newBinaries;
        }

        static /* synthetic */ Work access$2400(CompileWorker compileWorker) {
            return compileWorker.ticket;
        }

        static /* synthetic */ BinaryAnalyser access$2600(CompileWorker compileWorker) {
            return compileWorker.activeBinaryAnalyzer;
        }

        static /* synthetic */ BinaryAnalyser access$2602(CompileWorker compileWorker, BinaryAnalyser binaryAnalyser) {
            compileWorker.activeBinaryAnalyzer = binaryAnalyser;
            return compileWorker.activeBinaryAnalyzer;
        }

        static /* synthetic */ Work access$602(CompileWorker compileWorker, Work work) {
            compileWorker.work = work;
            return compileWorker.work;
        }

        static /* synthetic */ boolean access$2700(CompileWorker compileWorker) {
            return compileWorker.scanRoots();
        }

        static /* synthetic */ Set access$1500(CompileWorker compileWorker) {
            return compileWorker.oldRoots;
        }

        static /* synthetic */ long access$1200(CompileWorker compileWorker) {
            return compileWorker.cbst;
        }

        static /* synthetic */ long access$1300(CompileWorker compileWorker) {
            return compileWorker.csst;
        }

        static /* synthetic */ void access$3200(CompileWorker compileWorker, URL uRL, URL uRL2, boolean bl, Collection collection) throws IOException {
            compileWorker.updateFile(uRL, uRL2, bl, collection);
        }

        static /* synthetic */ List access$3300(CompileWorker compileWorker, URL uRL, URL uRL2, boolean bl, boolean bl2) throws IOException {
            return compileWorker.delete(uRL, uRL2, bl, bl2);
        }

        static /* synthetic */ void access$3500(CompileWorker compileWorker, URL uRL, URL uRL2) throws IOException {
            compileWorker.updateBinary(uRL, uRL2);
        }

        static /* synthetic */ void access$3600(CompileWorker compileWorker, URL uRL, Collection collection) throws IOException {
            compileWorker.compileWithDeps(uRL, collection);
        }

        static /* synthetic */ void access$3900(CompileWorker compileWorker) throws IOException {
            compileWorker.recompile();
        }
    }

    private static class NotifyFinishedWork
    extends Work {
        private Runnable r;

        public NotifyFinishedWork(Runnable runnable) {
            super(WorkType.NOTIFY_FINISHED, null);
            this.r = runnable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompileWithDepsWork
    extends Work {
        private URL root;
        private Collection<File> filesToCompile;

        public CompileWithDepsWork(URL uRL, Collection<File> collection, CountDownLatch countDownLatch) {
            super(WorkType.COMPILE_WITH_DEPENDENCIES, countDownLatch);
            this.root = uRL;
            this.filesToCompile = collection;
        }

        public URL getRoot() {
            return this.root;
        }

        public Collection<File> getFilesToCompile() {
            return this.filesToCompile;
        }
    }

    private static class RecompileFilesWithErrorsWork
    extends Work {
        public RecompileFilesWithErrorsWork(CountDownLatch countDownLatch) {
            super(WorkType.RECOMPILE_FILES_WITH_ERRORS, countDownLatch);
        }
    }

    private static class RecompileWork
    extends Work {
        public RecompileWork(CountDownLatch countDownLatch) {
            super(WorkType.RECOMPILE, countDownLatch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiRootsWork
    extends Work {
        private List<URL> roots;
        private boolean forceClean;

        public MultiRootsWork(WorkType workType, List<URL> list, boolean bl, CountDownLatch countDownLatch) {
            super(workType, countDownLatch);
            this.roots = list;
            this.forceClean = bl;
        }

        public List<URL> getRoots() {
            return this.roots;
        }

        public boolean getForceClean() {
            return this.forceClean;
        }
    }

    private static class SingleRootWork
    extends Work {
        private final URL file;
        private final URL root;
        private final boolean isFolder;
        private final boolean isVirtual;
        private final boolean isInitialCompilation;

        public SingleRootWork(WorkType workType, URL uRL, URL uRL2, boolean bl, boolean bl2, CountDownLatch countDownLatch, boolean bl3) {
            super(workType, countDownLatch);
            this.file = uRL;
            this.root = uRL2;
            this.isFolder = bl;
            this.isVirtual = bl2;
            this.isInitialCompilation = bl3;
        }

        public URL getFile() {
            return this.file;
        }

        public URL getRoot() {
            return this.root;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public boolean isInitialCompilation() {
            return this.isInitialCompilation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Work {
        private final WorkType workType;
        private final CountDownLatch latch;

        protected Work(WorkType workType, CountDownLatch countDownLatch) {
            assert (workType != null);
            this.workType = workType;
            this.latch = countDownLatch;
        }

        public WorkType getType() {
            return this.workType;
        }

        public void finished() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public static Work batch() {
            return new Work(WorkType.COMPILE_BATCH, null);
        }

        public static Work compile(FileObject fileObject, URL uRL, boolean bl) throws FileStateInvalidException {
            return Work.compile(fileObject.getURL(), uRL, fileObject.isFolder(), bl);
        }

        public static Work compile(URL uRL, URL uRL2, boolean bl, boolean bl2) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.COMPILE, uRL, uRL2, bl, bl2, null, false);
        }

        private static Work compile(FileObject fileObject, URL uRL, CountDownLatch[] countDownLatchArray, boolean bl) throws FileStateInvalidException {
            assert (fileObject != null && uRL != null);
            assert (countDownLatchArray != null && countDownLatchArray.length == 1 && countDownLatchArray[0] == null);
            countDownLatchArray[0] = new CountDownLatch(1);
            return new SingleRootWork(WorkType.COMPILE, fileObject.getURL(), uRL, fileObject.isFolder(), false, countDownLatchArray[0], bl);
        }

        public static Work delete(FileObject fileObject, URL uRL, boolean bl, boolean bl2) throws FileStateInvalidException {
            return Work.delete(fileObject.getURL(), uRL, fileObject.isFolder(), bl2);
        }

        public static Work delete(URL uRL, URL uRL2, boolean bl, boolean bl2) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.DELETE, uRL, uRL2, bl, bl2, null, false);
        }

        public static Work binary(FileObject fileObject, URL uRL) throws FileStateInvalidException {
            return Work.binary(fileObject.getURL(), uRL, fileObject.isFolder());
        }

        public static Work binary(URL uRL, URL uRL2, boolean bl) {
            assert (uRL != null && uRL2 != null);
            return new SingleRootWork(WorkType.UPDATE_BINARY, uRL, uRL2, bl, false, null, false);
        }

        public static Work filterChange(List<URL> list, boolean bl) {
            assert (list != null);
            return new MultiRootsWork(WorkType.FILTER_CHANGED, list, bl, null);
        }

        public static Work recompile() {
            return new RecompileWork(null);
        }

        public static Work recompileFilesWithErrors() {
            return new RecompileFilesWithErrorsWork(null);
        }

        public static Work compileWithDeps(URL uRL, Collection<File> collection) {
            return new CompileWithDepsWork(uRL, collection, null);
        }

        public static Work notifyFinished(Runnable runnable) {
            return new NotifyFinishedWork(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WorkType {
        COMPILE_BATCH,
        COMPILE_CONT,
        COMPILE,
        DELETE,
        UPDATE_BINARY,
        FILTER_CHANGED,
        COMPILE_WITH_DEPENDENCIES,
        RECOMPILE,
        RECOMPILE_FILES_WITH_ERRORS,
        NOTIFY_FINISHED;

    }
}

