/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildOraculum {
    private static final String DEPRECATED = "DEPRECATED";
    private static Map<URL, Map<ElementHandle, Collection<String>>> url2Members = new HashMap<URL, Map<ElementHandle, Collection<String>>>();
    private static RebuildOraculum INSTANCE = new RebuildOraculum();
    private static final Pattern ANONYMOUS = Pattern.compile("\\$[0-9]");

    static synchronized void putMembers(URL uRL, Map<ElementHandle, Collection<String>> map) {
        url2Members.clear();
        url2Members.put(uRL, map);
    }

    private static synchronized Map<ElementHandle, Collection<String>> getMembers(URL uRL) {
        HashMap hashMap = url2Members.get(uRL);
        return hashMap != null ? hashMap : new HashMap();
    }

    public static RebuildOraculum get() {
        return INSTANCE;
    }

    private RebuildOraculum() {
    }

    private static String convertToSourceName(String string) {
        int n = (string = string.replace('.', '/')).lastIndexOf(47);
        if (n < 0) {
            n = 0;
        }
        if ((n = string.indexOf(n, 36)) > 0) {
            string = string.substring(0, n);
        }
        return string + ".java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<File> findFilesToRebuild(File file, URL uRL, ClasspathInfo classpathInfo, Map<ElementHandle, Collection<String>> map) {
        List<File> list;
        long l = System.currentTimeMillis();
        long l2 = -1L;
        try {
            Object object;
            Logger.getLogger(RebuildOraculum.class.getName()).log(Level.FINE, "members={0}", RebuildOraculum.getMembers(uRL));
            Logger.getLogger(RebuildOraculum.class.getName()).log(Level.FINE, "currentMembers={0}", map);
            HashMap<ElementHandle, Collection<String>> hashMap = new HashMap<ElementHandle, Collection<String>>(map);
            for (ElementHandle elementHandle : RebuildOraculum.getMembers(uRL).keySet()) {
                hashMap.remove(elementHandle);
            }
            HashMap<ElementHandle, Collection<String>> hashMap2 = new HashMap<ElementHandle, Collection<String>>(RebuildOraculum.getMembers(uRL));
            for (ElementHandle elementHandle : map.keySet()) {
                hashMap2.remove(elementHandle);
            }
            HashMap<ElementHandle, Collection<String>> hashMap3 = new HashMap<ElementHandle, Collection<String>>(RebuildOraculum.getMembers(uRL));
            Iterator iterator = hashMap3.keySet().iterator();
            while (iterator.hasNext()) {
                object = (ElementHandle)iterator.next();
                Collection collection = (Collection)hashMap3.get(object);
                Collection<String> collection2 = map.get(object);
                if (collection != null && collection2 != null && !((Object)collection).equals(collection2)) continue;
                iterator.remove();
            }
            Class<RebuildOraculum> clazz = RebuildOraculum.class;
            synchronized (RebuildOraculum.class) {
                if (url2Members.containsKey(uRL)) {
                    RebuildOraculum.putMembers(uRL, map);
                }
                // ** MonitorExit[var12_14] (shouldn't be in output)
                ArrayList<ElementHandle<TypeElement>> arrayList = new ArrayList<ElementHandle<TypeElement>>();
                if (!(hashMap.isEmpty() && hashMap2.isEmpty() && hashMap3.isEmpty())) {
                    for (ElementHandle elementHandle : map.keySet()) {
                        if (!elementHandle.getKind().isClass() && !elementHandle.getKind().isInterface()) continue;
                        arrayList.add(elementHandle);
                    }
                }
                if (arrayList.isEmpty()) {
                    object = Collections.emptyList();
                    Object var18_22 = null;
                    if (l2 == -1L) {
                        l2 = System.currentTimeMillis();
                    }
                    if (uRL == null) return object;
                    Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: findFilesToRebuild total", new Object[]{uRL, System.currentTimeMillis() - l});
                    Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: quick heuristics", new Object[]{uRL, l2 - l});
                    return object;
                }
                l2 = System.currentTimeMillis();
                object = classpathInfo.getClassIndex();
                list = RebuildOraculum.findAllDependent(file, uRL, (ClassIndex)object, arrayList);
                Object var18_23 = null;
                if (l2 != -1L) break block13;
            }
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            if (l2 == -1L) {
                l2 = System.currentTimeMillis();
            }
            if (uRL == null) throw throwable;
            Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: findFilesToRebuild total", new Object[]{uRL, System.currentTimeMillis() - l});
            Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: quick heuristics", new Object[]{uRL, l2 - l});
            throw throwable;
        }
        {
            block13: {
                l2 = System.currentTimeMillis();
            }
            if (uRL == null) return list;
            Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: findFilesToRebuild total", new Object[]{uRL, System.currentTimeMillis() - l});
            Logger.getLogger("TIMER").log(Level.FINE, "RebuildOraculum: quick heuristics", new Object[]{uRL, l2 - l});
            return list;
        }
    }

    public static List<File> findAllDependent(File file, URL uRL, ClassIndex classIndex, Collection<ElementHandle<TypeElement>> collection) {
        HashSet hashSet;
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (!ANONYMOUS.matcher(object.next().getBinaryName()).find()) continue;
            object.remove();
        }
        object = new HashSet<ElementHandle<TypeElement>>(collection);
        long l = System.currentTimeMillis();
        boolean bl = true;
        while (bl) {
            hashSet = new HashSet(object);
            for (ElementHandle elementHandle : hashSet) {
                object.addAll(classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            bl = !((Object)hashSet).equals(object);
        }
        hashSet = new HashSet(object);
        for (ElementHandle elementHandle : hashSet) {
            object.addAll(classIndex.getElements(elementHandle, EnumSet.complementOf(EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS)), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        object.removeAll(collection);
        if (uRL != null) {
            Logger.getLogger("TIMER").log(Level.FINE, "Deps - Handles", new Object[]{uRL, System.currentTimeMillis() - l});
            Logger.getLogger("TIMER").log(Level.FINE, "Deps - Handles #", new Object[]{uRL, object.size()});
        }
        long l2 = System.currentTimeMillis();
        HashSet<File> hashSet2 = new HashSet<File>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ElementHandle elementHandle = (ElementHandle)iterator.next();
            String string = RebuildOraculum.convertToSourceName(elementHandle.getBinaryName());
            File file2 = new File(file, string);
            if (!file2.canRead()) continue;
            hashSet2.add(FileUtil.normalizeFile((File)file2));
        }
        hashSet2.remove(null);
        if (uRL != null) {
            Logger.getLogger("TIMER").log(Level.FINE, "Deps - Files", new Object[]{uRL, System.currentTimeMillis() - l2});
            Logger.getLogger("TIMER").log(Level.FINE, "Deps - Files #", new Object[]{uRL, hashSet2.size()});
        }
        return new ArrayList<File>(hashSet2);
    }

    static synchronized boolean isInitialized(URL uRL) {
        return url2Members.containsKey(uRL);
    }

    private static Collection<String> getExtendedModifiers(Elements elements, Element element) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Modifier modifier : element.getModifiers()) {
            hashSet.add(modifier.name());
        }
        if (elements.isDeprecated(element)) {
            hashSet.add(DEPRECATED);
        }
        return hashSet;
    }

    public static Map<ElementHandle, Collection<String>> sortOut(Elements elements, Iterable<? extends TypeElement> iterable) {
        HashMap<ElementHandle, Collection<String>> hashMap = new HashMap<ElementHandle, Collection<String>>();
        LinkedList<TypeElement> linkedList = new LinkedList<TypeElement>();
        for (TypeElement object : iterable) {
            linkedList.offer(object);
        }
        while (!linkedList.isEmpty()) {
            TypeElement typeElement = (TypeElement)linkedList.poll();
            if (typeElement == null) continue;
            hashMap.put(ElementHandle.create(typeElement), RebuildOraculum.getExtendedModifiers(elements, typeElement));
            for (Element element : typeElement.getEnclosedElements()) {
                switch (element.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        linkedList.offer((TypeElement)element);
                        break;
                    }
                    case METHOD: 
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        hashMap.put(ElementHandle.create(element), RebuildOraculum.getExtendedModifiers(elements, element));
                    }
                }
            }
        }
        return hashMap;
    }
}

