/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.classpath.GlobalSourcePath;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheClassPath
implements ClassPathImplementation,
PropertyChangeListener {
    public static final boolean KEEP_JARS = Boolean.getBoolean("CacheClassPath.keepJars");
    private final ClassPath cp;
    private final boolean translate;
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> cache;
    private long eventId;

    private CacheClassPath(ClassPath classPath, boolean bl) {
        this.cp = classPath;
        this.translate = bl;
        this.cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)classPath));
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("entries".equals(propertyChangeEvent.getPropertyName())) {
            CacheClassPath cacheClassPath = this;
            synchronized (cacheClassPath) {
                this.cache = null;
                ++this.eventId;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        CacheClassPath cacheClassPath;
        long l;
        Object object = this;
        synchronized (object) {
            if (this.cache != null) {
                return this.cache;
            }
            l = this.eventId;
        }
        object = this.cp.entries();
        LinkedList<PathResourceImplementation> linkedList = new LinkedList<PathResourceImplementation>();
        GlobalSourcePath globalSourcePath = GlobalSourcePath.getDefault();
        List<PathResourceImplementation> list = object.iterator();
        while (list.hasNext()) {
            URL uRL;
            Object object2;
            cacheClassPath = (ClassPath.Entry)list.next();
            URL uRL2 = cacheClassPath.getURL();
            URL[] uRLArray = this.translate ? globalSourcePath.getSourceRootForBinaryRoot(uRL2, this.cp, true) : new URL[]{uRL2};
            if (uRLArray != null) {
                object2 = uRLArray;
                int n = ((URL[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object2[i];
                    try {
                        File file = Index.getClassFolder((URL)object3);
                        URL uRL3 = file.toURI().toURL();
                        if (!file.exists()) {
                            uRL3 = new URL(uRL3.toExternalForm() + "/");
                        }
                        linkedList.add(ClassPathSupport.createResource((URL)uRL3));
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                if (!KEEP_JARS || !this.translate) continue;
                linkedList.add(ClassPathSupport.createResource((URL)uRL2));
                continue;
            }
            if ("jar".equals(uRL2.getProtocol())) {
                FileObject fileObject;
                object2 = FileUtil.getArchiveFile((URL)uRL2);
                if (!"file".equals(((URL)object2).getProtocol()) && (fileObject = URLMapper.findFileObject((URL)object2)) != null && "file".equals(((URL)(object2 = URLMapper.findURL((FileObject)fileObject, (int)1))).getProtocol())) {
                    uRL2 = FileUtil.getArchiveRoot((URL)object2);
                }
            } else if (!"file".equals(uRL2.getProtocol()) && (object2 = URLMapper.findFileObject((URL)uRL2)) != null && "file".equals((uRL = URLMapper.findURL((FileObject)object2, (int)1)).getProtocol())) {
                uRL2 = uRL;
            }
            try {
                object2 = Index.getClassFolder(uRL2);
                linkedList.add(ClassPathSupport.createResource((URL)((File)object2).toURI().toURL()));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            linkedList.add(ClassPathSupport.createResource((URL)uRL2));
        }
        cacheClassPath = this;
        synchronized (cacheClassPath) {
            if (l == this.eventId) {
                if (this.cache == null) {
                    this.cache = linkedList;
                }
                list = this.cache;
            } else {
                list = linkedList;
            }
        }
        assert (list != null);
        return list;
    }

    public static ClassPath forClassPath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, true));
    }

    public static ClassPath forBootPath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, true));
    }

    public static ClassPath forSourcePath(ClassPath classPath) {
        assert (classPath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(classPath, false));
    }
}

