/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.java.source.ActivatedDocumentListener;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.modules.java.source.util.LowMemoryNotifierMBeanImpl;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class JBrowseModule
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.java.source.enableMBeans");
    private static final RequestProcessor RP = new RequestProcessor("java.source module install", 1);

    public void restored() {
        super.restored();
        JavaSourceTaskFactoryManager.register();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RP.post(new Runnable(){

                    public void run() {
                        RepositoryUpdater.getDefault();
                        ActivatedDocumentListener.register();
                    }
                });
            }
        });
        if (ENABLE_MBEANS) {
            JBrowseModule.registerMBeans();
        }
        System.setProperty("useJavaUtilZip", "true");
    }

    public boolean closing() {
        boolean bl = super.closing();
        RepositoryUpdater.getDefault().close();
        try {
            ClassIndexManager.getDefault().writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClassIndexManager.getDefault().close();
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        if (ENABLE_MBEANS) {
            JBrowseModule.unregisterMBeans();
        }
        return bl;
    }

    private static void registerMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
            mBeanServer.registerMBean(LuceneIndexMBeanImpl.getDefault(), new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ErrorManager.getDefault().notify((Throwable)notCompliantMBeanException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ErrorManager.getDefault().notify((Throwable)instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }

    private static void unregisterMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
            mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }
}

