/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMirrorHandle<T extends TypeMirror> {
    private TypeKind kind;
    private ElementHandle<? extends Element> element;
    private java.util.List<TypeMirrorHandle<? extends TypeMirror>> typeMirrors;

    private TypeMirrorHandle(TypeKind typeKind, ElementHandle<? extends Element> elementHandle, java.util.List<TypeMirrorHandle<? extends TypeMirror>> list) {
        this.kind = typeKind;
        this.element = elementHandle;
        this.typeMirrors = list;
    }

    public static <T extends TypeMirror> TypeMirrorHandle<T> create(T t) {
        return TypeMirrorHandle.create(t, new HashMap<TypeMirror, TypeMirrorHandle>());
    }

    private static <T extends TypeMirror> TypeMirrorHandle<T> create(T t, Map<TypeMirror, TypeMirrorHandle> map) {
        TypeMirrorHandle<TypeMirror> typeMirrorHandle = map.get(t);
        if (typeMirrorHandle != null) {
            return typeMirrorHandle.typeMirrors == null ? typeMirrorHandle : typeMirrorHandle.typeMirrors.get(0);
        }
        map.put(t, new TypeMirrorHandle<T>(null, null, null));
        TypeKind typeKind = t.getKind();
        ElementHandle<Element> elementHandle = null;
        java.util.List<TypeMirrorHandle<TypeMirror>> list = null;
        switch (typeKind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                break;
            }
            case DECLARED: {
                TypeParameterElement annotatedConstruct2;
                Object object;
                java.util.List<? extends TypeMirror> list2;
                boolean bl;
                DeclaredType declaredType = (DeclaredType)t;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                elementHandle = ElementHandle.create(typeElement);
                Element element = typeElement.getEnclosingElement();
                boolean bl2 = bl = (element.getKind().isClass() || element.getKind().isInterface()) && !((TypeElement)element).getTypeParameters().isEmpty() && !typeElement.getModifiers().contains((Object)Modifier.STATIC);
                if (typeElement.getTypeParameters().isEmpty() && !bl || !(list2 = declaredType.getTypeArguments()).isEmpty() && (object = list2.get(0)).getKind() == TypeKind.TYPEVAR && (annotatedConstruct2 = (TypeParameterElement)((TypeVariable)object).asElement()).getGenericElement() == declaredType.asElement()) break;
                if (bl) {
                    list = new ArrayList<TypeMirrorHandle<TypeMirror>>(list2.size() + 1);
                    list.add(TypeMirrorHandle.create(declaredType.getEnclosingType(), map));
                } else {
                    list = new ArrayList<TypeMirrorHandle<TypeMirror>>(list2.size());
                }
                for (TypeMirror typeMirror : list2) {
                    list.add(TypeMirrorHandle.create(typeMirror, map));
                }
                break;
            }
            case ARRAY: {
                list = Collections.singletonList(TypeMirrorHandle.create(((ArrayType)t).getComponentType(), map));
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)t;
                elementHandle = ElementHandle.create(typeVariable.asElement());
                list = new ArrayList<TypeMirrorHandle<TypeMirror>>();
                list.add(typeVariable.getLowerBound() != null ? TypeMirrorHandle.create(typeVariable.getLowerBound(), map) : null);
                list.add(typeVariable.getUpperBound() != null ? TypeMirrorHandle.create(typeVariable.getUpperBound(), map) : null);
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)t;
                list = new ArrayList<TypeMirrorHandle<TypeMirror>>();
                list.add(wildcardType.getExtendsBound() != null ? TypeMirrorHandle.create(wildcardType.getExtendsBound(), map) : null);
                list.add(wildcardType.getSuperBound() != null ? TypeMirrorHandle.create(wildcardType.getSuperBound(), map) : null);
                break;
            }
            case ERROR: {
                ErrorType errorType = (ErrorType)t;
                elementHandle = ElementHandle.create(errorType.asElement());
                break;
            }
            default: {
                throw new IllegalArgumentException("Currently unsupported TypeKind: " + (Object)((Object)t.getKind()));
            }
        }
        typeMirrorHandle = new TypeMirrorHandle<T>(typeKind, elementHandle, list);
        map.get(t).typeMirrors = Collections.singletonList(typeMirrorHandle);
        return typeMirrorHandle;
    }

    public T resolve(CompilationInfo compilationInfo) {
        return this.resolve(compilationInfo, new HashMap<TypeMirrorHandle, PlaceholderType>());
    }

    private T resolve(CompilationInfo compilationInfo, Map<TypeMirrorHandle, PlaceholderType> map) {
        if (this.kind == null) {
            TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle = this.typeMirrors.get(0);
            PlaceholderType placeholderType = map.get(typeMirrorHandle);
            if (placeholderType == null) {
                placeholderType = new PlaceholderType();
                map.put(typeMirrorHandle, placeholderType);
            }
            return (T)(placeholderType.delegate != null ? placeholderType.delegate : placeholderType);
        }
        switch (this.kind) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return (T)compilationInfo.getTypes().getPrimitiveType(this.kind);
            }
            case NONE: 
            case VOID: {
                return (T)compilationInfo.getTypes().getNoType(this.kind);
            }
            case NULL: {
                return (T)compilationInfo.getTypes().getNullType();
            }
            case DECLARED: {
                TypeMirror typeMirror;
                TypeElement typeElement = (TypeElement)this.element.resolve(compilationInfo);
                if (typeElement == null) {
                    return null;
                }
                if (this.typeMirrors == null) {
                    return (T)typeElement.asType();
                }
                Iterator<TypeMirrorHandle<? extends TypeMirror>> iterator = this.typeMirrors.iterator();
                Element element = typeElement.getEnclosingElement();
                boolean bl = (element.getKind().isClass() || element.getKind().isInterface()) && !((TypeElement)element).getTypeParameters().isEmpty() && !typeElement.getModifiers().contains((Object)Modifier.STATIC);
                TypeMirror typeMirror2 = null;
                if (bl) {
                    TypeMirror typeMirror3 = typeMirror2 = iterator.hasNext() ? super.resolve(compilationInfo, map) : null;
                    if (typeMirror2 == null || typeMirror2.getKind() != TypeKind.DECLARED) {
                        return null;
                    }
                }
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
                while (iterator.hasNext()) {
                    typeMirror = super.resolve(compilationInfo, map);
                    if (typeMirror == null) {
                        return null;
                    }
                    arrayList.add(typeMirror);
                }
                typeMirror = typeMirror2 != null ? compilationInfo.getTypes().getDeclaredType((DeclaredType)typeMirror2, typeElement, arrayList.toArray(new TypeMirror[arrayList.size()])) : compilationInfo.getTypes().getDeclaredType(typeElement, arrayList.toArray(new TypeMirror[arrayList.size()]));
                PlaceholderType placeholderType = map.get(this);
                if (placeholderType != null) {
                    placeholderType.delegate = (Type)typeMirror;
                    new Visitor().visitClassType((Type.ClassType)typeMirror, null);
                }
                return (T)typeMirror;
            }
            case ARRAY: {
                TypeMirror typeMirror = super.resolve(compilationInfo, map);
                if (typeMirror == null) {
                    return null;
                }
                ArrayType arrayType = compilationInfo.getTypes().getArrayType(typeMirror);
                PlaceholderType placeholderType = map.get(this);
                if (placeholderType != null) {
                    placeholderType.delegate = (Type)((Object)arrayType);
                    new Visitor().visitArrayType((Type.ArrayType)arrayType, null);
                }
                return (T)arrayType;
            }
            case TYPEVAR: {
                Element element = this.element.resolve(compilationInfo);
                if (!(element instanceof Symbol.TypeSymbol)) {
                    return null;
                }
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle = this.typeMirrors.get(0);
                TypeMirror typeMirror = typeMirrorHandle != null ? super.resolve(compilationInfo, map) : null;
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle2 = this.typeMirrors.get(1);
                TypeMirror typeMirror4 = typeMirrorHandle2 != null ? super.resolve(compilationInfo, map) : null;
                Type.TypeVar typeVar = new Type.TypeVar((Symbol.TypeSymbol)element, (Type)typeMirror4, (Type)typeMirror);
                PlaceholderType placeholderType = map.get(this);
                if (placeholderType != null) {
                    placeholderType.delegate = typeVar;
                    new Visitor().visitTypeVar(typeVar, null);
                }
                return (T)typeVar;
            }
            case WILDCARD: {
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle = this.typeMirrors.get(0);
                TypeMirror typeMirror = typeMirrorHandle != null ? super.resolve(compilationInfo, map) : null;
                TypeMirrorHandle<? extends TypeMirror> typeMirrorHandle3 = this.typeMirrors.get(1);
                TypeMirror typeMirror5 = typeMirrorHandle3 != null ? super.resolve(compilationInfo, map) : null;
                WildcardType wildcardType = compilationInfo.getTypes().getWildcardType(typeMirror, typeMirror5);
                PlaceholderType placeholderType = map.get(this);
                if (placeholderType != null) {
                    placeholderType.delegate = (Type)((Object)wildcardType);
                    new Visitor().visitWildcardType((Type.WildcardType)wildcardType, null);
                }
                return (T)wildcardType;
            }
            case ERROR: {
                Element element = this.element.resolve(compilationInfo);
                if (element == null) {
                    String[] stringArray = this.element.getSignature();
                    assert (stringArray.length == 1);
                    Context context = compilationInfo.impl.getJavacTask().getContext();
                    return (T)new Type.ErrorType(Name.Table.instance((Context)context).fromString(stringArray[0]), (Symbol.TypeSymbol)Symtab.instance((Context)context).rootPackage);
                }
                if (!(element instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                return (T)new Type.ErrorType((Symbol.ClassSymbol)element);
            }
        }
        throw new IllegalStateException("Internal error: unknown TypeHandle kind: " + (Object)((Object)this.kind));
    }

    public TypeKind getKind() {
        return this.kind;
    }

    ElementHandle<? extends Element> getElementHandle() {
        return this.element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Visitor
    extends Types.DefaultTypeVisitor<Void, Void> {
        private Visitor() {
        }

        @Override
        public Void visitType(Type type, Void void_) {
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Void void_) {
            arrayType.elemtype.accept(this, void_);
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Void void_) {
            List<Type> list = classType.typarams_field;
            while (list.nonEmpty()) {
                ((Type)list.head).accept(this, void_);
                list = list.tail;
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar typeVar, Void void_) {
            if (typeVar.bound instanceof PlaceholderType) {
                typeVar.bound = ((PlaceholderType)typeVar.bound).delegate;
            } else {
                typeVar.bound.accept(this, void_);
            }
            if (typeVar.lower instanceof PlaceholderType) {
                typeVar.lower = ((PlaceholderType)typeVar.lower).delegate;
            } else {
                typeVar.lower.accept(this, void_);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            if (wildcardType.type instanceof PlaceholderType) {
                wildcardType.type = ((PlaceholderType)wildcardType.type).delegate;
            } else {
                wildcardType.type.accept(this, void_);
            }
            if (wildcardType.bound != null) {
                wildcardType.bound.accept(this, void_);
            }
            return null;
        }
    }

    private static class PlaceholderType
    extends Type
    implements ReferenceType {
        private Type delegate = null;

        public PlaceholderType() {
            super(20, null);
        }
    }
}

