/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.modules.xslt.project.CommandlineXsltProjectXmlCatalogProvider;
import org.netbeans.modules.xslt.project.wizard.FoldersListSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XsltProjectRetriever {
    ProgressHandle pg = null;
    private RetrieverWrapper retrieveWrap = new RetrieverWrapper();
    private Logger logger = Logger.getLogger(XsltProjectRetriever.class.getName());
    private volatile String mStatus = null;
    private RetrieverUpdater mRetUpd = null;
    Dialog mDialog = null;

    public XsltProjectRetriever(FileObject fileObject) {
        this.retrieveWrap.mProjectDirectoryPath = fileObject.getPath();
    }

    private void init() {
        String string = NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_Populate_Catalog");
        this.pg = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

            public boolean cancel() {
                try {
                    XsltProjectRetriever.this.pg.finish();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        this.mRetUpd = new RetrieverUpdater(this.pg);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.mRetUpd, string, true, new Object[0], null, 0, null, null, true);
        this.mDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.pg.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.init();
            Thread thread = new Thread(this.retrieveWrap);
            thread.start();
            this.mDialog.setVisible(true);
        }
        catch (Exception exception) {
            this.mRetUpd.setProgressMessage(NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_Populate_Catalog_Error"));
        }
        finally {
            this.dispose();
        }
    }

    void dispose() {
        try {
            this.mDialog.setVisible(false);
            this.mDialog.dispose();
            this.mDialog = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pg.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RetrieverUpdater
    extends JPanel {
        private JComponent progress;
        public JPanel innerPanel;
        public JTextField message;

        public RetrieverUpdater(ProgressHandle progressHandle) {
            this.progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            this.initComponents();
            this.message.setBackground(UIManager.getColor("Panel.background"));
        }

        private void initComponents() {
            this.innerPanel = new JPanel();
            this.message = new JTextField();
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            this.innerPanel.setLayout(new BorderLayout());
            this.innerPanel.add((Component)this.progress, "Center");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.innerPanel, gridBagConstraints);
            this.message.setColumns(40);
            this.message.setEditable(false);
            this.message.setFont(UIManager.getFont("Label.font"));
            this.message.setBorder(null);
            this.message.setDisabledTextColor(UIManager.getColor("Label.foreground"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.add((Component)this.message, gridBagConstraints);
        }

        public void setProgressMessage(String string) {
            this.message.setText(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RetrieverWrapper
    implements Runnable {
        private File mProjectDirectory = null;
        private String mProjectDirectoryPath = null;
        private String mProjectSourcePath = null;
        private File mRetrieveToDirectory = null;
        private HashSet mVisitedXMLResources = new HashSet();

        RetrieverWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String string = this.mProjectDirectoryPath;
                String string2 = (String)string + "/" + "src";
                this.mProjectSourcePath = string2.replace('\\', '/');
                CommandlineXsltProjectXmlCatalogProvider.getInstance().setSourceDirectory(string2);
                this.mProjectDirectory = new File(string);
                File file = new File(string2);
                this.mRetrieveToDirectory = new File(CommandlineXsltProjectXmlCatalogProvider.getInstance().getRetrieverPath());
                if (!this.mRetrieveToDirectory.exists()) {
                    this.mRetrieveToDirectory.mkdirs();
                }
                this.processSourceDir(file);
                this.moveCachedDirs();
                this.displayStatus(NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_Populate_Catalog_Complete"));
            }
            catch (Exception exception) {
                this.displayStatus(NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_Populate_Catalog_Error"));
            }
            finally {
                File file = new File(CommandlineXsltProjectXmlCatalogProvider.getInstance().getProjectWideCatalog());
                if (file.exists() && file.length() == 0L) {
                    file.delete();
                }
                XsltProjectRetriever.this.dispose();
            }
        }

        private void moveCachedDirs() throws Exception {
            File file = new File(this.mRetrieveToDirectory.getParent(), "catalog.xml");
            if (file.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                ArrayList<String> arrayList = new ArrayList<String>();
                NodeList nodeList = document.getElementsByTagName("system");
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                if (nodeList != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object52;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Object object6;
                        Object object7;
                        object52 = (Element)nodeList.item(i);
                        object4 = object52.getAttribute("uri");
                        if (((String)object4).startsWith("src/cached")) continue;
                        arrayList.add((String)object4);
                        object3 = new File(this.mRetrieveToDirectory.getParentFile(), (String)object4);
                        object2 = ((File)object3).getParentFile();
                        object = (File)hashMap.get(object2);
                        if (object == null) {
                            object7 = null;
                            int n = FoldersListSettings.getDefault().getNewProjectCount() + 1;
                            object6 = NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_DefaultCacheDirName");
                            while ((object7 = this.validFreeCacheDirName(this.mRetrieveToDirectory, (String)object6, n)) == null) {
                                ++n;
                            }
                            object = new File(this.mRetrieveToDirectory, (String)object7);
                            ((File)object).mkdirs();
                            hashMap.put(object2, object);
                        }
                        object7 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object));
                        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object3));
                        FileUtil.moveFile((FileObject)fileObject, (FileObject)object7, (String)fileObject.getName());
                        object6 = object52.getAttributeNode("uri");
                        object6.setNodeValue("src/" + ((File)object).getName() + "/" + ((File)object3).getName());
                    }
                    for (Object object52 : hashMap.keySet()) {
                        object4 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object52));
                        object3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.mRetrieveToDirectory));
                        while (object4.getParent() != object3) {
                            object4 = object4.getParent();
                        }
                        object4.delete();
                    }
                    object52 = new DOMSource(document);
                    object4 = new FileOutputStream(file);
                    object3 = new StreamResult((OutputStream)object4);
                    object2 = TransformerFactory.newInstance();
                    object = ((TransformerFactory)object2).newTransformer();
                    ((Transformer)object).transform((Source)object52, (Result)object3);
                }
            }
        }

        private String validFreeCacheDirName(File file, String string, int n) {
            String string2 = MessageFormat.format(string, new Integer(n));
            File file2 = new File(file, string2);
            return file2.exists() ? null : string2;
        }

        private void processSourceDirs(List<File> list) {
            for (File file : list) {
                this.processSourceDir(file);
            }
        }

        private void processSourceDir(File file) {
            this.processFileObject(file);
        }

        private void processFileObject(File file) {
            if (file.isDirectory()) {
                this.processFolder(file);
            } else {
                this.processFile(file);
            }
        }

        private void processFolder(File file) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.processFileObject(fileArray[i]);
            }
        }

        private void processFile(File file) {
            String string = file.getName();
            String string2 = null;
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string2 = string.substring(n + 1);
            }
        }

        public void displayStatus(String string) {
            XsltProjectRetriever.this.mRetUpd.setProgressMessage(NbBundle.getMessage(XsltProjectRetriever.class, (String)"LBL_Retrieving", (Object[])new Object[]{string}));
        }

        public SchemaModel getSchemaModel(org.netbeans.modules.xml.schema.model.Import import_) {
            SchemaModel schemaModel;
            String string = import_.getSchemaLocation();
            if (string == null) {
                return null;
            }
            try {
                URI uRI = new URI(string);
                ModelSource modelSource = CatalogModelFactory.getDefault().getCatalogModel(import_.getModel().getModelSource()).getModelSource(uRI, import_.getModel().getModelSource());
                schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            }
            catch (URISyntaxException uRISyntaxException) {
                schemaModel = null;
            }
            catch (CatalogModelException catalogModelException) {
                schemaModel = null;
            }
            if (schemaModel != null && schemaModel.getState() == Model.State.NOT_WELL_FORMED) {
                schemaModel = null;
            }
            return schemaModel;
        }

        public WSDLModel getWsdlModel(Import import_) {
            WSDLModel wSDLModel;
            String string = import_.getLocation();
            if (string == null) {
                return null;
            }
            try {
                URI uRI = new URI(string);
                ModelSource modelSource = CatalogModelFactory.getDefault().getCatalogModel(import_.getModel().getModelSource()).getModelSource(uRI, import_.getModel().getModelSource());
                wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            }
            catch (URISyntaxException uRISyntaxException) {
                wSDLModel = null;
            }
            catch (CatalogModelException catalogModelException) {
                wSDLModel = null;
            }
            if (wSDLModel != null && wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
                return null;
            }
            return wSDLModel;
        }

        URI externalResource(String string, String string2) {
            try {
                if (string2.startsWith("http:") || string2.startsWith("https:")) {
                    return new URI(string2);
                }
                File file = null;
                File file2 = null;
                if (string2.startsWith("file:")) {
                    URI uRI = new URI(string2);
                    file = new File(uRI);
                    file2 = FileUtil.normalizeFile((File)file);
                    if (file2.getAbsolutePath().replace('\\', '/').indexOf(this.mProjectSourcePath) != -1) {
                        return null;
                    }
                    if (file.exists()) {
                        return file2.toURI();
                    }
                }
                if (file == null) {
                    file = new File(string2);
                }
                if (!file.exists()) {
                    file = new File(this.mProjectSourcePath, string2);
                }
                if ((file2 = FileUtil.normalizeFile((File)file)).exists()) {
                    if (file2.getAbsolutePath().replace('\\', '/').indexOf(this.mProjectSourcePath) != -1) {
                        return null;
                    }
                    return file2.toURI();
                }
            }
            catch (Exception exception) {
                XsltProjectRetriever.this.logger.severe("Problem in the imported  location " + string2 + " of " + string);
            }
            return null;
        }
    }
}

