/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import org.netbeans.modules.cnd.makewizard.OptionSource;

public final class CompilerFlags {
    private boolean simpleDebug = false;
    private boolean simpleOptimize = false;
    private boolean develDebug = true;
    private OptionSource optionSource = OptionSource.DEVELOPMENT;
    private boolean finalOptimize = false;
    private boolean finalStrip = false;
    private boolean comp64bit = false;
    private String cFlagsSun;
    private String cFlagsGNU;
    private String ccFlagsSun;
    private String ccFlagsGNU;
    private String f90Flags;
    private String indent;

    public boolean isSimpleDebug() {
        return this.simpleDebug;
    }

    public void setSimpleDebug(boolean bl) {
        this.simpleDebug = bl;
    }

    public boolean isSimpleOptimize() {
        return this.simpleOptimize;
    }

    public void setSimpleOptimize(boolean bl) {
        this.simpleOptimize = bl;
    }

    public boolean isDevelDebug() {
        return this.develDebug;
    }

    public void setDevelDebug(boolean bl) {
        this.develDebug = bl;
    }

    public OptionSource getOptionSource() {
        return this.optionSource;
    }

    public void setOptionSource(OptionSource optionSource) {
        this.optionSource = optionSource;
    }

    public boolean isFinalOptimize() {
        return this.finalOptimize;
    }

    public void setFinalOptimize(boolean bl) {
        this.finalOptimize = bl;
    }

    public boolean isFinalStrip() {
        return this.finalStrip;
    }

    public void setFinalStrip(boolean bl) {
        this.finalStrip = bl;
    }

    public boolean is64Bit() {
        return this.comp64bit;
    }

    public void set64Bit(boolean bl) {
        this.comp64bit = bl;
    }

    public String getCFlags(int n) {
        if (n == 0) {
            return this.getCFlagsSun();
        }
        if (n == 1) {
            return this.getCFlagsGNU();
        }
        return null;
    }

    public String getCFlagsSun() {
        if (this.cFlagsSun == null) {
            this.cFlagsSun = "$(BASICOPTS) -xCC";
        }
        return this.cFlagsSun;
    }

    public String getCFlagsGNU() {
        if (this.cFlagsGNU == null) {
            this.cFlagsGNU = "$(BASICOPTS)";
        }
        return this.cFlagsGNU;
    }

    public void setCFlags(int n, String string) {
        if (n == 0) {
            this.setCFlagsSun(string);
        } else if (n == 1) {
            this.setCFlagsGNU(string);
        }
    }

    public void setCFlagsSun(String string) {
        this.cFlagsSun = string;
    }

    public void setCFlagsGNU(String string) {
        this.cFlagsGNU = string;
    }

    public String getCcFlags(int n) {
        if (n == 0) {
            return this.getCcFlagsSun();
        }
        if (n == 1) {
            return this.getCcFlagsGNU();
        }
        return null;
    }

    public String getCcFlagsSun() {
        if (this.ccFlagsSun == null) {
            this.ccFlagsSun = "$(BASICOPTS)";
        }
        return this.ccFlagsSun;
    }

    public String getCcFlagsGNU() {
        if (this.ccFlagsGNU == null) {
            this.ccFlagsGNU = "$(BASICOPTS)";
        }
        return this.ccFlagsGNU;
    }

    public void setCcFlags(int n, String string) {
        if (n == 0) {
            this.setCcFlagsSun(string);
        } else if (n == 1) {
            this.setCcFlagsGNU(string);
        }
    }

    public void setCcFlagsSun(String string) {
        this.ccFlagsSun = string;
    }

    public void setCcFlagsGNU(String string) {
        this.ccFlagsGNU = string;
    }

    public String getF90Flags() {
        if (this.f90Flags == null) {
            this.f90Flags = "$(BASICOPTS)";
        }
        return this.f90Flags;
    }

    public void setF90Flags(String string) {
        this.f90Flags = string;
    }

    public String getBasicOptions(int n) {
        if (n == 0) {
            return this.getBasicOptionsSun();
        }
        if (n == 1) {
            return this.getBasicOptionsGNU();
        }
        return null;
    }

    public String getBasicOptionsSun() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.optionSource == OptionSource.SIMPLE) {
            if (this.simpleDebug) {
                stringBuffer.append("-g ");
            }
            if (this.simpleOptimize) {
                stringBuffer.append("-xO3 ");
            }
        } else if (this.optionSource == OptionSource.DEVELOPMENT) {
            if (this.develDebug) {
                stringBuffer.append("-g ");
            } else {
                stringBuffer.append("-g -xO3 ");
            }
        } else {
            if (this.finalOptimize) {
                stringBuffer.append("-xO3 ");
            }
            if (this.finalStrip) {
                stringBuffer.append("-s ");
            }
        }
        if (this.comp64bit) {
            stringBuffer.append("-xarch=generic64 ");
        }
        return stringBuffer.toString().trim();
    }

    public String getBasicOptionsGNU() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.optionSource == OptionSource.SIMPLE) {
            if (this.simpleDebug) {
                stringBuffer.append("-g ");
            }
            if (this.simpleOptimize) {
                stringBuffer.append("-O ");
            }
        } else if (this.optionSource == OptionSource.DEVELOPMENT) {
            if (this.develDebug) {
                stringBuffer.append("-g ");
            } else {
                stringBuffer.append("-g -O ");
            }
        } else {
            if (this.finalOptimize) {
                stringBuffer.append("-O ");
            }
            if (this.finalStrip) {
                stringBuffer.append("-s ");
            }
        }
        if (this.comp64bit) {
            stringBuffer.append("-m64 ");
        }
        return stringBuffer.toString().trim();
    }

    public void dump() {
        this.println("Dumping CompilerFlags {");
        this.println("    Simple Debug      = ", this.simpleDebug);
        this.println("    Simple Optimize   = ", this.simpleOptimize);
        this.println("    OptionSource      = " + this.optionSource.toString());
        this.println("    Devel Debug       = True");
        this.println("    Devel Optimize    = ", !this.develDebug);
        this.println("    Final Optimize    = ", this.finalOptimize);
        this.println("    FinalStrip        = ", this.finalStrip);
        this.println("    64 Bit            = ", this.comp64bit);
        this.println("}");
    }

    public void dump(String string) {
        this.setIndent(string);
        this.dump();
    }

    private void println(String string) {
        System.out.println(this.indent + string);
    }

    private void println(String string, boolean bl) {
        System.out.println(this.indent + string + (bl ? "True" : "False"));
    }

    private void setIndent(String string) {
        this.indent = string;
    }
}

