/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HostInfoProvider {
    private static HostInfoProvider defaultProvider;

    public abstract PathMap getMapper(String var1);

    public abstract int getPlatform(String var1);

    public abstract Map<String, String> getEnv(String var1);

    public abstract boolean fileExists(String var1, String var2);

    public abstract String getLibDir(String var1);

    public static synchronized HostInfoProvider getDefault() {
        if (defaultProvider == null) {
            HostInfoProvider hostInfoProvider = (HostInfoProvider)Lookup.getDefault().lookup(HostInfoProvider.class);
            defaultProvider = new DefaultProvider(hostInfoProvider);
        }
        return defaultProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultProvider
    extends HostInfoProvider {
        private final HostInfoProvider provider;
        private static PathMap local = new LocalPathMap();

        public DefaultProvider(HostInfoProvider hostInfoProvider) {
            this.provider = hostInfoProvider;
        }

        @Override
        public PathMap getMapper(String string) {
            if (RemoteUtils.isLocalhost(string)) {
                return local;
            }
            if (this.provider != null) {
                return this.provider.getMapper(string);
            }
            throw DefaultProvider.getRE();
        }

        @Override
        public Map<String, String> getEnv(String string) {
            if (RemoteUtils.isLocalhost(string)) {
                return System.getenv();
            }
            if (this.provider != null) {
                return this.provider.getEnv(string);
            }
            throw DefaultProvider.getRE();
        }

        @Override
        public String getLibDir(String string) {
            if (RemoteUtils.isLocalhost(string)) {
                return null;
            }
            if (this.provider != null) {
                return this.provider.getLibDir(string);
            }
            throw DefaultProvider.getRE();
        }

        @Override
        public int getPlatform(String string) {
            if (RemoteUtils.isLocalhost(string)) {
                return CompilerSetManager.computeLocalPlatform();
            }
            if (this.provider != null) {
                return this.provider.getPlatform(string);
            }
            throw DefaultProvider.getRE();
        }

        private static RuntimeException getRE() {
            return new RuntimeException("No HostInfoProvider able to handle remote host was found");
        }

        @Override
        public boolean fileExists(String string, String string2) {
            if ("localhost".equals(string)) {
                return new File(string2).exists();
            }
            if (this.provider != null) {
                return this.provider.fileExists(string, string2);
            }
            throw new IllegalArgumentException();
        }

        private static class LocalPathMap
        implements PathMap {
            private LocalPathMap() {
            }

            public boolean isRemote(String string, boolean bl) {
                return false;
            }

            public String getLocalPath(String string) {
                return string;
            }

            public String getRemotePath(String string) {
                return string;
            }
        }
    }
}

