/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.NativeExecution;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.execution.OutputWindowWriter;
import org.netbeans.modules.cnd.execution.Unbuffer;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class NativeExecutor
implements Runnable {
    private final ArrayList<ExecutionListener> listeners = new ArrayList();
    private final String runDir;
    private final String executable;
    private final String arguments;
    private final String[] envp;
    private final String tabName;
    private final String actionName;
    private final boolean parseOutputForErrors;
    private final boolean showInput;
    private final String hkey;
    private final boolean unbuffer;
    private String rcfile;
    private NativeExecution nativeExecution;
    private boolean showHeader = true;
    private boolean showFooter = true;
    private InputOutput io;
    private PrintWriter out;
    private static ResourceBundle bundle = null;

    public NativeExecutor(String string, String string2, String string3, String string4, String[] stringArray, String string5, String string6, boolean bl, boolean bl2, boolean bl3) {
        this.hkey = string;
        this.runDir = string2;
        this.executable = string3;
        this.arguments = string4;
        this.envp = stringArray;
        this.tabName = string5;
        this.actionName = string6;
        this.parseOutputForErrors = bl;
        this.showInput = bl2;
        this.unbuffer = bl3;
    }

    public NativeExecutor(String string, String string2, String string3, String[] stringArray, String string4, String string5, boolean bl, boolean bl2) {
        this("localhost", string, string2, string3, stringArray, string4, string5, bl, bl2, false);
    }

    public ExecutorTask execute() throws IOException {
        return this.execute(this.getTab(this.tabName));
    }

    public ExecutorTask execute(InputOutput inputOutput) throws IOException {
        return this.execute(inputOutput, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(InputOutput inputOutput, String string) throws IOException {
        ExecutorTask executorTask;
        NativeExecutor nativeExecutor = this;
        synchronized (nativeExecutor) {
            this.io = inputOutput;
            inputOutput.select();
            executorTask = ExecutionEngine.getDefault().execute(this.tabName, (Runnable)this, InputOutput.NULL);
        }
        return executorTask;
    }

    private InputOutput getTab(String string) {
        return IOProvider.getDefault().getIO(string, true);
    }

    public InputOutput getTab() {
        return this.io;
    }

    public String getTabeName() {
        return this.tabName;
    }

    public void setExitValueOverride(String string) {
        this.rcfile = string;
    }

    private final String[] prepareEnvironment() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.envp != null) {
            arrayList.addAll(Arrays.asList(this.envp));
        }
        arrayList.add("SPRO_EXPAND_ERRORS=");
        if (this.unbuffer) {
            try {
                File file = new File(this.runDir, this.executable);
                if (!file.exists()) {
                    file = new File(this.executable);
                }
                for (String string : Unbuffer.getUnbufferEnvironment(this.hkey, file.getAbsolutePath())) {
                    arrayList.add(string);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        if (this.showInput) {
            this.io.setInputVisible(true);
        }
        File file = new File(this.runDir);
        this.out = this.parseOutputForErrors ? new PrintWriter(new OutputWindowWriter(this.hkey, this.io.getOut(), FileUtil.toFileObject((File)file), this.parseOutputForErrors)) : this.io.getOut();
        this.executionStarted();
        int n = 0;
        try {
            this.nativeExecution = NativeExecution.getDefault(this.hkey).getNativeExecution();
            n = this.nativeExecution.executeCommand(file, this.executable, this.arguments, this.prepareEnvironment(), this.out, this.showInput ? this.io.getIn() : null, this.unbuffer);
        }
        catch (ThreadDeath threadDeath) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            this.executionFinished(-1);
            this.out.close();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            StatusDisplayer.getDefault().setStatusText(NativeExecutor.getString("MSG_FailedStatus"));
            ErrorManager.getDefault().notify(throwable);
            n = -1;
        }
        finally {
            if (this.showInput) {
                this.io.setInputVisible(false);
                try {
                    this.io.getIn().close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (this.rcfile != null) {
            File file2 = null;
            try {
                file2 = new File(this.rcfile);
                if (file2.exists()) {
                    char[] cArray;
                    int n2;
                    FileReader fileReader = new FileReader(file2);
                    if (fileReader.ready() && (n2 = fileReader.read(cArray = new char[256])) > 0) {
                        n = Integer.valueOf(String.valueOf(cArray, 0, n2 - 1));
                    }
                    fileReader.close();
                    file2.delete();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
        }
        this.executionFinished(n);
        this.out.close();
    }

    public void stop() {
        this.nativeExecution.stop();
    }

    private void executionStarted() {
        if (this.showHeader) {
            String string = "localhost".equals(this.hkey) ? this.runDir : HostInfoProvider.getDefault().getMapper(this.hkey).getRemotePath(this.runDir);
            String string2 = MessageFormat.format(NativeExecutor.getString("PRETEXT"), this.exePlusArgsQuoted(this.executable, this.arguments), string);
            this.out.println(string2);
            this.out.println("");
        }
        this.fireExecutionStarted();
    }

    private void executionFinished(int n) {
        if (this.showFooter) {
            String string = MessageFormat.format(NativeExecutor.getString(n == 0 ? "SUCCESSFUL" : "FAILED"), this.actionName);
            String string2 = MessageFormat.format(NativeExecutor.getString("POSTTEXT"), string, "" + n);
            this.out.println("");
            this.out.println(string2);
            this.out.println("");
            StatusDisplayer.getDefault().setStatusText(string);
        }
        this.fireExecutionFinished(n);
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    private void fireExecutionStarted() {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionStarted();
        }
    }

    private void fireExecutionFinished(int n) {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(n);
        }
    }

    private String exePlusArgsQuoted(String string, String string2) {
        String string3 = string;
        string3 = string2 == null || string2.length() == 0 ? "\"" + string3 + "\"" : "\"" + string3 + " " + string2 + "\"";
        return string3;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NativeExecutor.class);
        }
        return bundle.getString(string);
    }
}

