/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.utils.Path;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolchainManager {
    private static final boolean TRACE = Boolean.getBoolean("cnd.toolchain.personality.trace");
    private static final boolean CREATE_SHADOW = Boolean.getBoolean("cnd.toolchain.personality.create_shadow");
    private static final ToolchainManager instance = new ToolchainManager();
    private List<ToolchainDescriptor> descriptors = new ArrayList<ToolchainDescriptor>();
    private Logger log = Logger.getLogger("cnd.toolchain.logger");

    static final ToolchainManager getInstance() {
        return instance;
    }

    private ToolchainManager() {
        this.initToolchainManager();
    }

    private void initToolchainManager() {
        try {
            TreeMap<Integer, CompilerVendor> treeMap = new TreeMap<Integer, CompilerVendor>();
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Services/CndToolChain");
            int n = 0x3FFFFFFF;
            if (fileObject != null && fileObject.isFolder()) {
                Object object;
                for (Object object2 : object = fileObject.getChildren()) {
                    CompilerVendor compilerVendor = new CompilerVendor(object2.getNameExt());
                    Integer n2 = (Integer)object2.getAttribute("position");
                    if (n2 == null || treeMap.containsKey(n2)) {
                        n2 = new Integer(n++);
                    }
                    if (!this.read((FileObject)object2, (FileObject[])object, compilerVendor, new HashSet<FileObject>())) continue;
                    treeMap.put(n2, compilerVendor);
                }
            }
            if (TRACE) {
                System.out.println("Declared vendors:");
            }
            for (Object object : treeMap.values()) {
                if (TRACE) {
                    System.out.println(((CompilerVendor)object).toString());
                }
                this.descriptors.add(new ToolchainDescriptorImpl((CompilerVendor)object));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (CREATE_SHADOW) {
            this.writeToolchains();
        }
    }

    void reinitToolchainManager() {
        this.descriptors.clear();
        this.initToolchainManager();
    }

    ToolchainDescriptor getToolchain(String string, int n) {
        ToolchainDescriptor toolchainDescriptor = null;
        for (ToolchainDescriptor toolchainDescriptor2 : this.descriptors) {
            if (this.isPlatforSupported(n, toolchainDescriptor2) && string.equals(toolchainDescriptor2.getName())) {
                return toolchainDescriptor2;
            }
            if (toolchainDescriptor != null || !this.isPlatforSupported(6, toolchainDescriptor2)) continue;
            toolchainDescriptor = toolchainDescriptor2;
        }
        return toolchainDescriptor;
    }

    List<ToolchainDescriptor> getAllToolchains() {
        return new ArrayList<ToolchainDescriptor>(this.descriptors);
    }

    List<ToolchainDescriptor> getToolchains(int n) {
        ArrayList<ToolchainDescriptor> arrayList = new ArrayList<ToolchainDescriptor>();
        for (ToolchainDescriptor toolchainDescriptor : this.descriptors) {
            if (!this.isPlatforSupported(n, toolchainDescriptor)) continue;
            arrayList.add(toolchainDescriptor);
        }
        return arrayList;
    }

    boolean isPlatforSupported(int n, ToolchainDescriptor toolchainDescriptor) {
        if (!this.releaseFileMatch(toolchainDescriptor)) {
            return false;
        }
        switch (n) {
            case 0: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_sparc".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"sun_intel".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"linux".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"windows".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"mac".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"unix".equals(string)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String string : toolchainDescriptor.getPlatforms()) {
                    if (!"none".equals(string)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean releaseFileMatch(ToolchainDescriptor toolchainDescriptor) {
        String string = toolchainDescriptor.getReleaseFile();
        String string2 = toolchainDescriptor.getReleasePattern();
        if (string != null && string2 != null) {
            File file = new File(string);
            if (file.exists()) {
                Pattern pattern = Pattern.compile(string2);
                try {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (!pattern.matcher(string3).find()) continue;
                        return true;
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    this.log.warning("Excetpiont reading releae file [" + string + "] for " + toolchainDescriptor.getName());
                }
            }
            return false;
        }
        return true;
    }

    boolean isMyFolder(String string, ToolchainDescriptor toolchainDescriptor, int n) {
        boolean bl = this.isMyFolderImpl(string, toolchainDescriptor, n);
        if (TRACE && bl) {
            System.out.println("Path [" + string + "] belongs to tool chain " + toolchainDescriptor.getName());
        }
        return bl;
    }

    private boolean isMyFolderImpl(String string, ToolchainDescriptor toolchainDescriptor, int n) {
        Object object;
        Object object2;
        CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
        if (compilerDescriptor == null || compilerDescriptor.getNames().length == 0) {
            return false;
        }
        Pattern pattern = null;
        if (compilerDescriptor.getPathPattern() != null) {
            pattern = n == 3 ? Pattern.compile(compilerDescriptor.getPathPattern(), 2) : Pattern.compile(compilerDescriptor.getPathPattern());
        }
        if (pattern != null && !pattern.matcher(string).find()) {
            object2 = compilerDescriptor.getExistFolder();
            if (object2 == null) {
                return false;
            }
            object = new File(string + "/" + (String)object2);
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                return false;
            }
        }
        if (!((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0]))).exists() && !((File)(object2 = new File(string + "/" + compilerDescriptor.getNames()[0] + ".exe"))).exists()) {
            return false;
        }
        object = compilerDescriptor.getVersionFlags();
        if (object == null) {
            return true;
        }
        if (compilerDescriptor.getVersionPattern() == null) {
            return true;
        }
        pattern = Pattern.compile(compilerDescriptor.getVersionPattern());
        String string2 = ToolchainManager.getCommandOutput(string, string + "/" + compilerDescriptor.getNames()[0] + " " + (String)object, true);
        boolean bl = pattern.matcher(string2).find();
        if (TRACE && !bl) {
            System.out.println("No match for pattern [" + compilerDescriptor.getVersionPattern() + "]:");
        }
        if (TRACE && !bl) {
            System.out.println("Run " + string + "/" + compilerDescriptor.getNames()[0] + " " + (String)object + "\n" + string2);
        }
        return bl;
    }

    String getBaseFolder(ToolchainDescriptor toolchainDescriptor, int n) {
        if (n != 3) {
            return null;
        }
        String string = toolchainDescriptor.getBaseFolderPattern();
        String string2 = toolchainDescriptor.getBaseFolderKey();
        if (string2 == null || string == null) {
            return null;
        }
        String string3 = this.readRegestry(string2, string);
        if (string3 != null && toolchainDescriptor.getBaseFolderSuffix() != null) {
            string3 = string3 + "/" + toolchainDescriptor.getBaseFolderSuffix();
        }
        return string3;
    }

    String getCommandFolder(ToolchainDescriptor toolchainDescriptor, int n) {
        if (n != 3) {
            return null;
        }
        String string = toolchainDescriptor.getCommandFolderPattern();
        String string2 = toolchainDescriptor.getCommandFolderKey();
        if (string2 == null || string == null) {
            return null;
        }
        String string3 = this.readRegestry(string2, string);
        if (string3 != null && toolchainDescriptor.getCommandFolderSuffix() != null) {
            string3 = string3 + "\\" + toolchainDescriptor.getCommandFolderSuffix();
        }
        if (string3 == null && (string = toolchainDescriptor.getCommandFolderPathPattern()) != null && string.length() > 0) {
            Pattern pattern = Pattern.compile(string);
            for (String string4 : Path.getPath()) {
                if (!pattern.matcher(string4).find()) continue;
                string3 = string4;
                break;
            }
        }
        return string3;
    }

    private String readRegestry(String string, String string2) {
        String string3;
        block5: {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("C:/Windows/System32/reg.exe");
            arrayList.add("query");
            arrayList.add(string);
            arrayList.add("/s");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            string3 = null;
            try {
                String string4;
                if (TRACE) {
                    System.out.println("Read registry " + string);
                }
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Pattern pattern = Pattern.compile(string2);
                while ((string4 = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    string4 = string4.trim();
                    if (TRACE) {
                        System.out.println("\t" + string4);
                    }
                    if (!(matcher = pattern.matcher(string4)).find() || matcher.groupCount() != 1) continue;
                    string3 = matcher.group(1).trim();
                    if (!TRACE) continue;
                    System.out.println("\tFound " + string3);
                }
            }
            catch (Exception exception) {
                if (!TRACE) break block5;
                exception.printStackTrace();
            }
        }
        return string3;
    }

    private static String getCommandOutput(String string, String string2, boolean bl) {
        StringBuilder stringBuilder;
        block21: {
            String iOException;
            Object object;
            stringBuilder = new StringBuilder();
            if (string == null) {
                string = "";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : System.getenv().keySet()) {
                object = System.getenv().get(object2);
                if (object2.equals(Path.getPathName())) {
                    arrayList.add(Path.getPathName() + "=" + string + File.pathSeparatorChar + (String)object);
                    continue;
                }
                iOException = object2 + "=" + (String)(object != null ? object : "");
                arrayList.add(iOException);
            }
            try {
                InputStream inputStream;
                block20: {
                    Process process;
                    block19: {
                        InputStream inputStream2;
                        block18: {
                            process = Runtime.getRuntime().exec(string2, arrayList.toArray(new String[arrayList.size()]));
                            inputStream2 = process.getInputStream();
                            object = new BufferedReader(new InputStreamReader(inputStream2));
                            try {
                                while ((iOException = ((BufferedReader)object).readLine()) != null) {
                                    stringBuilder.append(iOException);
                                    stringBuilder.append('\n');
                                }
                            }
                            catch (IOException iOException2) {
                                if (!TRACE) break block18;
                                iOException2.printStackTrace();
                            }
                        }
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                        }
                        catch (IOException iOException3) {
                            if (!TRACE) break block19;
                            iOException3.printStackTrace();
                        }
                    }
                    inputStream = process.getErrorStream();
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        while ((iOException = ((BufferedReader)object).readLine()) != null) {
                            stringBuilder.append(iOException);
                            stringBuilder.append('\n');
                        }
                    }
                    catch (IOException iOException4) {
                        if (!TRACE) break block20;
                        iOException4.printStackTrace();
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException5) {
                    if (TRACE) {
                        iOException5.printStackTrace();
                    }
                }
            }
            catch (IOException iOException6) {
                if (!TRACE) break block21;
                iOException6.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    private boolean read(FileObject fileObject, FileObject[] fileObjectArray, CompilerVendor compilerVendor, Set<FileObject> set) {
        if (set.contains(fileObject)) {
            return false;
        }
        set.add(fileObject);
        String string = (String)fileObject.getAttribute("extends");
        if (string != null && string.length() > 0) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (!string.equals(fileObject2.getName()) || this.read(fileObject2, fileObjectArray, compilerVendor, set)) continue;
                return false;
            }
        }
        try {
            this.read(fileObject.getInputStream(), compilerVendor);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private boolean read(InputStream inputStream, CompilerVendor compilerVendor) {
        Object object;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        XMLReader xMLReader = null;
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        object = new SAXHandler(compilerVendor);
        xMLReader.setContentHandler((ContentHandler)object);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private String unsplit(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToolchains() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Services/CndToolChain");
        if (fileObject != null && fileObject.isFolder()) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                String string = fileObject2.getNameExt();
                for (ToolchainDescriptor toolchainDescriptor : this.descriptors) {
                    DebuggerDescriptor debuggerDescriptor;
                    MakeDescriptor makeDescriptor;
                    Object object;
                    Object object2;
                    Object object3;
                    if (!string.equals(toolchainDescriptor.getFileName())) continue;
                    Document document = XMLUtil.createDocument((String)"toolchaindefinition", (String)"http://www.netbeans.org/ns/cnd-toolchain-definition/1", null, null);
                    Element element = document.getDocumentElement();
                    Element element2 = document.createElement("toolchain");
                    element2.setAttribute("name", toolchainDescriptor.getName());
                    element2.setAttribute("display", toolchainDescriptor.getDisplayName());
                    element2.setAttribute("family", this.unsplit(toolchainDescriptor.getFamily()));
                    element.appendChild(element2);
                    element2 = document.createElement("platforms");
                    element2.setAttribute("stringvalue", this.unsplit(toolchainDescriptor.getPlatforms()));
                    if (toolchainDescriptor.getReleaseFile() != null) {
                        element2.setAttribute("release_file", toolchainDescriptor.getReleaseFile());
                    }
                    if (toolchainDescriptor.getReleasePattern() != null) {
                        element2.setAttribute("release_pattern", toolchainDescriptor.getReleasePattern());
                    }
                    element.appendChild(element2);
                    if (toolchainDescriptor.getDriveLetterPrefix() != null) {
                        element2 = document.createElement("drive_letter_prefix");
                        element2.setAttribute("stringvalue", toolchainDescriptor.getDriveLetterPrefix());
                        element.appendChild(element2);
                    }
                    if (toolchainDescriptor.getBaseFolderKey() != null || toolchainDescriptor.getBaseFolderPattern() != null || toolchainDescriptor.getBaseFolderPathPattern() != null || toolchainDescriptor.getBaseFolderSuffix() != null) {
                        element2 = document.createElement("base_folder");
                        if (toolchainDescriptor.getBaseFolderKey() != null) {
                            element2.setAttribute("regestry", toolchainDescriptor.getBaseFolderKey());
                        }
                        if (toolchainDescriptor.getBaseFolderPattern() != null) {
                            element2.setAttribute("pattern", toolchainDescriptor.getBaseFolderPattern());
                        }
                        if (toolchainDescriptor.getBaseFolderPathPattern() != null) {
                            element2.setAttribute("path_patern", toolchainDescriptor.getBaseFolderPathPattern());
                        }
                        if (toolchainDescriptor.getBaseFolderSuffix() != null) {
                            element2.setAttribute("suffix", toolchainDescriptor.getBaseFolderSuffix());
                        }
                        element.appendChild(element2);
                    }
                    if (toolchainDescriptor.getCommandFolderKey() != null || toolchainDescriptor.getCommandFolderPattern() != null || toolchainDescriptor.getCommandFolderPathPattern() != null || toolchainDescriptor.getCommandFolderSuffix() != null) {
                        element2 = document.createElement("command_folder");
                        if (toolchainDescriptor.getCommandFolderKey() != null) {
                            element2.setAttribute("regestry", toolchainDescriptor.getCommandFolderKey());
                        }
                        if (toolchainDescriptor.getCommandFolderPattern() != null) {
                            element2.setAttribute("pattern", toolchainDescriptor.getCommandFolderPattern());
                        }
                        if (toolchainDescriptor.getCommandFolderPathPattern() != null) {
                            element2.setAttribute("path_patern", toolchainDescriptor.getCommandFolderPathPattern());
                        }
                        if (toolchainDescriptor.getCommandFolderSuffix() != null) {
                            element2.setAttribute("suffix", toolchainDescriptor.getCommandFolderSuffix());
                        }
                        element.appendChild(element2);
                    }
                    if (toolchainDescriptor.getDefaultLocations() != null) {
                        element2 = document.createElement("default_locations");
                        element.appendChild(element2);
                        object3 = toolchainDescriptor.getDefaultLocations().entrySet().iterator();
                        while (object3.hasNext()) {
                            object2 = (Map.Entry)object3.next();
                            object = document.createElement("platform");
                            object.setAttribute("os", (String)object2.getKey());
                            object.setAttribute("directory", (String)object2.getValue());
                            element2.appendChild((Node)object);
                        }
                    }
                    if ((object3 = toolchainDescriptor.getC()) != null) {
                        element2 = document.createElement("c");
                        this.writeCompiler(document, element2, (CompilerDescriptor)object3);
                        element.appendChild(element2);
                    }
                    if ((object3 = toolchainDescriptor.getCpp()) != null) {
                        element2 = document.createElement("cpp");
                        this.writeCompiler(document, element2, (CompilerDescriptor)object3);
                        element.appendChild(element2);
                    }
                    if ((object3 = toolchainDescriptor.getFortran()) != null) {
                        element2 = document.createElement("fortran");
                        this.writeCompiler(document, element2, (CompilerDescriptor)object3);
                        element.appendChild(element2);
                    }
                    if ((object2 = toolchainDescriptor.getScanner()) != null) {
                        element2 = document.createElement("scanner");
                        this.writeScanner(document, element2, (ScannerDescriptor)object2);
                        element.appendChild(element2);
                    }
                    if ((object = toolchainDescriptor.getLinker()) != null) {
                        element2 = document.createElement("linker");
                        this.writeLinker(document, element2, (LinkerDescriptor)object);
                        element.appendChild(element2);
                    }
                    if ((makeDescriptor = toolchainDescriptor.getMake()) != null) {
                        element2 = document.createElement("make");
                        this.writeMake(document, element2, makeDescriptor);
                        element.appendChild(element2);
                    }
                    if ((debuggerDescriptor = toolchainDescriptor.getDebugger()) != null) {
                        element2 = document.createElement("debugger");
                        this.writeDebugger(document, element2, debuggerDescriptor);
                        element.appendChild(element2);
                    }
                    try {
                        FileLock fileLock = fileObject2.lock();
                        try {
                            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                            try {
                                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                                fileObject2.setAttribute("extends", (Object)"");
                            }
                            finally {
                                outputStream.close();
                            }
                        }
                        finally {
                            fileLock.releaseLock();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
    }

    private void writeCompiler(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        Element element2 = document.createElement("compiler");
        element2.setAttribute("name", this.unsplit(compilerDescriptor.getNames()));
        element.appendChild(element2);
        if (compilerDescriptor.getPathPattern() != null || compilerDescriptor.getExistFolder() != null) {
            element2 = document.createElement("recognizer");
            if (compilerDescriptor.getPathPattern() != null) {
                element2.setAttribute("pattern", compilerDescriptor.getPathPattern());
            }
            if (compilerDescriptor.getExistFolder() != null) {
                element2.setAttribute("or_exist_folder", compilerDescriptor.getExistFolder());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getVersionFlags() != null || compilerDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (compilerDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getVersionFlags());
            }
            if (compilerDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", compilerDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getIncludeFlags() != null || compilerDescriptor.getIncludeParser() != null || compilerDescriptor.getRemoveIncludePathPrefix() != null || compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
            element2 = document.createElement("system_include_paths");
            if (compilerDescriptor.getIncludeFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getIncludeFlags());
            }
            if (compilerDescriptor.getIncludeParser() != null) {
                element2.setAttribute("parser", compilerDescriptor.getIncludeParser());
            }
            if (compilerDescriptor.getRemoveIncludePathPrefix() != null) {
                element2.setAttribute("remove_in_path", compilerDescriptor.getRemoveIncludePathPrefix());
            }
            if (compilerDescriptor.getRemoveIncludeOutputPrefix() != null) {
                element2.setAttribute("remove_in_output", compilerDescriptor.getRemoveIncludeOutputPrefix());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getUserIncludeFlag() != null) {
            element2 = document.createElement("user_include");
            element2.setAttribute("flags", compilerDescriptor.getUserIncludeFlag());
            element.appendChild(element2);
        }
        if (compilerDescriptor.getMacroFlags() != null || compilerDescriptor.getMacroParser() != null) {
            element2 = document.createElement("system_macros");
            if (compilerDescriptor.getMacroFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getMacroFlags());
            }
            if (compilerDescriptor.getMacroParser() != null) {
                element2.setAttribute("parser", compilerDescriptor.getMacroParser());
            }
            element.appendChild(element2);
        }
        if (compilerDescriptor.getUserMacroFlag() != null) {
            element2 = document.createElement("user_macro");
            element2.setAttribute("flags", compilerDescriptor.getUserMacroFlag());
            element.appendChild(element2);
        }
        this.writeDevelopmentMode(document, element, compilerDescriptor);
        this.writeWarningLevel(document, element, compilerDescriptor);
        this.writeArchitecture(document, element, compilerDescriptor);
        if (compilerDescriptor.getStripFlag() != null) {
            element2 = document.createElement("strip");
            element2.setAttribute("flags", compilerDescriptor.getStripFlag());
            element.appendChild(element2);
        }
        this.writeMultithreading(document, element, compilerDescriptor);
        this.writeStandard(document, element, compilerDescriptor);
        this.writeLanguageExtension(document, element, compilerDescriptor);
        this.writeLibrary(document, element, compilerDescriptor);
        if (compilerDescriptor.getDependencyGenerationFlags() != null) {
            element2 = document.createElement("dependency_generation");
            element2.setAttribute("flags", compilerDescriptor.getDependencyGenerationFlags());
            element.appendChild(element2);
        }
        if (compilerDescriptor.getPrecompiledHeaderFlags() != null || compilerDescriptor.getPrecompiledHeaderSuffix() != null) {
            element2 = document.createElement("precompiled_header");
            if (compilerDescriptor.getPrecompiledHeaderFlags() != null) {
                element2.setAttribute("flags", compilerDescriptor.getPrecompiledHeaderFlags());
            }
            if (compilerDescriptor.getPrecompiledHeaderSuffix() != null) {
                element2.setAttribute("suffix", compilerDescriptor.getPrecompiledHeaderSuffix());
            }
            if (compilerDescriptor.getPrecompiledHeaderSuffixAppend()) {
                element2.setAttribute("append", "true");
            }
            element.appendChild(element2);
        }
    }

    private void writeDevelopmentMode(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getDevelopmentModeFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).developmentMode.default_selection;
        }
        Element element2 = document.createElement("development_mode");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"fast_build", "debug", "performance_debug", "test_coverage", "diagnosable_release", "release", "performance_release"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeWarningLevel(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getWarningLevelFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).warningLevel.default_selection;
        }
        Element element2 = document.createElement("warning_level");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"no_warnings", "default", "more_warnings", "warning2error"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeArchitecture(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getArchitectureFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).architecture.default_selection;
        }
        Element element2 = document.createElement("architecture");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"default", "bits_32", "bits_64"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeMultithreading(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getMultithreadingFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).multithreading.default_selection;
        }
        Element element2 = document.createElement("multithreading");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "safe", "automatic", "open_mp"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeStandard(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getStandardFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).standard.default_selection;
        }
        Element element2 = document.createElement("standard");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"old", "legacy", "default", "modern"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeLanguageExtension(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getLanguageExtensionFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).languageExtension.default_selection;
        }
        Element element2 = document.createElement("language_extension");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "default", "all"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeLibrary(Document document, Element element, CompilerDescriptor compilerDescriptor) {
        String[] stringArray = compilerDescriptor.getLibraryFlags();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        if (compilerDescriptor instanceof CompilerDescriptorImpl) {
            n = ((Compiler)((CompilerDescriptorImpl)compilerDescriptor).tool).library.default_selection;
        }
        Element element2 = document.createElement("library");
        element.appendChild(element2);
        String[] stringArray2 = new String[]{"none", "runtime", "classic", "binary_standard", "conforming_standard"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document.createElement(stringArray2[i]);
            element3.setAttribute("flags", stringArray[i]);
            if (n == i) {
                element3.setAttribute("default", "true");
            }
            element2.appendChild(element3);
        }
    }

    private void writeScanner(Document document, Element element, ScannerDescriptor scannerDescriptor) {
        Element element2;
        for (ScannerPattern scannerPattern : scannerDescriptor.getPatterns()) {
            element2 = document.createElement(scannerPattern.getSeverity());
            element2.setAttribute("pattern", scannerPattern.getPattern());
            if (scannerPattern.getLanguage() != null) {
                element2.setAttribute("language", scannerPattern.getLanguage());
            }
            element.appendChild(element2);
        }
        if (scannerDescriptor.getStackHeaderPattern() != null) {
            element2 = document.createElement("stack_header");
            element2.setAttribute("pattern", scannerDescriptor.getStackHeaderPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getStackNextPattern() != null) {
            element2 = document.createElement("stack_next");
            element2.setAttribute("pattern", scannerDescriptor.getStackNextPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getEnterDirectoryPattern() != null) {
            element2 = document.createElement("enter_directory");
            element2.setAttribute("pattern", scannerDescriptor.getEnterDirectoryPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getChangeDirectoryPattern() != null) {
            element2 = document.createElement("change_directory");
            element2.setAttribute("pattern", scannerDescriptor.getChangeDirectoryPattern());
            element.appendChild(element2);
        }
        if (scannerDescriptor.getLeaveDirectoryPattern() != null) {
            element2 = document.createElement("leave_directory");
            element2.setAttribute("pattern", scannerDescriptor.getLeaveDirectoryPattern());
            element.appendChild(element2);
        }
    }

    private void writeLinker(Document document, Element element, LinkerDescriptor linkerDescriptor) {
        Element element2;
        if (linkerDescriptor.getLibraryPrefix() != null) {
            element2 = document.createElement("library_prefix");
            element2.setAttribute("stringvalue", linkerDescriptor.getLibraryPrefix());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getLibrarySearchFlag() != null) {
            element2 = document.createElement("library_search");
            element2.setAttribute("flags", linkerDescriptor.getLibrarySearchFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibrarySearchFlag() != null) {
            element2 = document.createElement("dynamic_library_search");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibrarySearchFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getLibraryFlag() != null) {
            element2 = document.createElement("library");
            element2.setAttribute("flags", linkerDescriptor.getLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getPICFlag() != null) {
            element2 = document.createElement("PIC");
            element2.setAttribute("flags", linkerDescriptor.getPICFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getStaticLibraryFlag() != null) {
            element2 = document.createElement("static_library");
            element2.setAttribute("flags", linkerDescriptor.getStaticLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibraryFlag() != null) {
            element2 = document.createElement("dynamic_library");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibraryFlag());
            element.appendChild(element2);
        }
        if (linkerDescriptor.getDynamicLibraryBasicFlag() != null) {
            element2 = document.createElement("dynamic_library_basic");
            element2.setAttribute("flags", linkerDescriptor.getDynamicLibraryBasicFlag());
            element.appendChild(element2);
        }
    }

    private void writeMake(Document document, Element element, MakeDescriptor makeDescriptor) {
        Element element2 = document.createElement("tool");
        element2.setAttribute("name", this.unsplit(makeDescriptor.getNames()));
        element.appendChild(element2);
        if (makeDescriptor.getVersionFlags() != null || makeDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (makeDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", makeDescriptor.getVersionFlags());
            }
            if (makeDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", makeDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
        if (makeDescriptor.getDependencySupportCode() != null) {
            element2 = document.createElement("dependency_support");
            element2.setAttribute("code", makeDescriptor.getDependencySupportCode());
            element.appendChild(element2);
        }
    }

    private void writeDebugger(Document document, Element element, DebuggerDescriptor debuggerDescriptor) {
        Element element2 = document.createElement("tool");
        element2.setAttribute("name", this.unsplit(debuggerDescriptor.getNames()));
        element.appendChild(element2);
        if (debuggerDescriptor.getVersionFlags() != null || debuggerDescriptor.getVersionPattern() != null) {
            element2 = document.createElement("version");
            if (debuggerDescriptor.getVersionFlags() != null) {
                element2.setAttribute("flags", debuggerDescriptor.getVersionFlags());
            }
            if (debuggerDescriptor.getVersionPattern() != null) {
                element2.setAttribute("pattern", debuggerDescriptor.getVersionPattern());
            }
            element.appendChild(element2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DebuggerDescriptorImpl
    extends ToolDescriptorImpl<Debugger>
    implements DebuggerDescriptor {
        public DebuggerDescriptorImpl(Debugger debugger) {
            super(debugger);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MakeDescriptorImpl
    extends ToolDescriptorImpl<Make>
    implements MakeDescriptor {
        private MakeDescriptorImpl(Make make) {
            super(make);
        }

        @Override
        public String getDependencySupportCode() {
            return ((Make)this.tool).dependencySupportCode;
        }
    }

    private static final class LinkerDescriptorImpl
    implements LinkerDescriptor {
        private Linker l;

        private LinkerDescriptorImpl(Linker linker) {
            this.l = linker;
        }

        public String getLibrarySearchFlag() {
            return this.l.librarySearchFlag;
        }

        public String getDynamicLibrarySearchFlag() {
            return this.l.dynamicLibrarySearchFlag;
        }

        public String getLibraryFlag() {
            return this.l.libraryFlag;
        }

        public String getLibraryPrefix() {
            return this.l.library_prefix;
        }

        public String getPICFlag() {
            return this.l.PICFlag;
        }

        public String getStaticLibraryFlag() {
            return this.l.staticLibraryFlag;
        }

        public String getDynamicLibraryFlag() {
            return this.l.dynamicLibraryFlag;
        }

        public String getDynamicLibraryBasicFlag() {
            return this.l.dynamicLibraryBasicFlag;
        }
    }

    private static final class ScannerPatternImpl
    implements ScannerPattern {
        private ErrorPattern e;

        private ScannerPatternImpl(ErrorPattern errorPattern) {
            this.e = errorPattern;
        }

        public String getPattern() {
            return this.e.pattern;
        }

        public String getSeverity() {
            return this.e.severity;
        }

        public String getLanguage() {
            return this.e.language;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerDescriptorImpl
    implements ScannerDescriptor {
        private Scanner s;
        private List<ScannerPattern> patterns;

        private ScannerDescriptorImpl(Scanner scanner) {
            this.s = scanner;
        }

        @Override
        public List<ScannerPattern> getPatterns() {
            if (this.patterns == null) {
                this.patterns = new ArrayList<ScannerPattern>();
                for (ErrorPattern errorPattern : this.s.patterns) {
                    this.patterns.add(new ScannerPatternImpl(errorPattern));
                }
            }
            return this.patterns;
        }

        @Override
        public String getChangeDirectoryPattern() {
            return this.s.changeDirectoryPattern;
        }

        @Override
        public String getEnterDirectoryPattern() {
            return this.s.enterDirectoryPattern;
        }

        @Override
        public String getLeaveDirectoryPattern() {
            return this.s.leaveDirectoryPattern;
        }

        @Override
        public String getStackHeaderPattern() {
            return this.s.stackHeaderPattern;
        }

        @Override
        public String getStackNextPattern() {
            return this.s.stackNextPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompilerDescriptorImpl
    extends ToolDescriptorImpl<Compiler>
    implements CompilerDescriptor {
        private CompilerDescriptorImpl(Compiler compiler) {
            super(compiler);
        }

        @Override
        public String getPathPattern() {
            return ((Compiler)this.tool).pathPattern;
        }

        @Override
        public String getExistFolder() {
            return ((Compiler)this.tool).existFolder;
        }

        @Override
        public String getIncludeFlags() {
            return ((Compiler)this.tool).includeFlags;
        }

        @Override
        public String getIncludeParser() {
            return ((Compiler)this.tool).includeOutputParser;
        }

        @Override
        public String getRemoveIncludePathPrefix() {
            return ((Compiler)this.tool).removeIncludePathPrefix;
        }

        @Override
        public String getRemoveIncludeOutputPrefix() {
            return ((Compiler)this.tool).removeIncludeOutputPrefix;
        }

        @Override
        public String getUserIncludeFlag() {
            return ((Compiler)this.tool).userIncludeFlag;
        }

        @Override
        public String getMacroFlags() {
            return ((Compiler)this.tool).macrosFlags;
        }

        @Override
        public String getMacroParser() {
            return ((Compiler)this.tool).macrosOutputParser;
        }

        @Override
        public String getUserMacroFlag() {
            return ((Compiler)this.tool).userMacroFlag;
        }

        @Override
        public String[] getDevelopmentModeFlags() {
            return ((Compiler)this.tool).developmentMode.values();
        }

        @Override
        public String[] getWarningLevelFlags() {
            return ((Compiler)this.tool).warningLevel.values();
        }

        @Override
        public String[] getArchitectureFlags() {
            return ((Compiler)this.tool).architecture.values();
        }

        @Override
        public String getStripFlag() {
            return ((Compiler)this.tool).strip;
        }

        @Override
        public String[] getMultithreadingFlags() {
            return ((Compiler)this.tool).multithreading.values();
        }

        @Override
        public String[] getStandardFlags() {
            return ((Compiler)this.tool).standard.values();
        }

        @Override
        public String[] getLanguageExtensionFlags() {
            return ((Compiler)this.tool).languageExtension.values();
        }

        @Override
        public String[] getLibraryFlags() {
            return ((Compiler)this.tool).library.values();
        }

        @Override
        public String getDependencyGenerationFlags() {
            return ((Compiler)this.tool).dependencyGenerationFlags;
        }

        @Override
        public String getPrecompiledHeaderFlags() {
            return ((Compiler)this.tool).precompiledHeaderFlags;
        }

        @Override
        public String getPrecompiledHeaderSuffix() {
            return ((Compiler)this.tool).precompiledHeaderSuffix;
        }

        @Override
        public boolean getPrecompiledHeaderSuffixAppend() {
            return ((Compiler)this.tool).precompiledHeaderSuffixAppend;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolDescriptorImpl<T extends Tool>
    implements ToolDescriptor {
        protected T tool;

        public ToolDescriptorImpl(T t) {
            this.tool = t;
        }

        @Override
        public String[] getNames() {
            if (((Tool)this.tool).name != null && ((Tool)this.tool).name.length() > 0) {
                return ((Tool)this.tool).name.split(",");
            }
            return new String[0];
        }

        @Override
        public String getVersionFlags() {
            return ((Tool)this.tool).versionFlags;
        }

        @Override
        public String getVersionPattern() {
            return ((Tool)this.tool).versionPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ToolchainDescriptorImpl
    implements ToolchainDescriptor {
        CompilerVendor v;
        private CompilerDescriptor c;
        private CompilerDescriptor cpp;
        private CompilerDescriptor fortran;
        private LinkerDescriptor linker;
        private ScannerDescriptor scanner;
        private MakeDescriptor make;
        private DebuggerDescriptor debugger;

        private ToolchainDescriptorImpl(CompilerVendor compilerVendor) {
            this.v = compilerVendor;
        }

        @Override
        public String getFileName() {
            return this.v.toolChainFileName;
        }

        @Override
        public String getName() {
            return this.v.toolChainName;
        }

        @Override
        public String getDisplayName() {
            return this.v.toolChainDisplay;
        }

        @Override
        public String getReleaseFile() {
            return this.v.release_file;
        }

        @Override
        public String getReleasePattern() {
            return this.v.release_pattern;
        }

        @Override
        public String[] getFamily() {
            if (this.v.family != null && this.v.family.length() > 0) {
                return this.v.family.split(",");
            }
            return new String[0];
        }

        @Override
        public String[] getPlatforms() {
            if (this.v.platforms != null && this.v.platforms.length() > 0) {
                return this.v.platforms.split(",");
            }
            return new String[0];
        }

        @Override
        public String getDriveLetterPrefix() {
            return this.v.driveLetterPrefix;
        }

        @Override
        public CompilerDescriptor getC() {
            if (this.c == null && this.v.c.isValid()) {
                this.c = new CompilerDescriptorImpl(this.v.c);
            }
            return this.c;
        }

        @Override
        public String getBaseFolderKey() {
            return this.v.baseFolderKey;
        }

        @Override
        public String getBaseFolderPattern() {
            return this.v.baseFolderPattern;
        }

        @Override
        public String getBaseFolderSuffix() {
            return this.v.baseFolderSuffix;
        }

        @Override
        public String getBaseFolderPathPattern() {
            return this.v.baseFolderPathPattern;
        }

        @Override
        public String getCommandFolderKey() {
            return this.v.commandFolderKey;
        }

        @Override
        public String getCommandFolderPattern() {
            return this.v.commandFolderPattern;
        }

        @Override
        public String getCommandFolderSuffix() {
            return this.v.commandFolderSuffix;
        }

        @Override
        public String getCommandFolderPathPattern() {
            return this.v.commandFolderPathPattern;
        }

        @Override
        public CompilerDescriptor getCpp() {
            if (this.cpp == null && this.v.cpp.isValid()) {
                this.cpp = new CompilerDescriptorImpl(this.v.cpp);
            }
            return this.cpp;
        }

        @Override
        public CompilerDescriptor getFortran() {
            if (this.fortran == null && this.v.fortran.isValid()) {
                this.fortran = new CompilerDescriptorImpl(this.v.fortran);
            }
            return this.fortran;
        }

        @Override
        public ScannerDescriptor getScanner() {
            if (this.scanner == null) {
                this.scanner = new ScannerDescriptorImpl(this.v.scanner);
            }
            return this.scanner;
        }

        @Override
        public LinkerDescriptor getLinker() {
            if (this.linker == null) {
                this.linker = new LinkerDescriptorImpl(this.v.linker);
            }
            return this.linker;
        }

        @Override
        public MakeDescriptor getMake() {
            if (this.make == null) {
                this.make = new MakeDescriptorImpl(this.v.make);
            }
            return this.make;
        }

        @Override
        public Map<String, String> getDefaultLocations() {
            return this.v.default_locations;
        }

        @Override
        public DebuggerDescriptor getDebugger() {
            if (this.debugger == null) {
                this.debugger = new DebuggerDescriptorImpl(this.v.debugger);
            }
            return this.debugger;
        }

        public String toString() {
            return this.v.toolChainName + "/" + this.v.family + "/" + this.v.platforms;
        }
    }

    private static final class SAXHandler
    extends DefaultHandler {
        private String path;
        private CompilerVendor v;
        private boolean isScanerOverrided = false;
        private int version = 1;

        private SAXHandler(CompilerVendor compilerVendor) {
            this.v = compilerVendor;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            if (this.path != null) {
                this.path = this.path.equals(string3) ? null : this.path.substring(0, this.path.length() - string3.length() - 1);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            super.startElement(string, string2, string3, attributes);
            this.path = this.path == null ? string3 : this.path + "." + string3;
            if (this.path.equals("toolchaindefinition")) {
                object = attributes.getValue("xmlns");
                if (object != null) {
                    int n = ((String)object).lastIndexOf(47);
                    if (n >= 0 && n + 1 < ((String)object).length()) {
                        String string4 = ((String)object).substring(n + 1);
                        if (string4.length() > 0) {
                            try {
                                this.version = Integer.parseInt(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (TRACE) {
                                    System.out.println("Incorrect version information:" + (String)object);
                                }
                            }
                        }
                    } else if (TRACE) {
                        System.out.println("Incorrect version information:" + (String)object);
                    }
                }
            } else {
                if (this.path.endsWith(".toolchain")) {
                    this.v.toolChainName = attributes.getValue("name");
                    this.v.toolChainDisplay = attributes.getValue("display");
                    this.v.family = attributes.getValue("family");
                    return;
                }
                if (this.path.endsWith(".platforms")) {
                    this.v.platforms = attributes.getValue("stringvalue");
                    this.v.release_file = attributes.getValue("release_file");
                    this.v.release_pattern = attributes.getValue("release_pattern");
                    return;
                }
                if (this.path.endsWith(".drive_letter_prefix")) {
                    this.v.driveLetterPrefix = attributes.getValue("stringvalue");
                    return;
                }
                if (this.path.endsWith(".base_folder")) {
                    this.v.baseFolderKey = attributes.getValue("regestry");
                    this.v.baseFolderPattern = attributes.getValue("pattern");
                    this.v.baseFolderSuffix = attributes.getValue("suffix");
                    this.v.baseFolderPathPattern = attributes.getValue("path_patern");
                    return;
                }
                if (this.path.endsWith(".command_folder")) {
                    this.v.commandFolderKey = attributes.getValue("regestry");
                    this.v.commandFolderPattern = attributes.getValue("pattern");
                    this.v.commandFolderSuffix = attributes.getValue("suffix");
                    this.v.commandFolderPathPattern = attributes.getValue("path_patern");
                    return;
                }
                if (this.path.indexOf(".default_locations.") > 0) {
                    if (this.path.endsWith(".platform")) {
                        String string5 = attributes.getValue("os");
                        String string6 = attributes.getValue("directory");
                        if (string5 != null && string6 != null) {
                            if (this.v.default_locations == null) {
                                this.v.default_locations = new HashMap<String, String>();
                            }
                            this.v.default_locations.put(string5, string6);
                        }
                    }
                    return;
                }
            }
            if (this.path.indexOf(".linker.") > 0) {
                object = this.v.linker;
                if (this.path.endsWith(".library_prefix")) {
                    ((Linker)object).library_prefix = attributes.getValue("stringvalue");
                    return;
                }
                if (this.path.endsWith(".library_search")) {
                    ((Linker)object).librarySearchFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_search")) {
                    ((Linker)object).dynamicLibrarySearchFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".library")) {
                    ((Linker)object).libraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".PIC")) {
                    ((Linker)object).PICFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".static_library")) {
                    ((Linker)object).staticLibraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library")) {
                    ((Linker)object).dynamicLibraryFlag = attributes.getValue("flags");
                    return;
                }
                if (this.path.endsWith(".dynamic_library_basic")) {
                    ((Linker)object).dynamicLibraryBasicFlag = attributes.getValue("flags");
                    return;
                }
                return;
            }
            if (this.path.indexOf(".make.") > 0) {
                object = this.v.make;
                if (this.path.endsWith(".tool")) {
                    ((Make)object).name = attributes.getValue("name");
                } else if (this.path.endsWith(".version")) {
                    ((Make)object).versionFlags = attributes.getValue("flags");
                    ((Make)object).versionPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".dependency_support")) {
                    ((Make)object).dependencySupportCode = attributes.getValue("code").replace("\\n", "\n");
                }
            }
            if (this.path.indexOf(".debugger.") > 0) {
                object = this.v.debugger;
                if (this.path.endsWith(".tool")) {
                    ((Debugger)object).name = attributes.getValue("name");
                } else if (this.path.endsWith(".version")) {
                    ((Debugger)object).versionFlags = attributes.getValue("flags");
                    ((Debugger)object).versionPattern = attributes.getValue("pattern");
                }
            }
            if (this.path.indexOf(".scanner.") > 0) {
                if (!this.isScanerOverrided) {
                    this.v.scanner = new Scanner();
                    this.isScanerOverrided = true;
                }
                object = this.v.scanner;
                if (this.path.endsWith(".error")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    ((Scanner)object).patterns.add(errorPattern);
                    errorPattern.severity = "error";
                    errorPattern.pattern = attributes.getValue("pattern");
                    errorPattern.language = attributes.getValue("language");
                } else if (this.path.endsWith(".warning")) {
                    ErrorPattern errorPattern = new ErrorPattern();
                    ((Scanner)object).patterns.add(errorPattern);
                    errorPattern.severity = "warning";
                    errorPattern.pattern = attributes.getValue("pattern");
                    errorPattern.language = attributes.getValue("language");
                } else if (this.path.endsWith(".change_directory")) {
                    ((Scanner)object).changeDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".enter_directory")) {
                    ((Scanner)object).enterDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".leave_directory")) {
                    ((Scanner)object).leaveDirectoryPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".stack_header")) {
                    ((Scanner)object).stackHeaderPattern = attributes.getValue("pattern");
                } else if (this.path.endsWith(".stack_next")) {
                    ((Scanner)object).stackNextPattern = attributes.getValue("pattern");
                }
            }
            if (this.path.indexOf(".c.") > 0) {
                object = this.v.c;
            } else if (this.path.indexOf(".cpp.") > 0) {
                object = this.v.cpp;
            } else if (this.path.indexOf(".fortran.") > 0) {
                object = this.v.fortran;
            } else {
                return;
            }
            if (this.path.endsWith(".compiler")) {
                ((Compiler)object).name = attributes.getValue("name");
                return;
            }
            if (this.path.endsWith(".recognizer")) {
                ((Compiler)object).pathPattern = attributes.getValue("pattern");
                ((Compiler)object).existFolder = attributes.getValue("or_exist_folder");
                return;
            }
            if (this.path.endsWith(".version")) {
                ((Compiler)object).versionPattern = attributes.getValue("pattern");
                ((Compiler)object).versionFlags = attributes.getValue("flags");
                return;
            }
            String string7 = attributes.getValue("flags");
            if (string7 == null) {
                return;
            }
            boolean bl = "true".equals(attributes.getValue("default"));
            if (this.path.endsWith(".system_include_paths")) {
                ((Compiler)object).includeFlags = string7;
                ((Compiler)object).includeOutputParser = attributes.getValue("parser");
                ((Compiler)object).removeIncludePathPrefix = attributes.getValue("remove_in_path");
                ((Compiler)object).removeIncludeOutputPrefix = attributes.getValue("remove_in_output");
            } else if (this.path.endsWith(".user_include")) {
                ((Compiler)object).userIncludeFlag = string7;
            } else if (this.path.endsWith(".system_macros")) {
                ((Compiler)object).macrosFlags = string7;
                ((Compiler)object).macrosOutputParser = attributes.getValue("parser");
            } else if (this.path.endsWith(".user_macro")) {
                ((Compiler)object).userMacroFlag = string7;
            } else if (this.path.indexOf(".development_mode.") > 0) {
                DevelopmentMode developmentMode = ((Compiler)object).developmentMode;
                if (this.path.endsWith(".fast_build")) {
                    developmentMode.fast_build = string7;
                    if (bl) {
                        developmentMode.default_selection = 0;
                    }
                } else if (this.path.endsWith(".debug")) {
                    developmentMode.debug = string7;
                    if (bl) {
                        developmentMode.default_selection = 1;
                    }
                } else if (this.path.endsWith(".performance_debug")) {
                    developmentMode.performance_debug = string7;
                    if (bl) {
                        developmentMode.default_selection = 2;
                    }
                } else if (this.path.endsWith(".test_coverage")) {
                    developmentMode.test_coverage = string7;
                    if (bl) {
                        developmentMode.default_selection = 3;
                    }
                } else if (this.path.endsWith(".diagnosable_release")) {
                    developmentMode.diagnosable_release = string7;
                    if (bl) {
                        developmentMode.default_selection = 4;
                    }
                } else if (this.path.endsWith(".release")) {
                    developmentMode.release = string7;
                    if (bl) {
                        developmentMode.default_selection = 5;
                    }
                } else if (this.path.endsWith(".performance_release")) {
                    developmentMode.performance_release = string7;
                    if (bl) {
                        developmentMode.default_selection = 6;
                    }
                }
            } else if (this.path.indexOf(".warning_level.") > 0) {
                WarningLevel warningLevel = ((Compiler)object).warningLevel;
                if (this.path.endsWith(".no_warnings")) {
                    warningLevel.no_warnings = string7;
                    if (bl) {
                        warningLevel.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    warningLevel.default_level = string7;
                    if (bl) {
                        warningLevel.default_selection = 1;
                    }
                } else if (this.path.endsWith(".more_warnings")) {
                    warningLevel.more_warnings = string7;
                    if (bl) {
                        warningLevel.default_selection = 2;
                    }
                } else if (this.path.endsWith(".warning2error")) {
                    warningLevel.warning2error = string7;
                    if (bl) {
                        warningLevel.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".architecture.") > 0) {
                Architecture architecture = ((Compiler)object).architecture;
                if (this.path.endsWith(".default")) {
                    architecture.default_architecture = string7;
                    if (bl) {
                        architecture.default_selection = 0;
                    }
                } else if (this.path.endsWith(".bits_32")) {
                    architecture.bits_32 = string7;
                    if (bl) {
                        architecture.default_selection = 1;
                    }
                } else if (this.path.endsWith(".bits_64")) {
                    architecture.bits_64 = string7;
                    if (bl) {
                        architecture.default_selection = 2;
                    }
                }
            } else if (this.path.endsWith(".strip")) {
                ((Compiler)object).strip = string7;
            } else if (this.path.endsWith(".dependency_generation")) {
                ((Compiler)object).dependencyGenerationFlags = string7;
            } else if (this.path.endsWith(".precompiled_header")) {
                ((Compiler)object).precompiledHeaderFlags = string7;
                ((Compiler)object).precompiledHeaderSuffix = attributes.getValue("suffix");
                ((Compiler)object).precompiledHeaderSuffixAppend = Boolean.valueOf(attributes.getValue("append"));
            } else if (this.path.indexOf(".multithreading.") > 0) {
                MultiThreading multiThreading = ((Compiler)object).multithreading;
                if (this.path.endsWith(".none")) {
                    multiThreading.none = string7;
                    if (bl) {
                        multiThreading.default_selection = 0;
                    }
                } else if (this.path.endsWith(".safe")) {
                    multiThreading.safe = string7;
                    if (bl) {
                        multiThreading.default_selection = 1;
                    }
                } else if (this.path.endsWith(".automatic")) {
                    multiThreading.automatic = string7;
                    if (bl) {
                        multiThreading.default_selection = 2;
                    }
                } else if (this.path.endsWith(".open_mp")) {
                    multiThreading.open_mp = string7;
                    if (bl) {
                        multiThreading.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".standard.") > 0) {
                Standard standard = ((Compiler)object).standard;
                if (this.path.endsWith(".old")) {
                    standard.old = string7;
                    if (bl) {
                        standard.default_selection = 0;
                    }
                } else if (this.path.endsWith(".legacy")) {
                    standard.legacy = string7;
                    if (bl) {
                        standard.default_selection = 1;
                    }
                } else if (this.path.endsWith(".default")) {
                    standard.default_standard = string7;
                    if (bl) {
                        standard.default_selection = 2;
                    }
                } else if (this.path.endsWith(".modern")) {
                    standard.modern = string7;
                    if (bl) {
                        standard.default_selection = 3;
                    }
                }
            } else if (this.path.indexOf(".language_extension.") > 0) {
                LanguageExtension languageExtension = ((Compiler)object).languageExtension;
                if (this.path.endsWith(".none")) {
                    languageExtension.none = string7;
                    if (bl) {
                        languageExtension.default_selection = 0;
                    }
                } else if (this.path.endsWith(".default")) {
                    languageExtension.default_extension = string7;
                    if (bl) {
                        languageExtension.default_selection = 1;
                    }
                } else if (this.path.endsWith(".all")) {
                    languageExtension.all = string7;
                    if (bl) {
                        languageExtension.default_selection = 2;
                    }
                }
            } else if (this.path.indexOf(".library.") > 0) {
                Library library = ((Compiler)object).library;
                if (this.path.endsWith(".none")) {
                    library.none = string7;
                    if (bl) {
                        library.default_selection = 0;
                    }
                } else if (this.path.endsWith(".runtime")) {
                    library.runtime = string7;
                    if (bl) {
                        library.default_selection = 1;
                    }
                } else if (this.path.endsWith(".classic")) {
                    library.classic = string7;
                    if (bl) {
                        library.default_selection = 2;
                    }
                } else if (this.path.endsWith(".binary_standard")) {
                    library.binary_standard = string7;
                    if (bl) {
                        library.default_selection = 3;
                    }
                } else if (this.path.endsWith(".conforming_standard")) {
                    library.conforming_standard = string7;
                    if (bl) {
                        library.default_selection = 4;
                    }
                }
            }
        }
    }

    static final class Library {
        String none;
        String runtime;
        String classic;
        String binary_standard;
        String conforming_standard;
        int default_selection = 0;

        Library() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.runtime + ";" + this.classic + ";" + this.binary_standard + ";" + this.conforming_standard + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.runtime != null && this.classic != null && this.binary_standard != null && this.conforming_standard != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.runtime, this.classic, this.binary_standard, this.conforming_standard};
            }
            return null;
        }
    }

    static final class LanguageExtension {
        String none;
        String default_extension;
        String all;
        int default_selection = 0;

        LanguageExtension() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.default_extension + ";" + this.all + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.default_extension != null && this.all != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.default_extension, this.all};
            }
            return null;
        }
    }

    static final class Standard {
        String old;
        String legacy;
        String default_standard;
        String modern;
        int default_selection = 0;

        Standard() {
        }

        public String toString() {
            return "[" + this.old + ";" + this.legacy + ";" + this.default_standard + ";" + this.modern + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.old != null && this.legacy != null && this.default_standard != null && this.modern != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.old, this.legacy, this.default_standard, this.modern};
            }
            return null;
        }
    }

    static final class MultiThreading {
        String none;
        String safe;
        String automatic;
        String open_mp;
        int default_selection = 0;

        MultiThreading() {
        }

        public String toString() {
            return "[" + this.none + ";" + this.safe + ";" + this.automatic + ";" + this.open_mp + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.none != null && this.safe != null && this.automatic != null && this.open_mp != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.none, this.safe, this.automatic, this.open_mp};
            }
            return null;
        }
    }

    static final class Architecture {
        String default_architecture;
        String bits_32;
        String bits_64;
        int default_selection = 0;

        Architecture() {
        }

        public String toString() {
            return "[" + this.default_architecture + ";" + this.bits_32 + ";" + this.bits_64 + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.default_architecture != null && this.bits_32 != null && this.bits_64 != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.default_architecture, this.bits_32, this.bits_64};
            }
            return null;
        }
    }

    static final class WarningLevel {
        String no_warnings;
        String default_level;
        String more_warnings;
        String warning2error;
        int default_selection = 0;

        WarningLevel() {
        }

        public String toString() {
            return "[" + this.no_warnings + ";" + this.default_level + ";" + this.more_warnings + ";" + this.warning2error + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.no_warnings != null && this.default_level != null && this.more_warnings != null && this.warning2error != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.no_warnings, this.default_level, this.more_warnings, this.warning2error};
            }
            return null;
        }
    }

    static final class DevelopmentMode {
        String fast_build;
        String debug;
        String performance_debug;
        String test_coverage;
        String diagnosable_release;
        String release;
        String performance_release;
        int default_selection = 0;

        DevelopmentMode() {
        }

        public String toString() {
            return "[" + this.fast_build + ";" + this.debug + ";" + this.performance_debug + ";" + this.test_coverage + ";" + this.diagnosable_release + ";" + this.release + ";" + this.performance_release + "] default " + this.default_selection;
        }

        public boolean isValid() {
            return this.fast_build != null && this.debug != null && this.performance_debug != null && this.test_coverage != null && this.diagnosable_release != null && this.release != null && this.performance_release != null;
        }

        public String[] values() {
            if (this.isValid()) {
                return new String[]{this.fast_build, this.debug, this.performance_debug, this.test_coverage, this.diagnosable_release, this.release, this.performance_release};
            }
            return null;
        }
    }

    static final class Debugger
    extends Tool {
        Debugger() {
        }
    }

    static final class Make
    extends Tool {
        String dependencySupportCode;

        Make() {
        }
    }

    static final class Linker {
        String library_prefix;
        String librarySearchFlag;
        String dynamicLibrarySearchFlag;
        String libraryFlag;
        String PICFlag;
        String staticLibraryFlag;
        String dynamicLibraryFlag;
        String dynamicLibraryBasicFlag;

        Linker() {
        }
    }

    static final class ErrorPattern {
        String pattern;
        String severity;
        String language;

        ErrorPattern() {
        }
    }

    static final class Scanner {
        List<ErrorPattern> patterns = new ArrayList<ErrorPattern>();
        String changeDirectoryPattern;
        String enterDirectoryPattern;
        String leaveDirectoryPattern;
        String stackHeaderPattern;
        String stackNextPattern;

        Scanner() {
        }
    }

    static final class Compiler
    extends Tool {
        String pathPattern;
        String existFolder;
        String includeFlags;
        String includeOutputParser;
        String removeIncludePathPrefix;
        String removeIncludeOutputPrefix;
        String userIncludeFlag;
        String macrosFlags;
        String macrosOutputParser;
        String userMacroFlag;
        String dependencyGenerationFlags;
        String precompiledHeaderFlags;
        String precompiledHeaderSuffix;
        boolean precompiledHeaderSuffixAppend;
        DevelopmentMode developmentMode = new DevelopmentMode();
        WarningLevel warningLevel = new WarningLevel();
        Architecture architecture = new Architecture();
        String strip;
        MultiThreading multithreading = new MultiThreading();
        Standard standard = new Standard();
        LanguageExtension languageExtension = new LanguageExtension();
        Library library = new Library();

        Compiler() {
        }

        public boolean isValid() {
            return this.name != null && this.name.length() > 0;
        }
    }

    static class Tool {
        String name;
        String versionFlags;
        String versionPattern;

        Tool() {
        }
    }

    static final class CompilerVendor {
        final String toolChainFileName;
        String toolChainName;
        String toolChainDisplay;
        Map<String, String> default_locations;
        String family;
        String platforms;
        String release_file;
        String release_pattern;
        String driveLetterPrefix;
        String baseFolderKey;
        String baseFolderPattern;
        String baseFolderSuffix;
        String baseFolderPathPattern;
        String commandFolderKey;
        String commandFolderPattern;
        String commandFolderSuffix;
        String commandFolderPathPattern;
        Compiler c = new Compiler();
        Compiler cpp = new Compiler();
        Compiler fortran = new Compiler();
        Scanner scanner = new Scanner();
        Linker linker = new Linker();
        Make make = new Make();
        Debugger debugger = new Debugger();

        private CompilerVendor(String string) {
            this.toolChainFileName = string;
        }

        public boolean isValid() {
            return this.toolChainName != null && this.toolChainName.length() > 0 && (this.c.isValid() || this.cpp.isValid() || this.fortran.isValid());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Toolchain [" + this.toolChainName + "/" + this.family + "] " + this.toolChainDisplay + "\n");
            stringBuilder.append("\tPlatforms [" + this.platforms + "]\n");
            stringBuilder.append("\tDrive Letter Prefix [" + this.driveLetterPrefix + "]\n");
            stringBuilder.append("\tBase Folder Key [" + this.baseFolderKey + "] Pattern [" + this.baseFolderPattern + "] Suffix [" + this.baseFolderSuffix + "] Path Pattern[" + this.baseFolderPattern + "] \n");
            stringBuilder.append("\tCommand Folder Key [" + this.commandFolderKey + "] Pattern [" + this.commandFolderPattern + "] Suffix [" + this.commandFolderSuffix + "] Path Pattern[" + this.commandFolderPattern + "] \n");
            stringBuilder.append("C compiler [" + this.c.name + "] Recognize path [" + this.c.pathPattern + "] Version [" + this.c.versionFlags + ";" + this.c.versionPattern + "]\n");
            stringBuilder.append("\tInclude flags [" + this.c.includeFlags + "] parser [" + this.c.includeOutputParser + "] remove from path[" + this.c.removeIncludePathPrefix + "] remove from output [" + this.c.removeIncludeOutputPrefix + "]\n");
            stringBuilder.append("\tMacros flags [" + this.c.macrosFlags + "] parser [" + this.c.macrosOutputParser + "]\n");
            stringBuilder.append("\tDevelopment mode " + this.c.developmentMode + "\n");
            stringBuilder.append("\tWarning Level " + this.c.warningLevel + "\n");
            stringBuilder.append("\tArchitecture " + this.c.architecture + "\n");
            stringBuilder.append("\tStrip [" + this.c.strip + "]\n");
            if (this.c.multithreading.isValid()) {
                stringBuilder.append("\tMultithreading [" + this.c.multithreading + "]\n");
            }
            if (this.c.standard.isValid()) {
                stringBuilder.append("\tStandard [" + this.c.standard + "]\n");
            }
            if (this.c.languageExtension.isValid()) {
                stringBuilder.append("\tLanguage [" + this.c.languageExtension + "]\n");
            }
            if (this.c.library.isValid()) {
                stringBuilder.append("\tLibrary [" + this.c.library + "]\n");
            }
            stringBuilder.append("C++ compiler [" + this.cpp.name + "] Recognize path [" + this.cpp.pathPattern + "] Version [" + this.cpp.versionFlags + ";" + this.cpp.versionPattern + "]\n");
            stringBuilder.append("\tInclude flags [" + this.cpp.includeFlags + "] parser [" + this.cpp.includeOutputParser + "] remove from path[" + this.cpp.removeIncludePathPrefix + "] remove from output [" + this.cpp.removeIncludeOutputPrefix + "]\n");
            stringBuilder.append("\tMacros flags [" + this.cpp.macrosFlags + "] parser [" + this.cpp.macrosOutputParser + "]\n");
            stringBuilder.append("\tDevelopment mode " + this.cpp.developmentMode + "\n");
            stringBuilder.append("\tWarning Level " + this.cpp.warningLevel + "\n");
            stringBuilder.append("\tArchitecture " + this.cpp.architecture + "\n");
            stringBuilder.append("\tStrip [" + this.cpp.strip + "]\n");
            stringBuilder.append("\tDependency generation flags [" + this.cpp.dependencyGenerationFlags + "]\n");
            if (this.cpp.multithreading.isValid()) {
                stringBuilder.append("\tMultithreading " + this.cpp.multithreading + "\n");
            }
            if (this.cpp.standard.isValid()) {
                stringBuilder.append("\tStandard " + this.cpp.standard + "\n");
            }
            if (this.cpp.languageExtension.isValid()) {
                stringBuilder.append("\tLanguage " + this.cpp.languageExtension + "\n");
            }
            if (this.cpp.library.isValid()) {
                stringBuilder.append("\tLibrary " + this.cpp.library + "\n");
            }
            if (this.fortran.isValid()) {
                stringBuilder.append("Fortran compiler [" + this.fortran.name + "] Recognize path [" + this.fortran.pathPattern + "] Version [" + this.fortran.versionFlags + ";" + this.fortran.versionPattern + "]\n");
                stringBuilder.append("\tDevelopment mode " + this.fortran.developmentMode + "\n");
                stringBuilder.append("\tWarning Level " + this.fortran.warningLevel + "\n");
                stringBuilder.append("\tArchitecture " + this.fortran.architecture + "\n");
                stringBuilder.append("\tStrip [" + this.fortran.strip + "]\n");
            }
            stringBuilder.append("Scanner\n");
            stringBuilder.append("\tChange Directory [" + this.scanner.changeDirectoryPattern + "]\n");
            stringBuilder.append("\tEnter Directory [" + this.scanner.enterDirectoryPattern + "]\n");
            stringBuilder.append("\tLeave Directory [" + this.scanner.leaveDirectoryPattern + "]\n");
            stringBuilder.append("\tStack Header [" + this.scanner.stackHeaderPattern + "]\n");
            stringBuilder.append("\tStack Next [" + this.scanner.stackNextPattern + "]\n");
            for (ErrorPattern errorPattern : this.scanner.patterns) {
                stringBuilder.append("\tPattern [" + errorPattern.pattern + "] Level [" + errorPattern.severity + "] Language [" + errorPattern.language + "]\n");
            }
            stringBuilder.append("Linker\n");
            stringBuilder.append("\tLibrary prefix [" + this.linker.library_prefix + "]\n");
            stringBuilder.append("\tLibrary search [" + this.linker.librarySearchFlag + "]\n");
            stringBuilder.append("\tDynamic library search [" + this.linker.dynamicLibrarySearchFlag + "]\n");
            stringBuilder.append("\tLibrary [" + this.linker.libraryFlag + "]\n");
            stringBuilder.append("\tPIC [" + this.linker.PICFlag + "]\n");
            stringBuilder.append("\tStatic library [" + this.linker.staticLibraryFlag + "]\n");
            stringBuilder.append("\tDynamic library [" + this.linker.dynamicLibraryFlag + "]\n");
            stringBuilder.append("\tDynamic library basic [" + this.linker.dynamicLibraryBasicFlag + "]\n");
            stringBuilder.append("Make [" + this.make.name + "] Version [" + this.make.versionFlags + "; " + this.make.versionPattern + "]\n");
            stringBuilder.append("\tDependency support code [" + this.make.dependencySupportCode + "]\n");
            stringBuilder.append("Debugger [" + this.debugger.name + "] Version [" + this.debugger.versionFlags + "; " + this.debugger.versionPattern + "]\n");
            return stringBuilder.toString();
        }
    }

    public static interface ScannerPattern {
        public String getPattern();

        public String getSeverity();

        public String getLanguage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ScannerDescriptor {
        public List<ScannerPattern> getPatterns();

        public String getChangeDirectoryPattern();

        public String getEnterDirectoryPattern();

        public String getLeaveDirectoryPattern();

        public String getStackHeaderPattern();

        public String getStackNextPattern();
    }

    public static interface LinkerDescriptor {
        public String getLibraryPrefix();

        public String getLibrarySearchFlag();

        public String getDynamicLibrarySearchFlag();

        public String getLibraryFlag();

        public String getPICFlag();

        public String getStaticLibraryFlag();

        public String getDynamicLibraryFlag();

        public String getDynamicLibraryBasicFlag();
    }

    public static interface DebuggerDescriptor
    extends ToolDescriptor {
    }

    public static interface MakeDescriptor
    extends ToolDescriptor {
        public String getDependencySupportCode();
    }

    public static interface CompilerDescriptor
    extends ToolDescriptor {
        public String getPathPattern();

        public String getExistFolder();

        public String getIncludeFlags();

        public String getUserIncludeFlag();

        public String getIncludeParser();

        public String getRemoveIncludePathPrefix();

        public String getRemoveIncludeOutputPrefix();

        public String getMacroFlags();

        public String getUserMacroFlag();

        public String getMacroParser();

        public String[] getDevelopmentModeFlags();

        public String[] getWarningLevelFlags();

        public String[] getArchitectureFlags();

        public String getStripFlag();

        public String[] getMultithreadingFlags();

        public String[] getStandardFlags();

        public String[] getLanguageExtensionFlags();

        public String[] getLibraryFlags();

        public String getDependencyGenerationFlags();

        public String getPrecompiledHeaderFlags();

        public String getPrecompiledHeaderSuffix();

        public boolean getPrecompiledHeaderSuffixAppend();
    }

    public static interface ToolDescriptor {
        public String[] getNames();

        public String getVersionFlags();

        public String getVersionPattern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ToolchainDescriptor {
        public String getFileName();

        public String getName();

        public String getDisplayName();

        public String getReleaseFile();

        public String getReleasePattern();

        public String[] getFamily();

        public String[] getPlatforms();

        public String getDriveLetterPrefix();

        public String getBaseFolderKey();

        public String getBaseFolderPattern();

        public String getBaseFolderSuffix();

        public String getBaseFolderPathPattern();

        public String getCommandFolderKey();

        public String getCommandFolderPattern();

        public String getCommandFolderSuffix();

        public String getCommandFolderPathPattern();

        public CompilerDescriptor getC();

        public CompilerDescriptor getCpp();

        public CompilerDescriptor getFortran();

        public ScannerDescriptor getScanner();

        public LinkerDescriptor getLinker();

        public MakeDescriptor getMake();

        public Map<String, String> getDefaultLocations();

        public DebuggerDescriptor getDebugger();
    }
}

