/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.Settings;
import org.netbeans.modules.cnd.editor.shell.ShellKit;
import org.netbeans.modules.cnd.editor.shell.ShellSettingsInitializer;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CndModule
extends ModuleInstall {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.cnd");

    public void restored() {
        Settings.addInitializer((Settings.Initializer)new ShellSettingsInitializer(ShellKit.class));
        if (Utilities.isUnix()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            CndModule.addFile(arrayList, "bin/dorun.sh");
            if (Utilities.getOperatingSystem() == 8) {
                if (System.getProperty("os.arch").equals("sparc")) {
                    CndModule.addFile(arrayList, "bin/unbuffer-SunOS-sparc.so");
                    CndModule.addFile(arrayList, "bin/unbuffer-SunOS-sparc_64.so");
                } else {
                    CndModule.addFile(arrayList, "bin/unbuffer-SunOS-x86.so");
                    CndModule.addFile(arrayList, "bin/unbuffer-SunOS-x86_64.so");
                }
            } else if (Utilities.getOperatingSystem() == 16) {
                CndModule.addFile(arrayList, "bin/unbuffer-Linux-x86.so");
                CndModule.addFile(arrayList, "bin/unbuffer-Linux-x86_64.so");
            } else if (Utilities.isMac()) {
                CndModule.addFile(arrayList, "bin/unbuffer-Mac_OS_X-x86.dylib");
                CndModule.addFile(arrayList, "bin/unbuffer-Mac_OS_X-x86_64.dylib");
            }
            CndModule.setPermissions(arrayList);
        }
    }

    private static void addFile(List<String> list, String string) {
        File file = InstalledFileLocator.getDefault().locate(string, null, false);
        if (file != null && file.exists()) {
            list.add(file.getAbsolutePath());
        }
    }

    private static void setPermissions(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/bin/chmod");
        arrayList.add("755");
        arrayList.addAll(list);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

