/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.Image;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.IrbAction;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class RubyLogicalViewProvider
implements LogicalViewProvider {
    private static final boolean INCLUDE_IRB_CONSOLE = Boolean.getBoolean("ruby.irbconsole");
    private final RubyProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    private static Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/rubyproject/ui/resources/brokenProjectBadge.gif", (boolean)true);

    public RubyLogicalViewProvider(RubyProject rubyProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = rubyProject;
        assert (rubyProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new RubyLogicalViewRootNode();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2;
                TreeRootNode.PathFinder pathFinder = (TreeRootNode.PathFinder)nodeArray[i].getLookup().lookup(TreeRootNode.PathFinder.class);
                if (pathFinder != null && (node2 = pathFinder.findPath(nodeArray[i], object)) != null) {
                    return node2;
                }
                node2 = ((DataObject)nodeArray[i].getLookup().lookup(DataObject.class)).getPrimaryFile();
                if (!fileObject.equals(node2)) continue;
                return nodeArray[i];
            }
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.changeListeners == null) {
                return;
            }
            changeListenerArray = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public boolean hasBrokenLinks() {
        return false;
    }

    public boolean hasInvalidJdkVersion() {
        return false;
    }

    private final class RubyLogicalViewRootNode
    extends AbstractNode {
        private boolean broken;
        private boolean illegalState;
        private final RSpecSupport rspecSupport;

        public RubyLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)RubyLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-ruby-rubyproject/Nodes"), Lookups.singleton((Object)RubyLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/ruby/rubyproject/ui/resources/jruby.png");
            super.setName(ProjectUtils.getInformation((Project)RubyLogicalViewProvider.this.project).getDisplayName());
            if (RubyLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (RubyLogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.rspecSupport = new RSpecSupport(RubyLogicalViewProvider.this.project);
        }

        public String getShortDescription() {
            String string = RubyPlatform.platformDescriptionFor((Project)RubyLogicalViewProvider.this.project);
            if (string == null) {
                string = NbBundle.getMessage(RubyLogicalViewProvider.class, (String)"RubyLogicalViewProvider.PlatformNotFound");
            }
            String string2 = FileUtil.getFileDisplayName((FileObject)RubyLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(RubyLogicalViewProvider.class, (String)"RubyLogicalViewProvider.ProjectTooltipDescription", (Object)string2, (Object)string);
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.illegalState ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.illegalState ? ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.illegalState ? ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0) : image;
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)RubyLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RubyLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(RubyLogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildGemAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(RakeRunnerAction.class));
            arrayList.add((Action)SystemAction.get(IrbAction.class));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rdoc", (String)resourceBundle.getString("LBL_RDocAction_Name"), null));
            arrayList.add(null);
            if (INCLUDE_IRB_CONSOLE) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"irb-console", (String)"IRB", null));
                arrayList.add(null);
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            if (AutoTestSupport.isInstalled(RubyLogicalViewProvider.this.project)) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"autotest", (String)resourceBundle.getString("LBL_AutoTest"), null));
            }
            if (this.rspecSupport.isRSpecInstalled()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rspec", (String)resourceBundle.getString("LBL_RSpec"), null));
            }
            arrayList.add(CommonProjectActions.setProjectConfigurationAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }
}

