/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class TestNotifier
extends OutputRecognizer
implements Runnable {
    private static String mostRecentMessage;
    private boolean accumulate;
    private boolean showSuccesses;
    private int examples;
    private int failures;
    private int notImplemented;
    private int tests;
    private int assertions;
    private int errors;
    private boolean seenTestUnit;
    private boolean seenRSpec;
    private boolean seenRake;
    private static final boolean QUIET;
    private static final Pattern TEST_UNIT_PATTERN;
    private static final Pattern RSPEC_PATTERN;
    private static final Pattern RAKE_PATTERN;
    private final Pattern[] PATTERNS = new Pattern[]{TEST_UNIT_PATTERN, RSPEC_PATTERN, RAKE_PATTERN};

    public TestNotifier(boolean bl, boolean bl2) {
        this.accumulate = bl;
        this.showSuccesses = bl2;
    }

    public void start() {
        String string = mostRecentMessage;
        if (string != null) {
            String string2;
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (jTextComponent != null && jTextComponent.isShowing() && string.equals(string2 = Utilities.getStatusText((JTextComponent)jTextComponent))) {
                Utilities.clearStatusText((JTextComponent)jTextComponent);
            }
            mostRecentMessage = null;
        }
        this.resetResults();
    }

    public OutputRecognizer.ActionText processLine(String string) {
        if (QUIET) {
            return null;
        }
        String string2 = string;
        for (Pattern pattern : this.PATTERNS) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            if (!this.accumulate) {
                this.resetResults();
            }
            this.addTotals(pattern, matcher);
            if (this.isError() || this.isWarning() || this.showSuccesses) {
                this.run();
                continue;
            }
            String string3 = this.getSummary();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestNotifier.class, (String)"TestsCompleted", (Object)string3));
        }
        if (string2 != string) {
            return new OutputRecognizer.ActionText(new String[]{string2}, null, null, null);
        }
        return null;
    }

    private void resetResults() {
        this.examples = 0;
        this.failures = 0;
        this.notImplemented = 0;
        this.tests = 0;
        this.assertions = 0;
        this.errors = 0;
        this.seenTestUnit = false;
        this.seenRake = false;
        this.seenRake = false;
    }

    public void run() {
        String string = this.getSummary();
        String string2 = this.isError() ? NbBundle.getMessage(AutoTestSupport.class, (String)"TestsFailed", (Object)string) : NbBundle.getMessage(AutoTestSupport.class, (String)"TestsCompleted", (Object)string);
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent != null) {
            if (jTextComponent.isShowing()) {
                mostRecentMessage = string2;
                if (this.isError()) {
                    Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)string2);
                } else {
                    StatusBar statusBar;
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
                    if (editorUI != null && (statusBar = editorUI.getStatusBar()) != null) {
                        Coloring coloring = null;
                        coloring = this.isWarning() ? new Coloring(null, Color.BLACK, Color.YELLOW) : new Coloring(null, Color.BLACK, Color.GREEN);
                        statusBar.setText("main", string2, coloring);
                        return;
                    }
                    Utilities.setStatusText((JTextComponent)jTextComponent, (String)string2);
                }
            }
        } else {
            StatusDisplayer.getDefault().setStatusText(string2);
        }
    }

    boolean recognizeLine(String string) {
        for (Pattern pattern : this.PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private void addTotals(Pattern pattern, Matcher matcher) {
        assert (this.PATTERNS.length == 3);
        if (pattern == TEST_UNIT_PATTERN) {
            this.seenTestUnit = true;
            this.tests += Integer.parseInt(matcher.group(1));
            this.assertions += Integer.parseInt(matcher.group(2));
            this.failures += Integer.parseInt(matcher.group(3));
            this.errors += Integer.parseInt(matcher.group(4));
        } else if (pattern == RSPEC_PATTERN) {
            this.seenRSpec = true;
            this.examples += Integer.parseInt(matcher.group(1));
            this.failures += Integer.parseInt(matcher.group(2));
            if (matcher.group(4) != null) {
                this.notImplemented += Integer.parseInt(matcher.group(4));
            }
        } else {
            assert (pattern == RAKE_PATTERN);
            this.seenRake = true;
            ++this.errors;
        }
    }

    private void appendSummary(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    private String getCountDescription(String string, String string2, int n) {
        String string3 = Integer.toString(n);
        return NbBundle.getMessage(TestNotifier.class, (String)(n == 1 ? string : string2), (Object)string3);
    }

    boolean isError() {
        return this.errors > 0 || this.failures > 0;
    }

    boolean isWarning() {
        return this.notImplemented > 0;
    }

    String getSummary() {
        StringBuilder stringBuilder = new StringBuilder(80);
        if (this.seenTestUnit || this.tests > 0) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneTest", "ManyTests", this.tests));
        }
        if (this.seenTestUnit || this.assertions > 0) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneAssert", "ManyAssert", this.assertions));
        }
        if (this.seenRSpec || this.examples > 0) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneExample", "ManyExamples", this.examples));
        }
        if (!this.seenRake || this.seenTestUnit || this.seenRSpec) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneFailure", "ManyFailures", this.failures));
        }
        if (this.seenTestUnit || this.errors > 0) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneError", "ManyErrors", this.errors));
        }
        if (this.notImplemented > 0) {
            this.appendSummary(stringBuilder, this.getCountDescription("OneNotImpl", "ManyNotImpl", this.notImplemented));
        }
        return stringBuilder.toString();
    }

    static {
        QUIET = Boolean.getBoolean("ruby.quiet.tests");
        TEST_UNIT_PATTERN = Pattern.compile("(\\d+) tests, (\\d+) assertions, (\\d+) failures, (\\d+) errors\\s?");
        RSPEC_PATTERN = Pattern.compile("(\\d+) examples?, (\\d)+ failures?(, (\\d+) (pending|not implemented))?\\s?");
        RAKE_PATTERN = Pattern.compile("Test failures\\s?");
    }
}

