/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.rubyproject.IrbTopComponent;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class IrbAction
extends CallableSystemAction {
    private static final boolean USE_JRUBY_CONSOLE = Boolean.getBoolean("irb.jruby");

    private boolean runIrbConsole(Project project) {
        String string;
        PropertyEvaluator propertyEvaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (!(actionProvider instanceof ScriptDescProvider)) {
            return false;
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (rubyPlatform == null) {
            rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        }
        if ((string = rubyPlatform.getIRB()) == null) {
            return false;
        }
        ScriptDescProvider scriptDescProvider = (ScriptDescProvider)actionProvider;
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("--simple-prompt");
        arrayList.add("--noreadline");
        String string2 = NbBundle.getMessage(IrbAction.class, (String)"CTL_IrbTopComponentWithPlatform", (Object)rubyPlatform.getLabel());
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        String string3 = null;
        if (propertyEvaluator != null) {
            string3 = propertyEvaluator.getProperty("source.encoding");
        }
        OutputRecognizer[] outputRecognizerArray = new OutputRecognizer[]{new TestNotifier(true, true)};
        String string4 = string;
        ExecutionDescriptor executionDescriptor = scriptDescProvider.getScriptDescriptor(file, null, string4, string2, project.getLookup(), bl, outputRecognizerArray);
        executionDescriptor.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
        executionDescriptor.frontWindow(true);
        new RubyExecution(executionDescriptor, string3).run();
        return true;
    }

    public void performAction() {
        if (USE_JRUBY_CONSOLE) {
            IrbTopComponent irbTopComponent = IrbTopComponent.findInstance();
            irbTopComponent.open();
            irbTopComponent.requestActive();
            return;
        }
        RubyBaseProject rubyBaseProject = Util.inferRubyProject();
        if (rubyBaseProject != null) {
            this.runIrbConsole(rubyBaseProject);
        } else {
            org.netbeans.modules.ruby.platform.Util.notifyLocalized(IrbAction.class, (String)"IrbAction.not.project.in.context", (Object[])new Object[0]);
        }
    }

    public String getName() {
        return NbBundle.getMessage(IrbAction.class, (String)"CTL_IrbAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

