/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSURILocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSDebuggerBaseImpl;

public class JSCallStackFrameImpl
extends JSDebuggerBaseImpl
implements JSCallStackFrame {
    private int depth;
    private JSCallStackFrame.TYPE type;
    private JSLocation location;
    private String functionName;
    private Map<String, Object> evaledExpressions = new HashMap<String, Object>();

    JSCallStackFrameImpl(JSDebugger jSDebugger, int n, JSCallStackFrame.TYPE tYPE, String string, URI uRI, int n2) {
        this(jSDebugger, n, tYPE, string, uRI, n2, -1);
    }

    JSCallStackFrameImpl(JSDebugger jSDebugger, int n, JSCallStackFrame.TYPE tYPE, String string, URI uRI, int n2, int n3) {
        super(jSDebugger);
        this.depth = n;
        this.type = tYPE;
        this.location = new JSURILocation(uRI, n2, n3);
        this.functionName = string;
    }

    JSCallStackFrameImpl(JSDebugger jSDebugger, int n, JSCallStackFrame.TYPE tYPE, String string, String string2, int n2, int n3) {
        super(jSDebugger);
        this.depth = n;
        this.type = tYPE;
        this.location = new JSURILocation(string2, n2, n3);
        this.functionName = string;
    }

    public JSProperty getScope() throws IllegalStateException {
        return this.getJSDebugger().getScope(this);
    }

    public JSProperty getThis() throws IllegalStateException {
        return this.getJSDebugger().getThis(this);
    }

    public URI getURI() {
        return this.location.getURI();
    }

    public int getLineNumber() {
        return this.location.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    public JSProperty eval(String string) throws IllegalStateException {
        Object object = this.evaledExpressions.get(string);
        if (object == null) {
            object = this.getJSDebugger().eval(this, string);
            if (object == null) {
                this.evaledExpressions.put(string, Void.TYPE);
            } else {
                this.evaledExpressions.put(string, object);
            }
        }
        if (object instanceof JSProperty) {
            return (JSProperty)object;
        }
        return null;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getDisplayName() {
        return this.functionName;
    }

    public JSLocation getLocation() {
        return this.location;
    }

    public JSCallStackFrame.TYPE getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }
}

