/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.api;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSURILocation
implements JSLocation {
    private URI uri;
    private int lineNumber;
    private int columnNumber;
    private Set<URI> extraURIs;

    public JSURILocation(URI uRI, int n) {
        this(uRI, n, -1);
    }

    public JSURILocation(URI uRI, int n, int n2) {
        this.uri = uRI;
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public JSURILocation(URL uRL, int n) {
        this(URI.create(uRL.getPath()), n);
    }

    public JSURILocation(String string, int n, int n2) {
        try {
            String string2 = "file://";
            if (string.indexOf(string2) != -1 && string.indexOf("\\") != -1) {
                string = string.substring(string2.length());
                string = string.replace("\\", "/");
                this.uri = new File(string).toURI();
            }
            if (this.uri == null) {
                this.uri = new URI(string);
            }
            assert (this.uri.isAbsolute());
            this.lineNumber = n;
            this.columnNumber = n2;
        }
        catch (URISyntaxException uRISyntaxException) {
            if (string.contains("%u")) {
                string = JSURILocation.decodeUnicode16Escapes(string);
                try {
                    this.uri = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    Log.getLogger().log(Level.SEVERE, "URI syntax exception", uRISyntaxException2);
                }
            }
            Log.getLogger().log(Level.SEVERE, "URI syntax exception", uRISyntaxException);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public JSLocation getJSLocation() {
        return this;
    }

    public String getDisplayName() {
        return this.getURI().toString() + ":" + this.getLineNumber();
    }

    public Set<URI> getEquivalentURIs() {
        return this.extraURIs;
    }

    public void addEquivalentURI(URI uRI) {
        if (this.extraURIs == null) {
            this.extraURIs = new LinkedHashSet<URI>();
        }
        this.extraURIs.add(uRI);
    }

    public void removeEquivalentURI(URI uRI) {
        if (this.extraURIs != null) {
            this.extraURIs.remove(uRI);
        }
    }

    private static String decodeUnicode16Escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() - 6; ++i) {
            String string2 = string.substring(i, i + 6);
            if (string2.startsWith("%u")) {
                String string3 = string2.substring(2, 4);
                String string4 = string2.substring(4, 6);
                try {
                    byte[] byArray = new byte[]{Byte.parseByte(string3, 16), Byte.parseByte(string4, 16)};
                    String string5 = new String(byArray, "UTF-16");
                    stringBuilder.append(string5);
                    i += 5;
                }
                catch (Exception exception) {
                    stringBuilder.append(string.charAt(i));
                }
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }
}

