/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;

public class Source {

    public static class SourceResponse
    extends ResponseMessage {
        SourceResponse(Node node) {
            super(node);
        }

        public boolean isSusccess() {
            return SourceResponse.getBoolean(this.getNode(), "success");
        }

        public Message.Encoding getEncoding() {
            String string = SourceResponse.getAttribute(this.getNode(), "encoding");
            return string != null ? Message.Encoding.valueOf(string.toUpperCase()) : null;
        }

        public byte[] getSourceCode(boolean bl) {
            String string = bl ? SourceResponse.getSourceText(this.getNode()) : SourceResponse.getNodeValue(this.getNode());
            return Message.getDecodedBytes(this.getEncoding(), string);
        }

        private static String getSourceText(Node node) {
            StringBuilder stringBuilder = SourceResponse.getNodeValueImpl(node);
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(0, 1);
            }
            return SourceResponse.replaceHtmlEntities(stringBuilder.toString());
        }
    }

    public static class SourceCommand
    extends Command {
        private static final String BEGIN_ARG = "-b ";
        private static final String END_ARG = "-e ";
        private String fileUri;
        private int begin;
        private int end;

        public SourceCommand(int n, String string) {
            super(CommandMap.SOURCE.getCommand(), n);
            this.fileUri = string;
            this.begin = -1;
            this.end = -1;
        }

        public void setFile(String string) {
            this.fileUri = string;
        }

        public void setBeginLine(int n) {
            this.begin = n;
        }

        public void setEndLine(int n) {
            this.end = n;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder("-f ");
            stringBuilder.append(this.fileUri);
            if (this.begin != -1) {
                stringBuilder.append(" ");
                stringBuilder.append(BEGIN_ARG);
                stringBuilder.append(this.begin);
            }
            if (this.end != -1) {
                stringBuilder.append(" ");
                stringBuilder.append(END_ARG);
                stringBuilder.append(this.end);
            }
            return stringBuilder.toString();
        }
    }
}

