/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.ApplyAllCaseFoldFunction;
import org.joni.ApplyCaseFoldArg;
import org.joni.BitSet;
import org.joni.ScanEnvironment;
import org.joni.ast.CClassNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.StringNode;
import org.joni.encoding.Encoding;

final class ApplyCaseFold
implements ApplyAllCaseFoldFunction {
    static final ApplyCaseFold INSTANCE = new ApplyCaseFold();

    ApplyCaseFold() {
    }

    public void apply(int from, int[] to, int length, Object o) {
        ApplyCaseFoldArg arg = (ApplyCaseFoldArg)o;
        ScanEnvironment env = arg.env;
        Encoding enc = env.enc;
        CClassNode cc = arg.cc;
        BitSet bs = cc.bs;
        if (length == 1) {
            boolean inCC = cc.isCodeInCC(enc, from);
            if (inCC && !cc.isNot() || !inCC && cc.isNot()) {
                if (enc.minLength() > 1 || to[0] >= 256) {
                    cc.addCodeRange(env, to[0], to[0]);
                } else {
                    bs.set(to[0]);
                }
            }
        } else if (cc.isCodeInCC(enc, from) && !cc.isNot()) {
            StringNode node = null;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    node = new StringNode();
                    node.ensure(7);
                    node.end += enc.codeToMbc(to[i], node.bytes, node.end);
                    node.setAmbig();
                    continue;
                }
                node.ensure(7);
                node.end += enc.codeToMbc(to[i], node.bytes, node.end);
            }
            ConsAltNode alt = ConsAltNode.newAltNode(node, null);
            if (arg.tail == null) {
                arg.altRoot = alt;
            } else {
                arg.tail.setCdr(alt);
            }
            arg.tail = alt;
        }
    }
}

