/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.checkout.CheckoutCompleted;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutAction
extends CallableSystemAction {
    public void performAction() {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        CheckoutWizard checkoutWizard = new CheckoutWizard();
        if (!checkoutWizard.show()) {
            return;
        }
        final SVNUrl sVNUrl = checkoutWizard.getRepositoryRoot();
        final RepositoryFile[] repositoryFileArray = checkoutWizard.getRepositoryFiles();
        final File file = checkoutWizard.getWorkdir();
        final boolean bl = checkoutWizard.isAtWorkingDirLevel();
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                SvnClient svnClient;
                try {
                    svnClient = Subversion.getInstance().getClient(sVNUrl);
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                    return;
                }
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    CheckoutAction.checkout(svnClient, sVNUrl, repositoryFileArray, file, bl, this);
                }
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                    return;
                }
                finally {
                    Subversion.getInstance().versionedFilesChanged();
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (SvnModuleConfig.getDefault().getShowCheckoutCompleted()) {
                    String[] stringArray;
                    if (bl) {
                        stringArray = new String[]{"."};
                    } else {
                        stringArray = new String[repositoryFileArray.length];
                        for (int i = 0; i < repositoryFileArray.length; ++i) {
                            if (this.isCanceled()) {
                                return;
                            }
                            stringArray[i] = repositoryFileArray[i].isRepositoryRoot() ? "." : repositoryFileArray[i].getFileUrl().getLastPathSegment();
                        }
                    }
                    CheckoutCompleted checkoutCompleted = new CheckoutCompleted(file, stringArray, true);
                    if (this.isCanceled()) {
                        return;
                    }
                    checkoutCompleted.scanForProjects(this);
                }
            }
        };
        svnProgressSupport.start(Subversion.getInstance().getRequestProcessor(sVNUrl), sVNUrl, ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public String getName() {
        return NbBundle.getMessage(CheckoutAction.class, (String)"CTL_CheckoutAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static void checkout(SvnClient svnClient, SVNUrl sVNUrl, RepositoryFile[] repositoryFileArray, File file, boolean bl, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        for (int i = 0; i < repositoryFileArray.length; ++i) {
            File file2;
            if (!bl) {
                file2 = new File(file.getAbsolutePath() + "/" + repositoryFileArray[i].getName());
                file2 = FileUtil.normalizeFile((File)file2);
                file2.mkdir();
            } else {
                file2 = file;
            }
            if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
                return;
            }
            svnClient.checkout(repositoryFileArray[i].getFileUrl(), file2, repositoryFileArray[i].getRevision(), true);
            if (svnProgressSupport == null || !svnProgressSupport.isCanceled()) continue;
            return;
        }
    }
}

