/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CopyCommand
extends SvnCommand {
    private final CopyType type;
    private SVNUrl fromUrl;
    private SVNUrl toUrl;
    private File fromFile;
    private File toFile;
    private String msg;
    private SVNRevision rev;

    public CopyCommand(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) {
        this.fromUrl = sVNUrl;
        this.toUrl = sVNUrl2;
        this.msg = string;
        this.rev = sVNRevision;
        this.type = CopyType.url2url;
    }

    public CopyCommand(SVNUrl sVNUrl, File file, SVNRevision sVNRevision) {
        this.fromUrl = sVNUrl;
        this.toFile = file;
        this.rev = sVNRevision;
        this.type = CopyType.url2file;
    }

    public CopyCommand(File file, SVNUrl sVNUrl, String string) {
        this.fromFile = file;
        this.toUrl = sVNUrl;
        this.msg = string;
        this.type = CopyType.file2url;
    }

    protected int getCommand() {
        return 6;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("copy");
        switch (this.type) {
            case url2url: {
                arguments.add(this.fromUrl);
                arguments.add(this.toUrl);
                if (this.rev == null) break;
                arguments.add(this.rev);
                break;
            }
            case url2file: {
                arguments.add(this.fromUrl);
                arguments.add(this.toFile);
                if (this.rev != null) {
                    arguments.add(this.rev);
                }
                this.setCommandWorkingDirectory(this.toFile);
                break;
            }
            case file2url: {
                arguments.add(this.fromFile);
                arguments.add(this.toUrl);
                this.setCommandWorkingDirectory(this.fromFile);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal copytype: " + (Object)((Object)this.type));
            }
        }
        arguments.addMessage(this.msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CopyType {
        url2url,
        url2file,
        file2url,
        file2file;

    }
}

