/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File file, String string) throws IOException {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return null;
        }
        if ("BASE".equals(string)) {
            try {
                File file2 = this.getMetadataDir(file.getParentFile());
                if (file2 == null) {
                    return null;
                }
                File file3 = new File(file2, "text-base/" + file.getName() + ".svn-base");
                if (!file3.exists()) {
                    return null;
                }
                File file4 = new File(file2, "text-base/" + file.getName() + ".netbeans-base");
                if (file4.canRead() && file3.isFile() && file4.lastModified() >= file3.lastModified()) {
                    return file4;
                }
                SvnClient svnClient = Subversion.getInstance().getClient(file);
                InputStream inputStream = svnClient.getContent(file, SVNRevision.BASE);
                file4 = FileUtil.normalizeFile((File)file4);
                file4.deleteOnExit();
                FileUtils.copyStreamToFile(new BufferedInputStream(inputStream), file4);
                file4.setLastModified(file3.lastModified());
                return file4;
            }
            catch (SVNClientException sVNClientException) {
                IOException iOException = new IOException();
                iOException.initCause(sVNClientException);
                throw iOException;
            }
        }
        if ("PRISTINE".equals(string)) {
            String string2 = file.getName();
            File file5 = this.getMetadataDir(file.getParentFile());
            if (file5 != null) {
                File file6 = new File(file5, "text-base");
                File file7 = new File(file6, string2 + ".svn-base");
                if (file7.isFile()) {
                    return file7;
                }
                return null;
            }
            return null;
        }
        if ("LOCAL".equals(string)) {
            return file;
        }
        SVNRevision sVNRevision = SvnUtils.toSvnRevision(string);
        try {
            Object object;
            InputStream inputStream;
            SvnClient svnClient = Subversion.getInstance().getClient(file);
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            try {
                if ((fileStatusCache.getStatus(file).getStatus() & 0x1DF8) != 0) {
                    inputStream = svnClient.getContent(file, sVNRevision);
                } else {
                    object = SvnUtils.getRepositoryUrl(file);
                    if (object != null) {
                        if (SvnClientFactory.isCLI()) {
                            object = object.appendPath("@" + string);
                            inputStream = svnClient.getContent((SVNUrl)object, sVNRevision);
                        } else {
                            inputStream = svnClient.getContent((SVNUrl)object, sVNRevision, sVNRevision);
                        }
                    } else {
                        inputStream = new ByteArrayInputStream(NbBundle.getMessage(VersionsCache.class, (String)"MSG_UnknownURL").getBytes());
                    }
                }
            }
            catch (SVNClientException sVNClientException) {
                if (SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage())) {
                    inputStream = new ByteArrayInputStream(new byte[0]);
                }
                throw sVNClientException;
            }
            object = File.createTempFile("nb-svn", file.getName());
            object = FileUtil.normalizeFile((File)object);
            ((File)object).deleteOnExit();
            FileUtils.copyStreamToFile(new BufferedInputStream(inputStream), (File)object);
            return object;
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Can not load: " + file.getAbsolutePath() + " in revision: " + string);
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    private File getMetadataDir(File file) {
        File file2 = new File(file, SvnUtils.SVN_ADMIN_DIR);
        if (!file2.isDirectory()) {
            return null;
        }
        return file2;
    }
}

