/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.WsdlNamespaceHandler;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class WSUtils {
    private static String SUN_DOMAIN_12_DTD_SUFFIX = "lib" + File.separator + "dtds" + File.separator + "sun-domain_1_2.dtd";
    private static String SUN_DOMAIN_13_DTD_SUFFIX = "lib" + File.separator + "dtds" + File.separator + "sun-domain_1_3.dtd";
    private static final String ENDORSED_DIR_PROPERTY = "jaxws.endorsed.dir";
    private static final String JAX_WS_XML_PATH = "nbproject/jax-ws.xml";
    private static final String DEFAULT_PACKAGE_NAME = "org.netbeans.ws";

    public static FileObject retrieveResource(FileObject fileObject, URI uRI) throws UnknownHostException, URISyntaxException, IOException {
        try {
            Map map;
            Retriever retriever = Retriever.getDefault();
            FileObject fileObject2 = retriever.retrieveResource(fileObject, uRI);
            if (fileObject2 == null && (map = retriever.getRetrievedResourceExceptionMap()) != null) {
                Set set = map.keySet();
                for (RetrieveEntry retrieveEntry : set) {
                    Object v = map.get(retrieveEntry);
                    if (v instanceof IOException) {
                        throw (IOException)v;
                    }
                    if (v instanceof URISyntaxException) {
                        throw (URISyntaxException)v;
                    }
                    if (!(v instanceof Exception)) continue;
                    IOException iOException = new IOException(NbBundle.getMessage(WSUtils.class, (String)"ERR_retrieveResource", (Object)retrieveEntry.getCurrentAddress()));
                    iOException.initCause((Exception)v);
                    throw iOException;
                }
            }
            return fileObject2;
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new IOException(runtimeException.getLocalizedMessage()).initCause(runtimeException);
        }
    }

    public static String findProperServiceName(String string, JaxWsModel jaxWsModel) {
        if (jaxWsModel.findServiceByName(string) == null) {
            return string;
        }
        int n = 1;
        String string2;
        while (jaxWsModel.findServiceByName(string2 = string + "_" + n) != null) {
            ++n;
        }
        return string2;
    }

    public static void retrieveJaxWsFromResource(FileObject fileObject) throws IOException {
        final String string = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
        final FileObject fileObject2 = fileObject.getFileObject("nbproject");
        assert (fileObject2 != null) : "Cannot find nbproject directory";
        FileSystem fileSystem = fileObject2.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject = FileUtil.createData((FileObject)fileObject2, (String)"jax-ws.xml");
                FileLock fileLock = fileObject.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                    bufferedWriter.write(string);
                    bufferedWriter.close();
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        });
    }

    public static void retrieveHandlerConfigFromResource(final FileObject fileObject, final String string) throws IOException {
        final String string2 = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/handler.xml"));
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
                FileLock fileLock = fileObject2.lock();
                BufferedWriter bufferedWriter = null;
                OutputStream outputStream = null;
                try {
                    outputStream = fileObject2.getOutputStream(fileLock);
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                }
                finally {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        });
    }

    public static String getJAXWSVersion(File file) {
        if (file == null) {
            return "jaxws20";
        }
        File file2 = new File(file, SUN_DOMAIN_12_DTD_SUFFIX);
        File file3 = new File(file, SUN_DOMAIN_13_DTD_SUFFIX);
        if (file2.exists() && !file3.exists()) {
            return "jaxws20";
        }
        return "jaxws21";
    }

    public static void generateSunJaxwsFile(final FileObject fileObject) throws IOException {
        final String string = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/sun-jaxws.xml"));
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"sun-jaxws.xml");
                FileLock fileLock = fileObject2.lock();
                BufferedWriter bufferedWriter = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    outputStream = fileObject2.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream);
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    bufferedWriter.write(string);
                }
                finally {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        });
    }

    private static String readResource(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void removeImplClass(Project project, String string) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String string2 = string.replace('.', '/') + ".java";
        if (sources != null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                FileObject fileObject = sourceGroupArray[i].getRootFolder();
                final FileObject fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 == null) continue;
                try {
                    FileSystem fileSystem = fileObject2.getFileSystem();
                    fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() {
                            WSUtils.deleteFile(fileObject2);
                        }
                    });
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFile(FileObject fileObject) {
        FileLock fileLock = null;
        try {
            SaveCookie saveCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
            fileLock = fileObject.lock();
            fileObject.delete(fileLock);
        }
        catch (IOException iOException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"MSG_Unable_Delete_File", (Object)fileObject.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static void copyFiles(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isFolder()) {
                FileObject fileObject3 = fileObject2.createFolder(fileObjectArray[i].getNameExt());
                WSUtils.copyFiles(fileObjectArray[i], fileObject3);
                continue;
            }
            fileObjectArray[i].copy(fileObject2, fileObjectArray[i].getName(), fileObjectArray[i].getExt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject backupAndGenerateJaxWs(FileObject fileObject, FileObject fileObject2, RuntimeException runtimeException) throws IOException {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"ERR_corruptedJaxWs", (Object)fileObject2.getPath(), (Object)runtimeException.getMessage()), 0));
        FileObject fileObject3 = fileObject2.getParent();
        FileObject fileObject4 = fileObject3.getFileObject("jax-ws.xml.old");
        FileLock fileLock = null;
        if (fileObject4 != null) {
            try {
                fileLock = fileObject4.lock();
                fileObject4.delete(fileLock);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
        try {
            fileLock = fileObject2.lock();
            fileObject2.rename(fileLock, "jax-ws.xml", "old");
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        WSUtils.retrieveJaxWsFromResource(fileObject);
        return fileObject.getFileObject(JAX_WS_XML_PATH);
    }

    public static boolean setJaxWsEndorsedDirProperty(EditableProperties editableProperties) {
        String string = editableProperties.getProperty(ENDORSED_DIR_PROPERTY);
        String string2 = System.getProperty("java.specification.version");
        boolean bl = false;
        if ("1.6".equals(string2)) {
            String string3 = WSUtils.getJaxWsApiDir();
            if (string3 != null && !string3.equals(string)) {
                editableProperties.setProperty(ENDORSED_DIR_PROPERTY, string3);
                bl = true;
            }
        } else if (string != null) {
            editableProperties.remove((Object)ENDORSED_DIR_PROPERTY);
            bl = true;
        }
        return bl;
    }

    private static String getJaxWsApiDir() {
        File file = InstalledFileLocator.getDefault().locate("modules/ext/jaxws21/api/jaxws-api.jar", null, false);
        if (file != null) {
            File file2 = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
            return file.getParent() + (file2 != null ? ":" + file2.getParent() : "");
        }
        return null;
    }

    public static FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject(JAX_WS_XML_PATH);
    }

    public static FileObject createJaxWsFileObject(final Project project) throws IOException {
        try {
            return (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                public FileObject run() throws IOException {
                    JaxWsModel jaxWsModel;
                    WSUtils.retrieveJaxWsFromResource(project.getProjectDirectory());
                    FileObject fileObject = WSUtils.findJaxWsFileObject(project);
                    assert (fileObject != null) : "Cannot find jax-ws.xml in project's nbproject directory";
                    if (fileObject != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                        jaxWsModel.setJaxWsFile(fileObject);
                    }
                    return fileObject;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static EditableProperties getEditableProperties(final Project project, final String string) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject fileObject = project.getProjectDirectory().getFileObject(string);
                    EditableProperties editableProperties = null;
                    if (fileObject != null) {
                        InputStream inputStream = null;
                        editableProperties = new EditableProperties();
                        try {
                            inputStream = fileObject.getInputStream();
                            editableProperties.load(inputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    return editableProperties;
                }
            });
        }
        catch (MutexException mutexException) {
            return null;
        }
    }

    public static void storeEditableProperties(final Project project, final String string, final EditableProperties editableProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    FileObject fileObject = project.getProjectDirectory().getFileObject(string);
                    if (fileObject != null) {
                        OutputStream outputStream = null;
                        try {
                            outputStream = fileObject.getOutputStream();
                            editableProperties.store(outputStream);
                        }
                        finally {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static String getPackageNameFromNamespace(String string) {
        String string2 = string;
        int n = string.indexOf("//");
        if (n >= 0) {
            string2 = string.substring(n + 2);
        } else {
            int n2 = string.indexOf(":");
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        if (stringTokenizer.countTokens() > 0) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).length() < 0) continue;
                arrayList2.add((String)object);
            }
            if (arrayList2.size() > 0) {
                int n3;
                object = new StringTokenizer((String)arrayList2.get(0), ".");
                int n4 = ((StringTokenizer)object).countTokens();
                if (n4 > 0) {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList3.add(((StringTokenizer)object).nextToken());
                    }
                    for (n3 = n4 - 1; n3 >= 0; --n3) {
                        String string3 = (String)arrayList3.get(n3);
                        if (n3 <= 0 && "www".equals(string3)) continue;
                        arrayList.add(((String)arrayList3.get(n3)).toLowerCase());
                    }
                } else {
                    return DEFAULT_PACKAGE_NAME;
                }
                for (int i = 1; i < arrayList2.size(); ++i) {
                    arrayList.add(((String)arrayList2.get(i)).toLowerCase());
                }
                StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(0));
                for (n3 = 1; n3 < arrayList.size(); ++n3) {
                    stringBuffer.append("." + (String)arrayList.get(n3));
                }
                return stringBuffer.toString();
            }
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public static String getPackageNameForWsdl(File file) {
        WsdlNamespaceHandler wsdlNamespaceHandler;
        block5: {
            wsdlNamespaceHandler = new WsdlNamespaceHandler();
            try {
                wsdlNamespaceHandler.parse(file);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().log(parserConfigurationException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
            catch (SAXException sAXException) {
                if ("sax_parser_finished_correctly".equals(sAXException.getMessage())) break block5;
                ErrorManager.getDefault().log(sAXException.getLocalizedMessage());
            }
        }
        String string = wsdlNamespaceHandler.getTargetNamespace();
        if (string != null) {
            return WSUtils.getPackageNameFromNamespace(string);
        }
        return null;
    }
}

