/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.netbeans.nbbuild.ModuleSelector;
import org.netbeans.nbbuild.XMLUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeJNLP
extends Task {
    private FileSet files;
    private SignJar signTask;
    private File targetFile;
    private String codebase = "$$codebase";
    private boolean verify;
    private String verifyExcludes;
    private String permissions = "<all-permissions/>";
    private FileSet indirectJars;
    private boolean signJars = true;
    private static final Pattern SF = Pattern.compile("META-INF/(.+)\\.SF");

    public FileSet createModules() throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be created just once");
        }
        this.files = new FileSet();
        return this.files;
    }

    private SignJar getSignTask() {
        if (this.signTask == null) {
            this.signTask = (SignJar)this.getProject().createTask("signjar");
        }
        return this.signTask;
    }

    public void setDir(File t) {
        this.targetFile = t;
    }

    public void setAlias(String a) {
        this.getSignTask().setAlias(a);
    }

    public void setStorePass(String p) {
        this.getSignTask().setStorepass(p);
    }

    public void setKeystore(String k) {
        this.getSignTask().setKeystore(k);
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setVerify(boolean v) {
        this.verify = v;
    }

    public void setVerifyExcludes(String s) {
        this.verifyExcludes = s;
    }

    public void setPermissions(String s) {
        this.permissions = s;
    }

    public void addIndirectJars(FileSet fs) {
        this.indirectJars = fs;
    }

    public void setSignJars(boolean s) {
        this.signJars = s;
    }

    private void signOrCopy(File from, File to) {
        if (!from.exists() && from.getParentFile().getName().equals("locale")) {
            this.log("Localization file " + from + " is referenced, but cannot be found. Skipping.", 1);
            return;
        }
        if (this.signJars) {
            this.getSignTask().setJar(from);
            if (to != null) {
                to.getParentFile().mkdirs();
            }
            this.getSignTask().setSignedjar(to);
            this.getSignTask().execute();
        } else if (to != null) {
            Copy copy = (Copy)this.getProject().createTask("copy");
            copy.setFile(from);
            copy.setTofile(to);
            copy.execute();
        }
    }

    public void execute() throws BuildException {
        if (this.targetFile == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        DirectoryScanner scan;
        Set<String> indirectJarPaths = Collections.emptySet();
        if (this.indirectJars != null) {
            scan = this.indirectJars.getDirectoryScanner(this.getProject());
            indirectJarPaths = new HashSet();
            for (String f : scan.getIncludedFiles()) {
                indirectJarPaths.add(f.replace(File.pathSeparatorChar, '/'));
            }
        }
        scan = this.files.getDirectoryScanner(this.getProject());
        for (String f : scan.getIncludedFiles()) {
            File jar = new File(this.files.getDir(this.getProject()), f);
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            String codenamebase = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module");
            if (codenamebase == null) {
                throw new BuildException("Not a NetBeans Module: " + jar);
            }
            int slash = codenamebase.indexOf(47);
            if (slash >= 0) {
                codenamebase = codenamebase.substring(0, slash);
            }
            String dashcnb = codenamebase.replace('.', '-');
            String osDep = null;
            String bundle = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
            Properties prop = new Properties();
            if (bundle != null) {
                ZipEntry en = theJar.getEntry(bundle);
                if (en == null) {
                    throw new BuildException("Cannot find entry: " + bundle + " in file: " + jar);
                }
                InputStream is = theJar.getInputStream(en);
                prop.load(is);
                is.close();
            }
            String title = prop.getProperty("OpenIDE-Module-Name", codenamebase);
            String oneline = prop.getProperty("OpenIDE-Module-Short-Description", title);
            String shrt = prop.getProperty("OpenIDE-Module-Long-Description", oneline);
            String osMan = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Requires");
            if (osMan != null && osMan.indexOf("org.openide.modules.os.MacOSX") >= 0) {
                osDep = "Mac OS X";
            }
            Map<String, List<File>> localizedFiles = this.verifyExtensions(jar, theJar.getManifest(), dashcnb, codenamebase, this.verify, indirectJarPaths);
            new File(this.targetFile, dashcnb).mkdir();
            File signed = new File(new File(this.targetFile, dashcnb), jar.getName());
            File jnlp = new File(this.targetFile, dashcnb + ".jnlp");
            StringWriter writeJNLP = new StringWriter();
            writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Discriptor 1.5//EN\" \"http://java.sun.com/dtd/JNLP-1.5.dtd\">\n");
            writeJNLP.write("<jnlp spec='1.0+' codebase='" + this.codebase + "'>\n");
            writeJNLP.write("  <information>\n");
            writeJNLP.write("   <title>" + XMLUtil.toElementContent(title) + "</title>\n");
            writeJNLP.write("   <vendor>NetBeans</vendor>\n");
            writeJNLP.write("   <description kind='one-line'>" + XMLUtil.toElementContent(oneline) + "</description>\n");
            writeJNLP.write("   <description kind='short'>" + XMLUtil.toElementContent(shrt) + "</description>\n");
            writeJNLP.write("  </information>\n");
            writeJNLP.write(this.permissions + "\n");
            if (osDep == null) {
                writeJNLP.write("  <resources>\n");
            } else {
                writeJNLP.write("  <resources os='" + osDep + "'>\n");
            }
            writeJNLP.write("     <jar href='" + dashcnb + '/' + jar.getName() + "'/>\n");
            this.processExtensions(jar, theJar.getManifest(), writeJNLP, dashcnb, this.codebase);
            this.processIndirectJars(writeJNLP, dashcnb, this.codebase);
            writeJNLP.write("  </resources>\n");
            for (Map.Entry<String, List<File>> e : localizedFiles.entrySet()) {
                String locale = e.getKey();
                List<File> allFiles = e.getValue();
                writeJNLP.write("  <resources locale='" + locale + "'>\n");
                for (File n : allFiles) {
                    this.log("generating locale " + locale + " for " + n, 3);
                    String name = n.getName();
                    String clusterRootPrefix = jar.getParent() + File.separatorChar;
                    String absname = n.getAbsolutePath();
                    if (absname.startsWith(clusterRootPrefix)) {
                        name = absname.substring(clusterRootPrefix.length()).replace(File.separatorChar, '-');
                    }
                    File t = new File(new File(this.targetFile, dashcnb), name);
                    this.signOrCopy(n, t);
                    writeJNLP.write("    <jar href='" + dashcnb + '/' + name + "'/>\n");
                }
                writeJNLP.write("  </resources>\n");
            }
            writeJNLP.write("  <component-desc/>\n");
            writeJNLP.write("</jnlp>\n");
            writeJNLP.close();
            FileWriter w = new FileWriter(jnlp);
            w.write(writeJNLP.toString());
            w.close();
            this.signOrCopy(jar, signed);
            theJar.close();
        }
    }

    private Map<String, List<File>> verifyExtensions(File f, Manifest mf, String dashcnb, String codebasename, boolean verify, Set<String> indirectJarPaths) throws IOException, BuildException {
        StringTokenizer tok;
        File updateTracking;
        HashMap<String, List<File>> localizedFiles = new HashMap<String, List<File>>();
        File clusterRoot = f.getParentFile();
        String moduleDirPrefix = "";
        while (!(updateTracking = new File(clusterRoot, "update_tracking")).isDirectory()) {
            moduleDirPrefix = clusterRoot.getName() + "/" + moduleDirPrefix;
            if ((clusterRoot = clusterRoot.getParentFile()) != null && clusterRoot.exists()) continue;
            if (!verify) {
                return localizedFiles;
            }
            throw new BuildException("Cannot find update_tracking directory for module " + f);
        }
        File ut = new File(updateTracking, dashcnb + ".xml");
        if (!ut.exists()) {
            throw new BuildException("The file " + ut + " for module " + codebasename + " cannot be found");
        }
        HashMap<String, String> fileToOwningModule = new HashMap<String, String>();
        try {
            ModuleSelector.readUpdateTracking(this.getProject(), ut.toString(), fileToOwningModule);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        this.log("project files: " + fileToOwningModule, 4);
        String name = MakeJNLP.relative(f, clusterRoot);
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/Modules/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/ModuleAutoDeps/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "update_tracking/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        String path = mf.getMainAttributes().getValue("Class-Path");
        if (path != null) {
            tok = new StringTokenizer(path, ", ");
            while (tok.hasMoreElements()) {
                String s = tok.nextToken();
                File e = new File(f.getParentFile(), s);
                String r = MakeJNLP.relative(e, clusterRoot);
                MakeJNLP.removeWithLocales(fileToOwningModule, r, clusterRoot, localizedFiles);
            }
        }
        fileToOwningModule.remove("ant/nblib/" + dashcnb + ".jar");
        fileToOwningModule.keySet().removeAll(indirectJarPaths);
        if (this.verifyExcludes != null) {
            tok = new StringTokenizer(this.verifyExcludes, ", ");
            while (tok.hasMoreElements()) {
                MakeJNLP.removeWithLocales(fileToOwningModule, tok.nextToken(), clusterRoot, localizedFiles);
            }
        }
        if (verify && !fileToOwningModule.isEmpty()) {
            throw new BuildException("Cannot build JNLP for module " + f + " as these files are in " + "module's NBM, but are not referenced from any path:\n" + fileToOwningModule.keySet());
        }
        return localizedFiles;
    }

    private static void removeWithLocales(Map<String, String> removeFrom, String removeWhat, File clusterRoot, Map<String, List<File>> recordLocales) {
        if (removeFrom.remove(removeWhat) != null && removeWhat.endsWith(".jar")) {
            int basedir = removeWhat.lastIndexOf(47);
            String base = basedir == -1 ? "" : removeWhat.substring(0, basedir);
            String name = removeWhat.substring(basedir + 1, removeWhat.length() - 4);
            Pattern p = Pattern.compile(base + "/locale/" + name + "(|_[a-zA-Z0-9_]+)\\.jar");
            Iterator<String> it = removeFrom.keySet().iterator();
            while (it.hasNext()) {
                String s = it.next();
                Matcher m = p.matcher(s);
                if (!m.matches()) continue;
                String locale = m.group(1).substring(1);
                List<File> l = recordLocales.get(locale);
                if (l == null) {
                    l = new ArrayList<File>();
                    recordLocales.put(locale, l);
                }
                l.add(new File(clusterRoot, s.replace('/', File.separatorChar)));
                it.remove();
            }
        }
    }

    private void processExtensions(File f, Manifest mf, Writer fileWriter, String dashcnb, String codebase) throws IOException, BuildException {
        String path;
        File nblibJar = new File(new File(new File(f.getParentFile().getParentFile(), "ant"), "nblib"), dashcnb + ".jar");
        if (nblibJar.isFile()) {
            File ext = new File(new File(this.targetFile, dashcnb), "ant-nblib-" + nblibJar.getName());
            fileWriter.write("    <jar href='" + dashcnb + '/' + ext.getName() + "'/>\n");
            this.signOrCopy(nblibJar, ext);
        }
        if ((path = mf.getMainAttributes().getValue("Class-Path")) == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(path, ", ");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            File e = new File(f.getParentFile(), s);
            if (!e.canRead()) {
                throw new BuildException("Cannot read extension " + e + " referenced from " + f);
            }
            String n = e.getName();
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
            if (MakeJNLP.isSigned(e) != null) {
                Copy copy = (Copy)this.getProject().createTask("copy");
                copy.setFile(e);
                File t = new File(new File(this.targetFile, dashcnb), s.replace('/', '-'));
                copy.setTofile(t);
                copy.execute();
                String extJnlpName = dashcnb + '-' + t.getName().replaceFirst("\\.jar$", "") + ".jnlp";
                File jnlp = new File(this.targetFile, extJnlpName);
                FileWriter writeJNLP = new FileWriter(jnlp);
                writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                writeJNLP.write("<!DOCTYPE jnlp PUBLIC \"-//Sun Microsystems, Inc//DTD JNLP Discriptor 1.5//EN\" \"http://java.sun.com/dtd/JNLP-1.5.dtd\">\n");
                writeJNLP.write("<jnlp spec='1.0+' codebase='" + codebase + "'>\n");
                writeJNLP.write("  <information>\n");
                writeJNLP.write("    <title>" + n + "</title>\n");
                writeJNLP.write("    <vendor>NetBeans</vendor>\n");
                writeJNLP.write("  </information>\n");
                writeJNLP.write(this.permissions + "\n");
                writeJNLP.write("  <resources>\n");
                writeJNLP.write("    <jar href='" + dashcnb + '/' + t.getName() + "'/>\n");
                writeJNLP.write("  </resources>\n");
                writeJNLP.write("  <component-desc/>\n");
                writeJNLP.write("</jnlp>\n");
                writeJNLP.close();
                fileWriter.write("    <extension name='" + e.getName().replaceFirst("\\.jar$", "") + "' href='" + extJnlpName + "'/>\n");
                continue;
            }
            File ext = new File(new File(this.targetFile, dashcnb), s.replace('/', '-'));
            fileWriter.write("    <jar href='" + dashcnb + '/' + ext.getName() + "'/>\n");
            this.signOrCopy(e, ext);
        }
    }

    private void processIndirectJars(Writer fileWriter, String dashcnb, String codebase) throws IOException, BuildException {
        if (this.indirectJars == null) {
            return;
        }
        DirectoryScanner scan = this.indirectJars.getDirectoryScanner(this.getProject());
        for (String f : scan.getIncludedFiles()) {
            File jar = new File(scan.getBasedir(), f);
            String rel = f.replace(File.separatorChar, '/');
            String sig = MakeJNLP.isSigned(jar);
            String rel2 = rel.endsWith(".jar") ? rel : rel.replaceFirst("(\\.zip)?$", ".jar");
            File ext = new File(new File(this.targetFile, dashcnb), rel2.replace('/', '-').replaceFirst("^modules-", ""));
            Zip jartask = (Zip)this.getProject().createTask("jar");
            jartask.setDestFile(ext);
            ZipFileSet zfs = new ZipFileSet();
            zfs.setSrc(jar);
            if (sig != null) {
                zfs.setExcludes("META-INF/" + sig + ".*");
            }
            jartask.addZipfileset(zfs);
            zfs = new ZipFileSet();
            File blank = File.createTempFile("empty", "");
            blank.deleteOnExit();
            zfs.setFile(blank);
            zfs.setFullpath("META-INF/clusterpath/" + rel);
            jartask.addZipfileset(zfs);
            jartask.execute();
            blank.delete();
            fileWriter.write("    <jar href='" + dashcnb + '/' + ext.getName() + "'/>\n");
            this.signOrCopy(ext, null);
        }
    }

    private static String relative(File file, File root) {
        String sroot;
        String sfile = file.toString().replace(File.separatorChar, '/');
        if (sfile.startsWith(sroot = (root.toString() + File.separator).replace(File.separatorChar, '/'))) {
            return sfile.substring(sroot.length());
        }
        return sfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String isSigned(File f) throws IOException {
        JarFile jar = new JarFile(f);
        try {
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                Matcher m = SF.matcher(en.nextElement().getName());
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            jar.close();
        }
    }
}

