/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.yaml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyRange;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubyStruct;
import org.jruby.nb.nb.RubyTime;
import org.jruby.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorImpl;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.SafeConstructorImpl;
import org.jvyamlb.Scanner;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.exceptions.ConstructorException;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;

public class JRubyConstructor
extends ConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private final Ruby runtime;

    public Constructor.YamlConstructor getYamlConstructor(Object object) {
        return (Constructor.YamlConstructor)yamlConstructors.get(object);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object object) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(object);
    }

    public Pattern getYamlMultiRegexp(Object object) {
        return (Pattern)yamlMultiRegexps.get(object);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String string, Constructor.YamlConstructor yamlConstructor) {
        yamlConstructors.put(string, yamlConstructor);
    }

    public static void addMultiConstructor(String string, Constructor.YamlMultiConstructor yamlMultiConstructor) {
        yamlMultiConstructors.put(string, yamlMultiConstructor);
        yamlMultiRegexps.put(string, Pattern.compile("^" + string));
    }

    public JRubyConstructor(IRubyObject iRubyObject, Composer composer) {
        this(iRubyObject.getRuntime(), composer);
    }

    public JRubyConstructor(Ruby ruby, Composer composer) {
        super(composer);
        this.runtime = ruby;
    }

    public Object constructRubyScalar(Node node) {
        if (node instanceof ScalarNode) {
            ByteList byteList = (ByteList)super.constructScalar(node);
            if (byteList.length() > 1 && byteList.charAt(0) == ':' && ((ScalarNode)node).getStyle() == '\u0000') {
                int n = byteList.get(1);
                int n2 = byteList.get(byteList.realSize - 1);
                if (n == 34 && n2 == 34 || n == 39 && n2 == 39) {
                    ScannerImpl scannerImpl = new ScannerImpl(byteList.makeShared(1, byteList.realSize - 1));
                    JRubyConstructor jRubyConstructor = new JRubyConstructor(this.runtime, (Composer)new ComposerImpl((Parser)new ParserImpl((Scanner)scannerImpl, YAML.config().version("1.0")), (Resolver)new ResolverImpl()));
                    jRubyConstructor.checkData();
                    return ((RubyString)jRubyConstructor.getData()).intern();
                }
                return this.runtime.newSymbol(new String(byteList.bytes, byteList.begin + 1, byteList.realSize - 1));
            }
            return RubyString.newString(this.runtime, (ByteList)super.constructScalar(node));
        }
        Map map = (Map)this.constructMapping(node);
        RubyString rubyString = (RubyString)map.get(this.runtime.newString("str"));
        HashMap hashMap = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith("@")) continue;
            hashMap.put(entry.getKey(), entry.getValue());
            iterator.remove();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            rubyString.instance_variable_set((IRubyObject)entry.getKey(), (IRubyObject)entry.getValue());
        }
        return rubyString;
    }

    public Object constructPrivateType(Node node) {
        Object object = null;
        object = node.getValue() instanceof Map ? this.constructRubyMapping(node) : (node.getValue() instanceof List ? this.constructRubySequence(node) : this.constructRubyScalar(node));
        return RuntimeHelpers.invoke(this.runtime.getCurrentContext(), this.runtime.fastGetModule("YAML").fastGetConstant("PrivateType"), "new", (IRubyObject)this.runtime.newString(node.getTag()), (IRubyObject)object);
    }

    public Object constructRubySequence(Node node) {
        final RubyArray rubyArray = this.runtime.newArray();
        List list = (List)super.constructSequence(node);
        this.doRecursionFix(node, rubyArray);
        int n = 0;
        for (Object e : list) {
            if (e instanceof LinkNode) {
                rubyArray.append(this.runtime.getNil());
                final RubyFixnum rubyFixnum = this.runtime.newFixnum(n);
                this.addFixer((Node)((LinkNode)e).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object object) {
                        rubyArray.aset(rubyFixnum, (IRubyObject)object);
                    }
                });
            } else {
                rubyArray.append((IRubyObject)e);
            }
            ++n;
        }
        return rubyArray;
    }

    public Object constructRubyMapping(Node node) {
        RubyHash rubyHash = RubyHash.newHash(this.runtime, (Map)super.constructMapping(node), this.runtime.getNil());
        return rubyHash;
    }

    public Object constructRubyPairs(Node node) {
        return this.runtime.newArray((List)super.constructPairs(node));
    }

    public static Object constructYamlNull(Constructor constructor, Node node) {
        return ((JRubyConstructor)constructor).runtime.getNil();
    }

    public static Object constructYamlBool(Constructor constructor, Node node) {
        return SafeConstructorImpl.constructYamlBool((Constructor)constructor, (Node)node) == Boolean.TRUE ? ((JRubyConstructor)constructor).runtime.getTrue() : ((JRubyConstructor)constructor).runtime.getFalse();
    }

    public static Object constructYamlOmap(Constructor constructor, Node node) {
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        RubyArray rubyArray = (RubyArray)ruby.fastGetModule("YAML").fastGetConstant("Omap").callMethod(ruby.getCurrentContext(), "new");
        List list = (List)constructor.constructSequence(node);
        constructor.doRecursionFix(node, (Object)rubyArray);
        for (IRubyObject iRubyObject : list) {
            if (iRubyObject instanceof RubyHash) {
                rubyArray.concat(((RubyHash)iRubyObject).to_a());
                continue;
            }
            throw new ConstructorException(null, "Invalid !omap entry: " + list, null);
        }
        return rubyArray;
    }

    public static Object constructYamlPairs(Constructor constructor, Node node) {
        return ((JRubyConstructor)constructor).constructRubyPairs(node);
    }

    public static Object constructYamlSet(Constructor constructor, Node node) {
        return SafeConstructorImpl.constructYamlSet((Constructor)constructor, (Node)node);
    }

    public static Object constructYamlStr(Constructor constructor, Node node) {
        Object object = ((JRubyConstructor)constructor).constructRubyScalar(node);
        if (object instanceof RubyString) {
            RubyString rubyString = (RubyString)object;
            return rubyString.getByteList().realSize == 0 && ((ScalarNode)node).getStyle() == '\u0000' ? rubyString.getRuntime().getNil() : rubyString;
        }
        return object;
    }

    public static Object constructYamlSeq(Constructor constructor, Node node) {
        return ((JRubyConstructor)constructor).constructRubySequence(node);
    }

    public static Object constructYamlMap(Constructor constructor, Node node) {
        return ((JRubyConstructor)constructor).constructRubyMapping(node);
    }

    public static Object constructUndefined(Constructor constructor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor constructor, Node node) {
        Object[] objectArray = (Object[])SafeConstructorImpl.constructYamlTimestamp((Constructor)constructor, (Node)node);
        DateTime dateTime = (DateTime)objectArray[0];
        RubyTime rubyTime = RubyTime.newTime(((JRubyConstructor)constructor).runtime, dateTime);
        rubyTime.setUSec(((Integer)objectArray[1]).intValue());
        return rubyTime;
    }

    public static Object constructYamlTimestampYMD(Constructor constructor, Node node) {
        DateTime dateTime = (DateTime)((Object[])SafeConstructorImpl.constructYamlTimestamp((Constructor)constructor, (Node)node))[0];
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        return RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)ruby.fastGetClass("Date"), "new", (IRubyObject)ruby.newFixnum(dateTime.getYear()), (IRubyObject)ruby.newFixnum(dateTime.getMonthOfYear()), ruby.newFixnum(dateTime.getDayOfMonth()));
    }

    public static Object constructYamlInt(Constructor constructor, Node node) {
        return JavaUtil.convertJavaToRuby(((JRubyConstructor)constructor).runtime, SafeConstructorImpl.constructYamlInt((Constructor)constructor, (Node)node));
    }

    public static Object constructYamlFloat(Constructor constructor, Node node) {
        return ((JRubyConstructor)constructor).runtime.newFloat((Double)SafeConstructorImpl.constructYamlFloat((Constructor)constructor, (Node)node));
    }

    public static Object constructYamlBinary(Constructor constructor, Node node) {
        Object object = SafeConstructorImpl.constructYamlBinary((Constructor)constructor, (Node)node);
        if (object instanceof byte[]) {
            return RubyString.newString(((JRubyConstructor)constructor).runtime, new ByteList((byte[])object, false));
        }
        return ((JRubyConstructor)constructor).runtime.newString((String)object);
    }

    public static Object constructJava(Constructor constructor, String string, Node node) {
        return SafeConstructorImpl.constructJava((Constructor)constructor, (String)string, (Node)node);
    }

    public static Object constructRubyException(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            try {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    object = (RubyModule)object.getConstant(stringArray[i]);
                }
            }
            catch (Exception exception) {
                object = (RubyClass)ruby.fastGetModule("YAML").fastGetConstant("Object");
                RubyHash rubyHash = (RubyHash)((JRubyConstructor)constructor).constructRubyMapping(node);
                return RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)object, "new", (IRubyObject)ruby.newString(string), rubyHash);
            }
        }
        stringArray = object;
        final RubyObject rubyObject = (RubyObject)stringArray.getAllocator().allocate(ruby, (RubyClass)stringArray);
        Map map = (Map)constructor.constructMapping(node);
        constructor.doRecursionFix(node, (Object)rubyObject);
        for (IRubyObject iRubyObject : map.keySet()) {
            Object v = map.get(iRubyObject);
            if (v instanceof LinkNode) {
                final String string2 = "@" + iRubyObject.toString();
                constructor.addFixer((Node)((LinkNode)v).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object object) {
                        rubyObject.setInstanceVariable(string2, (IRubyObject)object);
                    }
                });
                continue;
            }
            rubyObject.setInstanceVariable("@" + iRubyObject.toString(), (IRubyObject)v);
        }
        return rubyObject;
    }

    public static Object constructRubyStruct(Constructor constructor, String string, Node node) {
        RubyClass rubyClass;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        RubyModule rubyModule = ruby.fastGetModule("Struct");
        String[] stringArray = string.split("::");
        int n = stringArray.length;
        for (int n2 = 0; n2 < n && rubyModule != null; rubyModule = (RubyModule)rubyModule.getConstant(stringArray[n2]), ++n2) {
        }
        HashMap hashMap = new HashMap();
        Map map = (Map)constructor.constructMapping(node);
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            if (!entry.getKey().toString().startsWith("@")) continue;
            hashMap.put(entry.getKey(), entry.getValue());
            object.remove();
        }
        if (rubyModule == null) {
            object = new IRubyObject[map.size() + 1];
            object[0] = ruby.newString(string);
            int n3 = 1;
            for (Map.Entry entry : map.entrySet()) {
                object[n3] = ((RubyString)entry.getKey()).intern();
                ++n3;
            }
            rubyClass = RubyStruct.newInstance(ruby.fastGetModule("Struct"), (IRubyObject[])object, Block.NULL_BLOCK);
        } else {
            rubyClass = (RubyClass)rubyModule;
        }
        object = rubyClass.callMethod(ruby.getCurrentContext(), "new");
        RubyArray rubyArray = RubyStruct.members(rubyClass, Block.NULL_BLOCK);
        int n4 = rubyArray.size();
        for (int i = 0; i < n4; ++i) {
            IRubyObject iRubyObject = rubyArray.eltInternal(i);
            object.callMethod(ruby.getCurrentContext(), iRubyObject.toString() + "=", (IRubyObject)map.get(iRubyObject));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((RubyObject)object).instance_variable_set((IRubyObject)entry.getKey(), (IRubyObject)entry.getValue());
        }
        return object;
    }

    public static Object constructRuby(Constructor constructor, RubyClass rubyClass, Node node) {
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        if (rubyClass.respondsTo("yaml_new")) {
            RubyHash rubyHash = (RubyHash)((JRubyConstructor)constructor).constructRubyMapping(node);
            return RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)rubyClass, "yaml_new", (IRubyObject)rubyClass, (IRubyObject)ruby.newString(node.getTag()), rubyHash);
        }
        final RubyObject rubyObject = (RubyObject)rubyClass.getAllocator().allocate(ruby, rubyClass);
        if (rubyObject.respondsTo("yaml_initialize")) {
            RubyHash rubyHash = (RubyHash)((JRubyConstructor)constructor).constructRubyMapping(node);
            RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)rubyObject, "yaml_initialize", (IRubyObject)ruby.newString(node.getTag()), rubyHash);
        } else {
            Map map = (Map)constructor.constructMapping(node);
            constructor.doRecursionFix(node, (Object)rubyObject);
            for (IRubyObject iRubyObject : map.keySet()) {
                Object v = map.get(iRubyObject);
                if (v instanceof LinkNode) {
                    final String string = "@" + iRubyObject.toString();
                    constructor.addFixer((Node)((LinkNode)v).getValue(), new Constructor.RecursiveFixer(){

                        public void replace(Node node, Object object) {
                            rubyObject.setInstanceVariable(string, (IRubyObject)object);
                        }
                    });
                    continue;
                }
                rubyObject.setInstanceVariable("@" + iRubyObject.toString(), (IRubyObject)v);
            }
        }
        return rubyObject;
    }

    public static Object constructRuby(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            try {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    object = (RubyModule)object.getConstant(stringArray[i]);
                }
            }
            catch (Exception exception) {
                object = (RubyClass)ruby.fastGetModule("YAML").fastGetConstant("Object");
                RubyHash rubyHash = (RubyHash)((JRubyConstructor)constructor).constructRubyMapping(node);
                return RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)object, "new", (IRubyObject)ruby.newString(string), rubyHash);
            }
        }
        stringArray = object;
        return JRubyConstructor.constructRuby(constructor, (RubyClass)stringArray, node);
    }

    public static Object constructRubyRegexp(Constructor constructor, Node node) {
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        String string = constructor.constructScalar(node).toString();
        return ruby.evalScriptlet(string);
    }

    public static Object constructRubyRange(Constructor constructor, Node node) {
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        ThreadContext threadContext = ruby.getCurrentContext();
        if (node instanceof ScalarNode) {
            String string;
            String string2;
            String string3 = constructor.constructScalar(node).toString();
            boolean bl = false;
            int n = -1;
            n = string3.indexOf("...");
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 3);
                bl = true;
            } else {
                n = string3.indexOf("..");
                string2 = string3.substring(0, n);
                string = string3.substring(n + 2);
            }
            IRubyObject iRubyObject = ruby.fastGetModule("YAML").callMethod(threadContext, "load", ruby.newString(string2));
            IRubyObject iRubyObject2 = ruby.fastGetModule("YAML").callMethod(threadContext, "load", ruby.newString(string));
            return RubyRange.newRange(ruby, threadContext, iRubyObject, iRubyObject2, bl);
        }
        Map map = (Map)constructor.constructMapping(node);
        IRubyObject iRubyObject = (IRubyObject)map.get(ruby.newString("begin"));
        IRubyObject iRubyObject3 = (IRubyObject)map.get(ruby.newString("end"));
        boolean bl = ((IRubyObject)map.get(ruby.newString("excl"))).isTrue();
        return RubyRange.newRange(ruby, threadContext, iRubyObject, iRubyObject3, bl);
    }

    public static Object findAndCreateFromCustomTagging(Constructor constructor, Node node) {
        String string = node.getTag();
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        IRubyObject iRubyObject = ruby.fastGetModule("YAML").callMethod(ruby.getCurrentContext(), "tagged_classes").callMethod(ruby.getCurrentContext(), "[]", ruby.newString(string));
        if (!(iRubyObject instanceof RubyClass)) {
            return null;
        }
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if (rubyClass != null && !rubyClass.isNil()) {
            return JRubyConstructor.constructRuby(constructor, rubyClass, node);
        }
        return null;
    }

    public static Object constructRubyInt(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = (RubyModule)object.getConstant(stringArray[i]);
            }
        }
        stringArray = object;
        RubyObject rubyObject = (RubyObject)stringArray.getAllocator().allocate(ruby, (RubyClass)stringArray);
        IRubyObject iRubyObject = (IRubyObject)JRubyConstructor.constructYamlInt(constructor, node);
        rubyObject.callInit(new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
        return rubyObject;
    }

    public static Object constructRubyString(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = (RubyModule)object.getConstant(stringArray[i]);
            }
        }
        stringArray = object;
        RubyObject rubyObject = (RubyObject)stringArray.getAllocator().allocate(ruby, (RubyClass)stringArray);
        IRubyObject iRubyObject = (IRubyObject)JRubyConstructor.constructYamlStr(constructor, node);
        rubyObject.callInit(new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
        return rubyObject;
    }

    public static Object constructRubyMap(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = (RubyModule)object.getConstant(stringArray[i]);
            }
        }
        stringArray = object;
        RubyObject rubyObject = (RubyObject)stringArray.getAllocator().allocate(ruby, (RubyClass)stringArray);
        Map map = (Map)constructor.constructMapping(node);
        for (IRubyObject iRubyObject : map.keySet()) {
            RuntimeHelpers.invoke(rubyObject.getRuntime().getCurrentContext(), (IRubyObject)rubyObject, "[]=", iRubyObject, (IRubyObject)map.get(iRubyObject));
        }
        return rubyObject;
    }

    public static Object constructRubySequence(Constructor constructor, String string, Node node) {
        String[] stringArray;
        Ruby ruby = ((JRubyConstructor)constructor).runtime;
        Object object = ruby.getObject();
        if (string != null) {
            stringArray = string.split("::");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                object = (RubyModule)object.getConstant(stringArray[i]);
            }
        }
        stringArray = object;
        RubyObject rubyObject = (RubyObject)stringArray.getAllocator().allocate(ruby, (RubyClass)stringArray);
        List list = (List)constructor.constructSequence(node);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RuntimeHelpers.invoke(rubyObject.getRuntime().getCurrentContext(), (IRubyObject)rubyObject, "<<", (IRubyObject)iterator.next());
        }
        return rubyObject;
    }

    static {
        JRubyConstructor.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlNull(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlBool(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlOmap(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlPairs(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlSet(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlInt(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlFloat(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                Matcher matcher = SafeConstructorImpl.YMD_REGEXP.matcher(node.getValue().toString());
                if (matcher.matches()) {
                    return JRubyConstructor.constructYamlTimestampYMD(constructor, node);
                }
                return JRubyConstructor.constructYamlTimestamp(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlTimestampYMD(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlStr(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlBinary(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlSeq(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructYamlMap(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:range", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructRubyRange(constructor, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:regexp", new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                return JRubyConstructor.constructRubyRegexp(constructor, node);
            }
        });
        JRubyConstructor.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor constructor, Node node) {
                Object object = JRubyConstructor.findAndCreateFromCustomTagging(constructor, node);
                if (null != object) {
                    return object;
                }
                return constructor.constructPrivateType(node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyMap(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:hash:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyMap(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:int:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyInt(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubySequence(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:array:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubySequence(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:str:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyString(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:string:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyString(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:ruby/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRuby(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRuby(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructJava(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:java.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructJava(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:struct:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRubyStruct(constructor, string, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:exception:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor constructor, String string, Node node) {
                return JRubyConstructor.constructRuby(constructor, string, node);
            }
        });
    }
}

