/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyProc;
import org.jruby.nb.nb.exceptions.MainExitException;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.BlockCallback;
import org.jruby.nb.nb.runtime.CallBlock;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    public IRubyObject trap(final IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        SignalHandler signalHandler;
        final JRubySignalHandler jRubySignalHandler = new JRubySignalHandler(iRubyObject.getRuntime(), iRubyObject2, iRubyObject3, iRubyObject4.toString());
        try {
            signalHandler = Signal.handle(new Signal(jRubySignalHandler.signal), jRubySignalHandler);
        }
        catch (Exception exception) {
            throw iRubyObject.getRuntime().newArgumentError(exception.getMessage());
        }
        if (signalHandler instanceof JRubySignalHandler) {
            return ((JRubySignalHandler)signalHandler).block;
        }
        return RubyProc.newProc(iRubyObject.getRuntime(), CallBlock.newCallClosure(iRubyObject, (RubyModule)iRubyObject, Arity.noArguments(), new BlockCallback(){

            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                signalHandler.handle(new Signal(jRubySignalHandler.signal));
                return iRubyObject.getRuntime().getNil();
            }
        }, iRubyObject.getRuntime().getCurrentContext()), Block.Type.NORMAL);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final IRubyObject signal_object;
        private final String signal;

        public JRubySignalHandler(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string) {
            this.runtime = ruby;
            this.block = iRubyObject;
            this.signal_object = iRubyObject2;
            this.signal = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(Signal signal) {
            ThreadContext threadContext = this.runtime.getCurrentContext();
            try {
                try {
                    this.block.callMethod(threadContext, "call");
                }
                catch (RaiseException raiseException) {
                    try {
                        this.runtime.getThread().callMethod(threadContext, "main").callMethod(threadContext, "raise", raiseException.getException());
                    }
                    catch (Exception exception) {
                    }
                    Object var6_4 = null;
                    Signal.handle(new Signal(this.signal), this);
                    return;
                }
                catch (MainExitException mainExitException) {
                    this.runtime.getThreadService().getMainThread().kill();
                    Object var6_5 = null;
                    Signal.handle(new Signal(this.signal), this);
                    return;
                }
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Signal.handle(new Signal(this.signal), this);
                throw throwable;
            }
            Signal.handle(new Signal(this.signal), this);
        }
    }
}

