/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;

public class RubyDateFormat
extends DateFormat {
    private static final long serialVersionUID = -250429218019023997L;
    private List<Token> compiledPattern;
    private final DateFormatSymbols formatSymbols;
    private static final int FORMAT_STRING = 0;
    private static final int FORMAT_WEEK_LONG = 1;
    private static final int FORMAT_WEEK_SHORT = 2;
    private static final int FORMAT_MONTH_LONG = 3;
    private static final int FORMAT_MONTH_SHORT = 4;
    private static final int FORMAT_DAY = 5;
    private static final int FORMAT_DAY_S = 6;
    private static final int FORMAT_HOUR = 7;
    private static final int FORMAT_HOUR_M = 8;
    private static final int FORMAT_DAY_YEAR = 9;
    private static final int FORMAT_MINUTES = 10;
    private static final int FORMAT_MONTH = 11;
    private static final int FORMAT_MERIDIAN = 12;
    private static final int FORMAT_SECONDS = 13;
    private static final int FORMAT_WEEK_YEAR_S = 14;
    private static final int FORMAT_WEEK_YEAR_M = 15;
    private static final int FORMAT_DAY_WEEK = 16;
    private static final int FORMAT_YEAR_LONG = 17;
    private static final int FORMAT_YEAR_SHORT = 18;
    private static final int FORMAT_ZONE_OFF = 19;
    private static final int FORMAT_ZONE_ID = 20;
    private DateTime dt;

    public RubyDateFormat() {
        this("", new DateFormatSymbols());
    }

    public RubyDateFormat(String string, Locale locale) {
        this(string, new DateFormatSymbols(locale));
    }

    public RubyDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.formatSymbols = dateFormatSymbols;
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        this.compilePattern(string);
    }

    private void compilePattern(String string) {
        this.compiledPattern = new LinkedList<Token>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '%') {
                switch (string.charAt(++n2)) {
                    case 'A': {
                        this.compiledPattern.add(new Token(1));
                        break;
                    }
                    case 'a': {
                        this.compiledPattern.add(new Token(2));
                        break;
                    }
                    case 'B': {
                        this.compiledPattern.add(new Token(3));
                        break;
                    }
                    case 'b': {
                        this.compiledPattern.add(new Token(4));
                        break;
                    }
                    case 'c': {
                        this.compiledPattern.add(new Token(2));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(4));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(13));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(17));
                        break;
                    }
                    case 'd': {
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'e': {
                        this.compiledPattern.add(new Token(6));
                        break;
                    }
                    case 'F': {
                        this.compiledPattern.add(new Token(17));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'H': {
                        this.compiledPattern.add(new Token(7));
                        break;
                    }
                    case 'I': {
                        this.compiledPattern.add(new Token(8));
                        break;
                    }
                    case 'j': {
                        this.compiledPattern.add(new Token(9));
                        break;
                    }
                    case 'M': {
                        this.compiledPattern.add(new Token(10));
                        break;
                    }
                    case 'm': {
                        this.compiledPattern.add(new Token(11));
                        break;
                    }
                    case 'p': {
                        this.compiledPattern.add(new Token(12));
                        break;
                    }
                    case 'S': {
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'U': {
                        this.compiledPattern.add(new Token(14));
                        break;
                    }
                    case 'W': {
                        this.compiledPattern.add(new Token(15));
                        break;
                    }
                    case 'w': {
                        this.compiledPattern.add(new Token(16));
                        break;
                    }
                    case 'X': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(10));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'x': {
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'Y': {
                        this.compiledPattern.add(new Token(17));
                        break;
                    }
                    case 'y': {
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'Z': {
                        this.compiledPattern.add(new Token(20));
                        break;
                    }
                    case 'z': {
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case '%': {
                        this.compiledPattern.add(new Token(0, "%"));
                        break;
                    }
                    default: {
                        this.compiledPattern.add(new Token(0, "%" + string.charAt(n2)));
                    }
                }
                ++n2;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (n2 < n && string.charAt(n2) != '%') {
                stringBuilder.append(string.charAt(n2));
                ++n2;
            }
            this.compiledPattern.add(new Token(0, stringBuilder.toString()));
        }
    }

    public void setDateTime(DateTime dateTime) {
        this.dt = dateTime;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        for (Token token : this.compiledPattern) {
            switch (token.getFormat()) {
                case 0: {
                    stringBuffer.append(token.getData());
                    break;
                }
                case 1: {
                    int n = (this.dt.getDayOfWeek() + 1) % 8;
                    if (n == 0) {
                        ++n;
                    }
                    stringBuffer.append(this.formatSymbols.getWeekdays()[n]);
                    break;
                }
                case 2: {
                    int n = (this.dt.getDayOfWeek() + 1) % 8;
                    if (n == 0) {
                        ++n;
                    }
                    stringBuffer.append(this.formatSymbols.getShortWeekdays()[n]);
                    break;
                }
                case 3: {
                    stringBuffer.append(this.formatSymbols.getMonths()[this.dt.getMonthOfYear() - 1]);
                    break;
                }
                case 4: {
                    stringBuffer.append(this.formatSymbols.getShortMonths()[this.dt.getMonthOfYear() - 1]);
                    break;
                }
                case 5: {
                    int n = this.dt.getDayOfMonth();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 6: {
                    int n = this.dt.getDayOfMonth();
                    if (n < 10) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 7: {
                    int n = this.dt.getHourOfDay();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 8: {
                    int n = this.dt.getHourOfDay();
                    if (n > 12) {
                        n -= 12;
                    }
                    if (n == 0) {
                        stringBuffer.append("12");
                        break;
                    }
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 9: {
                    int n = this.dt.getDayOfYear();
                    if (n < 10) {
                        stringBuffer.append("00");
                    } else if (n < 100) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 10: {
                    int n = this.dt.getMinuteOfHour();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 11: {
                    int n = this.dt.getMonthOfYear();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 12: {
                    if (this.dt.getHourOfDay() < 12) {
                        stringBuffer.append("AM");
                        break;
                    }
                    stringBuffer.append("PM");
                    break;
                }
                case 13: {
                    int n = this.dt.getSecondOfMinute();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 15: {
                    this.formatWeekYear(2, stringBuffer);
                    break;
                }
                case 14: {
                    this.formatWeekYear(1, stringBuffer);
                    break;
                }
                case 16: {
                    int n = this.dt.getDayOfWeek();
                    stringBuffer.append(n);
                    break;
                }
                case 17: {
                    int n = this.dt.getYear();
                    if (n < 10) {
                        stringBuffer.append("000");
                    } else if (n < 100) {
                        stringBuffer.append("00");
                    } else if (n < 1000) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 18: {
                    int n = this.dt.getYear() % 100;
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 19: {
                    int n = this.dt.getZone().getOffset(this.dt.getMillis());
                    if (n <= 0) {
                        stringBuffer.append('+');
                    } else {
                        stringBuffer.append('-');
                    }
                    n = Math.abs(n);
                    if (n / 3600000 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n / 3600000);
                    n = n % 3600000 / 60000;
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    break;
                }
                case 20: {
                    stringBuffer.append(this.dt.getZone().getShortName(this.dt.getMillis()));
                }
            }
        }
        return stringBuffer;
    }

    private void formatWeekYear(int n, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = this.dt.toGregorianCalendar();
        gregorianCalendar.setFirstDayOfWeek(n);
        gregorianCalendar.setMinimalDaysInFirstWeek(7);
        int n2 = gregorianCalendar.get(3);
        if ((n2 == 52 || n2 == 53) && gregorianCalendar.get(2) == 0) {
            n2 = 0;
        }
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private static class Token {
        private int format;
        private Object data;

        public Token(int n) {
            this(n, null);
        }

        public Token(int n, Object object) {
            this.format = n;
            this.data = object;
        }

        public Object getData() {
            return this.data;
        }

        public int getFormat() {
            return this.format;
        }
    }
}

