/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.encoding.specific.UTF8Encoding;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyKernel;
import org.jruby.nb.nb.RubyNumeric;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Pack {
    private static final byte[] sSp10;
    private static final byte[] sNil10;
    private static final int IS_STAR = -1;
    private static final ASCIIEncoding ASCII;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String sTooFew = "too few arguments";
    private static final byte[] hex_table;
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    private static final byte[] sHexDigits;
    private static final int[] b64_xtable;
    private static final Converter[] converters;
    private static final BigInteger QUAD_MIN;
    private static final BigInteger QUAD_MAX;
    private static final long[] utf8_limits;

    private static long num2quad(IRubyObject iRubyObject) {
        if (iRubyObject == iRubyObject.getRuntime().getNil()) {
            return 0L;
        }
        if (iRubyObject instanceof RubyBignum) {
            BigInteger bigInteger = ((RubyBignum)iRubyObject).getValue();
            if (bigInteger.compareTo(QUAD_MIN) < 0 || bigInteger.compareTo(QUAD_MAX) > 0) {
                throw iRubyObject.getRuntime().newRangeError("bignum too big to convert into `quad int'");
            }
            return bigInteger.longValue();
        }
        return RubyNumeric.num2long(iRubyObject);
    }

    private static ByteList encodes(Ruby ruby, ByteList byteList, byte[] byArray, int n, int n2, int n3, byte by) {
        byte by2;
        byte by3;
        byte by4;
        byte[] byArray2;
        n3 = n3 < n2 ? n3 : n2;
        byteList.ensure(n3 * 4 / 3 + 6);
        int n4 = n;
        byte[] byArray3 = byArray2 = by == 117 ? uu_table : b64_table;
        if (by == 117) {
            if (n3 >= byArray2.length) {
                throw ruby.newArgumentError("" + n3 + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + byArray2.length);
            }
            byteList.append(byArray2[n3]);
            by4 = 96;
        } else {
            by4 = 61;
        }
        while (n3 >= 3) {
            by3 = byArray[n4++];
            by2 = byArray[n4++];
            byte by5 = byArray[n4++];
            byteList.append(byArray2[0x3F & by3 >>> 2]);
            byteList.append(byArray2[0x3F & (by3 << 4 & 0x30 | by2 >>> 4 & 0xF)]);
            byteList.append(byArray2[0x3F & (by2 << 2 & 0x3C | by5 >>> 6 & 3)]);
            byteList.append(byArray2[0x3F & by5]);
            n3 -= 3;
        }
        if (n3 == 2) {
            by3 = byArray[n4++];
            by2 = byArray[n4++];
            byteList.append(byArray2[0x3F & by3 >>> 2]);
            byteList.append(byArray2[0x3F & (by3 << 4 & 0x30 | by2 >> 4 & 0xF)]);
            byteList.append(byArray2[0x3F & (by2 << 2 & 0x3C | 0)]);
            byteList.append(by4);
        } else if (n3 == 1) {
            by3 = byArray[n4++];
            byteList.append(byArray2[0x3F & by3 >>> 2]);
            byteList.append(byArray2[0x3F & (by3 << 4 & 0x30 | 0)]);
            byteList.append(by4);
            byteList.append(by4);
        }
        byteList.append(10);
        return byteList;
    }

    private static ByteList qpencode(ByteList byteList, ByteList byteList2, int n) {
        byteList.ensure(1024);
        int n2 = 0;
        int n3 = -1;
        byte[] byArray = byteList2.bytes;
        try {
            int n4 = byteList2.begin + byteList2.realSize;
            for (int i = byteList2.begin; i < n4; ++i) {
                int n5 = byArray[i];
                if (n5 > 126 || n5 < 32 && n5 != 10 && n5 != 9 || n5 == 61) {
                    byteList.append(61);
                    byteList.append(hex_table[n5 >> 4]);
                    byteList.append(hex_table[n5 & 0xF]);
                    n2 += 3;
                    n3 = -1;
                } else if (n5 == 10) {
                    if (n3 == 32 || n3 == 9) {
                        byteList.append(61);
                        byteList.append((byte)n5);
                    }
                    byteList.append((byte)n5);
                    n2 = 0;
                    n3 = n5;
                } else {
                    byteList.append((byte)n5);
                    ++n2;
                    n3 = n5;
                }
                if (n2 <= n) continue;
                byteList.append(61);
                byteList.append(10);
                n2 = 0;
                n3 = 10;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n2 > 0) {
            byteList.append(61);
            byteList.append(10);
        }
        return byteList;
    }

    public static RubyArray unpack(Ruby ruby, ByteList byteList, ByteList byteList2) {
        RubyArray rubyArray = ruby.newArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList2.unsafeBytes(), byteList2.begin(), byteList2.length());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        byte by = 0;
        byte by2 = Pack.safeGet(byteBuffer);
        block25: while (by2 != 0) {
            by = by2;
            by2 = Pack.safeGet(byteBuffer);
            if (by2 == 95 || by2 == 33) {
                if (NATIVE_CODES.indexOf(by) == -1) {
                    throw ruby.newArgumentError("'" + by2 + "' allowed only after types " + NATIVE_CODES);
                }
                by2 = Pack.safeGet(byteBuffer);
            }
            int n = 0;
            if (by2 == 0) {
                n = 1;
            } else if (by2 == 42) {
                n = -1;
                by2 = Pack.safeGet(byteBuffer);
            } else if (ASCII.isDigit((int)by2)) {
                n = 0;
                do {
                    n = n * 10 + Character.digit((char)(by2 & 0xFF), 10);
                } while ((by2 = Pack.safeGet(byteBuffer)) != 0 && ASCII.isDigit((int)by2));
            } else {
                n = by == 64 ? 0 : 1;
            }
            Converter converter = converters[by];
            if (converter != null) {
                Pack.decode(ruby, byteBuffer2, n, rubyArray, converter);
                by = by2;
                continue;
            }
            switch (by) {
                case 64: {
                    try {
                        if (n == -1) {
                            byteBuffer2.position(byteBuffer2.remaining());
                            break;
                        }
                        byteBuffer2.position(n);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ruby.newArgumentError("@ outside of string");
                    }
                }
                case 37: {
                    throw ruby.newArgumentError("% is not supported");
                }
                case 65: {
                    byte by3;
                    if (n == -1 || n > byteBuffer2.remaining()) {
                        n = byteBuffer2.remaining();
                    }
                    byte[] byArray = new byte[n];
                    byteBuffer2.get(byArray);
                    int n2 = n - 1;
                    while (n > 0 && ((by3 = byArray[n2]) == 0 || by3 == 32)) {
                        --n;
                        --n2;
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, 0, n, false)));
                    break;
                }
                case 90: {
                    int n3;
                    int n4;
                    boolean bl;
                    boolean bl2 = bl = n == -1;
                    if (n == -1 || n > byteBuffer2.remaining()) {
                        n = byteBuffer2.remaining();
                    }
                    byte[] byArray = new byte[n];
                    for (n4 = 0; n4 < n && (n3 = (int)byteBuffer2.get()) != 0; ++n4) {
                        byArray[n4] = n3;
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, 0, n4, false)));
                    if (bl) continue block25;
                    if (n4 < n) {
                        ++n4;
                    }
                    while (n4 < n) {
                        byteBuffer2.get();
                        ++n4;
                    }
                    continue block25;
                }
                case 97: {
                    if (n == -1 || n > byteBuffer2.remaining()) {
                        n = byteBuffer2.remaining();
                    }
                    byte[] byArray = new byte[n];
                    byteBuffer2.get(byArray);
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, false)));
                    break;
                }
                case 98: {
                    int n3;
                    if (n == -1 || n > byteBuffer2.remaining() * 8) {
                        n = byteBuffer2.remaining() * 8;
                    }
                    int n5 = 0;
                    byte[] byArray = new byte[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        n5 = (n3 & 7) != 0 ? (n5 >>>= 1) : (int)byteBuffer2.get();
                        byArray[n3] = (n5 & 1) != 0 ? 49 : 48;
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, false)));
                    break;
                }
                case 66: {
                    int n3;
                    if (n == -1 || n > byteBuffer2.remaining() * 8) {
                        n = byteBuffer2.remaining() * 8;
                    }
                    int n6 = 0;
                    byte[] byArray = new byte[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        n6 = (n3 & 7) != 0 ? (n6 <<= 1) : (int)byteBuffer2.get();
                        byArray[n3] = (n6 & 0x80) != 0 ? 49 : 48;
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, false)));
                    break;
                }
                case 104: {
                    int n3;
                    if (n == -1 || n > byteBuffer2.remaining() * 2) {
                        n = byteBuffer2.remaining() * 2;
                    }
                    int n7 = 0;
                    byte[] byArray = new byte[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        n7 = (n3 & 1) != 0 ? (n7 >>>= 4) : (int)byteBuffer2.get();
                        byArray[n3] = sHexDigits[n7 & 0xF];
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, false)));
                    break;
                }
                case 72: {
                    int n3;
                    if (n == -1 || n > byteBuffer2.remaining() * 2) {
                        n = byteBuffer2.remaining() * 2;
                    }
                    int n8 = 0;
                    byte[] byArray = new byte[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        n8 = (n3 & 1) != 0 ? (n8 <<= 4) : (int)byteBuffer2.get();
                        byArray[n3] = sHexDigits[n8 >>> 4 & 0xF];
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, false)));
                    break;
                }
                case 117: {
                    int n9;
                    int n10;
                    int n11;
                    int n12 = byteBuffer2.remaining() * 3 / 4;
                    byte[] byArray = new byte[n12];
                    int n3 = 0;
                    int n13 = 0;
                    int n14 = byteBuffer2.get();
                    while (byteBuffer2.hasRemaining() && n14 > 32 && n14 < 97) {
                        byte[] byArray2 = new byte[3];
                        int n15 = n14 - 32 & 0x3F;
                        n14 = Pack.safeGet(byteBuffer2);
                        if ((n13 += n15) > n12) {
                            n15 -= n13 - n12;
                            n13 = n12;
                        }
                        while (n15 > 0) {
                            int n16;
                            int n17;
                            int n18 = n17 = n15 > 3 ? 3 : n15;
                            if (byteBuffer2.hasRemaining() && n14 >= 32) {
                                n11 = n14 - 32 & 0x3F;
                                n14 = Pack.safeGet(byteBuffer2);
                            } else {
                                n11 = 0;
                            }
                            if (byteBuffer2.hasRemaining() && n14 >= 32) {
                                n10 = n14 - 32 & 0x3F;
                                n14 = Pack.safeGet(byteBuffer2);
                            } else {
                                n10 = 0;
                            }
                            if (byteBuffer2.hasRemaining() && n14 >= 32) {
                                n9 = n14 - 32 & 0x3F;
                                n14 = Pack.safeGet(byteBuffer2);
                            } else {
                                n9 = 0;
                            }
                            if (byteBuffer2.hasRemaining() && n14 >= 32) {
                                n16 = n14 - 32 & 0x3F;
                                n14 = Pack.safeGet(byteBuffer2);
                            } else {
                                n16 = 0;
                            }
                            byArray2[0] = (byte)((n11 << 2 | n10 >> 4) & 0xFF);
                            byArray2[1] = (byte)((n10 << 4 | n9 >> 2) & 0xFF);
                            byArray2[2] = (byte)((n9 << 6 | n16) & 0xFF);
                            for (int i = 0; i < n17; ++i) {
                                byArray[n3++] = byArray2[i];
                            }
                            n15 -= n17;
                        }
                        if (n14 == 13) {
                            n14 = Pack.safeGet(byteBuffer2);
                        }
                        if (n14 == 10) {
                            n14 = Pack.safeGet(byteBuffer2);
                            continue;
                        }
                        if (!byteBuffer2.hasRemaining()) continue;
                        if (Pack.safeGet(byteBuffer2) == 10) {
                            Pack.safeGet(byteBuffer2);
                            continue;
                        }
                        if (!byteBuffer2.hasRemaining()) continue;
                        byteBuffer2.position(byteBuffer2.position() - 1);
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, 0, n3, false)));
                    break;
                }
                case 109: {
                    int n11;
                    int n19 = byteBuffer2.remaining() * 3 / 4;
                    byte[] byArray = new byte[n19];
                    int n3 = -1;
                    int n14 = -1;
                    int n13 = 0;
                    int n10 = 0;
                    int n9 = -1;
                    while (byteBuffer2.hasRemaining()) {
                        n11 = -1;
                        n13 = -1;
                        n14 = -1;
                        n3 = -1;
                        n9 = Pack.safeGet(byteBuffer2);
                        while ((n3 = b64_xtable[n9]) == -1 && byteBuffer2.hasRemaining()) {
                            n9 = Pack.safeGet(byteBuffer2);
                        }
                        if (n3 == -1) break;
                        n9 = Pack.safeGet(byteBuffer2);
                        while ((n14 = b64_xtable[n9]) == -1 && byteBuffer2.hasRemaining()) {
                            n9 = Pack.safeGet(byteBuffer2);
                        }
                        if (n14 == -1) break;
                        n9 = Pack.safeGet(byteBuffer2);
                        while ((n13 = b64_xtable[n9]) == -1 && byteBuffer2.hasRemaining() && n9 != 61) {
                            n9 = Pack.safeGet(byteBuffer2);
                        }
                        if (n9 == 61 || n13 == -1) {
                            if (n9 != 61) break;
                            byteBuffer2.position(byteBuffer2.position() - 1);
                            break;
                        }
                        n9 = Pack.safeGet(byteBuffer2);
                        while ((n11 = b64_xtable[n9]) == -1 && byteBuffer2.hasRemaining() && n9 != 61) {
                            n9 = Pack.safeGet(byteBuffer2);
                        }
                        if (n9 == 61 || n11 == -1) {
                            if (n9 != 61) break;
                            byteBuffer2.position(byteBuffer2.position() - 1);
                            break;
                        }
                        byArray[n10++] = (byte)((n3 << 2 | n14 >> 4) & 0xFF);
                        byArray[n10++] = (byte)((n14 << 4 | n13 >> 2) & 0xFF);
                        byArray[n10++] = (byte)((n13 << 6 | n11) & 0xFF);
                    }
                    if (n3 != -1 && n14 != -1) {
                        if (n13 == -1 && n9 == 61) {
                            byArray[n10++] = (byte)((n3 << 2 | n14 >> 4) & 0xFF);
                        } else if (n13 != -1 && n9 == 61) {
                            byArray[n10++] = (byte)((n3 << 2 | n14 >> 4) & 0xFF);
                            byArray[n10++] = (byte)((n14 << 4 | n13 >> 2) & 0xFF);
                        }
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, 0, n10, false)));
                    break;
                }
                case 77: {
                    int n9;
                    int n10;
                    int n11;
                    int n14;
                    int n13;
                    int n3;
                    byte[] byArray = new byte[Math.max(byteBuffer2.remaining(), 0)];
                    int n20 = 0;
                    while (byteBuffer2.hasRemaining()) {
                        n3 = Pack.safeGet(byteBuffer2);
                        if (n3 != 61) {
                            byArray[n20++] = n3;
                            continue;
                        }
                        if (!byteBuffer2.hasRemaining()) break;
                        byteBuffer2.mark();
                        n14 = Pack.safeGet(byteBuffer2);
                        if (n14 == 10) continue;
                        n13 = Character.digit((char)(n14 & 0xFF), 16);
                        if (n13 == -1) {
                            byteBuffer2.reset();
                            break;
                        }
                        byteBuffer2.mark();
                        if (!byteBuffer2.hasRemaining()) break;
                        n11 = Pack.safeGet(byteBuffer2);
                        n10 = Character.digit((char)(n11 & 0xFF), 16);
                        if (n10 == -1) {
                            byteBuffer2.reset();
                            break;
                        }
                        n9 = (byte)(n13 << 4 | n10);
                        byArray[n20++] = n9;
                    }
                    rubyArray.append(RubyString.newString(ruby, new ByteList(byArray, 0, n20, false)));
                    break;
                }
                case 85: {
                    if (n == -1 || n > byteBuffer2.remaining()) {
                        n = byteBuffer2.remaining();
                    }
                    while (n-- > 0 && byteBuffer2.remaining() > 0) {
                        try {
                            rubyArray.append(ruby.newFixnum(Pack.utf8Decode(byteBuffer2)));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ruby.newArgumentError(illegalArgumentException.getMessage());
                        }
                    }
                    break;
                }
                case 88: {
                    if (n == -1) {
                        n = byteBuffer2.remaining();
                    }
                    try {
                        byteBuffer2.position(byteBuffer2.position() - n);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ruby.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 120: {
                    if (n == -1) {
                        n = byteBuffer2.remaining();
                    }
                    try {
                        byteBuffer2.position(byteBuffer2.position() + n);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ruby.newArgumentError("in `unpack': x outside of string");
                    }
                }
            }
        }
        return rubyArray;
    }

    private static int utf8Decode(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3 = n2 = byteBuffer.get() & 0xFF;
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        if ((n2 & 0x40) == 0) {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if ((n3 & 0x20) == 0) {
            n = 2;
            n3 &= 0x1F;
        } else if ((n3 & 0x10) == 0) {
            n = 3;
            n3 &= 0xF;
        } else if ((n3 & 8) == 0) {
            n = 4;
            n3 &= 7;
        } else if ((n3 & 4) == 0) {
            n = 5;
            n3 &= 3;
        } else if ((n3 & 2) == 0) {
            n = 6;
            n3 &= 1;
        } else {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if (n > byteBuffer.remaining() + 1) {
            throw new IllegalArgumentException("malformed UTF-8 character (expected " + n + " bytes, " + "given " + (byteBuffer.remaining() + 1) + " bytes)");
        }
        int n4 = n - 1;
        if (--n != 0) {
            while (n-- != 0) {
                n2 = byteBuffer.get() & 0xFF;
                if ((n2 & 0xC0) != 128) {
                    throw new IllegalArgumentException("malformed UTF-8 character");
                }
                n3 = n3 << 6 | (n2 &= 0x3F);
            }
        }
        if ((long)n3 < utf8_limits[n4]) {
            throw new IllegalArgumentException("redundant UTF-8 sequence");
        }
        return n3;
    }

    private static byte safeGet(ByteBuffer byteBuffer) {
        return byteBuffer.hasRemaining() ? byteBuffer.get() : (byte)0;
    }

    public static void decode(Ruby ruby, ByteBuffer byteBuffer, int n, RubyArray rubyArray, Converter converter) {
        int n2 = 0;
        if (n == -1) {
            n = byteBuffer.remaining() / converter.size;
        } else if (n > byteBuffer.remaining() / converter.size) {
            n2 = n - byteBuffer.remaining() / converter.size;
            n = byteBuffer.remaining() / converter.size;
        }
        while (n-- > 0) {
            rubyArray.append(converter.decode(ruby, byteBuffer));
        }
        if (converter != converters[81]) {
            while (n2-- > 0) {
                rubyArray.append(ruby.getNil());
            }
        }
    }

    public static int encode(Ruby ruby, int n, ByteList byteList, RubyArray rubyArray, int n2, Converter converter) {
        int n3 = rubyArray.size();
        while (n-- > 0) {
            if (n3-- <= 0) {
                throw ruby.newArgumentError(sTooFew);
            }
            IRubyObject iRubyObject = rubyArray.eltInternal(n2++);
            converter.encode(ruby, iRubyObject, byteList);
        }
        return n2;
    }

    private static final ByteList shrink(ByteList byteList, int n) {
        n = byteList.length() - n;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        byteList.length(n);
        return byteList;
    }

    private static final ByteList grow(ByteList byteList, byte[] byArray, int n) {
        int n2 = byArray.length;
        while (n >= n2) {
            byteList.append(byArray);
            n -= n2;
        }
        byteList.append(byArray, 0, n);
        return byteList;
    }

    public static RubyString pack(Ruby ruby, RubyArray rubyArray, ByteList byteList) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        ByteList byteList2 = new ByteList();
        int n = rubyArray.size();
        byte by = 0;
        byte by2 = Pack.safeGet(byteBuffer);
        int n2 = 0;
        block23: while (by2 != 0) {
            Converter converter;
            by = by2;
            by2 = Pack.safeGet(byteBuffer);
            while (ASCII.isSpace((int)by)) {
                if (by2 == 0) break block23;
                by = by2;
                by2 = Pack.safeGet(byteBuffer);
            }
            if (by == 35) {
                while (by != 10) {
                    if (by2 == 0) break block23;
                    by = by2;
                    by2 = Pack.safeGet(byteBuffer);
                }
            }
            if (by2 == 33 || by2 == 95) {
                if (NATIVE_CODES.indexOf(by) == -1) {
                    throw ruby.newArgumentError("'" + by2 + "' allowed only after types " + NATIVE_CODES);
                }
                by2 = Pack.safeGet(byteBuffer);
            }
            int n3 = 1;
            boolean bl = false;
            if (by2 != 0) {
                if (by2 == 42) {
                    if ("@Xxu".indexOf(by) != -1) {
                        n3 = 0;
                    } else {
                        n3 = n;
                        bl = true;
                    }
                    by2 = Pack.safeGet(byteBuffer);
                } else if (ASCII.isDigit((int)by2)) {
                    n3 = 0;
                    do {
                        n3 = n3 * 10 + Character.digit((char)(by2 & 0xFF), 10);
                    } while ((by2 = Pack.safeGet(byteBuffer)) != 0 && ASCII.isDigit((int)by2));
                }
            }
            if ((converter = converters[by]) != null) {
                n2 = Pack.encode(ruby, n3, byteList2, rubyArray, n2, converter);
                continue;
            }
            block1 : switch (by) {
                case 37: {
                    throw ruby.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    int n4;
                    Object object;
                    ByteList byteList3;
                    if (n-- <= 0) {
                        throw ruby.newArgumentError(sTooFew);
                    }
                    ByteList byteList4 = byteList3 = (object = rubyArray.eltInternal(n2++)) == ruby.getNil() ? ByteList.EMPTY_BYTELIST : object.convertToString().getByteList();
                    if (bl) {
                        n3 = byteList3.length();
                        if (by == 90) {
                            ++n3;
                        }
                    }
                    switch (by) {
                        case 65: 
                        case 90: 
                        case 97: {
                            if (byteList3.length() >= n3) {
                                byteList2.append(byteList3.bytes, byteList3.begin, n3);
                                break block1;
                            }
                            byteList2.append(byteList3);
                            n3 -= byteList3.length();
                            switch (by) {
                                case 90: 
                                case 97: {
                                    Pack.grow(byteList2, sNil10, n3);
                                    break block1;
                                }
                            }
                            Pack.grow(byteList2, sSp10, n3);
                            break block1;
                        }
                        case 98: {
                            int n5 = 0;
                            n4 = 0;
                            if (n3 > byteList3.length()) {
                                n4 = (n3 - byteList3.length()) / 2 + n3 % 2;
                                n3 = byteList3.length();
                            }
                            int n6 = 0;
                            while (n6 < n3) {
                                if ((byteList3.charAt(n6++) & '\u0001') != 0) {
                                    n5 |= 0x80;
                                }
                                if ((n6 & 7) == 0) {
                                    byteList2.append((byte)(n5 & 0xFF));
                                    n5 = 0;
                                    continue;
                                }
                                n5 >>= 1;
                            }
                            if ((n3 & 7) != 0) {
                                byteList2.append((byte)((n5 >>= 7 - (n3 & 7)) & 0xFF));
                            }
                            byteList2.length(byteList2.length() + n4);
                            break block1;
                        }
                        case 66: {
                            int n7 = 0;
                            n4 = 0;
                            if (n3 > byteList3.length()) {
                                n4 = (n3 - byteList3.length()) / 2 + n3 % 2;
                                n3 = byteList3.length();
                            }
                            int n8 = 0;
                            while (n8 < n3) {
                                n7 |= byteList3.charAt(n8++) & '\u0001';
                                if ((n8 & 7) == 0) {
                                    byteList2.append((byte)(n7 & 0xFF));
                                    n7 = 0;
                                    continue;
                                }
                                n7 <<= 1;
                            }
                            if ((n3 & 7) != 0) {
                                byteList2.append((byte)((n7 <<= 7 - (n3 & 7)) & 0xFF));
                            }
                            byteList2.length(byteList2.length() + n4);
                            break block1;
                        }
                        case 104: {
                            int n9 = 0;
                            n4 = 0;
                            if (n3 > byteList3.length()) {
                                n4 = n3 - byteList3.length();
                                n3 = byteList3.length();
                            }
                            int n10 = 0;
                            while (n10 < n3) {
                                byte by3;
                                n9 = Character.isJavaIdentifierStart(by3 = (byte)byteList3.charAt(n10++)) ? (n9 |= ((by3 & 0xF) + 9 & 0xF) << 4) : (n9 |= (by3 & 0xF) << 4);
                                if ((n10 & 1) != 0) {
                                    n9 >>= 4;
                                    continue;
                                }
                                byteList2.append((byte)(n9 & 0xFF));
                                n9 = 0;
                            }
                            if ((n3 & 1) != 0) {
                                byteList2.append((byte)(n9 & 0xFF));
                            }
                            byteList2.length(byteList2.length() + n4);
                            break block1;
                        }
                        case 72: {
                            int n11 = 0;
                            n4 = 0;
                            if (n3 > byteList3.length()) {
                                n4 = n3 - byteList3.length();
                                n3 = byteList3.length();
                            }
                            int n12 = 0;
                            while (n12 < n3) {
                                byte by4;
                                n11 = Character.isJavaIdentifierStart(by4 = (byte)byteList3.charAt(n12++)) ? (n11 |= (by4 & 0xF) + 9 & 0xF) : (n11 |= by4 & 0xF);
                                if ((n12 & 1) != 0) {
                                    n11 <<= 4;
                                    continue;
                                }
                                byteList2.append((byte)(n11 & 0xFF));
                                n11 = 0;
                            }
                            if ((n3 & 1) != 0) {
                                byteList2.append((byte)(n11 & 0xFF));
                            }
                            byteList2.length(byteList2.length() + n4);
                        }
                    }
                    break;
                }
                case 120: {
                    Pack.grow(byteList2, sNil10, n3);
                    break;
                }
                case 88: {
                    try {
                        Pack.shrink(byteList2, n3);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ruby.newArgumentError("in `pack': X outside of string");
                    }
                }
                case 64: {
                    if ((n3 -= byteList2.length()) > 0) {
                        Pack.grow(byteList2, sNil10, n3);
                    }
                    if ((n3 = -n3) <= 0) break;
                    Pack.shrink(byteList2, n3);
                    break;
                }
                case 109: 
                case 117: {
                    int n4;
                    Object object;
                    if (n-- <= 0) {
                        throw ruby.newArgumentError(sTooFew);
                    }
                    ByteList byteList3 = (object = rubyArray.eltInternal(n2++)) == ruby.getNil() ? ByteList.EMPTY_BYTELIST : object.convertToString().getByteList();
                    int n13 = n3 = n3 <= 2 ? 45 : n3 / 3 * 3;
                    if (byteList3.length() == 0) break;
                    byte[] byArray = byteList3.bytes;
                    for (n4 = 0; n4 < byteList3.length(); n4 += n3) {
                        Pack.encodes(ruby, byteList2, byArray, n4 + byteList3.begin, byteList3.length() - n4, n3, by);
                    }
                    continue block23;
                }
                case 77: {
                    Object object;
                    ByteList byteList3;
                    if (n-- <= 0) {
                        throw ruby.newArgumentError(sTooFew);
                    }
                    ByteList byteList5 = byteList3 = (object = rubyArray.eltInternal(n2++)) == ruby.getNil() ? ByteList.EMPTY_BYTELIST : object.asString().getByteList();
                    if (n3 <= 1) {
                        n3 = 72;
                    }
                    Pack.qpencode(byteList2, byteList3, n3);
                    break;
                }
                case 85: {
                    Object object = UTF8Encoding.INSTANCE;
                    byte[] byArray = new byte[object.maxLength() * n3];
                    int n4 = 0;
                    while (n3-- > 0) {
                        IRubyObject iRubyObject;
                        int n14;
                        if (n-- <= 0) {
                            throw ruby.newArgumentError(sTooFew);
                        }
                        int n15 = n14 = (iRubyObject = rubyArray.eltInternal(n2++)) == ruby.getNil() ? 0 : RubyNumeric.num2int(iRubyObject);
                        if (n14 < 0) {
                            throw ruby.newRangeError("pack(U): value out of range");
                        }
                        int n16 = object.codeToMbc(n14, byArray, n4);
                        byteList2.append(byArray, n4, n16);
                        n4 += n16;
                    }
                    break;
                }
                case 119: {
                    IRubyObject iRubyObject;
                    String string;
                    BigInteger bigInteger;
                    if (n-- <= 0) {
                        throw ruby.newArgumentError(sTooFew);
                    }
                    if ((bigInteger = new BigInteger(string = (iRubyObject = rubyArray.eltInternal(n2++)) == ruby.getNil() ? "0" : iRubyObject.asString().toString())).compareTo(BigInteger.ZERO) >= 0) {
                        int n17 = bigInteger.toString(2).length();
                        byte[] byArray = bigInteger.toByteArray();
                        byte[] byArray2 = new byte[n17 / 7 + (n17 % 7 > 0 ? 1 : 0)];
                        int n18 = 0;
                        int n19 = 0;
                        int n20 = 0;
                        for (int i = byArray.length - 1; i >= 0; --i) {
                            int n21 = 0;
                            while (n21 < 8) {
                                if (n19 == 7) {
                                    byArray2[byArray2.length - 1 - n20++] = (byte)(n18 & 0xFF);
                                    n18 = 128;
                                    n19 = 0;
                                }
                                int n22 = byArray[i] & 1 << n21;
                                if (n19 > n21) {
                                    n22 = 0xFF & n22 << n19 - n21;
                                } else if (n19 < n21) {
                                    n22 = 0xFF & n22 >> n21 - n19;
                                }
                                n18 |= 0xFF & n22;
                                ++n21;
                                ++n19;
                            }
                        }
                        if (n18 != 128) {
                            byArray2[n20] = (byte)(n18 & 0xFF);
                        }
                        byteList2.append(byArray2);
                        break;
                    }
                    throw ruby.newArgumentError("can't compress negative numbers");
                }
            }
        }
        return ruby.newString(byteList2);
    }

    private static int decodeIntLittleEndian(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return n;
    }

    private static int decodeIntBigEndian(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return l;
    }

    private static void encodeIntLittleEndian(ByteList byteList, int n) {
        byteList.append((byte)(n & 0xFF)).append((byte)(n >> 8 & 0xFF));
        byteList.append((byte)(n >> 16 & 0xFF)).append((byte)(n >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(ByteList byteList, int n) {
        byteList.append((byte)(n >> 24 & 0xFF)).append((byte)(n >> 16 & 0xFF));
        byteList.append((byte)(n >> 8 & 0xFF)).append((byte)(n & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer byteBuffer) {
        int n = Pack.decodeIntBigEndian(byteBuffer);
        int n2 = Pack.decodeIntBigEndian(byteBuffer);
        return ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer byteBuffer) {
        int n = Pack.decodeIntLittleEndian(byteBuffer);
        int n2 = Pack.decodeIntLittleEndian(byteBuffer);
        return ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(ByteList byteList, long l) {
        Pack.encodeIntLittleEndian(byteList, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(byteList, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(ByteList byteList, long l) {
        Pack.encodeIntBigEndian(byteList, (int)(l >>> 32));
        Pack.encodeIntBigEndian(byteList, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer byteBuffer) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(byteBuffer));
    }

    private static double decodeDoubleBigEndian(ByteBuffer byteBuffer) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(byteBuffer));
    }

    private static void encodeDoubleLittleEndian(ByteList byteList, double d) {
        Pack.encodeLongLittleEndian(byteList, Double.doubleToLongBits(d));
    }

    private static void encodeDoubleBigEndian(ByteList byteList, double d) {
        Pack.encodeLongBigEndian(byteList, Double.doubleToLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer byteBuffer) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(byteBuffer));
    }

    private static float decodeFloatLittleEndian(ByteBuffer byteBuffer) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(byteBuffer));
    }

    private static void encodeFloatLittleEndian(ByteList byteList, float f) {
        Pack.encodeIntLittleEndian(byteList, Float.floatToIntBits(f));
    }

    private static void encodeFloatBigEndian(ByteList byteList, float f) {
        Pack.encodeIntBigEndian(byteList, Float.floatToIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getShort() & 0xFFFF;
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return n;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        return n;
    }

    private static short decodeShortBigEndian(ByteBuffer byteBuffer) {
        return byteBuffer.getShort();
    }

    private static void encodeShortLittleEndian(ByteList byteList, int n) {
        byteList.append((byte)(n & 0xFF)).append((byte)((n & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(ByteList byteList, int n) {
        byteList.append((byte)((n & 0xFF00) >> 8)).append((byte)(n & 0xFF));
    }

    static {
        Converter converter;
        int n;
        sSp10 = "          ".getBytes();
        sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes();
        ASCII = ASCIIEncoding.INSTANCE;
        b64_xtable = new int[256];
        converters = new Converter[256];
        QUAD_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        QUAD_MAX = new BigInteger("ffffffffffffffff", 16);
        hex_table = ByteList.plain((CharSequence)"0123456789ABCDEF");
        uu_table = ByteList.plain((CharSequence)"`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain((CharSequence)"0123456789abcdef0123456789ABCDEFx");
        for (n = 0; n < 256; ++n) {
            Pack.b64_xtable[n] = -1;
        }
        for (n = 0; n < 64; ++n) {
            Pack.b64_xtable[Pack.b64_table[n]] = n;
        }
        Pack.converters[118] = new Converter(2){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeShortUnsignedLittleEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n = iRubyObject == ruby.getNil() ? 0 : (int)(RubyNumeric.num2long(iRubyObject) & 0xFFFFL);
                Pack.encodeShortLittleEndian(byteList, n);
            }
        };
        Pack.converters[101] = new Converter(4){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return RubyFloat.newFloat(ruby, Pack.decodeFloatLittleEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                float f = iRubyObject == ruby.getNil() ? 0.0f : (float)RubyKernel.new_float(iRubyObject, iRubyObject).convertToFloat().getDoubleValue();
                Pack.encodeFloatLittleEndian(byteList, f);
            }
        };
        Pack.converters[70] = converter = new Converter(4){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return RubyFloat.newFloat(ruby, Pack.decodeFloatBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                float f = iRubyObject == ruby.getNil() ? 0.0f : (float)RubyKernel.new_float(iRubyObject, iRubyObject).convertToFloat().getDoubleValue();
                Pack.encodeFloatBigEndian(byteList, f);
            }
        };
        Pack.converters[102] = converter;
        Pack.converters[103] = converter;
        Pack.converters[69] = new Converter(8){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return RubyFloat.newFloat(ruby, Pack.decodeDoubleLittleEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                double d = iRubyObject == ruby.getNil() ? 0.0 : RubyKernel.new_float(iRubyObject, iRubyObject).convertToFloat().getDoubleValue();
                Pack.encodeDoubleLittleEndian(byteList, d);
            }
        };
        Pack.converters[68] = converter = new Converter(8){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return RubyFloat.newFloat(ruby, Pack.decodeDoubleBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                double d = iRubyObject == ruby.getNil() ? 0.0 : RubyKernel.new_float(iRubyObject, iRubyObject).convertToFloat().getDoubleValue();
                Pack.encodeDoubleBigEndian(byteList, d);
            }
        };
        Pack.converters[100] = converter;
        Pack.converters[71] = converter;
        Pack.converters[115] = new Converter(2){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeShortBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n;
                if (iRubyObject == ruby.getNil()) {
                    n = 0;
                } else {
                    long l = RubyNumeric.num2long(iRubyObject);
                    if (l == Long.MIN_VALUE || Math.abs(l) > 0xFFFFFFFFL) {
                        throw ruby.newRangeError("bignum too big to convert into 'unsigned long'");
                    }
                    n = (int)(l & 0xFFFFL);
                }
                Pack.encodeShortBigEndian(byteList, n);
            }
        };
        Pack.converters[83] = converter = new Converter(2){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeShortUnsignedBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n = iRubyObject == ruby.getNil() ? 0 : (int)(RubyNumeric.num2long(iRubyObject) & 0xFFFFL);
                Pack.encodeShortBigEndian(byteList, n);
            }
        };
        Pack.converters[110] = converter;
        Pack.converters[99] = new Converter(1){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                int n = byteBuffer.get();
                return ruby.newFixnum(n > 127 ? n - 256 : n);
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                byte by = iRubyObject == ruby.getNil() ? (byte)0 : (byte)(RubyNumeric.num2long(iRubyObject) & 0xFFL);
                byteList.append(by);
            }
        };
        Pack.converters[67] = new Converter(1){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(byteBuffer.get() & 0xFF);
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                byte by = iRubyObject == ruby.getNil() ? (byte)0 : (byte)(RubyNumeric.num2long(iRubyObject) & 0xFFL);
                byteList.append(by);
            }
        };
        Pack.converters[86] = new Converter(4){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeIntUnsignedLittleEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n = iRubyObject == ruby.getNil() ? 0 : (int)RubyNumeric.num2long(iRubyObject);
                Pack.encodeIntLittleEndian(byteList, n);
            }
        };
        Pack.converters[73] = converter = new Converter(4){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeIntUnsignedBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n = iRubyObject == ruby.getNil() ? 0 : (int)RubyNumeric.num2long(iRubyObject);
                Pack.encodeIntBigEndian(byteList, n);
            }
        };
        Pack.converters[76] = converter;
        Pack.converters[78] = converter;
        Pack.converters[108] = converter = new Converter(4){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeIntBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                int n;
                if (iRubyObject == ruby.getNil()) {
                    n = 0;
                } else {
                    long l = RubyNumeric.num2long(iRubyObject);
                    if (l == Long.MIN_VALUE || Math.abs(l) > 0xFFFFFFFFL) {
                        throw ruby.newRangeError("bignum too big to convert into 'unsigned long'");
                    }
                    n = (int)l;
                }
                Pack.encodeIntBigEndian(byteList, n);
            }
        };
        Pack.converters[105] = converter;
        Pack.converters[81] = converter = new Converter(8){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                long l = Pack.decodeLongBigEndian(byteBuffer);
                return RubyBignum.bignorm(ruby, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                long l = Pack.num2quad(iRubyObject);
                Pack.encodeLongBigEndian(byteList, l);
            }
        };
        Pack.converters[113] = converter = new Converter(8){

            public IRubyObject decode(Ruby ruby, ByteBuffer byteBuffer) {
                return ruby.newFixnum(Pack.decodeLongBigEndian(byteBuffer));
            }

            public void encode(Ruby ruby, IRubyObject iRubyObject, ByteList byteList) {
                long l = Pack.num2quad(iRubyObject);
                Pack.encodeLongBigEndian(byteList, l);
            }
        };
        utf8_limits = new long[]{0L, 128L, 2048L, 65536L, 0x200000L, 0x4000000L, Integer.MIN_VALUE};
    }

    public static abstract class Converter {
        public int size;

        public Converter(int n) {
            this.size = n;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }
}

