/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime.marshal;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyArray;
import org.jruby.nb.nb.RubyBignum;
import org.jruby.nb.nb.RubyClass;
import org.jruby.nb.nb.RubyFixnum;
import org.jruby.nb.nb.RubyFloat;
import org.jruby.nb.nb.RubyHash;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.RubyObject;
import org.jruby.nb.nb.RubyRegexp;
import org.jruby.nb.nb.RubyString;
import org.jruby.nb.nb.RubyStruct;
import org.jruby.nb.nb.RubySymbol;
import org.jruby.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.runtime.builtin.Variable;
import org.jruby.nb.nb.runtime.component.VariableEntry;
import org.jruby.nb.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.nb.runtime.marshal.UnmarshalCache;
import org.jruby.util.ByteList;

public class UnmarshalStream
extends BufferedInputStream {
    protected final Ruby runtime;
    private final UnmarshalCache cache;
    private final IRubyObject proc;

    public UnmarshalStream(Ruby ruby, InputStream inputStream, IRubyObject iRubyObject) throws IOException {
        super(inputStream);
        this.runtime = ruby;
        this.cache = new UnmarshalCache(ruby);
        this.proc = iRubyObject;
        inputStream.read();
        inputStream.read();
    }

    public IRubyObject unmarshalObject() throws IOException {
        int n = this.readUnsignedByte();
        IRubyObject iRubyObject = this.cache.isLinkType(n) ? this.cache.readLink(this, n) : this.unmarshalObjectDirectly(n);
        return iRubyObject;
    }

    public void registerLinkTarget(IRubyObject iRubyObject) {
        if (MarshalStream.shouldBeRegistered(iRubyObject)) {
            this.cache.register(iRubyObject);
        }
    }

    public static RubyModule getModuleFromPath(Ruby ruby, String string) {
        RubyModule rubyModule = ruby.getClassFromPath(string);
        if (!rubyModule.isModule()) {
            throw ruby.newArgumentError(string + " does not refer module");
        }
        return rubyModule;
    }

    public static RubyClass getClassFromPath(Ruby ruby, String string) {
        RubyModule rubyModule = ruby.getClassFromPath(string);
        if (!rubyModule.isClass()) {
            throw ruby.newArgumentError(string + " does not refer class");
        }
        return (RubyClass)rubyModule;
    }

    private IRubyObject unmarshalObjectDirectly(int n) throws IOException {
        IRubyObject iRubyObject = null;
        switch (n) {
            case 73: {
                iRubyObject = this.unmarshalObject();
                this.defaultVariablesUnmarshal(iRubyObject);
                break;
            }
            case 48: {
                iRubyObject = this.runtime.getNil();
                break;
            }
            case 84: {
                iRubyObject = this.runtime.getTrue();
                break;
            }
            case 70: {
                iRubyObject = this.runtime.getFalse();
                break;
            }
            case 34: {
                iRubyObject = RubyString.unmarshalFrom(this);
                break;
            }
            case 105: {
                iRubyObject = RubyFixnum.unmarshalFrom(this);
                break;
            }
            case 102: {
                iRubyObject = RubyFloat.unmarshalFrom(this);
                break;
            }
            case 47: {
                iRubyObject = RubyRegexp.unmarshalFrom(this);
                break;
            }
            case 58: {
                iRubyObject = RubySymbol.unmarshalFrom(this);
                break;
            }
            case 91: {
                iRubyObject = RubyArray.unmarshalFrom(this);
                break;
            }
            case 123: {
                iRubyObject = RubyHash.unmarshalFrom(this, false);
                break;
            }
            case 125: {
                iRubyObject = RubyHash.unmarshalFrom(this, true);
                break;
            }
            case 99: {
                iRubyObject = RubyClass.unmarshalFrom(this);
                break;
            }
            case 109: {
                iRubyObject = RubyModule.unmarshalFrom(this);
                break;
            }
            case 101: {
                RubySymbol rubySymbol = (RubySymbol)this.unmarshalObject();
                RubyModule rubyModule = null;
                try {
                    rubyModule = this.runtime.getClassFromPath(rubySymbol.asJavaString());
                }
                catch (RaiseException raiseException) {
                    if (this.runtime.fastGetModule("NameError").isInstance(raiseException.getException())) {
                        throw this.runtime.newArgumentError("undefined class/module " + rubySymbol.asJavaString());
                    }
                    throw raiseException;
                }
                iRubyObject = this.unmarshalObject();
                rubyModule.extend_object(iRubyObject);
                rubyModule.callMethod(this.runtime.getCurrentContext(), "extended", iRubyObject);
                break;
            }
            case 108: {
                iRubyObject = RubyBignum.unmarshalFrom(this);
                break;
            }
            case 83: {
                iRubyObject = RubyStruct.unmarshalFrom(this);
                break;
            }
            case 111: {
                iRubyObject = this.defaultObjectUnmarshal();
                break;
            }
            case 117: {
                iRubyObject = this.userUnmarshal();
                break;
            }
            case 85: {
                iRubyObject = this.userNewUnmarshal();
                break;
            }
            case 67: {
                iRubyObject = this.uclassUnmarshall();
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError("dump format error(" + (char)n + ")");
            }
        }
        if (this.proc != null && n != 58) {
            RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this.proc, "call", iRubyObject);
        }
        return iRubyObject;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return n;
    }

    public byte readSignedByte() throws IOException {
        int n = this.readUnsignedByte();
        if (n > 127) {
            return (byte)(n - 256);
        }
        return (byte)n;
    }

    public ByteList unmarshalString() throws IOException {
        int n = this.unmarshalInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && (n2 = this.read()) != -1) {
            byArray[n3++] = (byte)n2;
        }
        if (n3 < n) {
            throw this.getRuntime().newArgumentError("marshal data too short");
        }
        return new ByteList(byArray, false);
    }

    public int unmarshalInt() throws IOException {
        long l;
        int n = this.readSignedByte();
        if (n == 0) {
            return 0;
        }
        if (5 < n && n < 128) {
            return n - 5;
        }
        if (-129 < n && n < -5) {
            return n + 5;
        }
        if (n > 0) {
            l = 0L;
            for (int i = 0; i < n; ++i) {
                l |= (long)this.readUnsignedByte() << 8 * i;
            }
        } else {
            n = -n;
            l = -1L;
            for (int i = 0; i < n; ++i) {
                l &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                l |= (long)this.readUnsignedByte() << 8 * i;
            }
        }
        return (int)l;
    }

    private IRubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol rubySymbol = (RubySymbol)this.unmarshalObject();
        RubyClass rubyClass = null;
        try {
            rubyClass = UnmarshalStream.getClassFromPath(this.runtime, rubySymbol.toString());
        }
        catch (RaiseException raiseException) {
            if (this.runtime.fastGetModule("NameError").isInstance(raiseException.getException())) {
                throw this.runtime.newArgumentError("undefined class/module " + rubySymbol.asJavaString());
            }
            throw raiseException;
        }
        assert (rubyClass != null) : "type shouldn't be null.";
        IRubyObject iRubyObject = (IRubyObject)rubyClass.unmarshal(this);
        return iRubyObject;
    }

    public void defaultVariablesUnmarshal(IRubyObject iRubyObject) throws IOException {
        int n = this.unmarshalInt();
        ArrayList<Variable<IRubyObject>> arrayList = new ArrayList<Variable<IRubyObject>>(n);
        int n2 = n;
        while (--n2 >= 0) {
            String string = this.unmarshalObject().asJavaString();
            IRubyObject iRubyObject2 = this.unmarshalObject();
            arrayList.add(new VariableEntry<IRubyObject>(string, iRubyObject2));
        }
        iRubyObject.syncVariables(arrayList);
    }

    private IRubyObject uclassUnmarshall() throws IOException {
        RubySymbol rubySymbol = (RubySymbol)this.unmarshalObject();
        RubyClass rubyClass = (RubyClass)this.runtime.getClassFromPath(rubySymbol.asJavaString());
        RubyObject rubyObject = (RubyObject)this.unmarshalObject();
        rubyObject.setMetaClass(rubyClass);
        return rubyObject;
    }

    private IRubyObject userUnmarshal() throws IOException {
        String string = this.unmarshalObject().asJavaString();
        ByteList byteList = this.unmarshalString();
        RubyClass rubyClass = this.findClass(string);
        if (!rubyClass.respondsTo("_load")) {
            throw this.runtime.newTypeError("class " + rubyClass.getName() + " needs to have method `_load'");
        }
        IRubyObject iRubyObject = rubyClass.callMethod(this.getRuntime().getCurrentContext(), "_load", RubyString.newString(this.getRuntime(), byteList));
        this.registerLinkTarget(iRubyObject);
        return iRubyObject;
    }

    private IRubyObject userNewUnmarshal() throws IOException {
        String string = this.unmarshalObject().asJavaString();
        RubyClass rubyClass = this.findClass(string);
        IRubyObject iRubyObject = rubyClass.allocate();
        this.registerLinkTarget(iRubyObject);
        IRubyObject iRubyObject2 = this.unmarshalObject();
        iRubyObject.callMethod(this.getRuntime().getCurrentContext(), "marshal_load", iRubyObject2);
        return iRubyObject;
    }

    private RubyClass findClass(String string) {
        RubyModule rubyModule;
        try {
            rubyModule = this.runtime.getClassFromPath(string);
        }
        catch (RaiseException raiseException) {
            if (this.runtime.getModule("NameError").isInstance(raiseException.getException())) {
                throw this.runtime.newArgumentError("undefined class/module " + string);
            }
            throw raiseException;
        }
        if (!(rubyModule instanceof RubyClass)) {
            throw this.runtime.newArgumentError(string + " does not refer class");
        }
        return (RubyClass)rubyModule;
    }
}

