/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime;

import java.util.List;
import org.jruby.nb.nb.Ruby;
import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.nb.nb.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.runtime.Arity;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodFactory {
    public static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
    private static final boolean reflection;
    private static final boolean dumping;
    private static final String dumpingPath;

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath, classLoader);
        }
        return new InvocationMethodFactory(classLoader);
    }

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getCompiledMethodLazily(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, List<JavaMethodDescriptor> var2);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, JavaMethodDescriptor var2);

    @Deprecated
    public abstract void defineIndexedAnnotatedMethods(RubyModule var1, Class var2, MethodDefiningCallback var3);

    static {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        if (Ruby.isSecurityRestricted()) {
            bl = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                bl = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                bl2 = true;
                string = SafePropertyAccessor.getProperty("jruby.dump_invocations");
            }
        }
        reflection = bl;
        dumping = bl2;
        dumpingPath = string;
    }

    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, JavaMethodDescriptor var2, DynamicMethod var3);
    }
}

