/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.runtime;

import org.jruby.nb.nb.RubyModule;
import org.jruby.nb.nb.internal.runtime.JumpTarget;
import org.jruby.nb.nb.runtime.Block;
import org.jruby.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.runtime.builtin.IRubyObject;

public final class Frame
implements JumpTarget {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block = Block.NULL_BLOCK;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private final JumpTarget jumpTarget;
    private BackrefAndLastline backrefAndLastline;
    private String fileName;
    private int line;

    public Frame() {
        this.jumpTarget = this;
    }

    private Frame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.jumpTarget = frame.jumpTarget;
        frame.lazyBackrefAndLastline();
        this.backrefAndLastline = frame.backrefAndLastline;
    }

    public void updateFrame(String string, int n) {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, string, n);
    }

    public void updateFrame(String string, String string2, int n) {
        this.name = string;
        this.fileName = string2;
        this.line = n;
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        frame.lazyBackrefAndLastline();
        this.backrefAndLastline = frame.backrefAndLastline;
    }

    public void updateFrame(RubyModule rubyModule, IRubyObject iRubyObject, String string, Block block, String string2, int n) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = iRubyObject;
        this.name = string;
        this.klazz = rubyModule;
        this.fileName = string2;
        this.line = n;
        this.block = block;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
        this.backrefAndLastline = null;
    }

    public void updateFrameForEval(IRubyObject iRubyObject, String string, int n) {
        this.self = iRubyObject;
        this.name = null;
        this.fileName = string;
        this.line = n;
        this.visibility = Visibility.PRIVATE;
        this.isBindingFrame = false;
        this.backrefAndLastline = null;
    }

    public void clear() {
        this.self = null;
        this.klazz = null;
        this.block = Block.NULL_BLOCK;
        this.backrefAndLastline = null;
    }

    public Frame duplicate() {
        Frame frame = new Frame(this);
        frame.updateFrame(this);
        return frame;
    }

    public JumpTarget getJumpTarget() {
        return this.jumpTarget;
    }

    @Deprecated
    public void setJumpTarget(JumpTarget jumpTarget) {
    }

    public IRubyObject getBackRef() {
        if (this.hasBackref()) {
            return this.self.getRuntime().getNil();
        }
        return this.backrefAndLastline.backref;
    }

    private boolean hasBackref() {
        return this.backrefAndLastline == null || this.backrefAndLastline.backref == null;
    }

    public IRubyObject setBackRef(IRubyObject iRubyObject) {
        this.lazyBackrefAndLastline();
        this.backrefAndLastline.backref = iRubyObject;
        return this.backrefAndLastline.backref;
    }

    public IRubyObject getLastLine() {
        if (this.hasLastline()) {
            return this.self.getRuntime().getNil();
        }
        return this.backrefAndLastline.lastline;
    }

    private boolean hasLastline() {
        return this.backrefAndLastline == null || this.backrefAndLastline.lastline == null;
    }

    public IRubyObject setLastLine(IRubyObject iRubyObject) {
        this.lazyBackrefAndLastline();
        this.backrefAndLastline.lastline = iRubyObject;
        return this.backrefAndLastline.lastline;
    }

    private void lazyBackrefAndLastline() {
        if (this.backrefAndLastline == null) {
            this.backrefAndLastline = new BackrefAndLastline();
        }
    }

    public String getFile() {
        return this.fileName;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule rubyModule) {
        this.klazz = rubyModule;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject iRubyObject) {
        this.self = iRubyObject;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean bl) {
        this.isBindingFrame = bl;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.fileName).append(':').append(this.line + 1).append(':').append(this.klazz);
        if (this.name != null) {
            stringBuilder.append(" in ").append(this.name);
        }
        return stringBuilder.toString();
    }

    private static class BackrefAndLastline {
        public IRubyObject backref;
        public IRubyObject lastline;

        private BackrefAndLastline() {
        }
    }
}

