/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.runtime.callback;

import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.exceptions.MainExitException;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.exceptions.ThreadKill;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.callback.InvocationCallback;

public abstract class FastInvocationCallback
extends InvocationCallback {
    public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        if (this.arityValue >= 0) {
            if (iRubyObjectArray.length != this.arityValue) {
                throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + this.arityValue + ")");
            }
        } else if (iRubyObjectArray.length < -(1 + this.arityValue)) {
            throw iRubyObject.getRuntime().newArgumentError("wrong number of arguments(" + iRubyObjectArray.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(iRubyObject, iRubyObjectArray);
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (JumpException jumpException) {
            throw jumpException;
        }
        catch (ThreadKill threadKill) {
            throw threadKill;
        }
        catch (MainExitException mainExitException) {
            throw mainExitException;
        }
        catch (Exception exception) {
            Ruby ruby = iRubyObject.getRuntime();
            ruby.getJavaSupport().handleNativeException(exception);
            return ruby.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2);
}

