/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.runtime;

import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.nb.runtime.Frame;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public class Binding {
    private final Frame frame;
    private final RubyModule klass;
    private Visibility visibility;
    private IRubyObject self;
    private final DynamicScope dynamicScope;

    public Binding(IRubyObject iRubyObject, Frame frame, Visibility visibility, RubyModule rubyModule, DynamicScope dynamicScope) {
        this.self = iRubyObject;
        this.frame = frame.duplicate();
        this.visibility = visibility;
        this.klass = rubyModule;
        this.dynamicScope = dynamicScope;
    }

    public Binding(Frame frame, RubyModule rubyModule, DynamicScope dynamicScope) {
        this.self = frame.getSelf();
        this.frame = frame.duplicate();
        this.visibility = frame.getVisibility();
        this.klass = rubyModule;
        this.dynamicScope = dynamicScope;
    }

    public Binding cloneBinding() {
        Binding binding = new Binding(this.self, this.frame.duplicate(), this.visibility, this.klass, this.dynamicScope.cloneScope());
        return binding;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject iRubyObject) {
        this.self = iRubyObject;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }
}

