/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.libraries;

import java.io.IOException;
import java.util.LinkedList;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyThread;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.load.Library;

public class ThreadLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) throws IOException {
        Mutex.setup(ruby);
        ConditionVariable.setup(ruby);
        Queue.setup(ruby);
        SizedQueue.setup(ruby);
    }

    static boolean wait_timeout(IRubyObject iRubyObject, Double d) throws InterruptedException {
        if (d != null) {
            long l;
            long l2 = (long)(d * 1.0E9);
            long l3 = System.nanoTime();
            if (l2 > 0L) {
                l = l2 / 1000000L;
                int n = (int)(l2 % 1000000L);
                iRubyObject.wait(l, n);
            }
            return (l = System.nanoTime()) - l3 <= l2;
        }
        iRubyObject.wait();
        return true;
    }

    @JRubyClass(name={"SizedQueue"}, parent="Queue")
    public static class SizedQueue
    extends Queue {
        private int capacity = 1;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            SizedQueue sizedQueue = new SizedQueue(threadContext.getRuntime(), (RubyClass)iRubyObject);
            sizedQueue.callInit(iRubyObjectArray, block);
            return sizedQueue;
        }

        public SizedQueue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("SizedQueue", ruby.fastGetClass("Queue"), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new SizedQueue(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(SizedQueue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear(ThreadContext threadContext) {
            super.clear(threadContext);
            this.notifyAll();
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized RubyNumeric max(ThreadContext threadContext) {
            return RubyNumeric.int2fix(threadContext.getRuntime(), this.capacity);
        }

        @JRubyMethod(name={"max=", "initialize"})
        public synchronized IRubyObject max_set(ThreadContext threadContext, IRubyObject iRubyObject) {
            int n = RubyNumeric.fix2int(iRubyObject);
            if (n <= 0) {
                threadContext.getRuntime().newArgumentError("queue size must be positive");
            }
            int n2 = n > this.capacity ? n - this.capacity : 0;
            this.capacity = n;
            if (n2 > 0) {
                this.notifyAll();
            }
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject = super.pop(threadContext, iRubyObjectArray);
            this.notifyAll();
            return iRubyObject;
        }

        @JRubyMethod(name={"push", "<<"})
        public synchronized IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (this.java_length() >= (long)this.capacity) {
                ++this.numWaiting;
                while (this.java_length() >= (long)this.capacity) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                --this.numWaiting;
            }
            super.push(threadContext, iRubyObject);
            this.notifyAll();
            return threadContext.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Queue"})
    public static class Queue
    extends RubyObject {
        private LinkedList entries = new LinkedList();
        protected volatile int numWaiting = 0;

        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Queue queue = new Queue(threadContext.getRuntime(), (RubyClass)iRubyObject);
            queue.callInit(iRubyObjectArray, block);
            return queue;
        }

        public Queue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Queue", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Queue(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(Queue.class);
        }

        @JRubyMethod
        public synchronized IRubyObject clear(ThreadContext threadContext) {
            this.entries.clear();
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(name={"empty?"})
        public synchronized RubyBoolean empty_p(ThreadContext threadContext) {
            return threadContext.getRuntime().newBoolean(this.entries.size() == 0);
        }

        @JRubyMethod(name={"length", "size"})
        public synchronized RubyNumeric length(ThreadContext threadContext) {
            return RubyNumeric.int2fix(threadContext.getRuntime(), this.entries.size());
        }

        protected synchronized long java_length() {
            return this.entries.size();
        }

        @JRubyMethod
        public RubyNumeric num_waiting(ThreadContext threadContext) {
            return threadContext.getRuntime().newFixnum(this.numWaiting);
        }

        @JRubyMethod(name={"pop", "deq", "shift"}, optional=1)
        public synchronized IRubyObject pop(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            boolean bl = true;
            if (Arity.checkArgumentCount(threadContext.getRuntime(), iRubyObjectArray, 0, 1) == 1) {
                boolean bl2 = bl = !iRubyObjectArray[0].isTrue();
            }
            if (!bl && this.entries.size() == 0) {
                throw new RaiseException(threadContext.getRuntime(), threadContext.getRuntime().getThreadError(), "queue empty", false);
            }
            ++this.numWaiting;
            while (this.entries.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.numWaiting;
            return (IRubyObject)this.entries.removeFirst();
        }

        @JRubyMethod(name={"push", "<<", "enq"})
        public synchronized IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.entries.addLast(iRubyObject);
            this.notify();
            return threadContext.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"ConditionVariable"})
    public static class ConditionVariable
    extends RubyObject {
        @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
        public static ConditionVariable newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            ConditionVariable conditionVariable = new ConditionVariable(threadContext.getRuntime(), (RubyClass)iRubyObject);
            conditionVariable.callInit(iRubyObjectArray, block);
            return conditionVariable;
        }

        public ConditionVariable(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("ConditionVariable", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new ConditionVariable(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(ConditionVariable.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"wait"}, required=1, optional=1)
        public IRubyObject wait_ruby(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) throws InterruptedException {
            if (iRubyObjectArray.length < 1) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            if (iRubyObjectArray.length > 2) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            if (!(iRubyObjectArray[0] instanceof Mutex)) {
                throw threadContext.getRuntime().newTypeError(iRubyObjectArray[0], threadContext.getRuntime().fastGetClass("Mutex"));
            }
            Mutex mutex = (Mutex)iRubyObjectArray[0];
            Double d = null;
            if (iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil()) {
                d = iRubyObjectArray[1].convertToFloat().getDoubleValue();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean bl = false;
            try {
                ConditionVariable conditionVariable = this;
                synchronized (conditionVariable) {
                    mutex.unlock(threadContext);
                    try {
                        bl = ThreadLibrary.wait_timeout(this, d);
                        Object var8_7 = null;
                        if (!bl) {
                            this.notify();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (!bl) {
                            this.notify();
                        }
                        throw throwable;
                    }
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                mutex.lock(threadContext);
                throw throwable;
            }
            mutex.lock(threadContext);
            if (d != null) {
                return threadContext.getRuntime().newBoolean(bl);
            }
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject broadcast(ThreadContext threadContext) {
            this.notifyAll();
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public synchronized IRubyObject signal(ThreadContext threadContext) {
            this.notify();
            return threadContext.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"Mutex"})
    public static class Mutex
    extends RubyObject {
        private RubyThread owner = null;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static Mutex newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Mutex mutex = new Mutex(threadContext.getRuntime(), (RubyClass)iRubyObject);
            mutex.callInit(iRubyObjectArray, block);
            return mutex;
        }

        public Mutex(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Mutex", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Mutex(ruby, rubyClass);
                }
            });
            rubyClass.defineAnnotatedMethods(Mutex.class);
        }

        @JRubyMethod(name={"locked?"})
        public synchronized RubyBoolean locked_p(ThreadContext threadContext) {
            return threadContext.getRuntime().newBoolean(this.owner != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public RubyBoolean try_lock(ThreadContext threadContext) throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner != null) {
                    return threadContext.getRuntime().getFalse();
                }
                this.lock(threadContext);
            }
            return threadContext.getRuntime().getTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject lock(ThreadContext threadContext) throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                try {
                    while (this.owner != null) {
                        this.wait();
                    }
                    this.owner = threadContext.getThread();
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
            return this;
        }

        @JRubyMethod
        public synchronized RubyBoolean unlock(ThreadContext threadContext) {
            if (this.owner != null) {
                this.owner = null;
                this.notify();
                return threadContext.getRuntime().getTrue();
            }
            return threadContext.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public IRubyObject synchronize(ThreadContext threadContext, Block block) throws InterruptedException {
            IRubyObject iRubyObject;
            try {
                this.lock(threadContext);
                iRubyObject = block.yield(threadContext, null);
                Object var5_4 = null;
                this.unlock(threadContext);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.unlock(threadContext);
                throw throwable;
            }
            return iRubyObject;
        }
    }
}

