/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.javasupport.proxy.InternalJavaProxy;
import org.jruby.nb.nb.nb.javasupport.proxy.InternalJavaProxyHelper;
import org.jruby.nb.nb.nb.javasupport.proxy.JavaProxyClass;
import org.jruby.nb.nb.nb.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.nb.nb.nb.javasupport.proxy.JavaProxyMethod;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class JavaProxyClassFactory {
    private static final Type JAVA_LANG_CLASS_TYPE = Type.getType(Class.class);
    private static final Type[] EMPTY_TYPE_ARR = new Type[0];
    private static final Method HELPER_GET_PROXY_CLASS_METHOD = Method.getMethod((String)(JavaProxyClass.class.getName() + " initProxyClass(java.lang.Class)"));
    private static final Method CLASS_FORNAME_METHOD = Method.getMethod((String)"java.lang.Class forName(java.lang.String)");
    private static final String INVOCATION_HANDLER_FIELD_NAME = "__handler";
    private static final String PROXY_CLASS_FIELD_NAME = "__proxy_class";
    private static final Class[] EMPTY_CLASS_ARR = new Class[0];
    private static final Type INVOCATION_HANDLER_TYPE = Type.getType(JavaProxyInvocationHandler.class);
    private static final Type PROXY_METHOD_TYPE = Type.getType(JavaProxyMethod.class);
    private static final Type PROXY_CLASS_TYPE = Type.getType(JavaProxyClass.class);
    private static final Method INVOCATION_HANDLER_INVOKE_METHOD = Method.getMethod((String)("java.lang.Object invoke(java.lang.Object, " + PROXY_METHOD_TYPE.getClassName() + ", java.lang.Object[])"));
    private static final Type PROXY_HELPER_TYPE = Type.getType(InternalJavaProxyHelper.class);
    private static final Method PROXY_HELPER_GET_METHOD = Method.getMethod((String)(PROXY_METHOD_TYPE.getClassName() + " initProxyMethod(" + JavaProxyClass.class.getName() + ",java.lang.String,java.lang.String,boolean)"));
    private static final Type JAVA_PROXY_TYPE = Type.getType(InternalJavaProxy.class);
    private static int counter;
    private static Map proxies;
    private static java.lang.reflect.Method defineClass_method;

    private static synchronized int nextId() {
        return counter++;
    }

    @Deprecated
    static JavaProxyClass newProxyClass(ClassLoader classLoader, String string, Class clazz, Class[] classArray, Set set) throws InvocationTargetException {
        return JavaProxyClassFactory.newProxyClass(JavaProxyClass.runtimeTLS.get(), classLoader, string, clazz, classArray, set);
    }

    static JavaProxyClass newProxyClass(Ruby ruby, ClassLoader classLoader, String string, Class clazz, Class[] classArray, Set set) throws InvocationTargetException {
        JavaProxyClass javaProxyClass;
        if (classLoader == null) {
            classLoader = JavaProxyClassFactory.class.getClassLoader();
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        if (classArray == null) {
            classArray = EMPTY_CLASS_ARR;
        }
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(clazz);
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.add(classArray[i]);
        }
        if (set != null) {
            hashSet.addAll(set);
        }
        if ((javaProxyClass = (JavaProxyClass)proxies.get(hashSet)) == null) {
            Object object;
            Object object2;
            if (string == null) {
                object2 = JavaProxyClassFactory.proxyPackageName(clazz);
                object = clazz.getName();
                int n = ((String)object).lastIndexOf(46);
                String string2 = object;
                if (n != -1) {
                    string2 = ((String)object).substring(n + 1);
                }
                string = (String)object2 + "." + string2 + "$Proxy" + JavaProxyClassFactory.nextId();
            }
            JavaProxyClassFactory.validateArgs(ruby, string, clazz);
            object2 = new HashMap();
            JavaProxyClassFactory.collectMethods(clazz, classArray, (Map)object2, set);
            object = Type.getType("L" + JavaProxyClassFactory.toInternalClassName(string) + ";");
            javaProxyClass = JavaProxyClassFactory.generate(classLoader, string, clazz, classArray, (Map)object2, (Type)object);
            proxies.put(hashSet, javaProxyClass);
        }
        return javaProxyClass;
    }

    static JavaProxyClass newProxyClass(ClassLoader classLoader, String string, Class clazz, Class[] classArray) throws InvocationTargetException {
        return JavaProxyClassFactory.newProxyClass(classLoader, string, clazz, classArray, null);
    }

    private static JavaProxyClass generate(ClassLoader classLoader, String string, Class clazz, Class[] classArray, Map map, Type type) {
        ClassWriter classWriter = JavaProxyClassFactory.beginProxyClass(string, clazz, classArray);
        GeneratorAdapter generatorAdapter = JavaProxyClassFactory.createClassInitializer(type, classWriter);
        JavaProxyClassFactory.generateConstructors(clazz, type, classWriter);
        JavaProxyClassFactory.generateGetProxyClass(type, classWriter);
        JavaProxyClassFactory.generateGetInvocationHandler(type, classWriter);
        JavaProxyClassFactory.generateProxyMethods(clazz, map, type, classWriter, generatorAdapter);
        generatorAdapter.returnValue();
        generatorAdapter.endMethod();
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        Class clazz2 = JavaProxyClassFactory.invokeDefineClass(classLoader, type.getClassName(), byArray);
        try {
            Field field = clazz2.getDeclaredField(PROXY_CLASS_FIELD_NAME);
            field.setAccessible(true);
            return (JavaProxyClass)field.get(clazz2);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError();
            internalError.initCause(exception);
            throw internalError;
        }
    }

    private static Class invokeDefineClass(ClassLoader classLoader, String string, byte[] byArray) {
        try {
            return (Class)defineClass_method.invoke((Object)classLoader, string, byArray, new Integer(0), new Integer(byArray.length), JavaProxyClassFactory.class.getProtectionDomain());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    private static ClassWriter beginProxyClass(String string, Class clazz, Class[] classArray) {
        ClassWriter classWriter = new ClassWriter(1);
        int n = 25;
        String string2 = JavaProxyClassFactory.toInternalClassName(string);
        String string3 = null;
        String string4 = JavaProxyClassFactory.toInternalClassName(clazz);
        String[] stringArray = new String[classArray.length + 1];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = JavaProxyClassFactory.toInternalClassName(classArray[i]);
        }
        stringArray[classArray.length] = JavaProxyClassFactory.toInternalClassName(InternalJavaProxy.class);
        classWriter.visit(47, n, string2, string3, string4, stringArray);
        classWriter.visitField(2, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE.getDescriptor(), null, null).visitEnd();
        classWriter.visitField(10, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE.getDescriptor(), null, null).visitEnd();
        return classWriter;
    }

    private static void generateProxyMethods(Class clazz, Map map, Type type, ClassVisitor classVisitor, GeneratorAdapter generatorAdapter) {
        for (MethodData methodData : map.values()) {
            Type type2 = Type.getType(clazz);
            JavaProxyClassFactory.generateProxyMethod(type, type2, classVisitor, generatorAdapter, methodData);
        }
    }

    private static void generateGetInvocationHandler(Type type, ClassVisitor classVisitor) {
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(1, new Method("___getInvocationHandler", INVOCATION_HANDLER_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, classVisitor);
        generatorAdapter.loadThis();
        generatorAdapter.getField(type, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        generatorAdapter.returnValue();
        generatorAdapter.endMethod();
    }

    private static void generateGetProxyClass(Type type, ClassVisitor classVisitor) {
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(1, new Method("___getProxyClass", PROXY_CLASS_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, classVisitor);
        generatorAdapter.getStatic(type, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        generatorAdapter.returnValue();
        generatorAdapter.endMethod();
    }

    private static void generateConstructors(Class clazz, Type type, ClassVisitor classVisitor) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            int n = constructor.getModifiers();
            if (!Modifier.isProtected(n) && !Modifier.isPublic(n) && (Modifier.isPrivate(n) || !JavaProxyClassFactory.packageName(constructor.getDeclaringClass()).equals(JavaProxyClassFactory.packageName(type.getClassName())))) continue;
            JavaProxyClassFactory.generateConstructor(type, constructor, classVisitor);
        }
    }

    private static GeneratorAdapter createClassInitializer(Type type, ClassVisitor classVisitor) {
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(10, new Method("<clinit>", Type.VOID_TYPE, EMPTY_TYPE_ARR), null, EMPTY_TYPE_ARR, classVisitor);
        generatorAdapter.visitLdcInsn((Object)type.getClassName());
        generatorAdapter.invokeStatic(JAVA_LANG_CLASS_TYPE, CLASS_FORNAME_METHOD);
        generatorAdapter.invokeStatic(PROXY_HELPER_TYPE, HELPER_GET_PROXY_CLASS_METHOD);
        generatorAdapter.dup();
        generatorAdapter.putStatic(type, PROXY_CLASS_FIELD_NAME, PROXY_CLASS_TYPE);
        return generatorAdapter;
    }

    private static void generateProxyMethod(Type type, Type type2, ClassVisitor classVisitor, GeneratorAdapter generatorAdapter, MethodData methodData) {
        Label label;
        if (!methodData.generateProxyMethod()) {
            return;
        }
        Method method = methodData.getMethod();
        Type[] typeArray = JavaProxyClassFactory.toType(methodData.getExceptions());
        String string = "__mth$" + methodData.getName() + methodData.scrambledSignature();
        FieldVisitor fieldVisitor = classVisitor.visitField(10, string, PROXY_METHOD_TYPE.getDescriptor(), null, null);
        fieldVisitor.visitEnd();
        generatorAdapter.dup();
        generatorAdapter.push(method.getName());
        generatorAdapter.push(method.getDescriptor());
        generatorAdapter.push(methodData.isImplemented());
        generatorAdapter.invokeStatic(PROXY_HELPER_TYPE, PROXY_HELPER_GET_METHOD);
        generatorAdapter.putStatic(type, string, PROXY_METHOD_TYPE);
        Method method2 = new Method("__super$" + method.getName(), method.getReturnType(), method.getArgumentTypes());
        GeneratorAdapter generatorAdapter2 = new GeneratorAdapter(1, method, null, typeArray, classVisitor);
        generatorAdapter2.loadThis();
        generatorAdapter2.getField(type, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        if (methodData.isImplemented()) {
            generatorAdapter2.dup();
            label = generatorAdapter2.newLabel();
            generatorAdapter2.ifNonNull(label);
            generatorAdapter2.loadThis();
            generatorAdapter2.loadArgs();
            generatorAdapter2.invokeConstructor(type2, method);
            generatorAdapter2.returnValue();
            generatorAdapter2.mark(label);
        }
        generatorAdapter2.loadThis();
        generatorAdapter2.getStatic(type, string, PROXY_METHOD_TYPE);
        if (method.getArgumentTypes().length == 0) {
            generatorAdapter2.getStatic(JAVA_PROXY_TYPE, "NO_ARGS", Type.getType(Object[].class));
        } else {
            generatorAdapter2.loadArgArray();
        }
        label = generatorAdapter2.mark();
        generatorAdapter2.invokeInterface(INVOCATION_HANDLER_TYPE, INVOCATION_HANDLER_INVOKE_METHOD);
        Label label2 = generatorAdapter2.mark();
        generatorAdapter2.unbox(method.getReturnType());
        generatorAdapter2.returnValue();
        Label label3 = generatorAdapter2.mark();
        generatorAdapter2.visitInsn(191);
        for (int i = 0; i < typeArray.length; ++i) {
            generatorAdapter2.visitTryCatchBlock(label, label2, label3, typeArray[i].getInternalName());
        }
        generatorAdapter2.visitTryCatchBlock(label, label2, label3, "java/lang/Error");
        generatorAdapter2.visitTryCatchBlock(label, label2, label3, "java/lang/RuntimeException");
        Type type3 = Type.getType(Throwable.class);
        Label label4 = generatorAdapter2.mark();
        Type type4 = Type.getType(UndeclaredThrowableException.class);
        int n = generatorAdapter2.newLocal(type3);
        generatorAdapter2.storeLocal(n, type3);
        generatorAdapter2.newInstance(type4);
        generatorAdapter2.dup();
        generatorAdapter2.loadLocal(n, type3);
        generatorAdapter2.invokeConstructor(type4, Method.getMethod((String)"void <init>(java.lang.Throwable)"));
        generatorAdapter2.throwException();
        generatorAdapter2.visitTryCatchBlock(label, label2, label4, "java/lang/Throwable");
        generatorAdapter2.endMethod();
        if (methodData.isImplemented()) {
            GeneratorAdapter generatorAdapter3 = new GeneratorAdapter(1, method2, null, typeArray, classVisitor);
            generatorAdapter3.loadThis();
            generatorAdapter3.loadArgs();
            generatorAdapter3.invokeConstructor(type2, method);
            generatorAdapter3.returnValue();
            generatorAdapter3.endMethod();
        }
    }

    private static Class[] generateConstructor(Type type, Constructor constructor, ClassVisitor classVisitor) {
        Class[] classArray = constructor.getParameterTypes();
        Class[] classArray2 = new Class[classArray.length + 1];
        System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
        classArray2[classArray.length] = JavaProxyInvocationHandler.class;
        int n = 1;
        String string = "<init>";
        String string2 = null;
        Class[] classArray3 = constructor.getExceptionTypes();
        Method method = new Method(string, Type.VOID_TYPE, JavaProxyClassFactory.toType(classArray));
        Method method2 = new Method(string, Type.VOID_TYPE, JavaProxyClassFactory.toType(classArray2));
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(n, method2, string2, JavaProxyClassFactory.toType(classArray3), classVisitor);
        generatorAdapter.loadThis();
        generatorAdapter.loadArgs(0, classArray.length);
        generatorAdapter.invokeConstructor(Type.getType(constructor.getDeclaringClass()), method);
        generatorAdapter.loadThis();
        generatorAdapter.loadArg(classArray.length);
        generatorAdapter.putField(type, INVOCATION_HANDLER_FIELD_NAME, INVOCATION_HANDLER_TYPE);
        generatorAdapter.returnValue();
        generatorAdapter.endMethod();
        return classArray2;
    }

    private static String toInternalClassName(Class clazz) {
        return JavaProxyClassFactory.toInternalClassName(clazz.getName());
    }

    private static String toInternalClassName(String string) {
        return string.replace('.', '/');
    }

    private static Type[] toType(Class[] classArray) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    private static void collectMethods(Class clazz, Class[] classArray, Map map, Set set) {
        HashSet hashSet = new HashSet();
        JavaProxyClassFactory.addClass(hashSet, map, clazz, set);
        JavaProxyClassFactory.addInterfaces(hashSet, map, classArray, set);
    }

    private static void addInterfaces(Set set, Map map, Class[] classArray, Set set2) {
        for (int i = 0; i < classArray.length; ++i) {
            JavaProxyClassFactory.addInterface(set, map, classArray[i], set2);
        }
    }

    private static void addInterface(Set set, Map map, Class clazz, Set set2) {
        if (set.add(clazz)) {
            JavaProxyClassFactory.addMethods(map, clazz, set2);
            JavaProxyClassFactory.addInterfaces(set, map, clazz.getInterfaces(), set2);
        }
    }

    private static void addMethods(Map map, Class clazz, Set set) {
        java.lang.reflect.Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (set != null && !set.contains(methodArray[i].getName())) continue;
            JavaProxyClassFactory.addMethod(map, methodArray[i]);
        }
    }

    private static void addMethod(Map map, java.lang.reflect.Method method) {
        int n = method.getModifiers();
        if (Modifier.isStatic(n) || Modifier.isPrivate(n)) {
            return;
        }
        MethodKey methodKey = new MethodKey(method);
        MethodData methodData = (MethodData)map.get(methodKey);
        if (methodData == null) {
            methodData = new MethodData(method);
            map.put(methodKey, methodData);
        }
        methodData.add(method);
    }

    private static void addClass(Set set, Map map, Class clazz, Set set2) {
        if (set.add(clazz)) {
            JavaProxyClassFactory.addMethods(map, clazz, set2);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                JavaProxyClassFactory.addClass(set, map, clazz2, set2);
            }
            JavaProxyClassFactory.addInterfaces(set, map, clazz.getInterfaces(), set2);
        }
    }

    private static void validateArgs(Ruby ruby, String string, Class clazz) {
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw ruby.newTypeError("cannot extend final class " + clazz.getName());
        }
        String string2 = JavaProxyClassFactory.packageName(string);
        String string3 = string2.replace('.', '/');
        if (string3.startsWith("java")) {
            throw ruby.newTypeError("cannot add classes to package " + string3);
        }
        Package package_ = Package.getPackage(string3);
        if (package_ != null && package_.isSealed()) {
            throw ruby.newTypeError("package " + package_ + " is sealed");
        }
    }

    private static String packageName(Class clazz) {
        String string = clazz.getName();
        return JavaProxyClassFactory.packageName(string);
    }

    private static String packageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private static String proxyPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "org.jruby.nb.nb.nb.proxy";
        }
        return "org.jruby.nb.nb.nb.proxy." + string.substring(0, n);
    }

    static {
        proxies = Collections.synchronizedMap(new HashMap());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    defineClass_method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                defineClass_method.setAccessible(true);
                return null;
            }
        });
    }

    static class MethodKey {
        private String name;
        private Class[] arguments;

        MethodKey(java.lang.reflect.Method method) {
            this.name = method.getName();
            this.arguments = method.getParameterTypes();
        }

        public boolean equals(Object object) {
            if (object instanceof MethodKey) {
                MethodKey methodKey = (MethodKey)object;
                return this.name.equals(methodKey.name) && Arrays.equals(this.arguments, methodKey.arguments);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    static class MethodData {
        Set methods = new HashSet();
        final java.lang.reflect.Method mostSpecificMethod;
        final Class[] mostSpecificParameterTypes;
        boolean hasPublicDecl = false;

        MethodData(java.lang.reflect.Method method) {
            this.mostSpecificMethod = method;
            this.mostSpecificParameterTypes = this.mostSpecificMethod.getParameterTypes();
            this.hasPublicDecl = method.getDeclaringClass().isInterface() || Modifier.isPublic(method.getModifiers());
        }

        public String scrambledSignature() {
            StringBuilder stringBuilder = new StringBuilder();
            Class[] classArray = this.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuilder.append('$');
                String string = classArray[i].getName();
                string = string.replace('[', '1');
                string = string.replace('.', '_');
                string = string.replace(';', '2');
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        public Class getDeclaringClass() {
            return this.mostSpecificMethod.getDeclaringClass();
        }

        public Method getMethod() {
            return new Method(this.getName(), Type.getType(this.getReturnType()), this.getType(this.getParameterTypes()));
        }

        private Type[] getType(Class[] classArray) {
            Type[] typeArray = new Type[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                typeArray[i] = Type.getType(classArray[i]);
            }
            return typeArray;
        }

        private String getName() {
            return this.mostSpecificMethod.getName();
        }

        private Class[] getParameterTypes() {
            return this.mostSpecificParameterTypes;
        }

        public Class[] getExceptions() {
            HashSet hashSet = new HashSet();
            for (java.lang.reflect.Method method : this.methods) {
                Class<?>[] classArray = method.getExceptionTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz = classArray[i];
                    if (hashSet.contains(clazz)) continue;
                    boolean bl = true;
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Class clazz2 = (Class)iterator.next();
                        if (clazz2.isAssignableFrom(clazz)) {
                            bl = false;
                            break;
                        }
                        if (!clazz.isAssignableFrom(clazz2)) continue;
                        iterator.remove();
                        bl = true;
                    }
                    if (!bl) continue;
                    hashSet.add(clazz);
                }
            }
            return hashSet.toArray(new Class[hashSet.size()]);
        }

        public boolean generateProxyMethod() {
            return !this.isFinal() && !this.isPrivate();
        }

        public void add(java.lang.reflect.Method method) {
            this.methods.add(method);
            this.hasPublicDecl |= Modifier.isPublic(method.getModifiers());
        }

        Class getReturnType() {
            return this.mostSpecificMethod.getReturnType();
        }

        boolean isFinal() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int n = this.mostSpecificMethod.getModifiers();
            return Modifier.isFinal(n);
        }

        boolean isPrivate() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int n = this.mostSpecificMethod.getModifiers();
            return Modifier.isPrivate(n);
        }

        boolean isImplemented() {
            if (this.mostSpecificMethod.getDeclaringClass().isInterface()) {
                return false;
            }
            int n = this.mostSpecificMethod.getModifiers();
            return !Modifier.isAbstract(n);
        }
    }
}

