/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.javasupport;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyInteger;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNil;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.RubyProc;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubyTime;
import org.jruby.nb.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.java.proxies.JavaProxy;
import org.jruby.nb.nb.nb.javasupport.Java;
import org.jruby.nb.nb.nb.javasupport.JavaClass;
import org.jruby.nb.nb.nb.javasupport.JavaConstructor;
import org.jruby.nb.nb.nb.javasupport.JavaField;
import org.jruby.nb.nb.nb.javasupport.JavaMethod;
import org.jruby.nb.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.TypeConverter;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtil {
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.isTrue();
        }
    };
    public static final RubyConverter RUBY_BYTE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Byte((byte)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Byte(0);
        }
    };
    public static final RubyConverter RUBY_SHORT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Short((short)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Short(0);
        }
    };
    public static final RubyConverter RUBY_CHAR_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Character((char)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Character('\u0000');
        }
    };
    public static final RubyConverter RUBY_INTEGER_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Integer((int)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Integer(0);
        }
    };
    public static final RubyConverter RUBY_LONG_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Long(((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Long(0L);
        }
    };
    public static final RubyConverter RUBY_FLOAT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_f")) {
                return new Float((float)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Float(0.0);
        }
    };
    public static final RubyConverter RUBY_DOUBLE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_f")) {
                return new Double(((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Double(0.0);
        }
    };
    public static final RubyConverter ARRAY_BOOLEAN_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject == threadContext.getRuntime().getFalse() || iRubyObject.isNil()) {
                return Boolean.FALSE;
            }
            if (iRubyObject == threadContext.getRuntime().getTrue()) {
                return Boolean.TRUE;
            }
            if (iRubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)iRubyObject).getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            if (iRubyObject instanceof RubyString) {
                return Boolean.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return rubyInteger.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_BYTE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return (byte)((RubyNumeric)iRubyObject).getLongValue();
            }
            if (iRubyObject instanceof RubyString) {
                return Byte.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return (byte)rubyInteger.getLongValue();
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_SHORT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return (short)((RubyNumeric)iRubyObject).getLongValue();
            }
            if (iRubyObject instanceof RubyString) {
                return Short.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return (short)rubyInteger.getLongValue();
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_CHAR_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return Character.valueOf((char)((RubyNumeric)iRubyObject).getLongValue());
            }
            if (iRubyObject instanceof RubyString) {
                return Character.valueOf(iRubyObject.asJavaString().charAt(0));
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return Character.valueOf((char)rubyInteger.getLongValue());
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_INT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return (int)((RubyNumeric)iRubyObject).getLongValue();
            }
            if (iRubyObject instanceof RubyString) {
                return Integer.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return (int)rubyInteger.getLongValue();
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_LONG_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)iRubyObject).getLongValue();
            }
            if (iRubyObject instanceof RubyString) {
                return Long.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return rubyInteger.getLongValue();
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_FLOAT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return Float.valueOf((float)((RubyNumeric)iRubyObject).getDoubleValue());
            }
            if (iRubyObject instanceof RubyString) {
                return Float.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return Float.valueOf((float)rubyInteger.getDoubleValue());
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_DOUBLE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)iRubyObject).getDoubleValue();
            }
            if (iRubyObject instanceof RubyString) {
                return Double.valueOf(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return rubyInteger.getDoubleValue();
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_OBJECT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyInteger) {
                long l = ((RubyInteger)iRubyObject).getLongValue();
                if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                if (l >= Long.MIN_VALUE && l <= Long.MAX_VALUE) {
                    return l;
                }
                return new BigInteger(iRubyObject.toString());
            }
            if (iRubyObject instanceof RubyFloat) {
                return ((RubyFloat)iRubyObject).getDoubleValue();
            }
            if (iRubyObject instanceof JavaProxy) {
                return ((JavaProxy)iRubyObject).unwrap();
            }
            return JavaUtil.java_to_ruby(threadContext.getRuntime(), iRubyObject);
        }
    };
    public static final RubyConverter ARRAY_CLASS_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof JavaClass) {
                return ((JavaClass)iRubyObject).javaClass();
            }
            return JavaUtil.java_to_ruby(threadContext.getRuntime(), iRubyObject);
        }
    };
    public static final RubyConverter ARRAY_STRING_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyString) {
                return ((RubyString)iRubyObject).getUnicodeValue();
            }
            return iRubyObject.toString();
        }
    };
    public static final RubyConverter ARRAY_BIGINTEGER_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)iRubyObject).getLongValue());
            }
            if (iRubyObject instanceof RubyString) {
                return new BigDecimal(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return BigInteger.valueOf(rubyInteger.getLongValue());
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_BIGDECIMAL_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyNumeric) {
                return BigDecimal.valueOf(((RubyNumeric)iRubyObject).getDoubleValue());
            }
            if (iRubyObject instanceof RubyString) {
                return new BigDecimal(iRubyObject.asJavaString());
            }
            if (iRubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
            }
            if (iRubyObject.respondsTo("to_f")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_f");
                return BigDecimal.valueOf(rubyInteger.getDoubleValue());
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyInteger rubyInteger = (RubyInteger)RuntimeHelpers.invoke(threadContext, iRubyObject, "to_i");
                return BigDecimal.valueOf(rubyInteger.getLongValue());
            }
            return JavaUtil.ruby_to_java(iRubyObject, iRubyObject, Block.NULL_BLOCK);
        }
    };
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final Map<Class, RubyConverter> ARRAY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final JavaConverter JAVA_DEFAULT_CONVERTER;
    public static final JavaConverter JAVA_BOOLEAN_CONVERTER;
    public static final JavaConverter JAVA_FLOAT_CONVERTER;
    public static final JavaConverter JAVA_DOUBLE_CONVERTER;
    public static final JavaConverter JAVA_CHAR_CONVERTER;
    public static final JavaConverter JAVA_BYTE_CONVERTER;
    public static final JavaConverter JAVA_SHORT_CONVERTER;
    public static final JavaConverter JAVA_INT_CONVERTER;
    public static final JavaConverter JAVA_LONG_CONVERTER;
    public static final JavaConverter JAVA_STRING_CONVERTER;
    public static final JavaConverter BYTELIST_CONVERTER;
    public static final JavaConverter JAVA_BIGINTEGER_CONVERTER;
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS;
    private static final Pattern JAVA_PROPERTY_CHOPPER;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Pattern RUBY_CASE_SPLITTER;

    public static Object convertRubyToJava(IRubyObject iRubyObject) {
        return JavaUtil.convertRubyToJava(iRubyObject, Object.class);
    }

    public static RubyConverter getArrayConverter(Class clazz) {
        RubyConverter rubyConverter = ARRAY_CONVERTERS.get(clazz);
        if (rubyConverter == null) {
            return ARRAY_OBJECT_CONVERTER;
        }
        return rubyConverter;
    }

    public static byte convertRubyToJavaByte(IRubyObject iRubyObject) {
        return (Byte)JavaUtil.convertRubyToJava(iRubyObject, Byte.TYPE);
    }

    public static short convertRubyToJavaShort(IRubyObject iRubyObject) {
        return (Short)JavaUtil.convertRubyToJava(iRubyObject, Short.TYPE);
    }

    public static char convertRubyToJavaChar(IRubyObject iRubyObject) {
        return ((Character)JavaUtil.convertRubyToJava(iRubyObject, Character.TYPE)).charValue();
    }

    public static int convertRubyToJavaInt(IRubyObject iRubyObject) {
        return (Integer)JavaUtil.convertRubyToJava(iRubyObject, Integer.TYPE);
    }

    public static long convertRubyToJavaLong(IRubyObject iRubyObject) {
        return (Long)JavaUtil.convertRubyToJava(iRubyObject, Long.TYPE);
    }

    public static float convertRubyToJavaFloat(IRubyObject iRubyObject) {
        return ((Float)JavaUtil.convertRubyToJava(iRubyObject, Float.TYPE)).floatValue();
    }

    public static double convertRubyToJavaDouble(IRubyObject iRubyObject) {
        return (Double)JavaUtil.convertRubyToJava(iRubyObject, Double.TYPE);
    }

    public static boolean convertRubyToJavaBoolean(IRubyObject iRubyObject) {
        return (Boolean)JavaUtil.convertRubyToJava(iRubyObject, Boolean.TYPE);
    }

    public static Object convertRubyToJava(IRubyObject iRubyObject, Class clazz) {
        if (clazz == Void.TYPE || iRubyObject == null || iRubyObject.isNil()) {
            return null;
        }
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        if (iRubyObject.dataGetStruct() instanceof JavaObject) {
            iRubyObject = (JavaObject)iRubyObject.dataGetStruct();
        } else if (iRubyObject.respondsTo("java_object")) {
            iRubyObject = iRubyObject.callMethod(threadContext, "java_object");
        } else if (iRubyObject.respondsTo("to_java_object")) {
            iRubyObject = iRubyObject.callMethod(threadContext, "to_java_object");
        }
        if (iRubyObject instanceof JavaObject) {
            Object object = ((JavaObject)iRubyObject).getValue();
            return JavaUtil.convertArgument(iRubyObject.getRuntime(), object, object.getClass());
        }
        if (clazz == Object.class || clazz == null) {
            clazz = iRubyObject.getJavaClass();
        }
        if (clazz.isInstance(iRubyObject)) {
            return iRubyObject;
        }
        if (clazz.isPrimitive()) {
            RubyConverter rubyConverter = RUBY_CONVERTERS.get(clazz);
            if (rubyConverter != null) {
                return rubyConverter.convert(threadContext, iRubyObject);
            }
            String string = ((RubyString)TypeConverter.convertToType(iRubyObject, iRubyObject.getRuntime().getString(), "to_s", true)).getUnicodeValue();
            if (string.length() > 0) {
                return new Character(string.charAt(0));
            }
            return new Character('\u0000');
        }
        if (clazz == String.class) {
            RubyString rubyString = (RubyString)iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s");
            ByteList byteList = rubyString.getByteList();
            try {
                return new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            }
        }
        if (clazz == ByteList.class) {
            return iRubyObject.convertToString().getByteList();
        }
        if (clazz == BigInteger.class) {
            if (iRubyObject instanceof RubyBignum) {
                return ((RubyBignum)iRubyObject).getValue();
            }
            if (iRubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)iRubyObject).getLongValue());
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (clazz == BigDecimal.class && !(iRubyObject instanceof JavaObject) && iRubyObject.respondsTo("to_f")) {
            double d = ((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue();
            return new BigDecimal(d);
        }
        try {
            return ((JavaObject)iRubyObject).getValue();
        }
        catch (ClassCastException classCastException) {
            if (iRubyObject.getRuntime().getDebug().isTrue()) {
                classCastException.printStackTrace();
            }
            return null;
        }
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby ruby, Object[] objectArray) {
        if (objectArray == null) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] iRubyObjectArray = new IRubyObject[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iRubyObjectArray[i] = JavaUtil.convertJavaToRuby(ruby, objectArray[i]);
        }
        return iRubyObjectArray;
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter javaConverter = JAVA_CONVERTERS.get(clazz);
        if (javaConverter == null) {
            javaConverter = JAVA_DEFAULT_CONVERTER;
        }
        return javaConverter;
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        return JavaUtil.convertJavaToRuby(ruby, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, int n) {
        return ruby.newFixnum(n);
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, long l) {
        return ruby.newFixnum(l);
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, float f) {
        return ruby.newFloat(f);
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, double d) {
        return ruby.newFloat(d);
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, boolean bl) {
        return ruby.newBoolean(bl);
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object, Class clazz) {
        return JavaUtil.getJavaConverter(clazz).convert(ruby, object);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        JavaConverter javaConverter = JAVA_CONVERTERS.get(object.getClass());
        if (javaConverter == null || javaConverter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(ruby, object);
        }
        return javaConverter.convert(ruby, object);
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Void.TYPE) {
                return Void.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
        }
        return clazz;
    }

    public static Object convertArgument(Ruby ruby, Object object, Class<?> clazz) {
        Serializable serializable;
        if (object == null) {
            if (clazz.isPrimitive()) {
                throw ruby.newTypeError("primitives do not accept null");
            }
            return null;
        }
        if (object instanceof JavaObject && (object = ((JavaObject)object).getValue()) == null) {
            return null;
        }
        Class<?> clazz2 = JavaUtil.primitiveToWrapper(clazz);
        if (clazz2 == Void.class) {
            return null;
        }
        if (object instanceof Number) {
            serializable = (Number)object;
            if (clazz2 == Long.class) {
                return new Long(((Number)serializable).longValue());
            }
            if (clazz2 == Integer.class) {
                return new Integer(((Number)serializable).intValue());
            }
            if (clazz2 == Byte.class) {
                return new Byte(((Number)serializable).byteValue());
            }
            if (clazz2 == Character.class) {
                return new Character((char)((Number)serializable).intValue());
            }
            if (clazz2 == Double.class) {
                return new Double(((Number)serializable).doubleValue());
            }
            if (clazz2 == Float.class) {
                return new Float(((Number)serializable).floatValue());
            }
            if (clazz2 == Short.class) {
                return new Short(((Number)serializable).shortValue());
            }
        }
        if (JavaUtil.isDuckTypeConvertable(object.getClass(), clazz) && !((RubyObject)(serializable = (RubyObject)object)).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(ruby.getCurrentContext(), (RubyObject)serializable, clazz);
        }
        return object;
    }

    public static boolean isDuckTypeConvertable(Class clazz, Class clazz2) {
        return clazz2.isInterface() && !clazz2.isAssignableFrom(clazz) && RubyObject.class.isAssignableFrom(clazz);
    }

    public static Object convertProcToInterface(ThreadContext threadContext, RubyObject rubyObject, Class clazz) {
        RubyObject rubyObject2;
        Ruby ruby = threadContext.getRuntime();
        RubyModule rubyModule = ruby.getJavaSupport().getJavaUtilitiesModule();
        IRubyObject iRubyObject = Java.get_interface_module(rubyModule, JavaClass.get(ruby, clazz));
        if (!((RubyModule)iRubyObject).isInstance(rubyObject)) {
            rubyObject.extend(new IRubyObject[]{iRubyObject});
        }
        if (rubyObject instanceof RubyProc) {
            rubyObject2 = rubyObject.getSingletonClass();
            ((RubyModule)rubyObject2).addMethod("method_missing", new DynamicMethod((RubyModule)rubyObject2, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject[] iRubyObjectArray2;
                    if (!(iRubyObject instanceof RubyProc)) {
                        throw threadContext.getRuntime().newTypeError("interface impl method_missing for block used with non-Proc object");
                    }
                    RubyProc rubyProc = (RubyProc)iRubyObject;
                    if (iRubyObjectArray.length == 1) {
                        iRubyObjectArray2 = IRubyObject.NULL_ARRAY;
                    } else {
                        iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length - 1];
                        System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray.length - 1);
                    }
                    return rubyProc.call(threadContext, iRubyObjectArray2);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
        }
        rubyObject2 = (JavaObject)RuntimeHelpers.invoke(threadContext, rubyObject, "__jcreate_meta!");
        return ((JavaObject)rubyObject2).getValue();
    }

    public static Object convertArgumentToType(ThreadContext threadContext, IRubyObject iRubyObject, Class clazz) {
        if (iRubyObject instanceof JavaObject) {
            return JavaUtil.coerceJavaObjectToType(threadContext, ((JavaObject)iRubyObject).getValue(), clazz);
        }
        if (iRubyObject.dataGetStruct() instanceof JavaObject) {
            JavaObject javaObject = (JavaObject)iRubyObject.dataGetStruct();
            threadContext.getRuntime().getJavaSupport().getObjectProxyCache().put(javaObject.getValue(), iRubyObject);
            return javaObject.getValue();
        }
        switch (iRubyObject.getMetaClass().index) {
            case 5: {
                return JavaUtil.coerceNilToType((RubyNil)iRubyObject, clazz);
            }
            case 1: {
                return JavaUtil.coerceFixnumToType((RubyFixnum)iRubyObject, clazz);
            }
            case 2: {
                return JavaUtil.coerceBignumToType((RubyBignum)iRubyObject, clazz);
            }
            case 11: {
                return JavaUtil.coerceFloatToType((RubyFloat)iRubyObject, clazz);
            }
            case 4: {
                return JavaUtil.coerceStringToType((RubyString)iRubyObject, clazz);
            }
            case 6: {
                return Boolean.TRUE;
            }
            case 7: {
                return Boolean.FALSE;
            }
            case 19: {
                return ((RubyTime)iRubyObject).getJavaDate();
            }
        }
        return JavaUtil.coerceOtherToType(threadContext, iRubyObject, clazz);
    }

    public static Object coerceJavaObjectToType(ThreadContext threadContext, Object object, Class clazz) {
        if (object != null && JavaUtil.isDuckTypeConvertable(object.getClass(), clazz)) {
            RubyObject rubyObject = (RubyObject)object;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(threadContext, rubyObject, clazz);
            }
            return object;
        }
        return object;
    }

    public static Object coerceNilToType(RubyNil rubyNil, Class clazz) {
        if (clazz.isPrimitive()) {
            throw rubyNil.getRuntime().newTypeError("primitives do not accept null");
        }
        return null;
    }

    public static Object coerceFixnumToType(RubyFixnum rubyFixnum, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return (int)rubyFixnum.getLongValue();
            }
            if (clazz == Double.TYPE) {
                return (double)rubyFixnum.getLongValue();
            }
            if (clazz == Byte.TYPE) {
                return (byte)rubyFixnum.getLongValue();
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf((char)rubyFixnum.getLongValue());
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(rubyFixnum.getLongValue());
            }
            if (clazz == Long.TYPE) {
                return rubyFixnum.getLongValue();
            }
            if (clazz == Short.TYPE) {
                return (short)rubyFixnum.getLongValue();
            }
        }
        return rubyFixnum.getLongValue();
    }

    public static Object coerceBignumToType(RubyBignum rubyBignum, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return (int)rubyBignum.getLongValue();
            }
            if (clazz == Double.TYPE) {
                return (double)rubyBignum.getLongValue();
            }
            if (clazz == Byte.TYPE) {
                return (byte)rubyBignum.getLongValue();
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf((char)rubyBignum.getLongValue());
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(rubyBignum.getLongValue());
            }
            if (clazz == Long.TYPE) {
                return rubyBignum.getLongValue();
            }
            if (clazz == Short.TYPE) {
                return (short)rubyBignum.getLongValue();
            }
        }
        return rubyBignum.getValue();
    }

    public static Object coerceFloatToType(RubyFloat rubyFloat, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return (int)rubyFloat.getLongValue();
            }
            if (clazz == Double.TYPE) {
                return rubyFloat.getDoubleValue();
            }
            if (clazz == Byte.TYPE) {
                return (byte)rubyFloat.getLongValue();
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf((char)rubyFloat.getLongValue());
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf((float)rubyFloat.getDoubleValue());
            }
            if (clazz == Long.TYPE) {
                return rubyFloat.getLongValue();
            }
            if (clazz == Short.TYPE) {
                return (short)rubyFloat.getLongValue();
            }
        }
        return rubyFloat.getDoubleValue();
    }

    public static Object coerceStringToType(RubyString rubyString, Class clazz) {
        try {
            ByteList byteList = rubyString.getByteList();
            return new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return rubyString.toString();
        }
    }

    public static Object coerceOtherToType(ThreadContext threadContext, IRubyObject iRubyObject, Class clazz) {
        Ruby ruby = threadContext.getRuntime();
        if (JavaUtil.isDuckTypeConvertable(iRubyObject.getClass(), clazz)) {
            RubyObject rubyObject = (RubyObject)iRubyObject;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(threadContext, rubyObject, clazz);
            }
        } else if (iRubyObject.respondsTo("to_java_object")) {
            Object object = iRubyObject.callMethod(threadContext, "to_java_object");
            if (object instanceof JavaObject) {
                ruby.getJavaSupport().getObjectProxyCache().put(((JavaObject)object).getValue(), iRubyObject);
                object = ((JavaObject)object).getValue();
            }
            return object;
        }
        return iRubyObject;
    }

    public static IRubyObject primitive_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Object object;
        if (iRubyObject2 instanceof JavaObject) {
            return iRubyObject2;
        }
        Ruby ruby = iRubyObject.getRuntime();
        switch (iRubyObject2.getMetaClass().index) {
            case 5: {
                object = null;
                break;
            }
            case 1: {
                object = new Long(((RubyFixnum)iRubyObject2).getLongValue());
                break;
            }
            case 2: {
                object = ((RubyBignum)iRubyObject2).getValue();
                break;
            }
            case 11: {
                object = new Double(((RubyFloat)iRubyObject2).getValue());
                break;
            }
            case 4: {
                try {
                    ByteList byteList = ((RubyString)iRubyObject2).getByteList();
                    object = new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = iRubyObject2.toString();
                }
                break;
            }
            case 6: {
                object = Boolean.TRUE;
                break;
            }
            case 7: {
                object = Boolean.FALSE;
                break;
            }
            case 19: {
                object = ((RubyTime)iRubyObject2).getJavaDate();
                break;
            }
            default: {
                return iRubyObject2;
            }
        }
        return JavaObject.wrap(ruby, object);
    }

    public static IRubyObject java_to_ruby(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(ruby, ((JavaObject)iRubyObject).getValue());
        }
        return iRubyObject;
    }

    public static IRubyObject ruby_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2.respondsTo("to_java_object")) {
            IRubyObject iRubyObject3 = (JavaObject)iRubyObject2.dataGetStruct();
            if (iRubyObject3 == null) {
                iRubyObject3 = iRubyObject2.callMethod(iRubyObject.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (iRubyObject3 instanceof JavaObject) {
                iRubyObject.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)iRubyObject3).getValue(), iRubyObject2);
            }
            return iRubyObject3;
        }
        return JavaUtil.primitive_to_java(iRubyObject, iRubyObject2, block);
    }

    public static IRubyObject java_to_primitive(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (iRubyObject2 instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(iRubyObject.getRuntime(), ((JavaObject)iRubyObject2).getValue());
        }
        return iRubyObject2;
    }

    public static boolean isJavaObject(IRubyObject iRubyObject) {
        return iRubyObject.dataGetStruct() instanceof JavaObject;
    }

    public static Object unwrapJavaObject(IRubyObject iRubyObject) {
        return ((JavaObject)iRubyObject.dataGetStruct()).getValue();
    }

    public static String getJavaPropertyName(String string) {
        Matcher matcher = JAVA_PROPERTY_CHOPPER.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        String string2 = matcher.group(2).toLowerCase() + matcher.group(3);
        return string2;
    }

    public static String getRubyCasedName(String string) {
        Matcher matcher = CAMEL_CASE_SPLITTER.matcher(string);
        return matcher.replaceAll("$1_$2").toLowerCase();
    }

    public static String getJavaCasedName(String string) {
        Matcher matcher = RUBY_CASE_SPLITTER.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (!matcher.find()) {
            return null;
        }
        matcher.reset();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1) + Character.toUpperCase(matcher.group(2).charAt(0)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static Set<String> getRubyNamesForJavaName(String string, List<Method> list) {
        String string2 = JavaUtil.getJavaPropertyName(string);
        String string3 = JavaUtil.getRubyCasedName(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(string);
        linkedHashSet.add(string3);
        String string4 = null;
        for (Method method : list) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            int n = classArray.length;
            if (string2 != null) {
                if (string3.startsWith("get_")) {
                    string4 = string3.substring(4);
                    if (n != 0 && (n != 1 || classArray[0] != Integer.TYPE)) continue;
                    linkedHashSet.add(string2);
                    linkedHashSet.add(string4);
                    if (clazz != Boolean.TYPE) continue;
                    linkedHashSet.add(string2 + '?');
                    linkedHashSet.add(string4 + '?');
                    continue;
                }
                if (string3.startsWith("set_")) {
                    string4 = string3.substring(4);
                    if (n != 1 || clazz != Void.TYPE) continue;
                    linkedHashSet.add(string2 + '=');
                    linkedHashSet.add(string4 + '=');
                    continue;
                }
                if (!string3.startsWith("is_")) continue;
                string4 = string3.substring(3);
                if (clazz != Boolean.TYPE) continue;
                linkedHashSet.add(string2);
                linkedHashSet.add(string4);
                linkedHashSet.add(string2 + '?');
                linkedHashSet.add(string4 + '?');
                continue;
            }
            if (clazz != Boolean.TYPE) continue;
            linkedHashSet.add(string + '?');
            linkedHashSet.add(string3 + '?');
        }
        return linkedHashSet;
    }

    public static JavaObject unwrapJavaObject(Ruby ruby, IRubyObject iRubyObject, String string) {
        IRubyObject iRubyObject2 = iRubyObject;
        if (!(iRubyObject2 instanceof JavaObject)) {
            if (iRubyObject2.dataGetStruct() != null && iRubyObject2.dataGetStruct() instanceof JavaObject) {
                iRubyObject2 = (JavaObject)iRubyObject2.dataGetStruct();
            } else {
                throw ruby.newTypeError(string);
            }
        }
        return (JavaObject)iRubyObject2;
    }

    public static Object unwrapJavaValue(Ruby ruby, IRubyObject iRubyObject, String string) {
        if (iRubyObject instanceof JavaMethod) {
            return ((JavaMethod)iRubyObject).getValue();
        }
        if (iRubyObject instanceof JavaConstructor) {
            return ((JavaConstructor)iRubyObject).getValue();
        }
        if (iRubyObject instanceof JavaField) {
            return ((JavaField)iRubyObject).getValue();
        }
        if (iRubyObject instanceof JavaObject) {
            return ((JavaObject)iRubyObject).getValue();
        }
        if (iRubyObject.dataGetStruct() != null && iRubyObject.dataGetStruct() instanceof IRubyObject) {
            return JavaUtil.unwrapJavaValue(ruby, (IRubyObject)iRubyObject.dataGetStruct(), string);
        }
        throw ruby.newTypeError(string);
    }

    static {
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.class, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.TYPE, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.class, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.TYPE, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Short.class, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Short.TYPE, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Character.class, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Character.TYPE, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.class, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.TYPE, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Long.class, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Long.TYPE, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Float.class, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Float.TYPE, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Double.class, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Double.TYPE, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(String.class, ARRAY_STRING_CONVERTER);
        ARRAY_CONVERTERS.put(Class.class, ARRAY_CLASS_CONVERTER);
        ARRAY_CONVERTERS.put(BigInteger.class, ARRAY_BIGINTEGER_CONVERTER);
        ARRAY_CONVERTERS.put(BigDecimal.class, ARRAY_BIGDECIMAL_CONVERTER);
        JAVA_DEFAULT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                if (object instanceof IRubyObject) {
                    return (IRubyObject)object;
                }
                return JavaObject.wrap(ruby, object);
            }
        };
        JAVA_BOOLEAN_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyBoolean.newBoolean(ruby, (Boolean)object);
            }
        };
        JAVA_FLOAT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFloat.newFloat(ruby, ((Float)object).doubleValue());
            }
        };
        JAVA_DOUBLE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFloat.newFloat(ruby, (Double)object);
            }
        };
        JAVA_CHAR_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
            }
        };
        JAVA_BYTE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Byte)object).byteValue());
            }
        };
        JAVA_SHORT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Short)object).shortValue());
            }
        };
        JAVA_INT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Integer)object).intValue());
            }
        };
        JAVA_LONG_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, (Long)object);
            }
        };
        JAVA_STRING_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyString.newUnicodeString(ruby, (String)object);
            }
        };
        BYTELIST_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyString.newString(ruby, (ByteList)object);
            }
        };
        JAVA_BIGINTEGER_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyBignum.newBignum(ruby, (BigInteger)object);
            }
        };
        JAVA_CONVERTERS = new HashMap<Class, JavaConverter>();
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
        JAVA_PROPERTY_CHOPPER = Pattern.compile("(get|set|is)([A-Z0-9])(.*)");
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        RUBY_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)_([a-z])");
    }

    public static interface JavaConverter {
        public IRubyObject convert(Ruby var1, Object var2);
    }

    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }
}

