/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.javasupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyProc;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.javasupport.JavaClass;
import org.jruby.nb.nb.nb.javasupport.JavaObject;
import org.jruby.nb.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.nb.javasupport.util.ObjectProxyCache;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.callback.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSupport {
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Ruby runtime;
    private final Map<String, RubyProc> exceptionHandlers = new HashMap<String, RubyProc>();
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object object, RubyClass rubyClass) {
            IRubyObject iRubyObject = rubyClass.allocate();
            JavaObject javaObject = JavaObject.wrap(rubyClass.getRuntime(), object);
            iRubyObject.getInstanceVariables().fastSetInstanceVariable("@java_object", javaObject);
            iRubyObject.dataWrapStruct(javaObject);
            return iRubyObject;
        }
    };
    private boolean active;
    private final ConcurrentHashMap<Class, JavaClass> javaClassCache = new ConcurrentHashMap(128);
    private final Map matchCache = Collections.synchronizedMap(new HashMap(128));
    private Callback concreteProxyCallback;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyModule javaArrayUtilitiesModule;
    private RubyClass javaObjectClass;
    private JavaClass objectJavaClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyClass javaFieldClass;
    private RubyClass javaMethodClass;
    private RubyClass javaConstructorClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;
    private final Map<String, JavaClass> nameClassMap = new HashMap<String, JavaClass>();

    public static Class getPrimitiveClass(String string) {
        return PRIMITIVE_CLASSES.get(string);
    }

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
    }

    final synchronized void setConcreteProxyCallback(Callback callback) {
        if (this.concreteProxyCallback == null) {
            this.concreteProxyCallback = callback;
        }
    }

    final Callback getConcreteProxyCallback() {
        return this.concreteProxyCallback;
    }

    final Map getMatchCache() {
        return this.matchCache;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    private Class loadJavaClass(String string) throws ClassNotFoundException {
        Class clazz = PRIMITIVE_CLASSES.get(string);
        if (clazz == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(string, true, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(string);
        }
        return clazz;
    }

    public Class loadJavaClassVerbose(String string) {
        try {
            return this.loadJavaClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.runtime.newNameError("cannot load Java class " + string, string, classNotFoundException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.runtime.newNameError("cannot initialize Java class " + string, string, exceptionInInitializerError);
        }
        catch (LinkageError linkageError) {
            throw this.runtime.newNameError("cannot link Java class " + string, string, linkageError);
        }
        catch (SecurityException securityException) {
            throw this.runtime.newNameError("security: cannot load Java class " + string, string, securityException);
        }
    }

    public Class loadJavaClassQuiet(String string) {
        try {
            return this.loadJavaClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.runtime.newNameError("cannot load Java class " + string, string, classNotFoundException, false);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.runtime.newNameError("cannot initialize Java class " + string, string, exceptionInInitializerError, false);
        }
        catch (LinkageError linkageError) {
            throw this.runtime.newNameError("cannot link Java class " + string, string, linkageError, false);
        }
        catch (SecurityException securityException) {
            throw this.runtime.newNameError("security: cannot load Java class " + string, string, securityException, false);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public void putJavaClassIntoCache(JavaClass javaClass) {
        this.javaClassCache.put(javaClass.javaClass(), javaClass);
    }

    public void defineExceptionHandler(String string, RubyProc rubyProc) {
        this.exceptionHandlers.put(string, rubyProc);
    }

    public void handleNativeException(Throwable throwable) {
        Class<?> clazz;
        if (throwable instanceof RaiseException) {
            throw (RaiseException)throwable;
        }
        RubyProc rubyProc = this.exceptionHandlers.get(clazz.getName());
        for (clazz = throwable.getClass(); rubyProc == null && clazz != Throwable.class; clazz = clazz.getSuperclass()) {
        }
        if (rubyProc == null) {
            throw this.createRaiseException(throwable);
        }
        rubyProc.call(this.runtime.getCurrentContext(), new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, throwable)});
    }

    private RaiseException createRaiseException(Throwable throwable) {
        RaiseException raiseException = RaiseException.createNativeRaiseException(this.runtime, throwable);
        return raiseException;
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public Map<String, JavaClass> getNameClassMap() {
        return this.nameClassMap;
    }

    public RubyModule getJavaModule() {
        RubyModule rubyModule = this.javaModule;
        if (rubyModule != null) {
            return rubyModule;
        }
        this.javaModule = this.runtime.fastGetModule("Java");
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        RubyModule rubyModule = this.javaUtilitiesModule;
        if (rubyModule != null) {
            return rubyModule;
        }
        this.javaUtilitiesModule = this.runtime.fastGetModule("JavaUtilities");
        return this.javaUtilitiesModule;
    }

    public RubyModule getJavaArrayUtilitiesModule() {
        RubyModule rubyModule = this.javaArrayUtilitiesModule;
        if (rubyModule != null) {
            return rubyModule;
        }
        this.javaArrayUtilitiesModule = this.runtime.fastGetModule("JavaArrayUtilities");
        return this.javaArrayUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        RubyClass rubyClass = this.javaObjectClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaObjectClass = this.getJavaModule().fastGetClass("JavaObject");
        return this.javaObjectClass;
    }

    public JavaClass getObjectJavaClass() {
        return this.objectJavaClass;
    }

    public void setObjectJavaClass(JavaClass javaClass) {
        this.objectJavaClass = javaClass;
    }

    public RubyClass getJavaArrayClass() {
        RubyClass rubyClass = this.javaArrayClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaArrayClass = this.getJavaModule().fastGetClass("JavaArray");
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        RubyClass rubyClass = this.javaClassClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaClassClass = this.getJavaModule().fastGetClass("JavaClass");
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        RubyModule rubyModule = this.javaInterfaceTemplate;
        if (rubyModule != null) {
            return rubyModule;
        }
        this.javaInterfaceTemplate = this.runtime.fastGetModule("JavaInterfaceTemplate");
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        RubyModule rubyModule = this.packageModuleTemplate;
        if (rubyModule != null) {
            return rubyModule;
        }
        this.packageModuleTemplate = this.runtime.fastGetModule("JavaPackageModuleTemplate");
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        RubyClass rubyClass = this.javaProxyClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaProxyClass = this.runtime.fastGetClass("JavaProxy");
        return this.javaProxyClass;
    }

    public RubyClass getConcreteProxyClass() {
        RubyClass rubyClass = this.concreteProxyClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.concreteProxyClass = this.runtime.fastGetClass("ConcreteJavaProxy");
        return this.concreteProxyClass;
    }

    public RubyClass getArrayProxyClass() {
        RubyClass rubyClass = this.arrayProxyClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.arrayProxyClass = this.runtime.fastGetClass("ArrayJavaProxy");
        return this.arrayProxyClass;
    }

    public RubyClass getJavaFieldClass() {
        RubyClass rubyClass = this.javaFieldClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaFieldClass = this.getJavaModule().fastGetClass("JavaField");
        return this.javaFieldClass;
    }

    public RubyClass getJavaMethodClass() {
        RubyClass rubyClass = this.javaMethodClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaMethodClass = this.getJavaModule().fastGetClass("JavaMethod");
        return this.javaMethodClass;
    }

    public RubyClass getJavaConstructorClass() {
        RubyClass rubyClass = this.javaConstructorClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        this.javaConstructorClass = this.getJavaModule().fastGetClass("JavaConstructor");
        return this.javaConstructorClass;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
    }
}

