/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyObject;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.nb.compiler.util.HandleFactory;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.nb.nb.internal.runtime.methods.UndefinedMethod;
import org.jruby.nb.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.load.Library;
import org.jruby.nb.nb.nb.util.CodegenUtils;
import org.jruby.nb.nb.nb.util.IdUtil;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniJava
implements Library {
    private static final boolean DEBUG = false;
    static Map<Class, RubyModule> classMap = new HashMap<Class, RubyModule>();
    static final Map<Class, JavaMethodFactory> methodFactories = new HashMap<Class, JavaMethodFactory>();
    static final JavaMethodFactory JAVA_OBJECT_METHOD_FACTORY = new JavaMethodFactory(){

        public DynamicMethod createMethod(RubyClass rubyClass, Method method) {
            return new JavaObjectWrapperMethod((RubyModule)rubyClass, method);
        }
    };

    @Override
    public void load(Ruby ruby, boolean bl) {
        ruby.getErr().print("Warning: minijava is experimental and subject to change\n");
        ruby.getKernel().defineAnnotatedMethods(MiniJava.class);
        RubyModule rubyModule = MiniJava.getMirrorForClass(ruby, Object.class);
        rubyModule.addMethod("to_s", new JavaMethod.JavaMethodZero(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return threadContext.getRuntime().newString(((JavaObjectWrapper)iRubyObject).object.toString());
            }
        });
        rubyModule.addMethod("hash", new JavaMethod.JavaMethodZero(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return iRubyObject.getRuntime().newFixnum(((JavaObjectWrapper)iRubyObject).object.hashCode());
            }
        });
        rubyModule.addMethod("==", new JavaMethod.JavaMethodOne(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
                if (iRubyObject2 instanceof JavaObjectWrapper) {
                    return threadContext.getRuntime().newBoolean(((JavaObjectWrapper)iRubyObject).object.equals(((JavaObjectWrapper)iRubyObject2).object));
                }
                return threadContext.getRuntime().getFalse();
            }
        });
        RubyModule rubyModule2 = ruby.getKernel();
        rubyModule2.addModuleFunction("to_java", new JavaMethod.JavaMethodZeroOrOne(rubyModule2, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return ((RubyObject)iRubyObject).to_java();
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
                return ((RubyObject)iRubyObject).as(MiniJava.getJavaClassFromObject(iRubyObject2));
            }
        });
    }

    @JRubyMethod(name={"new_class"}, rest=true, module=true)
    public static IRubyObject new_class(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Class[] classArray = new Class[iRubyObjectArray.length];
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            classArray[i] = MiniJava.getJavaClassFromObject(iRubyObjectArray[i]);
        }
        return MiniJava.createImplClass(classArray, threadContext.getRuntime(), "I" + System.currentTimeMillis());
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.toString();
        try {
            Class clazz = MiniJava.findClass(threadContext.getRuntime().getJRubyClassLoader(), string);
            RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : iRubyObject.getMetaClass().getRealClass();
            rubyModule.defineConstant(clazz.getSimpleName(), MiniJava.getMirrorForClass(threadContext.getRuntime(), clazz));
            return threadContext.getRuntime().getNil();
        }
        catch (Exception exception) {
            if (threadContext.getRuntime().getDebug().isTrue()) {
                exception.printStackTrace();
            }
            throw threadContext.getRuntime().newTypeError("Could not find class " + string + ", exception: " + exception);
        }
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        String string = iRubyObject2.toString();
        try {
            Class clazz = MiniJava.findClass(threadContext.getRuntime().getJRubyClassLoader(), string);
            RubyModule rubyModule = iRubyObject instanceof RubyModule ? (RubyModule)iRubyObject : iRubyObject.getMetaClass().getRealClass();
            rubyModule.defineConstant(iRubyObject3.toString(), MiniJava.getMirrorForClass(threadContext.getRuntime(), clazz));
            return threadContext.getRuntime().getNil();
        }
        catch (Exception exception) {
            if (threadContext.getRuntime().getDebug().isTrue()) {
                exception.printStackTrace();
            }
            throw threadContext.getRuntime().newTypeError("Could not find class " + string + ", exception: " + exception);
        }
    }

    public static RubyClass createImplClass(Class[] classArray, Ruby ruby, String string) {
        String[] stringArray = new String[classArray.length];
        HashMap<String, List<Method>> hashMap = new HashMap<String, List<Method>>();
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = CodegenUtils.p(classArray[i]);
            for (Method method : classArray[i].getMethods()) {
                ArrayList<Method> arrayList = (ArrayList<Method>)hashMap.get(method.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                    hashMap.put(method.getName(), arrayList);
                }
                arrayList.add(method);
            }
        }
        Class clazz = MiniJava.defineImplClass(ruby, string, stringArray, hashMap);
        Method[] methodArray = MiniJava.populateImplClass(ruby, clazz, hashMap);
        return methodArray;
    }

    public static Class createOldStyleImplClass(Class[] classArray, RubyClass rubyClass, Ruby ruby, String string) {
        String[] stringArray = new String[classArray.length];
        HashMap<String, List<Method>> hashMap = new HashMap<String, List<Method>>();
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = CodegenUtils.p(classArray[i]);
            for (Method method : classArray[i].getMethods()) {
                ArrayList<Method> arrayList = (ArrayList<Method>)hashMap.get(method.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                    hashMap.put(method.getName(), arrayList);
                }
                arrayList.add(method);
            }
        }
        Class clazz = MiniJava.defineOldStyleImplClass(ruby, string, stringArray, hashMap);
        MiniJava.populateOldStyleImplClass(ruby, rubyClass, clazz, hashMap);
        return clazz;
    }

    public static Class defineImplClass(Ruby ruby, String string, String[] stringArray, Map<String, List<Method>> map) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 33, string, null, CodegenUtils.p(Object.class), stringArray);
        classWriter.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null).visitEnd();
        classWriter.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null).visitEnd();
        classWriter.visitField(18, "self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
        skinnyMethodAdapter.putfield(string, "self", CodegenUtils.ci(IRubyObject.class));
        skinnyMethodAdapter.voidreturn();
        skinnyMethodAdapter.end();
        SkinnyMethodAdapter skinnyMethodAdapter2 = new SkinnyMethodAdapter(classWriter.visitMethod(4105, "__setup__", CodegenUtils.sig(Void.TYPE, RubyClass.class), null, null));
        skinnyMethodAdapter2.start();
        skinnyMethodAdapter2.aload(0);
        skinnyMethodAdapter2.dup();
        skinnyMethodAdapter2.putstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
        skinnyMethodAdapter2.invokevirtual(CodegenUtils.p(RubyClass.class), "getClassRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        skinnyMethodAdapter2.putstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
        for (Map.Entry<String, List<Method>> object2 : map.entrySet()) {
            String string2 = object2.getKey();
            classWriter.visitField(73, string2, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
            for (Method method : object2.getValue()) {
                Class[] classArray = method.getParameterTypes();
                Class<?> clazz = method.getReturnType();
                SkinnyMethodAdapter skinnyMethodAdapter3 = new SkinnyMethodAdapter(classWriter.visitMethod(1, string2, CodegenUtils.sig(clazz, classArray), null, null));
                skinnyMethodAdapter3.start();
                String string3 = MiniJava.mangleMethodFieldName(string2, classArray);
                Label label = new Label();
                classWriter.visitField(73, string3, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
                skinnyMethodAdapter3.getstatic(string, string3, CodegenUtils.ci(DynamicMethod.class));
                skinnyMethodAdapter3.dup();
                skinnyMethodAdapter3.ifnonnull(label);
                skinnyMethodAdapter3.pop();
                skinnyMethodAdapter3.getstatic(string, string2, CodegenUtils.ci(DynamicMethod.class));
                skinnyMethodAdapter3.dup();
                skinnyMethodAdapter3.ifnonnull(label);
                skinnyMethodAdapter3.pop();
                skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                skinnyMethodAdapter3.ldc("method_missing");
                skinnyMethodAdapter3.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, String.class));
                skinnyMethodAdapter3.label(label);
                skinnyMethodAdapter3.getstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
                skinnyMethodAdapter3.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
                skinnyMethodAdapter3.aload(0);
                skinnyMethodAdapter3.getfield(string, "self", CodegenUtils.ci(IRubyObject.class));
                skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                skinnyMethodAdapter3.ldc(string2);
                if (method.getParameterTypes().length != 0) {
                    skinnyMethodAdapter3.pushInt(method.getParameterTypes().length);
                    skinnyMethodAdapter3.anewarray(CodegenUtils.p(IRubyObject.class));
                    for (int i = 0; i < classArray.length; ++i) {
                        skinnyMethodAdapter3.dup();
                        skinnyMethodAdapter3.pushInt(i);
                        skinnyMethodAdapter3.getstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
                        skinnyMethodAdapter3.aload(i + 1);
                        skinnyMethodAdapter3.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                        skinnyMethodAdapter3.aastore();
                    }
                } else {
                    skinnyMethodAdapter3.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
                }
                skinnyMethodAdapter3.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                skinnyMethodAdapter3.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
                if (method.getReturnType() != Void.TYPE) {
                    skinnyMethodAdapter3.invokestatic(CodegenUtils.p(MiniJava.class), "rubyToJava", CodegenUtils.sig(Object.class, IRubyObject.class));
                    skinnyMethodAdapter3.checkcast(CodegenUtils.p(clazz));
                    skinnyMethodAdapter3.areturn();
                } else {
                    skinnyMethodAdapter3.voidreturn();
                }
                skinnyMethodAdapter3.end();
            }
        }
        skinnyMethodAdapter2.voidreturn();
        skinnyMethodAdapter2.end();
        classWriter.visitEnd();
        Object object3 = classWriter.toByteArray();
        Class<?> clazz = ruby.getJRubyClassLoader().defineClass(string, classWriter.toByteArray());
        return clazz;
    }

    public static Class defineOldStyleImplClass(Ruby ruby, String string, String[] stringArray, Map<String, List<Method>> map) {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 33, string, null, CodegenUtils.p(Object.class), stringArray);
        classWriter.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null).visitEnd();
        classWriter.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null).visitEnd();
        classWriter.visitField(18, "self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, IRubyObject.class), null, null));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.putfield(string, "self", CodegenUtils.ci(IRubyObject.class));
        skinnyMethodAdapter.voidreturn();
        skinnyMethodAdapter.end();
        SkinnyMethodAdapter skinnyMethodAdapter2 = new SkinnyMethodAdapter(classWriter.visitMethod(4105, "__setup__", CodegenUtils.sig(Void.TYPE, RubyClass.class), null, null));
        skinnyMethodAdapter2.start();
        skinnyMethodAdapter2.aload(0);
        skinnyMethodAdapter2.dup();
        skinnyMethodAdapter2.putstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
        skinnyMethodAdapter2.invokevirtual(CodegenUtils.p(RubyClass.class), "getClassRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        skinnyMethodAdapter2.putstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
        for (Map.Entry<String, List<Method>> object2 : map.entrySet()) {
            String string2 = object2.getKey();
            Set<String> set = JavaUtil.getRubyNamesForJavaName(string2, object2.getValue());
            classWriter.visitField(73, string2, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
            for (Method method : object2.getValue()) {
                Class[] classArray = method.getParameterTypes();
                Class<?> clazz = method.getReturnType();
                SkinnyMethodAdapter skinnyMethodAdapter3 = new SkinnyMethodAdapter(classWriter.visitMethod(1, string2, CodegenUtils.sig(clazz, classArray), null, null));
                skinnyMethodAdapter3.start();
                if (string2.equals("equals") && classArray.length == 1 && classArray[0] == Object.class && clazz == Boolean.TYPE) {
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.aload(1);
                    skinnyMethodAdapter3.invokespecial(CodegenUtils.p(Object.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                    skinnyMethodAdapter3.ireturn();
                } else if (string2.equals("hashCode") && classArray.length == 0 && clazz == Integer.TYPE) {
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.invokespecial(CodegenUtils.p(Object.class), "hashCode", CodegenUtils.sig(Integer.TYPE, new Class[0]));
                    skinnyMethodAdapter3.ireturn();
                } else if (string2.equals("toString") && classArray.length == 0 && clazz == String.class) {
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.invokespecial(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
                    skinnyMethodAdapter3.areturn();
                } else {
                    Label label = new Label();
                    Label label2 = new Label();
                    skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    skinnyMethodAdapter3.monitorenter();
                    skinnyMethodAdapter3.getstatic(string, string2, CodegenUtils.ci(DynamicMethod.class));
                    skinnyMethodAdapter3.dup();
                    skinnyMethodAdapter3.ifnonnull(label);
                    skinnyMethodAdapter3.pop();
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.getfield(string, "self", CodegenUtils.ci(IRubyObject.class));
                    for (String string3 : set) {
                        skinnyMethodAdapter3.ldc(string3);
                    }
                    skinnyMethodAdapter3.invokestatic(CodegenUtils.p(MiniJava.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(IRubyObject.class, String.class, set.size())));
                    skinnyMethodAdapter3.dup();
                    skinnyMethodAdapter3.getstatic(CodegenUtils.p(UndefinedMethod.class), "INSTANCE", CodegenUtils.ci(UndefinedMethod.class));
                    skinnyMethodAdapter3.if_acmpne(label);
                    skinnyMethodAdapter3.pop();
                    skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    skinnyMethodAdapter3.monitorexit();
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.getfield(string, "self", CodegenUtils.ci(IRubyObject.class));
                    skinnyMethodAdapter3.ldc(string2);
                    MiniJava.coerceArgumentsToRuby(skinnyMethodAdapter3, classArray, string);
                    skinnyMethodAdapter3.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "invokeMethodMissing", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class));
                    skinnyMethodAdapter3.go_to(label2);
                    skinnyMethodAdapter3.label(label);
                    skinnyMethodAdapter3.dup();
                    skinnyMethodAdapter3.putstatic(string, string2, CodegenUtils.ci(DynamicMethod.class));
                    skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    skinnyMethodAdapter3.monitorexit();
                    skinnyMethodAdapter3.getstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
                    skinnyMethodAdapter3.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
                    skinnyMethodAdapter3.aload(0);
                    skinnyMethodAdapter3.getfield(string, "self", CodegenUtils.ci(IRubyObject.class));
                    skinnyMethodAdapter3.getstatic(string, "rubyClass", CodegenUtils.ci(RubyClass.class));
                    skinnyMethodAdapter3.ldc(string2);
                    MiniJava.coerceArgumentsToRuby(skinnyMethodAdapter3, classArray, string);
                    skinnyMethodAdapter3.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                    skinnyMethodAdapter3.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
                    skinnyMethodAdapter3.label(label2);
                    MiniJava.coerceResultAndReturn(method, skinnyMethodAdapter3, clazz);
                }
                skinnyMethodAdapter3.end();
            }
        }
        skinnyMethodAdapter2.voidreturn();
        skinnyMethodAdapter2.end();
        classWriter.visitEnd();
        Object object3 = classWriter.toByteArray();
        Class<?> clazz = ruby.getJRubyClassLoader().defineClass(string, classWriter.toByteArray());
        return clazz;
    }

    private static void coerceArgumentsToRuby(SkinnyMethodAdapter skinnyMethodAdapter, Class[] classArray, String string) {
        if (classArray.length != 0) {
            skinnyMethodAdapter.pushInt(classArray.length);
            skinnyMethodAdapter.anewarray(CodegenUtils.p(IRubyObject.class));
            for (int i = 0; i < classArray.length; ++i) {
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.pushInt(i);
                skinnyMethodAdapter.getstatic(string, "ruby", CodegenUtils.ci(Ruby.class));
                if (classArray[i].isPrimitive()) {
                    if (classArray[i] == Byte.TYPE || classArray[i] == Short.TYPE || classArray[i] == Character.TYPE || classArray[i] == Integer.TYPE) {
                        skinnyMethodAdapter.iload(i + 1);
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Integer.TYPE));
                    } else if (classArray[i] == Long.TYPE) {
                        skinnyMethodAdapter.lload(i + 1);
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Long.TYPE));
                    } else if (classArray[i] == Float.TYPE) {
                        skinnyMethodAdapter.fload(i + 1);
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Float.TYPE));
                    } else if (classArray[i] == Double.TYPE) {
                        skinnyMethodAdapter.dload(i + 1);
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Double.TYPE));
                    } else if (classArray[i] == Boolean.TYPE) {
                        skinnyMethodAdapter.iload(i + 1);
                        skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Boolean.TYPE));
                    }
                } else {
                    skinnyMethodAdapter.aload(i + 1);
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                }
                skinnyMethodAdapter.aastore();
            }
        } else {
            skinnyMethodAdapter.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        }
    }

    private static void coerceResultAndReturn(Method method, SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        if (method.getReturnType() != Void.TYPE) {
            if (method.getReturnType().isPrimitive()) {
                if (method.getReturnType() == Byte.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaByte", CodegenUtils.sig(Byte.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.ireturn();
                } else if (method.getReturnType() == Short.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaShort", CodegenUtils.sig(Short.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.ireturn();
                } else if (method.getReturnType() == Character.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaChar", CodegenUtils.sig(Character.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.ireturn();
                } else if (method.getReturnType() == Integer.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaInt", CodegenUtils.sig(Integer.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.ireturn();
                } else if (method.getReturnType() == Long.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaLong", CodegenUtils.sig(Long.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.lreturn();
                } else if (method.getReturnType() == Float.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaFloat", CodegenUtils.sig(Float.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.freturn();
                } else if (method.getReturnType() == Double.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaDouble", CodegenUtils.sig(Double.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.dreturn();
                } else if (method.getReturnType() == Boolean.TYPE) {
                    skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJavaBoolean", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    skinnyMethodAdapter.ireturn();
                }
            } else {
                skinnyMethodAdapter.ldc(Type.getType(method.getReturnType()));
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(JavaUtil.class), "convertRubyToJava", CodegenUtils.sig(Object.class, IRubyObject.class, Class.class));
                skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz));
                skinnyMethodAdapter.areturn();
            }
        } else {
            skinnyMethodAdapter.voidreturn();
        }
    }

    public static RubyClass populateImplClass(Ruby ruby, Class clazz, Map<String, List<Method>> map) {
        RubyClass rubyClass = (RubyClass)MiniJava.getMirrorForClass(ruby, clazz);
        try {
            clazz.getMethod("__setup__", RubyClass.class).invoke(null, rubyClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw MiniJava.error(ruby, illegalAccessException, "Could not setup class: " + clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MiniJava.error(ruby, illegalArgumentException, "Could not setup class: " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw MiniJava.error(ruby, invocationTargetException, "Could not setup class: " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw MiniJava.error(ruby, noSuchMethodException, "Could not setup class: " + clazz);
        }
        final HashMap<String, Field> hashMap = new HashMap<String, Field>();
        try {
            for (Map.Entry<String, List<Method>> entry : map.entrySet()) {
                String string = entry.getKey();
                Field field = clazz.getField(string);
                hashMap.put(string, field);
                for (Method method : entry.getValue()) {
                    String string2 = string + CodegenUtils.prettyParams(method.getParameterTypes());
                    String string3 = MiniJava.mangleMethodFieldName(string, method.getParameterTypes());
                    hashMap.put(string2, clazz.getField(string3));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MiniJava.error(ruby, illegalArgumentException, "Could not prepare method fields: " + clazz);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw MiniJava.error(ruby, noSuchFieldException, "Could not prepare method fields: " + clazz);
        }
        JavaMethod javaMethod = new JavaMethod((RubyModule)rubyClass.getSingletonClass(), Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                RubyClass rubyClass = (RubyClass)iRubyObject;
                Ruby ruby = rubyClass.getClassRuntime();
                String string2 = iRubyObjectArray[0].asJavaString();
                Field field = (Field)hashMap.get(string2);
                if (field != null) {
                    try {
                        field.set(null, rubyClass.searchMethod(string2));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw MiniJava.error(ruby, illegalAccessException, "Could not set new method into field: " + rubyClass + "." + string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MiniJava.error(ruby, illegalArgumentException, "Could not set new method into field: " + rubyClass + "." + string2);
                    }
                }
                return threadContext.getRuntime().getNil();
            }
        };
        rubyClass.getSingletonClass().addMethod("method_added", javaMethod);
        return rubyClass;
    }

    public static void populateOldStyleImplClass(Ruby ruby, RubyClass rubyClass, Class clazz, Map<String, List<Method>> map) {
        try {
            clazz.getMethod("__setup__", RubyClass.class).invoke(null, rubyClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw MiniJava.error(ruby, illegalAccessException, "Could not setup class: " + clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MiniJava.error(ruby, illegalArgumentException, "Could not setup class: " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw MiniJava.error(ruby, invocationTargetException, "Could not setup class: " + clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw MiniJava.error(ruby, noSuchMethodException, "Could not setup class: " + clazz);
        }
        final HashMap<String, Field> hashMap = new HashMap<String, Field>();
        try {
            for (Map.Entry<String, List<Method>> entry : map.entrySet()) {
                String string = entry.getKey();
                Field field = clazz.getField(string);
                Set<String> set = JavaUtil.getRubyNamesForJavaName(string, entry.getValue());
                for (String string2 : set) {
                    hashMap.put(string2, field);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MiniJava.error(ruby, illegalArgumentException, "Could not prepare method fields: " + clazz);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw MiniJava.error(ruby, noSuchFieldException, "Could not prepare method fields: " + clazz);
        }
        JavaMethod javaMethod = new JavaMethod((RubyModule)rubyClass.getSingletonClass(), Visibility.PUBLIC){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                RubyClass rubyClass = (RubyClass)iRubyObject;
                Ruby ruby = rubyClass.getClassRuntime();
                String string2 = iRubyObjectArray[0].asJavaString();
                Field field = (Field)hashMap.get(string2);
                if (field != null) {
                    try {
                        IRubyObject iRubyObject2 = iRubyObject;
                        synchronized (iRubyObject2) {
                            DynamicMethod dynamicMethod = rubyClass.searchMethod(string2);
                            if (dynamicMethod != UndefinedMethod.INSTANCE) {
                                field.set(null, dynamicMethod);
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw MiniJava.error(ruby, illegalAccessException, "Could not set new method into field: " + rubyClass + "." + string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MiniJava.error(ruby, illegalArgumentException, "Could not set new method into field: " + rubyClass + "." + string2);
                    }
                }
                return threadContext.getRuntime().getNil();
            }
        };
        rubyClass.getSingletonClass().addMethod("method_added", javaMethod);
    }

    protected static String mangleMethodFieldName(String string, Class[] classArray) {
        String string2 = string + CodegenUtils.prettyParams(classArray);
        string2 = string2.replace('.', '\\');
        return string2;
    }

    protected static Class findClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        if (string.indexOf(46) == -1 && Character.isLowerCase(string.charAt(0))) {
            switch (string.charAt(0)) {
                case 'b': {
                    return Byte.TYPE;
                }
                case 's': {
                    return Short.TYPE;
                }
                case 'c': {
                    return Character.TYPE;
                }
                case 'i': {
                    return Integer.TYPE;
                }
                case 'l': {
                    return Long.TYPE;
                }
                case 'f': {
                    return Float.TYPE;
                }
                case 'd': {
                    return Double.TYPE;
                }
            }
            return classLoader.loadClass(string);
        }
        return classLoader.loadClass(string);
    }

    public static RubyModule getMirrorForClass(Ruby ruby, Class clazz) {
        if (clazz == null) {
            return ruby.getObject();
        }
        RubyModule rubyModule = classMap.get(clazz);
        if (rubyModule == null) {
            rubyModule = MiniJava.createMirrorForClass(ruby, clazz);
            classMap.put(clazz, rubyModule);
            MiniJava.populateMirrorForClass(rubyModule, clazz);
            rubyModule = classMap.get(clazz);
        }
        return rubyModule;
    }

    protected static RubyModule createMirrorForClass(Ruby ruby, Class clazz) {
        if (clazz.isInterface()) {
            RubyModule rubyModule = RubyModule.newModule(ruby);
            return rubyModule;
        }
        RubyClass rubyClass = RubyClass.newClass(ruby, (RubyClass)MiniJava.getMirrorForClass(ruby, clazz.getSuperclass()));
        return rubyClass;
    }

    protected static void populateMirrorForClass(RubyModule rubyModule, Class clazz) {
        Class<?>[] classArray;
        Ruby ruby = rubyModule.getRuntime();
        rubyModule.setBaseName(clazz.getCanonicalName());
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            rubyModule.includeModule(MiniJava.getMirrorForClass(ruby, clazz2));
        }
        if (clazz.getEnclosingClass() != null && !Modifier.isPublic(clazz.getModifiers())) {
            return;
        }
        RubyClass rubyClass = rubyModule.getSingletonClass();
        if (clazz.isArray()) {
            MiniJava.populateMirrorForArrayClass(rubyModule, clazz);
        } else {
            MiniJava.populateDeclaredMethods(rubyModule, clazz, true);
            MiniJava.populateConstructors(rubyClass, clazz);
            MiniJava.populateArrayConstructors(rubyClass);
            MiniJava.populateFields(rubyModule, clazz);
        }
        MiniJava.populateSpecialMethods(rubyModule, rubyClass, clazz);
    }

    private static void populateArrayConstructors(RubyModule rubyModule) {
        rubyModule.addMethod("[]", new JavaMethod.JavaMethodOneOrTwoOrThree(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
                Class clazz = MiniJava.getJavaClassFromObject(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                return MiniJava.javaToRuby(threadContext.getRuntime(), Array.newInstance(clazz, n));
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
                Class clazz = MiniJava.getJavaClassFromObject(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                int n2 = RubyFixnum.fix2int(iRubyObject3.convertToInteger());
                return MiniJava.javaToRuby(threadContext.getRuntime(), Array.newInstance(clazz, n, n2));
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
                Class clazz = MiniJava.getJavaClassFromObject(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                int n2 = RubyFixnum.fix2int(iRubyObject3.convertToInteger());
                int n3 = RubyFixnum.fix2int(iRubyObject4.convertToInteger());
                return MiniJava.javaToRuby(threadContext.getRuntime(), Array.newInstance(clazz, n, n2, n3));
            }
        });
    }

    private static void populateConstructors(RubyModule rubyModule, final Class clazz) {
        Constructor<?>[] constructorArray;
        final Ruby ruby = rubyModule.getRuntime();
        for (final Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            JavaMethod javaMethod = constructor.getParameterTypes().length == 0 ? new JavaMethod.JavaMethodZero(rubyModule, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                    try {
                        return MiniJava.javaToRuby(threadContext.getRuntime(), constructor.newInstance(new Object[0]));
                    }
                    catch (InstantiationException instantiationException) {
                        if (ruby.getDebug().isTrue()) {
                            instantiationException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (ruby.getDebug().isTrue()) {
                            illegalAccessException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (ruby.getDebug().isTrue()) {
                            illegalArgumentException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (ruby.getDebug().isTrue()) {
                            invocationTargetException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                }
            } : new JavaMethod.JavaMethodNoBlock(rubyModule, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
                    Object[] objectArray = new Object[iRubyObjectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = MiniJava.rubyToJava(iRubyObjectArray[i]);
                    }
                    try {
                        return MiniJava.javaToRuby(ruby, constructor.newInstance(objectArray));
                    }
                    catch (InstantiationException instantiationException) {
                        if (ruby.getDebug().isTrue()) {
                            instantiationException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (ruby.getDebug().isTrue()) {
                            illegalAccessException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (ruby.getDebug().isTrue()) {
                            illegalArgumentException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (ruby.getDebug().isTrue()) {
                            invocationTargetException.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + clazz.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                }
            };
            if (rubyModule.getMethods().get("new") == null) {
                rubyModule.addMethod("new", javaMethod);
            }
            rubyModule.addMethod("new" + CodegenUtils.prettyParams(constructor.getParameterTypes()), javaMethod);
        }
    }

    private static void populateDeclaredMethods(RubyModule rubyModule, Class clazz, boolean bl) throws SecurityException {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            RubyModule rubyModule2;
            String string = method.getName();
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                if (!bl) continue;
                rubyModule2 = rubyModule.getSingletonClass();
            } else {
                rubyModule2 = rubyModule;
            }
            JavaMethodFactory javaMethodFactory = MiniJava.getMethodFactory(method.getReturnType());
            DynamicMethod dynamicMethod = javaMethodFactory.createMethod(rubyModule2, method);
            if (rubyModule2.getMethods().get(string) == null) {
                rubyModule2.addMethod(string, dynamicMethod);
            }
            string = string + CodegenUtils.prettyParams(method.getParameterTypes());
            rubyModule2.addMethod(string, dynamicMethod);
        }
    }

    private static void populateSpecialMethods(RubyModule rubyModule, RubyModule rubyModule2, final Class clazz) {
        final Ruby ruby = rubyModule.getRuntime();
        rubyModule2.addMethod("java_class", new JavaMethod.JavaMethodZero(rubyModule2, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                return MiniJava.javaToRuby(ruby, clazz);
            }
        });
    }

    private static void populateFields(RubyModule rubyModule, Class clazz) throws RaiseException, SecurityException {
        Field[] fieldArray;
        Ruby ruby = rubyModule.getRuntime();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !IdUtil.isConstant(field.getName())) continue;
            Object object = null;
            try {
                object = field.get(null);
            }
            catch (Exception exception) {
                throw ruby.newTypeError("Could not access field " + clazz.getCanonicalName() + "::" + field.getName() + " using " + CodegenUtils.ci(field.getType()));
            }
            rubyModule.defineConstant(field.getName(), new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, object.getClass()), object));
        }
    }

    protected static void populateMirrorForArrayClass(RubyModule rubyModule, Class clazz) {
        final Ruby ruby = rubyModule.getRuntime();
        rubyModule.addMethod("[]", new JavaMethod.JavaMethodOneOrTwo(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
                Object object = MiniJava.rubyToJava(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(object, n));
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
                Object object = MiniJava.rubyToJava(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                int n2 = RubyFixnum.fix2int(iRubyObject3.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(Array.get(object, n), n2));
            }
        });
        rubyModule.addMethod("[]=", new JavaMethod.JavaMethodTwoOrThree(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
                Object object = MiniJava.rubyToJava(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                Object object2 = MiniJava.rubyToJava(iRubyObject3);
                Array.set(object, n, object2);
                return iRubyObject3;
            }

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
                Object object = MiniJava.rubyToJava(iRubyObject);
                int n = RubyFixnum.fix2int(iRubyObject2.convertToInteger());
                int n2 = RubyFixnum.fix2int(iRubyObject3.convertToInteger());
                Object object2 = MiniJava.rubyToJava(iRubyObject4);
                Array.set(Array.get(object, n), n2, object2);
                return iRubyObject4;
            }
        });
        rubyModule.addMethod("length", new JavaMethod.JavaMethodZero(rubyModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                Object object = MiniJava.rubyToJava(iRubyObject);
                return MiniJava.javaToRuby(ruby, Array.getLength(object));
            }
        });
    }

    protected static JavaMethodFactory getMethodFactory(Class clazz) {
        JavaMethodFactory javaMethodFactory = methodFactories.get(clazz);
        if (javaMethodFactory == null) {
            return JAVA_OBJECT_METHOD_FACTORY;
        }
        return javaMethodFactory;
    }

    protected static RaiseException error(Ruby ruby, Exception exception, String string) throws RaiseException {
        if (ruby.getDebug().isTrue()) {
            exception.printStackTrace();
        }
        throw ruby.newTypeError(string);
    }

    public static Object rubyToJava(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return null;
        }
        if (iRubyObject instanceof JavaObjectWrapper) {
            return ((JavaObjectWrapper)iRubyObject).object;
        }
        return iRubyObject;
    }

    public static IRubyObject javaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        return new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, object.getClass()), object);
    }

    public static Class getJavaClassFromObject(IRubyObject iRubyObject) {
        if (!iRubyObject.respondsTo("java_class")) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject.getMetaClass().getBaseName() + " is not a Java type");
        }
        return (Class)MiniJava.rubyToJava(iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "java_class"));
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string) {
        return rubyClass.searchMethod(string);
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3, String string4) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3, string4);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3, String string4, String string5) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3, string4, string5);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3, String string4, String string5, String string6) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3, string4, string5, string6);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3, string4, string5, string6, string7);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(RubyClass rubyClass, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        DynamicMethod dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod == UndefinedMethod.INSTANCE) {
            return MiniJava.searchMethod(rubyClass, string2, string3, string4, string5, string6, string7, string8);
        }
        return dynamicMethod;
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3, String string4) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3, string4);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3, String string4, String string5) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3, string4, string5);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3, String string4, String string5, String string6) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3, string4, string5, string6);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3, string4, string5, string6, string7);
    }

    public static DynamicMethod searchMethod(IRubyObject iRubyObject, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return MiniJava.searchMethod(iRubyObject.getMetaClass(), string, string2, string3, string4, string5, string6, string7, string8);
    }

    static {
        methodFactories.put(Void.TYPE, new JavaMethodFactory(){

            public DynamicMethod createMethod(RubyModule rubyModule, Method method) {
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0) {
                    return new JavaVoidWrapperMethod(rubyModule, method);
                }
                return new JavaVoidWrapperMethodZero(rubyModule, method);
            }
        });
    }

    public static class JavaObjectWrapper
    extends RubyObject {
        Object object;

        public JavaObjectWrapper(RubyClass rubyClass, Object object) {
            super(rubyClass.getRuntime(), rubyClass);
            this.object = object;
        }
    }

    protected static class JavaVoidWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaVoidWrapperMethodZero(RubyModule rubyModule, Method method) {
            super(rubyModule, method);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return iRubyObject;
        }
    }

    protected static class JavaVoidWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaVoidWrapperMethod(RubyModule rubyModule, Method method) {
            super(rubyModule, method);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            Object[] objectArray = new Object[iRubyObjectArray.length];
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject2 = iRubyObjectArray[i];
                objectArray[i] = MiniJava.rubyToJava(iRubyObject2);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, objectArray);
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2));
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3));
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3), MiniJava.rubyToJava(iRubyObject4));
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
            Object[] objectArray = new Object[iRubyObjectArray.length];
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject2 = iRubyObjectArray[i];
                objectArray[i] = MiniJava.rubyToJava(iRubyObject2);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, objectArray);
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2));
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3));
            return iRubyObject;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3), MiniJava.rubyToJava(iRubyObject4));
            return iRubyObject;
        }
    }

    protected static class JavaObjectWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaObjectWrapperMethod(RubyModule rubyModule, Method method) {
            super(rubyModule, method);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            Object[] objectArray = new Object[iRubyObjectArray.length];
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject2 = iRubyObjectArray[i];
                objectArray[i] = MiniJava.rubyToJava(iRubyObject2);
            }
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, objectArray);
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, Block block) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, Block block) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2));
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3));
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3), MiniJava.rubyToJava(iRubyObject4));
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
            Object[] objectArray = new Object[iRubyObjectArray.length];
            for (int i = 0; i < iRubyObjectArray.length; ++i) {
                IRubyObject iRubyObject2 = iRubyObjectArray[i];
                objectArray[i] = MiniJava.rubyToJava(iRubyObject2);
            }
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, objectArray);
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2));
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3));
            return MiniJava.javaToRuby(this.ruby, object);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object, MiniJava.rubyToJava(iRubyObject2), MiniJava.rubyToJava(iRubyObject3), MiniJava.rubyToJava(iRubyObject4));
            return MiniJava.javaToRuby(this.ruby, object);
        }
    }

    protected static class JavaObjectWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaObjectWrapperMethodZero(RubyModule rubyModule, Method method) {
            super(rubyModule, method);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
            Object object = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)iRubyObject).object);
            return MiniJava.javaToRuby(this.ruby, object);
        }
    }

    public static abstract class AbstractJavaWrapperMethod
    extends JavaMethod {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethod(RubyModule rubyModule, Method method) {
            super(rubyModule, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(rubyModule.getRuntime().getJRubyClassLoader(), method);
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.className = method.getDeclaringClass().getCanonicalName();
            this.methodName = method.getName();
            this.prettySig = CodegenUtils.prettyParams(method.getParameterTypes());
            this.ruby = rubyModule.getRuntime();
        }

        protected RaiseException error(Exception exception) throws RaiseException {
            return MiniJava.error(this.ruby, exception, "Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static abstract class AbstractJavaWrapperMethodZero
    extends JavaMethod.JavaMethodZero {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethodZero(RubyModule rubyModule, Method method) {
            super(rubyModule, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(rubyModule.getRuntime().getJRubyClassLoader(), method);
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.className = method.getDeclaringClass().getCanonicalName();
            this.methodName = method.getName();
            this.prettySig = CodegenUtils.prettyParams(method.getParameterTypes());
            this.ruby = rubyModule.getRuntime();
        }

        protected RaiseException error(ThreadContext threadContext, Exception exception) throws RaiseException {
            if (this.ruby.getDebug().isTrue()) {
                exception.printStackTrace();
            }
            throw this.ruby.newTypeError("Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static class JavaMethodFactory {
        public DynamicMethod createMethod(RubyModule rubyModule, Method method) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length > 0) {
                return new JavaObjectWrapperMethod(rubyModule, method);
            }
            return new JavaObjectWrapperMethodZero(rubyModule, method);
        }
    }
}

