/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyFixnum;
import org.jruby.nb.nb.nb.RubyIO;
import org.jruby.nb.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyNumeric;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.anno.JRubyClass;
import org.jruby.nb.nb.nb.anno.JRubyMethod;
import org.jruby.nb.nb.nb.anno.JRubyModule;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.ext.socket.IANA;
import org.jruby.nb.nb.nb.ext.socket.RubyBasicSocket;
import org.jruby.nb.nb.nb.ext.socket.RubyIPSocket;
import org.jruby.nb.nb.nb.ext.socket.RubyTCPServer;
import org.jruby.nb.nb.nb.ext.socket.RubyTCPSocket;
import org.jruby.nb.nb.nb.ext.socket.RubyUDPSocket;
import org.jruby.nb.nb.nb.ext.socket.RubyUNIXServer;
import org.jruby.nb.nb.nb.ext.socket.RubyUNIXSocket;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.ObjectAllocator;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.load.Library;
import org.jruby.nb.nb.nb.util.io.ChannelDescriptor;
import org.jruby.nb.nb.nb.util.io.InvalidValueException;
import org.jruby.nb.nb.nb.util.io.ModeFlags;
import org.jruby.util.ByteList;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubySocket(ruby, rubyClass);
        }
    };
    public static final int NI_DGRAM = 16;
    public static final int NI_MAXHOST = 1025;
    public static final int NI_MAXSERV = 32;
    public static final int NI_NAMEREQD = 4;
    public static final int NI_NOFQDN = 1;
    public static final int NI_NUMERICHOST = 2;
    public static final int NI_NUMERICSERV = 8;
    public static final int SOL_IP = 0;
    public static final int SOL_SOCKET = 65535;
    public static final int SOL_TCP = 6;
    public static final int SOL_UDP = 17;
    public static final int SO_BROADCAST = 32;
    public static final int SO_DEBUG = 1;
    public static final int SO_DONTROUTE = 16;
    public static final int SO_ERROR = 4103;
    public static final int SO_KEEPALIVE = 8;
    public static final int SO_LINGER = 128;
    public static final int SO_OOBINLINE = 256;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_RCVLOWAT = 4100;
    public static final int SO_RCVTIMEO = 4102;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_SNDLOWAT = 4099;
    public static final int SO_SNDTIMEO = 4101;
    public static final int SO_TIMESTAMP = 1024;
    public static final int SO_TYPE = 4104;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int AF_UNSPEC = 0;
    public static final int PF_UNSPEC = 0;
    public static final int AF_UNIX = 1;
    public static final int PF_UNIX = 1;
    public static final int AF_INET = 2;
    public static final int PF_INET = 2;
    public static final int AF_INET6 = 30;
    public static final int IPPROTO_IP = 0;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_TCP = 6;
    public static final int IPPROTO_UDP = 17;
    private int soDomain;
    private int soType;
    private int soProtocol;
    private static final Pattern STRING_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int HOST_GROUP = 3;
    private static final int PORT_GROUP = 5;

    static void createSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Socket", ruby.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rubyModule = rubyClass.defineModuleUnder("Constants");
        rubyModule.fastSetConstant("SOCK_STREAM", ruby.newFixnum(1));
        rubyModule.fastSetConstant("SOCK_DGRAM", ruby.newFixnum(2));
        rubyModule.fastSetConstant("SOCK_RAW", ruby.newFixnum(3));
        rubyModule.fastSetConstant("PF_UNSPEC", ruby.newFixnum(0));
        rubyModule.fastSetConstant("AF_UNSPEC", ruby.newFixnum(0));
        rubyModule.fastSetConstant("PF_INET", ruby.newFixnum(2));
        rubyModule.fastSetConstant("AF_INET", ruby.newFixnum(2));
        rubyModule.fastSetConstant("AF_INET6", ruby.newFixnum(30));
        rubyModule.fastSetConstant("MSG_OOB", ruby.newFixnum(1));
        rubyModule.fastSetConstant("SOL_SOCKET", ruby.newFixnum(65535));
        rubyModule.fastSetConstant("SOL_IP", ruby.newFixnum(0));
        rubyModule.fastSetConstant("SOL_TCP", ruby.newFixnum(6));
        rubyModule.fastSetConstant("SOL_UDP", ruby.newFixnum(17));
        rubyModule.fastSetConstant("IPPROTO_IP", ruby.newFixnum(0));
        rubyModule.fastSetConstant("IPPROTO_ICMP", ruby.newFixnum(1));
        rubyModule.fastSetConstant("IPPROTO_TCP", ruby.newFixnum(6));
        rubyModule.fastSetConstant("IPPROTO_UDP", ruby.newFixnum(17));
        rubyModule.fastSetConstant("INADDR_ANY", ruby.newFixnum(0));
        rubyModule.fastSetConstant("INADDR_BROADCAST", ruby.newFixnum(-1));
        rubyModule.fastSetConstant("INADDR_LOOPBACK", ruby.newFixnum(2130706433));
        rubyModule.fastSetConstant("INADDR_UNSPEC_GROUP", ruby.newFixnum(-536870912));
        rubyModule.fastSetConstant("INADDR_ALLHOSTS_GROUP", ruby.newFixnum(-536870911));
        rubyModule.fastSetConstant("INADDR_MAX_LOCAL_GROUP", ruby.newFixnum(-536870657));
        rubyModule.fastSetConstant("INADDR_NONE", ruby.newFixnum(-1));
        rubyModule.fastSetConstant("SHUT_RD", ruby.newFixnum(0));
        rubyModule.fastSetConstant("SHUT_WR", ruby.newFixnum(1));
        rubyModule.fastSetConstant("SHUT_RDWR", ruby.newFixnum(2));
        rubyModule.fastSetConstant("AI_PASSIVE", ruby.newFixnum(1));
        rubyModule.fastSetConstant("SO_BROADCAST", ruby.newFixnum(32));
        rubyModule.fastSetConstant("SO_DEBUG", ruby.newFixnum(1));
        rubyModule.fastSetConstant("SO_DONTROUTE", ruby.newFixnum(16));
        rubyModule.fastSetConstant("SO_ERROR", ruby.newFixnum(4103));
        rubyModule.fastSetConstant("SO_KEEPALIVE", ruby.newFixnum(8));
        rubyModule.fastSetConstant("SO_LINGER", ruby.newFixnum(128));
        rubyModule.fastSetConstant("SO_OOBINLINE", ruby.newFixnum(256));
        rubyModule.fastSetConstant("SO_RCVBUF", ruby.newFixnum(4098));
        rubyModule.fastSetConstant("SO_RCVLOWAT", ruby.newFixnum(4100));
        rubyModule.fastSetConstant("SO_RCVTIMEO", ruby.newFixnum(4102));
        rubyModule.fastSetConstant("SO_REUSEADDR", ruby.newFixnum(4));
        rubyModule.fastSetConstant("SO_SNDBUF", ruby.newFixnum(4097));
        rubyModule.fastSetConstant("SO_SNDLOWAT", ruby.newFixnum(4099));
        rubyModule.fastSetConstant("SO_SNDTIMEO", ruby.newFixnum(4101));
        rubyModule.fastSetConstant("SO_TIMESTAMP", ruby.newFixnum(1024));
        rubyModule.fastSetConstant("SO_TYPE", ruby.newFixnum(4104));
        rubyModule.fastSetConstant("TCP_NODELAY", ruby.newFixnum(1));
        rubyModule.fastSetConstant("NI_DGRAM", ruby.newFixnum(16));
        rubyModule.fastSetConstant("NI_MAXHOST", ruby.newFixnum(1025));
        rubyModule.fastSetConstant("NI_MAXSERV", ruby.newFixnum(32));
        rubyModule.fastSetConstant("NI_NAMEREQD", ruby.newFixnum(4));
        rubyModule.fastSetConstant("NI_NOFQDN", ruby.newFixnum(1));
        rubyModule.fastSetConstant("NI_NUMERICHOST", ruby.newFixnum(2));
        rubyModule.fastSetConstant("NI_NUMERICSERV", ruby.newFixnum(8));
        rubyClass.includeModule(rubyModule);
        rubyClass.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected int getSoTypeDefault() {
        return this.soType;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject for_fd(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyFixnum) {
            RubySocket rubySocket = (RubySocket)((RubyClass)iRubyObject).allocate();
            ChannelDescriptor channelDescriptor = rubySocket.getDescriptorByFileno((int)((RubyFixnum)iRubyObject2).getLongValue());
            if (channelDescriptor == null) {
                throw ruby.newErrnoEBADFError();
            }
            Channel channel = channelDescriptor.getChannel();
            if (channel instanceof SocketChannel) {
                rubySocket.soDomain = 2;
                rubySocket.soType = 1;
                rubySocket.soProtocol = 0;
            } else if (channel instanceof DatagramChannel) {
                rubySocket.soDomain = 2;
                rubySocket.soType = 2;
                rubySocket.soProtocol = 0;
            } else {
                throw rubySocket.getRuntime().newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
            }
            rubySocket.initSocket(channelDescriptor);
            return rubySocket;
        }
        throw iRubyObject.getRuntime().newTypeError(iRubyObject2, iRubyObject.getRuntime().getFixnum());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        try {
            Object object;
            if (iRubyObject instanceof RubyString) {
                object = iRubyObject.toString();
                if (((String)object).equals("AF_INET")) {
                    this.soDomain = 2;
                } else {
                    if (!((String)object).equals("PF_INET")) throw RubySocket.sockerr(this, "unknown socket domain " + (String)object);
                    this.soDomain = 2;
                }
            } else {
                this.soDomain = RubyNumeric.fix2int(iRubyObject);
            }
            if (iRubyObject2 instanceof RubyString) {
                object = iRubyObject2.toString();
                if (((String)object).equals("SOCK_STREAM")) {
                    this.soType = 1;
                } else {
                    if (!((String)object).equals("SOCK_DGRAM")) throw RubySocket.sockerr(this, "unknown socket type " + (String)object);
                    this.soType = 2;
                }
            } else {
                this.soType = RubyNumeric.fix2int(iRubyObject2);
            }
            this.soProtocol = RubyNumeric.fix2int(iRubyObject3);
            object = null;
            if (this.soType == 1) {
                object = SocketChannel.open();
            } else if (this.soType == 2) {
                object = DatagramChannel.open();
            }
            this.initSocket(new ChannelDescriptor((Channel)object, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            return this;
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw RubySocket.sockerr(this, "initialize: " + iOException.toString());
        }
    }

    private static RuntimeException sockerr(IRubyObject iRubyObject, String string) {
        return new RaiseException(iRubyObject.getRuntime(), iRubyObject.getRuntime().fastGetClass("SocketError"), string, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(IRubyObject iRubyObject) {
        try {
            return iRubyObject.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            try {
                return iRubyObject.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException unknownHostException2) {
                throw RubySocket.sockerr(iRubyObject, "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(IRubyObject iRubyObject, String string) {
        try {
            byte[] byArray = ByteList.plain((CharSequence)string);
            return InetAddress.getByAddress(byArray);
        }
        catch (Exception exception) {
            throw RubySocket.sockerr(iRubyObject, "strtoaddr: " + exception.toString());
        }
    }

    private static String intoString(IRubyObject iRubyObject, InetAddress inetAddress) {
        try {
            return new String(ByteList.plain((byte[])inetAddress.getAddress()));
        }
        catch (Exception exception) {
            throw RubySocket.sockerr(iRubyObject, "addrtostr: " + exception.toString());
        }
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[]{ruby.newString(RubySocket.intoAddress(iRubyObject, iRubyObjectArray[0].convertToString().toString()).getCanonicalHostName()), ruby.newArray(), ruby.newFixnum(2), iRubyObjectArray[0]};
        return ruby.newArrayNoCopy(iRubyObjectArray2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        int n = Arity.checkArgumentCount(ruby, iRubyObjectArray, 1, 2);
        String string = iRubyObjectArray[0].convertToString().toString();
        String string2 = n == 1 ? "tcp" : iRubyObjectArray[1].convertToString().toString();
        Integer n2 = IANA.serviceToPort.get(string + "/" + string2);
        if (n2 == null) {
            throw RubySocket.sockerr(iRubyObject, "no such service " + string + "/" + string2);
        }
        return ruby.newFixnum(n2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0001');
        String string = iRubyObject2.convertToString().toString();
        stringBuilder.append(string);
        for (int i = string.length(); i < 104; ++i) {
            stringBuilder.append('\u0000');
        }
        return iRubyObject.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0010');
        stringBuilder.append('\u0002');
        int n = RubyNumeric.fix2int(iRubyObject2);
        stringBuilder.append((char)(n >> 8 & 0xFF));
        stringBuilder.append((char)(n & 0xFF));
        try {
            String string;
            String string2 = string = iRubyObject3.isNil() ? null : iRubyObject3.convertToString().toString();
            if (string != null && "".equals(string)) {
                stringBuilder.append('\u0000');
                stringBuilder.append('\u0000');
                stringBuilder.append('\u0000');
                stringBuilder.append('\u0000');
            } else {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                byte[] byArray = inetAddressArray[0].getAddress();
                stringBuilder.append((char)byArray[0]);
                stringBuilder.append((char)byArray[1]);
                stringBuilder.append((char)byArray[2]);
                stringBuilder.append((char)byArray[3]);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw RubySocket.sockerr(iRubyObject, "getaddrinfo: No address associated with nodename");
        }
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        stringBuilder.append('\u0000');
        return iRubyObject.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject2.convertToString().toString();
        if (string.charAt(0) != '\u0010' || string.charAt(1) != '\u0002') {
            throw iRubyObject.getRuntime().newArgumentError("can't resolve socket address of wrong type");
        }
        int n = (string.charAt(2) << 8) + string.charAt(3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((int)string.charAt(4));
        stringBuilder.append(".");
        stringBuilder.append((int)string.charAt(5));
        stringBuilder.append(".");
        stringBuilder.append((int)string.charAt(6));
        stringBuilder.append(".");
        stringBuilder.append((int)string.charAt(7));
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{iRubyObject.getRuntime().newFixnum(n), iRubyObject.getRuntime().newString(stringBuilder.toString())};
        return iRubyObject.getRuntime().newArrayNoCopy(iRubyObjectArray);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(iRubyObject2.convertToString().toString());
            Ruby ruby = iRubyObject.getRuntime();
            IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString(inetAddress.getCanonicalHostName()), ruby.newArray(), ruby.newFixnum(2), ruby.newString(RubySocket.intoString(iRubyObject, inetAddress))};
            return ruby.newArrayNoCopy(iRubyObjectArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw RubySocket.sockerr(iRubyObject, "gethostbyname: name or service not known");
        }
    }

    @JRubyMethod(required=2, optional=4, meta=true)
    public static IRubyObject getaddrinfo(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        iRubyObjectArray = Arity.scanArgs(iRubyObject.getRuntime(), iRubyObjectArray, 2, 4);
        try {
            Ruby ruby = iRubyObject.getRuntime();
            IRubyObject iRubyObject2 = iRubyObjectArray[0];
            IRubyObject iRubyObject3 = iRubyObjectArray[1];
            if (iRubyObject3 instanceof RubyString) {
                iRubyObject3 = RubySocket.getservbyname(iRubyObject, new IRubyObject[]{iRubyObject3});
            }
            IRubyObject iRubyObject4 = iRubyObjectArray[3];
            boolean bl = true;
            boolean bl2 = true;
            if (!iRubyObject4.isNil()) {
                int n = RubyNumeric.fix2int(iRubyObject4);
                if (n == 1) {
                    bl2 = false;
                } else if (n == 2) {
                    bl = false;
                }
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(iRubyObject2.isNil() ? null : iRubyObject2.convertToString().toString());
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            for (int i = 0; i < inetAddressArray.length; ++i) {
                IRubyObject[] iRubyObjectArray2;
                if (bl2) {
                    iRubyObjectArray2 = new IRubyObject[]{ruby.newString("AF_INET"), iRubyObject3, ruby.newString(inetAddressArray[i].getCanonicalHostName()), ruby.newString(inetAddressArray[i].getHostAddress()), ruby.newFixnum(2), ruby.newFixnum(2), ruby.newFixnum(17)};
                    arrayList.add(ruby.newArrayNoCopy(iRubyObjectArray2));
                }
                if (!bl) continue;
                iRubyObjectArray2 = new IRubyObject[]{ruby.newString("AF_INET"), iRubyObject3, ruby.newString(inetAddressArray[i].getCanonicalHostName()), ruby.newString(inetAddressArray[i].getHostAddress()), ruby.newFixnum(2), ruby.newFixnum(1), ruby.newFixnum(6)};
                arrayList.add(ruby.newArrayNoCopy(iRubyObjectArray2));
            }
            return ruby.newArray(arrayList);
        }
        catch (UnknownHostException unknownHostException) {
            throw RubySocket.sockerr(iRubyObject, "getaddrinfo: name or service not known");
        }
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        String string;
        String string2;
        Object object;
        Ruby ruby = iRubyObject.getRuntime();
        int n = Arity.checkArgumentCount(ruby, iRubyObjectArray, 1, 2);
        int n2 = n == 2 ? RubyNumeric.num2int(iRubyObjectArray[1]) : 0;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        if (iRubyObject2 instanceof RubyArray) {
            object = ((RubyArray)iRubyObject2).getList();
            int n3 = object.size();
            if (n3 < 3 || n3 > 4) {
                throw ruby.newArgumentError("array size should be 3 or 4, " + n3 + " given");
            }
            string2 = object.get(2).toString();
            string = object.get(1).toString();
        } else if (iRubyObject2 instanceof RubyString) {
            object = ((RubyString)iRubyObject2).toString();
            Matcher matcher = STRING_ADDRESS_PATTERN.matcher((CharSequence)object);
            if (!matcher.matches()) {
                throw ruby.newArgumentError("invalid address string");
            }
            string2 = matcher.group(3);
            if (string2 == null || string2.length() == 0 || (string = matcher.group(5)) == null || string.length() == 0) {
                throw ruby.newArgumentError("invalid address string");
            }
        } else {
            throw ruby.newArgumentError("invalid args");
        }
        try {
            object = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw RubySocket.sockerr(iRubyObject, "unknown host: " + string2);
        }
        string2 = (n2 & 2) == 0 ? ((InetAddress)object).getCanonicalHostName() : ((InetAddress)object).getHostAddress();
        return ruby.newArray(ruby.newString(string2), ruby.newString(string));
    }

    @JRubyModule(name={"Socket::Constants"})
    public static class Constants {
    }

    public static class Service
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            ruby.defineClass("SocketError", ruby.getStandardError(), ruby.getStandardError().getAllocator());
            RubyBasicSocket.createBasicSocket(ruby);
            RubySocket.createSocket(ruby);
            ruby.getInstanceConfig();
            if (RubyInstanceConfig.nativeEnabled && RubyUNIXSocket.tryUnixDomainSocket()) {
                RubyUNIXSocket.createUNIXSocket(ruby);
                RubyUNIXServer.createUNIXServer(ruby);
            }
            RubyIPSocket.createIPSocket(ruby);
            RubyTCPSocket.createTCPSocket(ruby);
            RubyTCPServer.createTCPServer(ruby);
            RubyUDPSocket.createUDPSocket(ruby);
        }
    }

    @JRubyClass(name={"SocketError"}, parent="StandardError")
    public static class SocketError {
    }
}

