/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.nb.nb.nb.NativeException;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyException;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.runtime.MethodIndex;
import org.jruby.nb.nb.nb.runtime.RubyEvent;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;

    public RaiseException(RubyException rubyException) {
        this(rubyException, false);
    }

    public RaiseException(Ruby ruby, RubyClass rubyClass, String string, boolean bl) {
        super(string);
        if (string == null) {
            string = "No message available";
        }
        this.setException((RubyException)RuntimeHelpers.invoke(ruby.getCurrentContext(), (IRubyObject)rubyClass, "new", RubyString.newUnicodeString(rubyClass.getRuntime(), string)), bl);
    }

    public RaiseException(RubyException rubyException, boolean bl) {
        this.setException(rubyException, bl);
    }

    public static RaiseException createNativeRaiseException(Ruby ruby, Throwable throwable) {
        NativeException nativeException = new NativeException(ruby, ruby.getClass("NativeException"), throwable);
        return new RaiseException(throwable, nativeException);
    }

    private static String buildMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringBuilder.append("Native Exception: '").append(throwable.getClass()).append("'; ");
        stringBuilder.append("Message: ").append(throwable.getMessage()).append("; ");
        stringBuilder.append("StackTrace: ").append(stringWriter.getBuffer().toString());
        return stringBuilder.toString();
    }

    public RaiseException(Throwable throwable, NativeException nativeException) {
        super(RaiseException.buildMessage(throwable), throwable);
        this.setException(nativeException, false);
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException rubyException, boolean bl) {
        Ruby ruby = rubyException.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        if (!threadContext.isWithinDefined()) {
            ruby.getGlobalVariables().set("$!", rubyException);
        }
        if (ruby.hasEventHooks()) {
            ruby.callEventHooks(threadContext, RubyEvent.RAISE, threadContext.getFile(), threadContext.getLine(), threadContext.getFrameName(), threadContext.getFrameKlazz());
        }
        this.exception = rubyException;
        if (ruby.getStackTraces() > 5) {
            return;
        }
        ruby.setStackTraces(ruby.getStackTraces() + 1);
        StackTraceElement[] stackTraceElementArray = threadContext.createBacktrace2(0, bl);
        rubyException.setBacktraceFrames(stackTraceElementArray);
        if (rubyException instanceof NativeException) {
            this.setStackTrace(((NativeException)rubyException).getCause().getStackTrace());
        } else {
            this.setStackTrace(stackTraceElementArray);
        }
        ruby.setStackTraces(ruby.getStackTraces() - 1);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        int n = 0;
        int n2 = stackTraceElementArray.length - 1;
        while (n2 > 0 && stackTraceElementArray[n2].getClassName().indexOf("org.jruby.nb.nb.nb.evaluator") < 0) {
            n = n2--;
        }
        IRubyObject iRubyObject = this.exception.backtrace();
        Ruby ruby = iRubyObject.getRuntime();
        if (ruby.getNil() != iRubyObject) {
            String string = iRubyObject.callMethod(ruby.getCurrentContext(), "first").callMethod(ruby.getCurrentContext(), MethodIndex.TO_S, "to_s").toString();
            printStream.print(string + ": ");
        }
        printStream.println(this.exception.message + " (" + this.exception.getMetaClass().toString() + ")");
        this.exception.printBacktrace(printStream);
        printStream.println("\t...internal jruby stack elided...");
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            printStream.println("\tfrom " + stackTraceElementArray[i].toString());
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(byteArrayOutputStream));
        printWriter.print(byteArrayOutputStream.toString());
    }
}

