/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.environment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.environment.IOSEnvironmentReader;
import org.jruby.nb.nb.nb.environment.OSEnvironment;
import org.jruby.nb.nb.nb.environment.OSEnvironmentReaderExcepton;

class OSEnvironmentReaderFromFile
implements IOSEnvironmentReader {
    private static final String JRUBY_ENVFILE = "jruby.envfile";
    private final OSEnvironment environmentReader = new OSEnvironment();

    OSEnvironmentReaderFromFile() {
    }

    public boolean isAccessible(Ruby ruby) {
        String string = System.getProperty(JRUBY_ENVFILE);
        if (string == null || string.length() < 1) {
            return false;
        }
        File file = new File(string);
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public Map getVariables(Ruby ruby) {
        String string = System.getProperty(JRUBY_ENVFILE);
        Map map = null;
        if (string == null || string.length() < 1) {
            this.environmentReader.handleException(new OSEnvironmentReaderExcepton("Property jruby.envfile not defined."));
        } else {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                map = null;
                this.environmentReader.handleException(fileNotFoundException);
            }
            map = this.environmentReader.getVariablesFrom(bufferedReader);
        }
        return map;
    }
}

