/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import org.jruby.nb.nb.nb.MetaClass;
import org.jruby.nb.nb.nb.Ruby;
import org.jruby.nb.nb.nb.RubyArray;
import org.jruby.nb.nb.nb.RubyBignum;
import org.jruby.nb.nb.nb.RubyBoolean;
import org.jruby.nb.nb.nb.RubyClass;
import org.jruby.nb.nb.nb.RubyException;
import org.jruby.nb.nb.nb.RubyFloat;
import org.jruby.nb.nb.nb.RubyHash;
import org.jruby.nb.nb.nb.RubyInstanceConfig;
import org.jruby.nb.nb.nb.RubyMatchData;
import org.jruby.nb.nb.nb.RubyModule;
import org.jruby.nb.nb.nb.RubyRange;
import org.jruby.nb.nb.nb.RubyRegexp;
import org.jruby.nb.nb.nb.RubyString;
import org.jruby.nb.nb.nb.RubySymbol;
import org.jruby.nb.nb.nb.ast.NodeType;
import org.jruby.nb.nb.nb.ast.executable.AbstractScript;
import org.jruby.nb.nb.nb.ast.util.ArgsUtil;
import org.jruby.nb.nb.nb.compiler.ASTInspector;
import org.jruby.nb.nb.nb.compiler.ArrayCallback;
import org.jruby.nb.nb.nb.compiler.BranchCallback;
import org.jruby.nb.nb.nb.compiler.CacheCompiler;
import org.jruby.nb.nb.nb.compiler.CompilerCallback;
import org.jruby.nb.nb.nb.compiler.InvocationCompiler;
import org.jruby.nb.nb.nb.compiler.MethodCompiler;
import org.jruby.nb.nb.nb.compiler.NotCompilableException;
import org.jruby.nb.nb.nb.compiler.ScriptCompiler;
import org.jruby.nb.nb.nb.compiler.VariableCompiler;
import org.jruby.nb.nb.nb.compiler.impl.BoxedVariableCompiler;
import org.jruby.nb.nb.nb.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.nb.nb.nb.compiler.impl.InheritedCacheCompiler;
import org.jruby.nb.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.nb.compiler.impl.StackBasedVariableCompiler;
import org.jruby.nb.nb.nb.compiler.impl.StandardInvocationCompiler;
import org.jruby.nb.nb.nb.exceptions.JumpException;
import org.jruby.nb.nb.nb.exceptions.RaiseException;
import org.jruby.nb.nb.nb.internal.runtime.GlobalVariables;
import org.jruby.nb.nb.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.nb.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.nb.nb.javasupport.JavaUtil;
import org.jruby.nb.nb.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.nb.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.Arity;
import org.jruby.nb.nb.nb.runtime.Block;
import org.jruby.nb.nb.nb.runtime.BlockBody;
import org.jruby.nb.nb.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.nb.runtime.Frame;
import org.jruby.nb.nb.nb.runtime.ThreadContext;
import org.jruby.nb.nb.nb.runtime.Visibility;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.runtime.builtin.InstanceVariables;
import org.jruby.nb.nb.nb.util.CodegenUtils;
import org.jruby.nb.nb.nb.util.JRubyClassLoader;
import org.jruby.nb.nb.nb.util.JavaNameMangler;
import org.jruby.util.ByteList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    private static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    private static final String RUBY = CodegenUtils.p(Ruby.class);
    private static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    public static final String[] METHOD_SIGNATURES = new String[]{CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class), CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)};
    private static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_OFFSET = 0;
    public static final int DYNAMIC_SCOPE_OFFSET = 1;
    public static final int RUNTIME_OFFSET = 2;
    public static final int VARS_ARRAY_OFFSET = 3;
    public static final int NIL_OFFSET = 4;
    public static final int EXCEPTION_OFFSET = 5;
    public static final int PREVIOUS_EXCEPTION_OFFSET = 6;
    public static final int FIRST_TEMP_OFFSET = 7;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    int methodIndex = -1;
    int innerIndex = -1;
    int fieldIndex = 0;
    int rescueNumber = 1;
    int ensureNumber = 1;
    StaticScope topLevelScope;
    CacheCompiler cacheCompiler;
    static boolean USE_INHERITED_CACHE_FIELDS = true;
    private int constants = 0;

    public StandardASMCompiler(String string, String string2) {
        this.classname = string;
        this.sourcename = string2;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader jRubyClassLoader) throws ClassNotFoundException {
        jRubyClassLoader.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return jRubyClassLoader.loadClass(CodegenUtils.c(this.classname));
    }

    public void dumpClass(PrintStream printStream) {
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(new PrintWriter(printStream));
        new ClassReader(this.classWriter.toByteArray()).accept((ClassVisitor)traceClassVisitor, 0);
        traceClassVisitor.print(new PrintWriter(printStream));
    }

    public void writeClass(File file) throws IOException {
        this.writeClass(this.classname, file, this.classWriter);
    }

    private void writeClass(String string, File file, ClassWriter classWriter) throws IOException {
        String string2 = string + ".class";
        String string3 = null;
        String string4 = null;
        byte[] byArray = classWriter.toByteArray();
        CheckClassAdapter.verify((ClassReader)new ClassReader(byArray), (boolean)false, (PrintWriter)new PrintWriter(System.err));
        if (string2.lastIndexOf("/") == -1) {
            string3 = string2;
            string4 = "";
        } else {
            string3 = string2.substring(string2.lastIndexOf("/") + 1);
            string4 = string2.substring(0, string2.lastIndexOf("/"));
        }
        File file2 = new File(file, string4);
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, string3));
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope staticScope) {
        String string;
        Object object;
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(RubyInstanceConfig.JAVA_VERSION, 33, this.classname, null, CodegenUtils.p(AbstractScript.class), null);
        this.topLevelScope = staticScope;
        this.beginInit();
        this.beginClassInit();
        this.cacheCompiler = new InheritedCacheCompiler(this);
        if (this.sourcename.indexOf("/") >= 0) {
            object = this.sourcename.split("/");
            string = object[((String[])object).length - 1];
        } else if (this.sourcename.indexOf("\\") >= 0) {
            object = this.sourcename.split("\\\\");
            string = object[((String[])object).length - 1];
        } else {
            string = this.sourcename;
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("SMAP\n").append(string).append("\n").append("Ruby\n").append("*S Ruby\n").append("*F\n").append("+ 1 ").append(string).append("\n").append(this.sourcename).append("\n").append("*L\n").append("1#1,999999:1,1\n").append("*E\n");
        this.classWriter.visitSource(string, ((StringBuffer)object).toString());
    }

    @Override
    public void endScript(boolean bl, boolean bl2) {
        SkinnyMethodAdapter skinnyMethodAdapter;
        String string = "__file__";
        if (bl || bl2) {
            skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURES[4], null, null));
            skinnyMethodAdapter.start();
            Label label = new Label();
            Label label2 = new Label();
            skinnyMethodAdapter.label(label);
            skinnyMethodAdapter.aload(1);
            StandardASMCompiler.buildStaticScopeNames(skinnyMethodAdapter, this.topLevelScope);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String[].class));
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.aload(3);
            skinnyMethodAdapter.aload(4);
            skinnyMethodAdapter.invokevirtual(this.classname, string, METHOD_SIGNATURES[4]);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            skinnyMethodAdapter.areturn();
            skinnyMethodAdapter.label(label2);
            skinnyMethodAdapter.aload(1);
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            skinnyMethodAdapter.athrow();
            skinnyMethodAdapter.trycatch(label, label2, label2, null);
            skinnyMethodAdapter.end();
        }
        if (bl2) {
            skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.newobj(this.classname);
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokespecial(this.classname, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            skinnyMethodAdapter.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            skinnyMethodAdapter.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
            skinnyMethodAdapter.swap();
            skinnyMethodAdapter.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            skinnyMethodAdapter.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            skinnyMethodAdapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            skinnyMethodAdapter.invokevirtual(this.classname, "load", METHOD_SIGNATURES[4]);
            skinnyMethodAdapter.voidreturn();
            skinnyMethodAdapter.end();
        }
        skinnyMethodAdapter = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(4106, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)), null, null));
        skinnyMethodAdapter.start();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.ldc(this.sourcename);
        skinnyMethodAdapter.iload(1);
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "setFileAndLine", CodegenUtils.sig(Void.TYPE, String.class, Integer.TYPE));
        skinnyMethodAdapter.voidreturn();
        skinnyMethodAdapter.end();
        this.endInit();
        this.endClassInit();
    }

    public static void buildStaticScopeNames(SkinnyMethodAdapter skinnyMethodAdapter, StaticScope staticScope) {
        String string = null;
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                skinnyMethodAdapter.pushInt(0);
                skinnyMethodAdapter.anewarray(CodegenUtils.p(String.class));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = CodegenUtils.sig(String[].class, CodegenUtils.params(String.class, staticScope.getNumberOfVariables()));
                for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                    skinnyMethodAdapter.ldc(staticScope.getVariables()[i]);
                }
                skinnyMethodAdapter.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructStringArray", string);
                break;
            }
            default: {
                skinnyMethodAdapter.pushInt(staticScope.getNumberOfVariables());
                skinnyMethodAdapter.anewarray(CodegenUtils.p(String.class));
                for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                    skinnyMethodAdapter.dup();
                    skinnyMethodAdapter.pushInt(i);
                    skinnyMethodAdapter.ldc(staticScope.getVariables()[i]);
                    skinnyMethodAdapter.arraystore();
                }
            }
        }
    }

    private void beginInit() {
        ClassVisitor classVisitor = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(classVisitor.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        if (USE_INHERITED_CACHE_FIELDS) {
            this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        } else {
            this.initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
        classVisitor.visitField(18, "$class", CodegenUtils.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(CodegenUtils.c(this.classname));
        this.initMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.initMethod.putfield(this.classname, "$class", CodegenUtils.ci(Class.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor classVisitor = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(classVisitor.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        this.clinitMethod.start();
    }

    private void endClassInit() {
        this.clinitMethod.voidreturn();
        this.clinitMethod.end();
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public MethodCompiler startMethod(String string, CompilerCallback compilerCallback, StaticScope staticScope, ASTInspector aSTInspector) {
        ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string, aSTInspector, staticScope);
        aSMMethodCompiler.beginMethod(compilerCallback, staticScope);
        aSMMethodCompiler.method.nop();
        return aSMMethodCompiler;
    }

    public String getNewConstant(String string, String string2) {
        return this.getNewConstant(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewConstant(String string, String string2, Object object) {
        String string3;
        ClassVisitor classVisitor = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            string3 = "_" + this.constants++;
        }
        classVisitor.visitField(2, string3, string, null, null).visitEnd();
        if (object != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(object);
            this.initMethod.putfield(this.classname, string3, string);
        }
        return string3;
    }

    public String getNewField(String string, String string2, Object object) {
        ClassVisitor classVisitor = this.getClassVisitor();
        classVisitor.visitField(2, string2, string, null, null).visitEnd();
        if (object != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(object);
            this.initMethod.putfield(this.classname, string2, string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String string, String string2) {
        String string3;
        ClassVisitor classVisitor = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            string3 = "__" + this.constants++;
        }
        classVisitor.visitField(26, string3, string, null, null).visitEnd();
        return string3;
    }

    public class ASMMethodCompiler
    extends AbstractMethodCompiler {
        private boolean specificArity;

        public ASMMethodCompiler(String string, ASTInspector aSTInspector, StaticScope staticScope) {
            super(staticScope, aSTInspector, string);
        }

        protected String getSignature() {
            if (this.scope.getRestArg() >= 0 || this.scope.getOptionalArgs() > 0 || this.scope.getRequiredArgs() > 3) {
                this.specificArity = false;
                return METHOD_SIGNATURES[4];
            }
            this.specificArity = true;
            return METHOD_SIGNATURES[this.scope.getRequiredArgs()];
        }

        protected void createVariableCompiler() {
            this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !this.inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()) : new HeapBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex())) : new StackBasedVariableCompiler(this, this.method, this.scope, this.specificArity, 3, this.getFirstTempIndex()));
        }

        public void beginChainedMethod() {
            this.method.start();
            this.method.aload(1);
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.getVarsArrayIndex());
            this.method.label(this.scopeStart);
        }

        public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginMethod(compilerCallback, staticScope);
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginClass(compilerCallback, staticScope);
            this.method.label(this.scopeStart);
        }

        public void endMethod() {
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
            this.method.end();
            if (this.specificArity) {
                this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, this.methodName, METHOD_SIGNATURES[4], null, null));
                this.method.start();
                this.method.aload(1);
                this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                this.method.aload(3);
                this.method.pushInt(this.scope.getRequiredArgs());
                this.method.pushInt(this.scope.getRequiredArgs());
                this.method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                this.method.pop();
                this.loadThis();
                this.loadThreadContext();
                this.loadSelf();
                for (int i = 0; i < this.scope.getRequiredArgs(); ++i) {
                    this.method.aload(3);
                    this.method.ldc(i);
                    this.method.arrayload();
                }
                this.method.aload(4);
                this.method.invokevirtual(StandardASMCompiler.this.classname, this.methodName, this.getSignature());
                this.method.areturn();
                this.method.end();
            }
        }

        public void performReturn() {
            if (this.withinProtection) {
                this.loadThreadContext();
                this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
                this.method.athrow();
            } else {
                this.method.areturn();
            }
        }

        public void issueBreakEvent(CompilerCallback compilerCallback) {
            if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopBreak();
            } else if (this.withinProtection) {
                this.loadThreadContext();
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            } else {
                this.loadRuntime();
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueNextEvent(CompilerCallback compilerCallback) {
            if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopNext();
            } else if (this.withinProtection) {
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                this.loadRuntime();
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueRedoEvent() {
            if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            } else {
                this.loadRuntime();
                this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
            }
        }
    }

    public class ASMClosureCompiler
    extends AbstractMethodCompiler {
        public ASMClosureCompiler(String string, ASTInspector aSTInspector, StaticScope staticScope) {
            super(staticScope, aSTInspector, string);
        }

        protected String getSignature() {
            return CLOSURE_SIGNATURE;
        }

        protected void createVariableCompiler() {
            this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !this.inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex())) : new StackBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()));
        }

        public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            this.method.dup();
            this.method.astore(this.getRuntimeIndex());
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.method.astore(this.getNilIndex());
            this.variableCompiler.beginClosure(compilerCallback, staticScope);
            this.redoJump = new Label();
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
            throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
        }

        public void endMethod() {
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, CodegenUtils.p(JumpException.RedoJump.class));
            this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
            this.method.end();
        }

        public void loadBlock() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
        }

        public void performReturn() {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
            this.method.athrow();
        }

        public void processRequiredArgs(Arity arity, int n, int n2, int n3) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void assignOptionalArgs(Object object, int n, int n2, ArrayCallback arrayCallback) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processRestArg(int n, int n2) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processBlockArgument(int n) {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadBlock();
            this.method.pushInt(n);
            this.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, Integer.TYPE)));
        }

        public void issueBreakEvent(CompilerCallback compilerCallback) {
            if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopBreak();
            } else {
                this.loadThreadContext();
                compilerCallback.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            }
        }

        public void issueNextEvent(CompilerCallback compilerCallback) {
            if (this.currentLoopLabels != null) {
                compilerCallback.call(this);
                this.issueLoopNext();
            } else {
                compilerCallback.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            }
        }

        public void issueRedoEvent() {
            if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            } else {
                this.method.go_to(this.scopeStart);
            }
        }
    }

    public abstract class AbstractMethodCompiler
    implements MethodCompiler {
        protected SkinnyMethodAdapter method;
        protected VariableCompiler variableCompiler;
        protected InvocationCompiler invocationCompiler;
        protected int argParamCount;
        protected Label[] currentLoopLabels;
        protected Label scopeStart = new Label();
        protected Label scopeEnd = new Label();
        protected Label redoJump;
        protected boolean withinProtection = false;
        private int lastLine = -1;
        private int lastPositionLine = -1;
        protected StaticScope scope;
        protected ASTInspector inspector;
        protected String methodName;

        public AbstractMethodCompiler(StaticScope staticScope, ASTInspector aSTInspector, String string) {
            this.scope = staticScope;
            this.inspector = aSTInspector;
            this.methodName = string;
            this.argParamCount = staticScope.getRestArg() >= 0 || staticScope.getOptionalArgs() > 0 || staticScope.getRequiredArgs() > 3 ? 1 : staticScope.getRequiredArgs();
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, string, this.getSignature(), null, null));
            this.createVariableCompiler();
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        protected abstract String getSignature();

        protected abstract void createVariableCompiler();

        public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

        public abstract void endMethod();

        public MethodCompiler chainToMethod(String string, ASTInspector aSTInspector) {
            MethodCompiler methodCompiler = this.outline(string, aSTInspector);
            this.endMethod();
            return methodCompiler;
        }

        public MethodCompiler outline(String string, ASTInspector aSTInspector) {
            this.method.aload(0);
            for (int i = 1; i <= this.getClosureIndex(); ++i) {
                this.method.aload(i);
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, this.getSignature());
            ASMMethodContinuationCompiler aSMMethodContinuationCompiler = new ASMMethodContinuationCompiler(string, aSTInspector, this.scope);
            aSMMethodContinuationCompiler.beginChainedMethod();
            return aSMMethodContinuationCompiler;
        }

        public StandardASMCompiler getScriptCompiler() {
            return StandardASMCompiler.this;
        }

        public void lineNumber(ISourcePosition iSourcePosition) {
            int n = iSourcePosition.getStartLine();
            if (n == this.lastLine) {
                return;
            }
            this.lastLine = n;
            Label label = new Label();
            this.method.label(label);
            this.method.visitLineNumber(n + 1, label);
        }

        public void loadThreadContext() {
            this.method.aload(1);
        }

        public void loadSelf() {
            this.method.aload(2);
        }

        protected int getClosureIndex() {
            return 3 + this.argParamCount + 0;
        }

        protected int getRuntimeIndex() {
            return 3 + this.argParamCount + 2;
        }

        protected int getNilIndex() {
            return 3 + this.argParamCount + 4;
        }

        protected int getPreviousExceptionIndex() {
            return 3 + this.argParamCount + 6;
        }

        protected int getDynamicScopeIndex() {
            return 3 + this.argParamCount + 1;
        }

        protected int getVarsArrayIndex() {
            return 3 + this.argParamCount + 3;
        }

        protected int getFirstTempIndex() {
            return 3 + this.argParamCount + 7;
        }

        protected int getExceptionIndex() {
            return 3 + this.argParamCount + 5;
        }

        public void loadThis() {
            this.method.aload(0);
        }

        public void loadRuntime() {
            this.method.aload(this.getRuntimeIndex());
        }

        public void loadBlock() {
            this.method.aload(this.getClosureIndex());
        }

        public void loadNil() {
            this.method.aload(this.getNilIndex());
        }

        public void loadNull() {
            this.method.aconst_null();
        }

        public void loadSymbol(String string) {
            this.loadRuntime();
            this.method.ldc(string);
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void loadObject() {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
        }

        public void invokeUtilityMethod(String string, String string2) {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), string, string2);
        }

        public void invokeThreadContext(String string, String string2) {
            this.method.invokevirtual(THREADCONTEXT, string, string2);
        }

        public void invokeIRuby(String string, String string2) {
            this.method.invokevirtual(RUBY, string, string2);
        }

        public void invokeIRubyObject(String string, String string2) {
            this.method.invokeinterface(IRUBYOBJECT, string, string2);
        }

        public void consumeCurrentValue() {
            this.method.pop();
        }

        public void duplicateCurrentValue() {
            this.method.dup();
        }

        public void swapValues() {
            this.method.swap();
        }

        public void retrieveSelf() {
            this.loadSelf();
        }

        public void retrieveSelfClass() {
            this.loadSelf();
            this.metaclass();
        }

        public VariableCompiler getVariableCompiler() {
            return this.variableCompiler;
        }

        public InvocationCompiler getInvocationCompiler() {
            return this.invocationCompiler;
        }

        public void assignConstantInCurrent(String string) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.dup2_x1();
            this.method.pop2();
            this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void assignConstantInModule(String string) {
            this.method.ldc(string);
            this.loadThreadContext();
            this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
        }

        public void assignConstantInObject(String string) {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
            this.method.swap();
            this.assignConstantInModule(string);
        }

        public void retrieveConstant(String string) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveConstantFromModule(String string) {
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantFrom", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveClassVariable(String string) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
        }

        public void assignClassVariable(String string) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void assignClassVariable(String string, CompilerCallback compilerCallback) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            compilerCallback.call(this);
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void declareClassVariable(String string) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void declareClassVariable(String string, CompilerCallback compilerCallback) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            compilerCallback.call(this);
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void createNewFloat(double d) {
            this.loadRuntime();
            this.method.ldc(new Double(d));
            this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
        }

        public void createNewFixnum(long l) {
            StandardASMCompiler.this.cacheCompiler.cacheFixnum(this, l);
        }

        public void createNewBignum(BigInteger bigInteger) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheBigInteger(this, bigInteger);
            this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
        }

        public void createNewString(ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < n; ++i) {
                arrayCallback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
        }

        public void createNewSymbol(ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            this.createNewString(arrayCallback, n);
            this.toJavaString();
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void createNewString(ByteList byteList) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheByteList(this, byteList.toString());
            this.invokeIRuby("newStringShared", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ByteList.class)));
        }

        public void createNewSymbol(String string) {
            StandardASMCompiler.this.getCacheCompiler().cacheSymbol(this, string);
        }

        public void createNewArray(boolean bl) {
            this.loadRuntime();
            this.method.swap();
            if (bl) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            }
        }

        public void createNewArray(Object[] objectArray, ArrayCallback arrayCallback, boolean bl) {
            this.loadRuntime();
            this.createObjectArray(objectArray, arrayCallback);
            if (bl) {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
            }
        }

        public void createEmptyArray() {
            this.loadRuntime();
            this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(new Class[0])));
        }

        public void createObjectArray(Object[] objectArray, ArrayCallback arrayCallback) {
            this.buildObjectArray(IRUBYOBJECT, objectArray, arrayCallback);
        }

        public void createObjectArray(int n) {
            if (n >= 6) {
                throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
            }
            Object[] objectArray = new Class[n];
            Arrays.fill(objectArray, IRubyObject.class);
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])objectArray));
        }

        private void buildObjectArray(String string, Object[] objectArray, ArrayCallback arrayCallback) {
            if (objectArray.length == 0) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else if (objectArray.length <= 5) {
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayCallback.nextValue(this, objectArray, i);
                }
                this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, objectArray.length)));
            } else {
                this.method.pushInt(objectArray.length);
                this.method.anewarray(string);
                for (int i = 0; i < objectArray.length; ++i) {
                    this.method.dup();
                    this.method.pushInt(i);
                    arrayCallback.nextValue(this, objectArray, i);
                    this.method.arraystore();
                }
            }
        }

        public void createEmptyHash() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
        }

        public void createNewHash(Object object, ArrayCallback arrayCallback, int n) {
            this.loadRuntime();
            if (n <= 3) {
                for (int i = 0; i < n; ++i) {
                    arrayCallback.nextValue(this, object, i);
                }
                this.invokeUtilityMethod("constructHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, n * 2)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
                for (int i = 0; i < n; ++i) {
                    this.method.dup();
                    arrayCallback.nextValue(this, object, i);
                    this.method.invokevirtual(CodegenUtils.p(RubyHash.class), "fastASet", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, IRubyObject.class)));
                }
            }
        }

        public void createNewRange(boolean bl) {
            this.loadRuntime();
            this.loadThreadContext();
            this.method.dup2_x2();
            this.method.pop2();
            if (bl) {
                this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
            }
        }

        private void isTrue() {
            this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        }

        public void performBooleanBranch(BranchCallback branchCallback, BranchCallback branchCallback2) {
            Label label = new Label();
            Label label2 = new Label();
            this.isTrue();
            this.method.ifeq(label2);
            branchCallback.branch(this);
            this.method.go_to(label);
            this.method.label(label2);
            branchCallback2.branch(this);
            this.method.label(label);
        }

        public void performLogicalAnd(BranchCallback branchCallback) {
            Label label = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifeq(label);
            this.method.pop();
            branchCallback.branch(this);
            this.method.label(label);
        }

        public void performLogicalOr(BranchCallback branchCallback) {
            Label label = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifne(label);
            this.method.pop();
            branchCallback.branch(this);
            this.method.label(label);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performBooleanLoopSafe(BranchCallback branchCallback, BranchCallback branchCallback2, boolean bl) {
            String string = this.getNewRescueName();
            String string2 = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class);
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, string2, null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            boolean bl2 = this.withinProtection;
            this.withinProtection = true;
            Label[] labelArray = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int n = this.argParamCount;
            this.argParamCount = 0;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                skinnyMethodAdapter.astore(this.getPreviousExceptionIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                skinnyMethodAdapter.astore(this.getNilIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getDynamicScopeIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                skinnyMethodAdapter.astore(this.getVarsArrayIndex());
                this.performBooleanLoop(branchCallback, branchCallback2, bl);
                skinnyMethodAdapter.areturn();
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var14_13 = null;
                this.withinProtection = bl2;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this.withinProtection = bl2;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, string2);
        }

        public void performBooleanLoop(BranchCallback branchCallback, BranchCallback branchCallback2, boolean bl) {
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label label5 = new Label();
            Label label6 = new Label();
            Label label7 = new Label();
            Label label8 = new Label();
            Label label9 = new Label();
            Label label10 = new Label();
            Label label11 = new Label();
            this.method.trycatch(label, label2, label3, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.trycatch(label, label2, label4, CodegenUtils.p(JumpException.NextJump.class));
            this.method.trycatch(label, label2, label5, CodegenUtils.p(JumpException.BreakJump.class));
            if (bl) {
                this.method.trycatch(label, label2, label6, CodegenUtils.p(RaiseException.class));
            }
            this.method.label(label);
            Object object = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{label7, label9, label10};
            if (bl) {
                this.method.go_to(label8);
            }
            this.method.label(label9);
            branchCallback2.branch(this);
            this.method.label(label7);
            this.method.pop();
            this.method.label(label8);
            branchCallback.branch(this);
            this.isTrue();
            this.method.ifne(label9);
            this.currentLoopLabels = object;
            this.method.label(label2);
            this.method.go_to(label11);
            this.method.label(label3);
            this.method.pop();
            this.method.go_to(label9);
            this.method.label(label4);
            this.method.pop();
            this.method.go_to(label8);
            this.method.label(label5);
            this.loadBlock();
            this.loadThreadContext();
            this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, Block.class, ThreadContext.class));
            this.method.go_to(label10);
            if (bl) {
                this.method.label(label6);
                object = new Label();
                Label label12 = new Label();
                Label label13 = new Label();
                this.method.dup();
                this.invokeUtilityMethod("getLocalJumpTypeOrRethrow", CodegenUtils.sig(String.class, CodegenUtils.params(RaiseException.class)));
                this.method.dup();
                this.method.ldc("break");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq((Label)object);
                this.method.pop();
                this.invokeUtilityMethod("unwrapLocalJumpErrorValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(RaiseException.class)));
                this.method.go_to(label10);
                this.method.label((Label)object);
                this.method.dup();
                this.method.ldc("next");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(label12);
                this.method.pop2();
                this.method.go_to(label8);
                this.method.label(label12);
                this.method.dup();
                this.method.ldc("redo");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(label13);
                this.method.pop2();
                this.method.go_to(label9);
                this.method.label(label13);
                this.method.pop();
                this.method.athrow();
            }
            this.method.label(label11);
            this.loadNil();
            this.method.label(label10);
        }

        public void performBooleanLoopLight(BranchCallback branchCallback, BranchCallback branchCallback2, boolean bl) {
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label[] labelArray = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{label, label3, label4};
            if (bl) {
                this.method.go_to(label2);
            }
            this.method.label(label3);
            branchCallback2.branch(this);
            this.method.label(label);
            this.method.pop();
            this.method.label(label2);
            branchCallback.branch(this);
            this.isTrue();
            this.method.ifne(label3);
            this.currentLoopLabels = labelArray;
            this.loadNil();
            this.method.label(label4);
        }

        public void createNewClosure(int n, StaticScope staticScope, int n2, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, boolean bl, NodeType nodeType, ASTInspector aSTInspector) {
            String string = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$" + "__block__";
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, aSTInspector, staticScope);
            aSMClosureCompiler.beginMethod(compilerCallback2, staticScope);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.this.cacheCompiler.cacheClosure(this, string, n2, staticScope, bl, nodeType, aSTInspector);
            this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, BlockBody.class)));
        }

        public void runBeginBlock(StaticScope staticScope, CompilerCallback compilerCallback) {
            String string = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__begin__";
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, null, staticScope);
            aSMClosureCompiler.beginMethod(null, staticScope);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.buildStaticScopeNames(this.method, staticScope);
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, string);
            this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
        }

        public void createNewForLoop(int n, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, boolean bl, NodeType nodeType) {
            String string = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__for__";
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, null, this.scope);
            aSMClosureCompiler.beginMethod(compilerCallback2, null);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            this.method.pushInt(n);
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, string);
            this.method.ldc(bl);
            this.method.ldc(BlockBody.asArgumentType(nodeType));
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        }

        public void createNewEndBlock(CompilerCallback compilerCallback) {
            String string = "block_" + ++StandardASMCompiler.this.innerIndex + "$RUBY$__end__";
            ASMClosureCompiler aSMClosureCompiler = new ASMClosureCompiler(string, null, this.scope);
            aSMClosureCompiler.beginMethod(null, null);
            compilerCallback.call(aSMClosureCompiler);
            aSMClosureCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            this.method.iconst_0();
            StandardASMCompiler.this.cacheCompiler.cacheClosureOld(this, string);
            this.method.iconst_0();
            this.method.iconst_0();
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
            this.loadRuntime();
            this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
            this.loadNil();
        }

        public void getCompiledClass() {
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, "$class", CodegenUtils.ci(Class.class));
        }

        public void println() {
            this.method.dup();
            this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        }

        public void defineAlias(String string, String string2) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.ldc(string2);
            this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
        }

        public void loadFalse() {
            this.loadRuntime();
            this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        }

        public void loadTrue() {
            this.loadRuntime();
            this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
        }

        public void loadCurrentModule() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
        }

        public void retrieveInstanceVariable(String string) {
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(string);
            this.invokeUtilityMethod("fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class, String.class));
        }

        public void assignInstanceVariable(String string) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void assignInstanceVariable(String string, CompilerCallback compilerCallback) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.ldc(string);
            compilerCallback.call(this);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void retrieveGlobalVariable(String string) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void assignGlobalVariable(String string) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.swap();
            this.method.ldc(string);
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void assignGlobalVariable(String string, CompilerCallback compilerCallback) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(string);
            compilerCallback.call(this);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void negateCurrentValue() {
            this.loadRuntime();
            this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
        }

        public void splatCurrentValue() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "splatValue", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void singlifySplattedValue() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void aryToAry() {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void ensureRubyArray() {
            this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void ensureMultipleAssignableRubyArray(boolean bl) {
            this.loadRuntime();
            this.method.pushBoolean(bl);
            this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class, Boolean.TYPE)));
        }

        public void forEachInValueArray(int n, int n2, Object object, ArrayCallback arrayCallback, ArrayCallback arrayCallback2, CompilerCallback compilerCallback) {
            while (n < n2) {
                this.method.dup();
                this.loadNil();
                this.method.pushInt(n);
                this.invokeUtilityMethod("arrayEntryOrNil", CodegenUtils.sig(IRubyObject.class, RubyArray.class, IRubyObject.class, Integer.TYPE));
                arrayCallback.nextValue(this, object, n);
                this.method.pop();
                ++n;
            }
            if (compilerCallback != null) {
                this.method.dup();
                this.loadRuntime();
                this.method.pushInt(n);
                this.invokeUtilityMethod("subarrayOrEmpty", CodegenUtils.sig(RubyArray.class, RubyArray.class, Ruby.class, Integer.TYPE));
                compilerCallback.call(this);
                this.method.pop();
            }
        }

        public void asString() {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
        }

        public void toJavaString() {
            this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        }

        public void nthRef(int n) {
            this.method.pushInt(n);
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
        }

        public void match() {
            this.loadThreadContext();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
        }

        public void match2() {
            this.loadThreadContext();
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
        }

        public void match3() {
            this.loadThreadContext();
            this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
        }

        public void createNewRegexp(ByteList byteList, int n) {
            String string = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            Label label = new Label();
            this.method.ifnonnull(label);
            String string2 = byteList.toString();
            this.loadRuntime();
            this.method.ldc(string2);
            this.method.pushInt(n);
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            this.method.label(label);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
        }

        public void createNewRegexp(CompilerCallback compilerCallback, int n) {
            boolean bl = (n & 0x80) != 0;
            Label label = null;
            String string = null;
            if (bl) {
                string = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
                label = new Label();
                this.method.ifnonnull(label);
            }
            this.loadRuntime();
            compilerCallback.call(this);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class, new Class[0]));
            this.method.pushInt(n);
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, ByteList.class, Integer.TYPE)));
            if (bl) {
                this.method.aload(0);
                this.method.swap();
                this.method.putfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
                this.method.label(label);
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, string, CodegenUtils.ci(RubyRegexp.class));
            }
        }

        public void pollThreadEvents() {
            if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
            }
        }

        public void nullToNil() {
            Label label = new Label();
            this.method.dup();
            this.method.ifnonnull(label);
            this.method.pop();
            this.loadNil();
            this.method.label(label);
        }

        public void isInstanceOf(Class clazz, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.instance_of(CodegenUtils.p(clazz));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isCaptured(final int n, final BranchCallback branchCallback, final BranchCallback branchCallback2) {
            this.backref();
            this.method.dup();
            this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "use", CodegenUtils.sig(Void.TYPE, new Class[0]));
                    AbstractMethodCompiler.this.method.pushInt(n);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                    AbstractMethodCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    Label label = new Label();
                    Label label2 = new Label();
                    AbstractMethodCompiler.this.method.ifne(label);
                    branchCallback.branch(methodCompiler);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label);
                    branchCallback2.branch(methodCompiler);
                    AbstractMethodCompiler.this.method.label(label2);
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    AbstractMethodCompiler.this.method.pop();
                    branchCallback2.branch(methodCompiler);
                }
            });
        }

        public void branchIfModule(CompilerCallback compilerCallback, BranchCallback branchCallback, BranchCallback branchCallback2) {
            compilerCallback.call(this);
            this.isInstanceOf(RubyModule.class, branchCallback, branchCallback2);
        }

        public void backref() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentFrame", CodegenUtils.sig(Frame.class, new Class[0]));
            this.method.invokevirtual(CodegenUtils.p(Frame.class), "getBackRef", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        public void backrefMethod(String string) {
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), string, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void issueLoopBreak() {
            this.method.go_to(this.currentLoopLabels[2]);
        }

        public void issueLoopNext() {
            this.method.go_to(this.currentLoopLabels[0]);
        }

        public void issueLoopRedo() {
            this.method.go_to(this.currentLoopLabels[1]);
        }

        protected String getNewEnsureName() {
            return "ensure_" + StandardASMCompiler.this.ensureNumber++ + "$RUBY$__ensure__";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void protect(BranchCallback branchCallback, BranchCallback branchCallback2, Class clazz) {
            String string = this.getNewEnsureName();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CodegenUtils.sig(clazz, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            boolean bl = this.withinProtection;
            this.withinProtection = true;
            Label[] labelArray = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int n = this.argParamCount;
            this.argParamCount = 0;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getRuntimeIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                skinnyMethodAdapter.astore(this.getNilIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getDynamicScopeIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                skinnyMethodAdapter.astore(this.getVarsArrayIndex());
                Label label = new Label();
                Label label2 = new Label();
                Label label3 = new Label();
                Label label4 = new Label();
                this.method.label(label);
                branchCallback.branch(this);
                this.method.label(label2);
                branchCallback2.branch(this);
                skinnyMethodAdapter.areturn();
                this.method.label(label3);
                this.method.astore(this.getExceptionIndex());
                this.method.label(label4);
                branchCallback2.branch(this);
                this.method.aload(this.getExceptionIndex());
                this.method.athrow();
                this.method.trycatch(label, label2, label3, null);
                this.method.trycatch(label3, label4, label3, null);
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var17_16 = null;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.withinProtection = bl;
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.withinProtection = bl;
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(clazz, ThreadContext.class, IRubyObject.class, Block.class));
        }

        protected String getNewRescueName() {
            return "rescue_" + StandardASMCompiler.this.rescueNumber++ + "$RUBY$__rescue__";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rescue(BranchCallback branchCallback, Class clazz, BranchCallback branchCallback2, Class clazz2) {
            String string = this.getNewRescueName();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CodegenUtils.sig(clazz2, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label label5 = new Label();
            boolean bl = this.withinProtection;
            this.withinProtection = true;
            Label[] labelArray = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int n = this.argParamCount;
            this.argParamCount = 0;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                skinnyMethodAdapter.astore(this.getPreviousExceptionIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                skinnyMethodAdapter.astore(this.getNilIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getDynamicScopeIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                skinnyMethodAdapter.astore(this.getVarsArrayIndex());
                Label label6 = new Label();
                Label label7 = new Label();
                Label label8 = new Label();
                skinnyMethodAdapter.visitTryCatchBlock(label6, label7, label8, CodegenUtils.p(clazz));
                skinnyMethodAdapter.visitLabel(label6);
                branchCallback.branch(this);
                skinnyMethodAdapter.label(label7);
                skinnyMethodAdapter.go_to(label5);
                skinnyMethodAdapter.label(label8);
                skinnyMethodAdapter.astore(this.getExceptionIndex());
                branchCallback2.branch(this);
                skinnyMethodAdapter.label(label);
                skinnyMethodAdapter.go_to(label5);
                skinnyMethodAdapter.trycatch(label8, label, label2, CodegenUtils.p(JumpException.RetryJump.class));
                skinnyMethodAdapter.label(label2);
                skinnyMethodAdapter.pop();
                skinnyMethodAdapter.go_to(label6);
                skinnyMethodAdapter.trycatch(label6, label, label3, CodegenUtils.p(RaiseException.class));
                skinnyMethodAdapter.label(label3);
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.trycatch(label6, label, label4, CodegenUtils.p(JumpException.class));
                skinnyMethodAdapter.label(label4);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.label(label5);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.areturn();
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var22_21 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(clazz2, ThreadContext.class, IRubyObject.class, Block.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performRescue(BranchCallback branchCallback, BranchCallback branchCallback2, BranchCallback branchCallback3) {
            String string = this.getNewRescueName();
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, string, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class), null, null));
            SkinnyMethodAdapter skinnyMethodAdapter2 = null;
            SkinnyMethodAdapter skinnyMethodAdapter3 = null;
            SkinnyMethodAdapter skinnyMethodAdapter4 = null;
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            Label label5 = new Label();
            Label label6 = new Label();
            Label label7 = new Label();
            Label label8 = new Label();
            Label label9 = new Label();
            boolean bl = this.withinProtection;
            this.withinProtection = true;
            Label[] labelArray = this.currentLoopLabels;
            this.currentLoopLabels = null;
            int n = this.argParamCount;
            this.argParamCount = 0;
            try {
                skinnyMethodAdapter2 = this.method;
                skinnyMethodAdapter3 = this.getVariableCompiler().getMethodAdapter();
                skinnyMethodAdapter4 = this.getInvocationCompiler().getMethodAdapter();
                this.method = skinnyMethodAdapter;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter);
                skinnyMethodAdapter.visitCode();
                skinnyMethodAdapter.aload(1);
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getRuntimeIndex());
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                skinnyMethodAdapter.astore(this.getPreviousExceptionIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
                skinnyMethodAdapter.astore(this.getNilIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
                skinnyMethodAdapter.dup();
                skinnyMethodAdapter.astore(this.getDynamicScopeIndex());
                skinnyMethodAdapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                skinnyMethodAdapter.astore(this.getVarsArrayIndex());
                Label label10 = new Label();
                Label label11 = new Label();
                Label label12 = new Label();
                Label label13 = new Label();
                Label label14 = new Label();
                skinnyMethodAdapter.visitTryCatchBlock(label10, label11, label12, CodegenUtils.p(RaiseException.class));
                skinnyMethodAdapter.visitTryCatchBlock(label10, label11, label13, CodegenUtils.p(JumpException.FlowControlException.class));
                skinnyMethodAdapter.visitTryCatchBlock(label10, label11, label14, CodegenUtils.p(Exception.class));
                skinnyMethodAdapter.visitLabel(label10);
                branchCallback.branch(this);
                skinnyMethodAdapter.label(label11);
                skinnyMethodAdapter.go_to(label9);
                skinnyMethodAdapter.label(label12);
                skinnyMethodAdapter.astore(this.getExceptionIndex());
                branchCallback2.branch(this);
                skinnyMethodAdapter.label(label);
                skinnyMethodAdapter.go_to(label9);
                skinnyMethodAdapter.trycatch(label12, label, label3, CodegenUtils.p(JumpException.RetryJump.class));
                skinnyMethodAdapter.label(label3);
                skinnyMethodAdapter.pop();
                skinnyMethodAdapter.go_to(label10);
                skinnyMethodAdapter.trycatch(label10, label, label4, CodegenUtils.p(RaiseException.class));
                skinnyMethodAdapter.label(label4);
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.trycatch(label10, label, label5, CodegenUtils.p(JumpException.class));
                skinnyMethodAdapter.label(label5);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.label(label13);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.label(label14);
                skinnyMethodAdapter.astore(this.getExceptionIndex());
                branchCallback3.branch(this);
                skinnyMethodAdapter.label(label2);
                skinnyMethodAdapter.go_to(label9);
                skinnyMethodAdapter.trycatch(label14, label2, label6, CodegenUtils.p(JumpException.RetryJump.class));
                skinnyMethodAdapter.label(label6);
                skinnyMethodAdapter.pop();
                skinnyMethodAdapter.go_to(label10);
                skinnyMethodAdapter.trycatch(label14, label2, label7, CodegenUtils.p(RaiseException.class));
                skinnyMethodAdapter.label(label7);
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.trycatch(label14, label2, label8, CodegenUtils.p(JumpException.class));
                skinnyMethodAdapter.label(label8);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.athrow();
                skinnyMethodAdapter.label(label9);
                this.loadRuntime();
                skinnyMethodAdapter.aload(this.getPreviousExceptionIndex());
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                skinnyMethodAdapter.areturn();
                skinnyMethodAdapter.visitMaxs(1, 1);
                skinnyMethodAdapter.visitEnd();
                Object var27_26 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
            }
            catch (Throwable throwable) {
                Object var27_27 = null;
                this.withinProtection = bl;
                this.method = skinnyMethodAdapter2;
                this.getVariableCompiler().setMethodAdapter(skinnyMethodAdapter3);
                this.getInvocationCompiler().setMethodAdapter(skinnyMethodAdapter4);
                this.currentLoopLabels = labelArray;
                this.argParamCount = n;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, string, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class));
        }

        public void wrapJavaException() {
            this.loadRuntime();
            this.loadException();
            this.wrapJavaObject();
        }

        public void wrapJavaObject() {
            this.method.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
        }

        public void inDefined() {
            this.method.aload(1);
            this.method.iconst_1();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void outDefined() {
            this.method.aload(1);
            this.method.iconst_0();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void stringOrNil() {
            this.loadRuntime();
            this.loadNil();
            this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
        }

        public void pushNull() {
            this.method.aconst_null();
        }

        public void pushString(String string) {
            this.method.ldc(string);
        }

        public void isMethodBound(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.metaclass();
            this.method.ldc(string);
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void hasBlock(BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadBlock();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isGlobalDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isConstantDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadThreadContext();
            this.method.ldc(string);
            this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isInstanceVariableDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.ldc(string);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifne(label);
            branchCallback2.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback.branch(this);
            this.method.label(label2);
        }

        public void isClassVarDefined(String string, BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifne(label);
            branchCallback2.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback.branch(this);
            this.method.label(label2);
        }

        public Object getNewEnding() {
            return new Label();
        }

        public void isNil(BranchCallback branchCallback, BranchCallback branchCallback2) {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void isNull(BranchCallback branchCallback, BranchCallback branchCallback2) {
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifnonnull(label);
            branchCallback.branch(this);
            this.method.go_to(label2);
            this.method.label(label);
            branchCallback2.branch(this);
            this.method.label(label2);
        }

        public void ifNull(Object object) {
            this.method.ifnull((Label)object);
        }

        public void ifNotNull(Object object) {
            this.method.ifnonnull((Label)object);
        }

        public void setEnding(Object object) {
            this.method.label((Label)object);
        }

        public void go(Object object) {
            this.method.go_to((Label)object);
        }

        public void isConstantBranch(final BranchCallback branchCallback, final BranchCallback branchCallback2, final BranchCallback branchCallback3, final BranchCallback branchCallback4, final String string) {
            this.rescue(new BranchCallback(){

                public void branch(MethodCompiler methodCompiler) {
                    branchCallback.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.instance_of(CodegenUtils.p(RubyModule.class));
                    Label label = new Label();
                    Label label2 = new Label();
                    Label label3 = new Label();
                    Label label4 = new Label();
                    AbstractMethodCompiler.this.method.ifeq(label3);
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ldc(string);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantAt", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ifnull(label4);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.pop();
                    branchCallback2.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label4);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.label(label3);
                    AbstractMethodCompiler.this.metaclass();
                    AbstractMethodCompiler.this.method.ldc(string);
                    AbstractMethodCompiler.this.method.iconst_1();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
                    AbstractMethodCompiler.this.method.ifeq(label);
                    branchCallback3.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(label2);
                    AbstractMethodCompiler.this.method.label(label);
                    branchCallback4.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.label(label2);
                }
            }, JumpException.class, branchCallback4, String.class);
        }

        public void metaclass() {
            this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        }

        public void aprintln() {
            this.method.aprintln();
        }

        public void getVisibilityFor(String string) {
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
            this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
        }

        public void isPrivate(Object object, int n) {
            this.method.getstatic(CodegenUtils.p(Visibility.class), "PRIVATE", CodegenUtils.ci(Visibility.class));
            Label label = new Label();
            this.method.if_acmpne(label);
            while (n-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)object);
            this.method.label(label);
        }

        public void isNotProtected(Object object, int n) {
            this.method.getstatic(CodegenUtils.p(Visibility.class), "PROTECTED", CodegenUtils.ci(Visibility.class));
            Label label = new Label();
            this.method.if_acmpeq(label);
            while (n-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)object);
            this.method.label(label);
        }

        public void selfIsKindOf(Object object) {
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
            this.loadSelf();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.ifne((Label)object);
        }

        public void notIsModuleAndClassVarDefined(String string, Object object) {
            this.method.dup();
            this.method.instance_of(CodegenUtils.p(RubyModule.class));
            Label label = new Label();
            Label label2 = new Label();
            this.method.ifeq(label);
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            this.method.ifeq((Label)object);
            this.method.go_to(label2);
            this.method.label(label);
            this.method.pop();
            this.method.go_to((Label)object);
            this.method.label(label2);
        }

        public void ifSingleton(Object object) {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            this.method.ifne((Label)object);
        }

        public void getInstanceVariable(String string) {
            this.method.ldc(string);
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void getFrameName() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class, new Class[0]));
        }

        public void getFrameKlazz() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class, new Class[0]));
        }

        public void superClass() {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        }

        public void attached() {
            this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
            this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        public void ifNotSuperMethodBound(Object object) {
            this.method.swap();
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            this.method.ifeq((Label)object);
        }

        public void concatArrays() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void concatObjectArrays() {
            this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
        }

        public void appendToArray() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void appendToObjectArray() {
            this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
        }

        public void convertToJavaArray() {
            this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
        }

        public void aliasGlobal(String string, String string2) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
            this.method.ldc(string);
            this.method.ldc(string2);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
            this.loadNil();
        }

        public void undefMethod(String string) {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class, new Class[0]));
            Label label = new Label();
            this.method.dup();
            this.method.ifnonnull(label);
            this.method.pop();
            this.loadRuntime();
            this.method.ldc("No class to undef method '" + string + "'.");
            this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
            this.method.athrow();
            this.method.label(label);
            this.loadThreadContext();
            this.method.ldc(string);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "undef", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            this.loadNil();
        }

        public void defineClass(String string, StaticScope staticScope, final CompilerCallback compilerCallback, CompilerCallback compilerCallback2, CompilerCallback compilerCallback3, final CompilerCallback compilerCallback4) {
            Object object;
            String string2 = null;
            if (compilerCallback4 == null) {
                object = JavaNameMangler.mangleStringForCleanJavaIdentifier(string);
                string2 = "class_" + ++StandardASMCompiler.this.methodIndex + "$RUBY$" + (String)object;
            } else {
                string2 = "sclass_" + ++StandardASMCompiler.this.methodIndex + "$RUBY$__singleton__";
            }
            object = new ASMMethodCompiler(string2, null, staticScope);
            CompilerCallback compilerCallback5 = new CompilerCallback((ASMMethodCompiler)object, compilerCallback2, string, staticScope){
                final /* synthetic */ ASMMethodCompiler val$methodCompiler;
                final /* synthetic */ CompilerCallback val$pathCallback;
                final /* synthetic */ String val$name;
                final /* synthetic */ StaticScope val$staticScope;
                {
                    this.val$methodCompiler = aSMMethodCompiler;
                    this.val$pathCallback = compilerCallback3;
                    this.val$name = string;
                    this.val$staticScope = staticScope;
                }

                public void call(MethodCompiler methodCompiler) {
                    if (compilerCallback4 == null) {
                        if (compilerCallback != null) {
                            this.val$methodCompiler.loadRuntime();
                            compilerCallback.call(this.val$methodCompiler);
                            this.val$methodCompiler.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                        } else {
                            this.val$methodCompiler.method.aconst_null();
                        }
                        this.val$methodCompiler.loadThreadContext();
                        this.val$pathCallback.call(this.val$methodCompiler);
                        this.val$methodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                        this.val$methodCompiler.method.swap();
                        this.val$methodCompiler.method.ldc(this.val$name);
                        this.val$methodCompiler.method.swap();
                        this.val$methodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                    } else {
                        this.val$methodCompiler.loadRuntime();
                        this.val$methodCompiler.method.aload(2);
                        int n = this.val$methodCompiler.getVariableCompiler().grabTempLocal();
                        this.val$methodCompiler.getVariableCompiler().setTempLocal(n);
                        this.val$methodCompiler.method.aload(2);
                        this.val$methodCompiler.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    }
                    this.val$methodCompiler.method.dup();
                    this.val$methodCompiler.method.astore(2);
                    this.val$methodCompiler.loadThreadContext();
                    this.val$methodCompiler.method.swap();
                    StandardASMCompiler.buildStaticScopeNames(this.val$methodCompiler.method, this.val$staticScope);
                    this.val$methodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            ((ASMMethodCompiler)object).method.trycatch(label, label2, label3, null);
            ((ASMMethodCompiler)object).beginClass(compilerCallback5, staticScope);
            ((ASMMethodCompiler)object).method.label(label);
            compilerCallback3.call((MethodCompiler)object);
            ((ASMMethodCompiler)object).method.label(label2);
            ((AbstractMethodCompiler)object).loadThreadContext();
            ((AbstractMethodCompiler)object).invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            ((ASMMethodCompiler)object).method.go_to(label4);
            ((ASMMethodCompiler)object).method.label(label3);
            ((AbstractMethodCompiler)object).loadThreadContext();
            ((AbstractMethodCompiler)object).invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            ((ASMMethodCompiler)object).method.athrow();
            ((ASMMethodCompiler)object).method.label(label4);
            ((ASMMethodCompiler)object).endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            if (compilerCallback4 == null) {
                this.method.aload(2);
            } else {
                compilerCallback4.call(this);
            }
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, string2, METHOD_SIGNATURES[0]);
        }

        public void defineModule(final String string, final StaticScope staticScope, final CompilerCallback compilerCallback, CompilerCallback compilerCallback2) {
            String string2 = JavaNameMangler.mangleStringForCleanJavaIdentifier(string);
            String string3 = "module__" + ++StandardASMCompiler.this.methodIndex + "$RUBY$" + string2;
            final ASMMethodCompiler aSMMethodCompiler = new ASMMethodCompiler(string3, null, staticScope);
            CompilerCallback compilerCallback3 = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    aSMMethodCompiler.loadThreadContext();
                    compilerCallback.call(aSMMethodCompiler);
                    aSMMethodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    aSMMethodCompiler.method.ldc(string);
                    aSMMethodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                    aSMMethodCompiler.method.dup();
                    aSMMethodCompiler.method.astore(2);
                    aSMMethodCompiler.loadThreadContext();
                    aSMMethodCompiler.method.swap();
                    StandardASMCompiler.buildStaticScopeNames(aSMMethodCompiler.method, staticScope);
                    aSMMethodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label label = new Label();
            Label label2 = new Label();
            Label label3 = new Label();
            Label label4 = new Label();
            aSMMethodCompiler.method.trycatch(label, label2, label3, null);
            aSMMethodCompiler.beginClass(compilerCallback3, staticScope);
            aSMMethodCompiler.method.label(label);
            compilerCallback2.call(aSMMethodCompiler);
            aSMMethodCompiler.method.label(label2);
            aSMMethodCompiler.method.go_to(label4);
            aSMMethodCompiler.method.label(label3);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.method.athrow();
            aSMMethodCompiler.method.label(label4);
            aSMMethodCompiler.loadThreadContext();
            aSMMethodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            aSMMethodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, string3, METHOD_SIGNATURES[4]);
        }

        public void unwrapPassedBlock() {
            this.loadBlock();
            this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
        }

        public void performBackref(char c) {
            this.loadThreadContext();
            switch (c) {
                case '~': {
                    this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '&': {
                    this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '`': {
                    this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '\'': {
                    this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '+': {
                    this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                default: {
                    throw new NotCompilableException("ERROR: backref with invalid type");
                }
            }
        }

        public void callZSuper(CompilerCallback compilerCallback) {
            this.loadRuntime();
            this.loadThreadContext();
            if (compilerCallback != null) {
                compilerCallback.call(this);
            } else {
                this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
            this.loadSelf();
            this.invokeUtilityMethod("callZSuper", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
        }

        public void checkIsExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        public void checkIsJavaExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Exception.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        public void rethrowException() {
            this.loadException();
            this.method.athrow();
        }

        public void loadClass(String string) {
            this.loadRuntime();
            this.method.ldc(string);
            this.invokeIRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
        }

        public void unwrapRaiseException() {
            this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class, new Class[0]));
        }

        public void loadException() {
            this.method.aload(this.getExceptionIndex());
        }

        public void setFilePosition(ISourcePosition iSourcePosition) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.method.ldc(iSourcePosition.getFile());
                this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
            }
        }

        public void setLinePosition(ISourcePosition iSourcePosition) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                if (this.lastPositionLine == iSourcePosition.getStartLine()) {
                    return;
                }
                this.lastPositionLine = iSourcePosition.getStartLine();
                this.loadThreadContext();
                this.method.pushInt(iSourcePosition.getStartLine());
                this.method.invokestatic(StandardASMCompiler.this.classname, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)));
            }
        }

        public void checkWhenWithSplat() {
            this.loadThreadContext();
            this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void issueRetryEvent() {
            this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }

        public void defineNewMethod(String string, int n, StaticScope staticScope, CompilerCallback compilerCallback, CompilerCallback compilerCallback2, CompilerCallback compilerCallback3, ASTInspector aSTInspector, boolean bl) {
            Object object;
            String string2;
            ++StandardASMCompiler.this.methodIndex;
            if (bl && Boolean.getBoolean("jruby.compile.toplevel")) {
                string2 = string;
            } else {
                object = JavaNameMangler.mangleStringForCleanJavaIdentifier(string);
                string2 = "method__" + StandardASMCompiler.this.methodIndex + "$RUBY$" + (String)object;
            }
            object = StandardASMCompiler.this.startMethod(string2, compilerCallback2, staticScope, aSTInspector);
            compilerCallback.call((MethodCompiler)object);
            object.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            if (compilerCallback3 != null) {
                compilerCallback3.call(this);
            }
            this.method.aload(0);
            this.method.ldc(string);
            this.method.ldc(string2);
            StandardASMCompiler.buildStaticScopeNames(this.method, staticScope);
            this.method.pushInt(n);
            this.method.pushInt(staticScope.getRequiredArgs());
            this.method.pushInt(staticScope.getOptionalArgs());
            this.method.pushInt(staticScope.getRestArg());
            if (aSTInspector.hasFrameAwareMethods() || !aSTInspector.noFrame() && !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
                if (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods()) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods()) {
                if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.SCOPE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED || aSTInspector.noFrame()) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.NO_FRAME_NO_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            }
            if (compilerCallback3 != null) {
                this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            } else {
                this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            }
        }

        public void rethrowIfSystemExit() {
            this.loadRuntime();
            this.method.ldc("SystemExit");
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.iconst_0();
            Label label = new Label();
            this.method.if_icmpeq(label);
            this.loadException();
            this.method.athrow();
            this.method.label(label);
        }

        public class ASMMethodContinuationCompiler
        extends ASMMethodCompiler {
            public ASMMethodContinuationCompiler(String string, ASTInspector aSTInspector, StaticScope staticScope) {
                super(string, aSTInspector, staticScope);
            }

            public void endMethod() {
                this.method.areturn();
                Label label = new Label();
                this.method.label(label);
                this.method.end();
            }
        }
    }
}

