/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.compiler.impl;

import org.jruby.nb.nb.nb.compiler.CompilerCallback;
import org.jruby.nb.nb.nb.compiler.NotCompilableException;
import org.jruby.nb.nb.nb.compiler.impl.AbstractVariableCompiler;
import org.jruby.nb.nb.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.nb.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.nb.nb.parser.StaticScope;
import org.jruby.nb.nb.nb.runtime.DynamicScope;
import org.jruby.nb.nb.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.nb.nb.util.CodegenUtils;
import org.objectweb.asm.Label;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int baseVariableIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler abstractMethodCompiler, SkinnyMethodAdapter skinnyMethodAdapter, StaticScope staticScope, boolean bl, int n, int n2) {
        super(abstractMethodCompiler, skinnyMethodAdapter, staticScope, bl, n, n2);
        this.baseVariableIndex = n2;
    }

    public void beginMethod(CompilerCallback compilerCallback, StaticScope staticScope) {
        if (staticScope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            compilerCallback.call(this.methodCompiler);
        }
    }

    public void declareLocals(StaticScope staticScope, Label label, Label label2) {
        String[] stringArray = staticScope.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            this.method.visitLocalVariable(stringArray[i], CodegenUtils.ci(IRubyObject.class), null, label, label2, this.baseVariableIndex + i);
        }
    }

    public void beginClass(CompilerCallback compilerCallback, StaticScope staticScope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    public void beginClosure(CompilerCallback compilerCallback, StaticScope staticScope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (staticScope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < staticScope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += staticScope.getNumberOfVariables();
        }
        if (compilerCallback != null) {
            this.method.aload(this.argsIndex);
            compilerCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    public void assignLocalVariable(int n) {
        this.method.dup();
        this.method.astore(this.baseVariableIndex + n);
    }

    public void assignLocalVariable(int n, CompilerCallback compilerCallback) {
        compilerCallback.call(this.methodCompiler);
        this.assignLocalVariable(n);
    }

    public void assignLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.assignLocalVariable(n);
        } else {
            this.assignHeapLocal(n2, n);
        }
    }

    public void assignLocalVariable(int n, int n2, CompilerCallback compilerCallback) {
        if (n2 == 0) {
            this.assignLocalVariable(n, compilerCallback);
        } else {
            this.assignHeapLocal(compilerCallback, n2, n);
        }
    }

    public void retrieveLocalVariable(int n) {
        this.method.aload(this.baseVariableIndex + n);
    }

    public void retrieveLocalVariable(int n, int n2) {
        if (n2 == 0) {
            this.retrieveLocalVariable(n);
        } else {
            this.retrieveHeapLocal(n2, n);
        }
    }
}

