/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.nb.nb.ast.util;

import org.jruby.nb.nb.nb.ast.AliasNode;
import org.jruby.nb.nb.nb.ast.ArgumentNode;
import org.jruby.nb.nb.nb.ast.AttrAssignNode;
import org.jruby.nb.nb.nb.ast.BackRefNode;
import org.jruby.nb.nb.nb.ast.BignumNode;
import org.jruby.nb.nb.nb.ast.BlockArgNode;
import org.jruby.nb.nb.nb.ast.CallNode;
import org.jruby.nb.nb.nb.ast.ClassVarAsgnNode;
import org.jruby.nb.nb.nb.ast.ClassVarDeclNode;
import org.jruby.nb.nb.nb.ast.ClassVarNode;
import org.jruby.nb.nb.nb.ast.Colon2Node;
import org.jruby.nb.nb.nb.ast.Colon3Node;
import org.jruby.nb.nb.nb.ast.ConstDeclNode;
import org.jruby.nb.nb.nb.ast.ConstNode;
import org.jruby.nb.nb.nb.ast.DAsgnNode;
import org.jruby.nb.nb.nb.ast.DRegexpNode;
import org.jruby.nb.nb.nb.ast.DVarNode;
import org.jruby.nb.nb.nb.ast.DotNode;
import org.jruby.nb.nb.nb.ast.FCallNode;
import org.jruby.nb.nb.nb.ast.FixnumNode;
import org.jruby.nb.nb.nb.ast.FlipNode;
import org.jruby.nb.nb.nb.ast.FloatNode;
import org.jruby.nb.nb.nb.ast.GlobalAsgnNode;
import org.jruby.nb.nb.nb.ast.GlobalVarNode;
import org.jruby.nb.nb.nb.ast.InstAsgnNode;
import org.jruby.nb.nb.nb.ast.InstVarNode;
import org.jruby.nb.nb.nb.ast.LocalAsgnNode;
import org.jruby.nb.nb.nb.ast.LocalVarNode;
import org.jruby.nb.nb.nb.ast.Node;
import org.jruby.nb.nb.nb.ast.NthRefNode;
import org.jruby.nb.nb.nb.ast.OpElementAsgnNode;
import org.jruby.nb.nb.nb.ast.RegexpNode;
import org.jruby.nb.nb.nb.ast.StrNode;
import org.jruby.nb.nb.nb.ast.SymbolNode;
import org.jruby.nb.nb.nb.ast.UndefNode;
import org.jruby.nb.nb.nb.ast.VAliasNode;
import org.jruby.nb.nb.nb.ast.VCallNode;
import org.jruby.nb.nb.nb.ast.XStrNode;

public class SexpMaker {
    private final StringBuilder sb = new StringBuilder();

    public static String create(Node node) {
        SexpMaker sexpMaker = new SexpMaker();
        sexpMaker.process(node);
        return sexpMaker.toString();
    }

    public static String create(String string, Node node, Node node2) {
        SexpMaker sexpMaker = new SexpMaker();
        sexpMaker.processMethod(string, node, node2);
        return sexpMaker.toString();
    }

    private SexpMaker() {
    }

    private void processMethod(String string, Node node, Node node2) {
        this.sb.append("(method ").append(string).append(' ');
        this.process(node);
        this.sb.append(" ");
        this.process(node2);
        this.sb.append(")");
    }

    public String toString() {
        return this.sb.toString();
    }

    private void process(Node node) {
        if (node == null) {
            this.sb.append("null");
            return;
        }
        this.sb.append("(");
        this.shortName(node);
        this.leafInfo(node);
        for (Node node2 : node.childNodes()) {
            this.sb.append(" ");
            this.process(node2);
        }
        this.sb.append(")");
    }

    private void shortName(Node node) {
        int n;
        String string = node.getClass().getName();
        if (string.endsWith("Node") && (n = (string = string.substring(0, string.length() - 4)).lastIndexOf(46)) != -1) {
            string = string.substring(n + 1);
        }
        this.sb.append(string.toLowerCase());
    }

    private void leafInfo(Node node) {
        switch (node.nodeId) {
            case ALIASNODE: {
                this.aliasNode((AliasNode)node);
                break;
            }
            case ANDNODE: {
                this.nothing(node);
                break;
            }
            case ARGSCATNODE: {
                this.nothing(node);
                break;
            }
            case ARGSPUSHNODE: {
                this.nothing(node);
                break;
            }
            case ARGUMENTNODE: {
                this.argumentNode((ArgumentNode)node);
                break;
            }
            case ARRAYNODE: {
                this.nothing(node);
                break;
            }
            case ATTRASSIGNNODE: {
                this.attrAssignNode((AttrAssignNode)node);
                break;
            }
            case BACKREFNODE: {
                this.backRefNode((BackRefNode)node);
                break;
            }
            case BEGINNODE: {
                this.nothing(node);
                break;
            }
            case BIGNUMNODE: {
                this.bignumNode((BignumNode)node);
                break;
            }
            case BLOCKARGNODE: {
                this.blockArgNode((BlockArgNode)node);
                break;
            }
            case BLOCKNODE: {
                this.nothing(node);
                break;
            }
            case BLOCKPASSNODE: {
                this.nothing(node);
                break;
            }
            case BREAKNODE: {
                this.nothing(node);
                break;
            }
            case CALLNODE: {
                this.callNode((CallNode)node);
                break;
            }
            case CASENODE: {
                this.nothing(node);
                break;
            }
            case CLASSNODE: {
                this.nothing(node);
                break;
            }
            case CLASSVARASGNNODE: {
                this.classVarAsgnNode((ClassVarAsgnNode)node);
                break;
            }
            case CLASSVARDECLNODE: {
                this.classVarDeclNode((ClassVarDeclNode)node);
                break;
            }
            case CLASSVARNODE: {
                this.classVarNode((ClassVarNode)node);
                break;
            }
            case COLON2NODE: {
                this.colon2Node((Colon2Node)node);
                break;
            }
            case COLON3NODE: {
                this.colon3Node((Colon3Node)node);
                break;
            }
            case CONSTDECLNODE: {
                this.constDeclNode((ConstDeclNode)node);
                break;
            }
            case CONSTNODE: {
                this.constNode((ConstNode)node);
                break;
            }
            case DASGNNODE: {
                this.dAsgnNode((DAsgnNode)node);
                break;
            }
            case DEFINEDNODE: {
                this.nothing(node);
                break;
            }
            case DEFNNODE: {
                this.nothing(node);
                break;
            }
            case DEFSNODE: {
                this.nothing(node);
                break;
            }
            case DOTNODE: {
                this.dotNode((DotNode)node);
                break;
            }
            case DREGEXPNODE: {
                this.dRegexpNode((DRegexpNode)node);
                break;
            }
            case DSTRNODE: {
                this.nothing(node);
                break;
            }
            case DSYMBOLNODE: {
                this.nothing(node);
                break;
            }
            case DVARNODE: {
                this.dVarNode((DVarNode)node);
                break;
            }
            case DXSTRNODE: {
                this.nothing(node);
                break;
            }
            case ENSURENODE: {
                this.nothing(node);
                break;
            }
            case EVSTRNODE: {
                this.nothing(node);
                break;
            }
            case FALSENODE: {
                this.nothing(node);
                break;
            }
            case FCALLNODE: {
                this.fCallNode((FCallNode)node);
                break;
            }
            case FIXNUMNODE: {
                this.fixnumNode((FixnumNode)node);
                break;
            }
            case FLIPNODE: {
                this.flipNode((FlipNode)node);
                break;
            }
            case FLOATNODE: {
                this.floatNode((FloatNode)node);
                break;
            }
            case FORNODE: {
                this.nothing(node);
                break;
            }
            case GLOBALASGNNODE: {
                this.globalAsgnNode((GlobalAsgnNode)node);
                break;
            }
            case GLOBALVARNODE: {
                this.globalVarNode((GlobalVarNode)node);
                break;
            }
            case HASHNODE: {
                this.nothing(node);
                break;
            }
            case IFNODE: {
                this.nothing(node);
                break;
            }
            case INSTASGNNODE: {
                this.nothing(node);
                this.instAsgnNode((InstAsgnNode)node);
                break;
            }
            case INSTVARNODE: {
                this.nothing(node);
                this.instVarNode((InstVarNode)node);
                break;
            }
            case ITERNODE: {
                this.nothing(node);
                break;
            }
            case LOCALASGNNODE: {
                this.localAsgnNode((LocalAsgnNode)node);
                break;
            }
            case LOCALVARNODE: {
                this.localVarNode((LocalVarNode)node);
                break;
            }
            case MATCH2NODE: {
                this.nothing(node);
                break;
            }
            case MATCH3NODE: {
                this.nothing(node);
                break;
            }
            case MATCHNODE: {
                this.nothing(node);
                break;
            }
            case MODULENODE: {
                this.nothing(node);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.nothing(node);
                break;
            }
            case NEWLINENODE: {
                this.nothing(node);
                break;
            }
            case NEXTNODE: {
                this.nothing(node);
                break;
            }
            case NILNODE: {
                this.nothing(node);
                break;
            }
            case NOTNODE: {
                this.nothing(node);
                break;
            }
            case NTHREFNODE: {
                this.nthRefNode((NthRefNode)node);
                break;
            }
            case OPASGNANDNODE: {
                this.nothing(node);
                break;
            }
            case OPASGNNODE: {
                this.nothing(node);
                break;
            }
            case OPASGNORNODE: {
                this.nothing(node);
                break;
            }
            case OPELEMENTASGNNODE: {
                this.opElementAsgnNode((OpElementAsgnNode)node);
                break;
            }
            case ORNODE: {
                this.nothing(node);
                break;
            }
            case PREEXENODE: {
                this.nothing(node);
                break;
            }
            case POSTEXENODE: {
                this.nothing(node);
                break;
            }
            case REDONODE: {
                this.nothing(node);
                break;
            }
            case REGEXPNODE: {
                this.regexpNode((RegexpNode)node);
                break;
            }
            case RESCUEBODYNODE: {
                this.nothing(node);
                break;
            }
            case RESCUENODE: {
                this.nothing(node);
                break;
            }
            case RETRYNODE: {
                this.nothing(node);
                break;
            }
            case RETURNNODE: {
                this.nothing(node);
                break;
            }
            case ROOTNODE: {
                this.nothing(node);
                break;
            }
            case SCLASSNODE: {
                this.nothing(node);
                break;
            }
            case SELFNODE: {
                this.nothing(node);
                break;
            }
            case SPLATNODE: {
                this.nothing(node);
                break;
            }
            case STRNODE: {
                this.strNode((StrNode)node);
                break;
            }
            case SUPERNODE: {
                this.nothing(node);
                break;
            }
            case SVALUENODE: {
                this.nothing(node);
                break;
            }
            case SYMBOLNODE: {
                this.symbolNode((SymbolNode)node);
                break;
            }
            case TOARYNODE: {
                this.nothing(node);
                break;
            }
            case TRUENODE: {
                this.nothing(node);
                break;
            }
            case UNDEFNODE: {
                this.undefNode((UndefNode)node);
                break;
            }
            case UNTILNODE: {
                this.nothing(node);
                break;
            }
            case VALIASNODE: {
                this.valiasNode((VAliasNode)node);
                break;
            }
            case VCALLNODE: {
                this.vcallNode((VCallNode)node);
                break;
            }
            case WHENNODE: {
                this.nothing(node);
                break;
            }
            case WHILENODE: {
                this.nothing(node);
                break;
            }
            case XSTRNODE: {
                this.xStrNode((XStrNode)node);
                break;
            }
            case YIELDNODE: {
                this.nothing(node);
                break;
            }
            case ZARRAYNODE: {
                this.nothing(node);
                break;
            }
            case ZSUPERNODE: {
                this.nothing(node);
                break;
            }
        }
    }

    private void xStrNode(XStrNode xStrNode) {
        this.sb.append(" '").append((CharSequence)xStrNode.getValue()).append("'");
    }

    private void vcallNode(VCallNode vCallNode) {
        this.sb.append(" ").append(vCallNode.getName());
    }

    private void valiasNode(VAliasNode vAliasNode) {
        this.sb.append(" ").append(vAliasNode.getOldName()).append(vAliasNode.getNewName());
    }

    private void undefNode(UndefNode undefNode) {
        this.sb.append(" ").append(undefNode.getName());
    }

    private void strNode(StrNode strNode) {
        this.sb.append(" '").append((CharSequence)strNode.getValue()).append("'");
    }

    private void regexpNode(RegexpNode regexpNode) {
        this.sb.append(" ").append((CharSequence)regexpNode.getValue()).append(" ").append(regexpNode.getOptions());
    }

    private void opElementAsgnNode(OpElementAsgnNode opElementAsgnNode) {
        this.sb.append(" ").append(opElementAsgnNode.getOperatorName());
    }

    private void nthRefNode(NthRefNode nthRefNode) {
        this.sb.append(" ").append(nthRefNode.getMatchNumber());
    }

    private void localAsgnNode(LocalAsgnNode localAsgnNode) {
        this.sb.append(" ").append(localAsgnNode.getName());
    }

    private void instVarNode(InstVarNode instVarNode) {
        this.sb.append(" ").append(instVarNode.getName());
    }

    private void instAsgnNode(InstAsgnNode instAsgnNode) {
        this.sb.append(" ").append(instAsgnNode.getName());
    }

    private void globalVarNode(GlobalVarNode globalVarNode) {
        this.sb.append(" ").append(globalVarNode.getName());
    }

    private void globalAsgnNode(GlobalAsgnNode globalAsgnNode) {
        this.sb.append(" ").append(globalAsgnNode.getName());
    }

    private void floatNode(FloatNode floatNode) {
        this.sb.append(" ").append(floatNode.getValue());
    }

    private void flipNode(FlipNode flipNode) {
        this.sb.append(" ").append(flipNode.isExclusive());
    }

    private void fixnumNode(FixnumNode fixnumNode) {
        this.sb.append(" ").append(fixnumNode.getValue());
    }

    private void fCallNode(FCallNode fCallNode) {
        this.sb.append(" ").append(fCallNode.getName());
    }

    private void dVarNode(DVarNode dVarNode) {
        this.sb.append(" ").append(dVarNode.getName());
    }

    private void blockArgNode(BlockArgNode blockArgNode) {
        this.sb.append(" ").append(blockArgNode.getName());
    }

    private void backRefNode(BackRefNode backRefNode) {
        this.sb.append(" ").append(backRefNode.getType());
    }

    private void symbolNode(SymbolNode symbolNode) {
        this.sb.append(" ").append(symbolNode.getName());
    }

    private void localVarNode(LocalVarNode localVarNode) {
        this.sb.append(" ").append(localVarNode.getName());
    }

    private void argumentNode(ArgumentNode argumentNode) {
        this.sb.append(" ").append(argumentNode.getName());
    }

    private void dRegexpNode(DRegexpNode dRegexpNode) {
        this.sb.append(" ").append(dRegexpNode.getOnce()).append(" ").append(dRegexpNode.getOptions());
    }

    private void dotNode(DotNode dotNode) {
        this.sb.append(" ").append(dotNode.isExclusive()).append(" ").append(dotNode.isLiteral());
    }

    private void dAsgnNode(DAsgnNode dAsgnNode) {
        this.sb.append(" ").append(dAsgnNode.getName());
    }

    private void constNode(ConstNode constNode) {
        this.sb.append(" ").append(constNode.getName());
    }

    private void constDeclNode(ConstDeclNode constDeclNode) {
        this.sb.append(" ").append(constDeclNode.getName());
    }

    private void colon3Node(Colon3Node colon3Node) {
        this.sb.append(" ").append(colon3Node.getName());
    }

    private void colon2Node(Colon2Node colon2Node) {
        this.sb.append(" ").append(colon2Node.getName());
    }

    private void classVarNode(ClassVarNode classVarNode) {
        this.sb.append(" ").append(classVarNode.getName());
    }

    private void classVarDeclNode(ClassVarDeclNode classVarDeclNode) {
        this.sb.append(" ").append(classVarDeclNode.getName());
    }

    private void classVarAsgnNode(ClassVarAsgnNode classVarAsgnNode) {
        this.sb.append(" ").append(classVarAsgnNode.getName());
    }

    private void callNode(CallNode callNode) {
        this.sb.append(" ").append(callNode.getName());
    }

    private void bignumNode(BignumNode bignumNode) {
        this.sb.append(" ").append(bignumNode.getValue());
    }

    private void attrAssignNode(AttrAssignNode attrAssignNode) {
        this.sb.append(" ").append(attrAssignNode.getName());
    }

    private void aliasNode(AliasNode aliasNode) {
        this.sb.append(" ").append(aliasNode.getOldName()).append(aliasNode.getNewName());
    }

    private void nothing(Node node) {
    }
}

